/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudtrail.model;

import javax.annotation.Generated;

/**
 * <p>
 * This exception is thrown when an operation is called with an ARN that is not valid.
 * </p>
 * <p>
 * The following is the format of a trail ARN: <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
 * </p>
 * <p>
 * The following is the format of an event data store ARN:
 * <code>arn:aws:cloudtrail:us-east-2:123456789012:eventdatastore/EXAMPLE-f852-4e8f-8bd1-bcf6cEXAMPLE</code>
 * </p>
 * <p>
 * The following is the format of a channel ARN:
 * <code>arn:aws:cloudtrail:us-east-2:123456789012:channel/01234567890</code>
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CloudTrailARNInvalidException extends com.amazonaws.services.cloudtrail.model.AWSCloudTrailException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new CloudTrailARNInvalidException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public CloudTrailARNInvalidException(String message) {
        super(message);
    }

}
