/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchrum.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatchrum.model.Telemetry;
import com.amazonaws.services.cloudwatchrum.model.transform.AppMonitorConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AppMonitorConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean allowCookies;
    private Boolean enableXRay;
    private List<String> excludedPages;
    private List<String> favoritePages;
    private String guestRoleArn;
    private String identityPoolId;
    private List<String> includedPages;
    private Double sessionSampleRate;
    private List<String> telemetries;

    public void setAllowCookies(Boolean allowCookies) {
        this.allowCookies = allowCookies;
    }

    public Boolean getAllowCookies() {
        return this.allowCookies;
    }

    public AppMonitorConfiguration withAllowCookies(Boolean allowCookies) {
        this.setAllowCookies(allowCookies);
        return this;
    }

    public Boolean isAllowCookies() {
        return this.allowCookies;
    }

    public void setEnableXRay(Boolean enableXRay) {
        this.enableXRay = enableXRay;
    }

    public Boolean getEnableXRay() {
        return this.enableXRay;
    }

    public AppMonitorConfiguration withEnableXRay(Boolean enableXRay) {
        this.setEnableXRay(enableXRay);
        return this;
    }

    public Boolean isEnableXRay() {
        return this.enableXRay;
    }

    public List<String> getExcludedPages() {
        return this.excludedPages;
    }

    public void setExcludedPages(Collection<String> excludedPages) {
        if (excludedPages == null) {
            this.excludedPages = null;
            return;
        }
        this.excludedPages = new ArrayList<String>(excludedPages);
    }

    public AppMonitorConfiguration withExcludedPages(String ... excludedPages) {
        if (this.excludedPages == null) {
            this.setExcludedPages(new ArrayList<String>(excludedPages.length));
        }
        for (String ele : excludedPages) {
            this.excludedPages.add(ele);
        }
        return this;
    }

    public AppMonitorConfiguration withExcludedPages(Collection<String> excludedPages) {
        this.setExcludedPages(excludedPages);
        return this;
    }

    public List<String> getFavoritePages() {
        return this.favoritePages;
    }

    public void setFavoritePages(Collection<String> favoritePages) {
        if (favoritePages == null) {
            this.favoritePages = null;
            return;
        }
        this.favoritePages = new ArrayList<String>(favoritePages);
    }

    public AppMonitorConfiguration withFavoritePages(String ... favoritePages) {
        if (this.favoritePages == null) {
            this.setFavoritePages(new ArrayList<String>(favoritePages.length));
        }
        for (String ele : favoritePages) {
            this.favoritePages.add(ele);
        }
        return this;
    }

    public AppMonitorConfiguration withFavoritePages(Collection<String> favoritePages) {
        this.setFavoritePages(favoritePages);
        return this;
    }

    public void setGuestRoleArn(String guestRoleArn) {
        this.guestRoleArn = guestRoleArn;
    }

    public String getGuestRoleArn() {
        return this.guestRoleArn;
    }

    public AppMonitorConfiguration withGuestRoleArn(String guestRoleArn) {
        this.setGuestRoleArn(guestRoleArn);
        return this;
    }

    public void setIdentityPoolId(String identityPoolId) {
        this.identityPoolId = identityPoolId;
    }

    public String getIdentityPoolId() {
        return this.identityPoolId;
    }

    public AppMonitorConfiguration withIdentityPoolId(String identityPoolId) {
        this.setIdentityPoolId(identityPoolId);
        return this;
    }

    public List<String> getIncludedPages() {
        return this.includedPages;
    }

    public void setIncludedPages(Collection<String> includedPages) {
        if (includedPages == null) {
            this.includedPages = null;
            return;
        }
        this.includedPages = new ArrayList<String>(includedPages);
    }

    public AppMonitorConfiguration withIncludedPages(String ... includedPages) {
        if (this.includedPages == null) {
            this.setIncludedPages(new ArrayList<String>(includedPages.length));
        }
        for (String ele : includedPages) {
            this.includedPages.add(ele);
        }
        return this;
    }

    public AppMonitorConfiguration withIncludedPages(Collection<String> includedPages) {
        this.setIncludedPages(includedPages);
        return this;
    }

    public void setSessionSampleRate(Double sessionSampleRate) {
        this.sessionSampleRate = sessionSampleRate;
    }

    public Double getSessionSampleRate() {
        return this.sessionSampleRate;
    }

    public AppMonitorConfiguration withSessionSampleRate(Double sessionSampleRate) {
        this.setSessionSampleRate(sessionSampleRate);
        return this;
    }

    public List<String> getTelemetries() {
        return this.telemetries;
    }

    public void setTelemetries(Collection<String> telemetries) {
        if (telemetries == null) {
            this.telemetries = null;
            return;
        }
        this.telemetries = new ArrayList<String>(telemetries);
    }

    public AppMonitorConfiguration withTelemetries(String ... telemetries) {
        if (this.telemetries == null) {
            this.setTelemetries(new ArrayList<String>(telemetries.length));
        }
        for (String ele : telemetries) {
            this.telemetries.add(ele);
        }
        return this;
    }

    public AppMonitorConfiguration withTelemetries(Collection<String> telemetries) {
        this.setTelemetries(telemetries);
        return this;
    }

    public AppMonitorConfiguration withTelemetries(Telemetry ... telemetries) {
        ArrayList<String> telemetriesCopy = new ArrayList<String>(telemetries.length);
        for (Telemetry value : telemetries) {
            telemetriesCopy.add(value.toString());
        }
        if (this.getTelemetries() == null) {
            this.setTelemetries(telemetriesCopy);
        } else {
            this.getTelemetries().addAll(telemetriesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowCookies() != null) {
            sb.append("AllowCookies: ").append(this.getAllowCookies()).append(",");
        }
        if (this.getEnableXRay() != null) {
            sb.append("EnableXRay: ").append(this.getEnableXRay()).append(",");
        }
        if (this.getExcludedPages() != null) {
            sb.append("ExcludedPages: ").append(this.getExcludedPages()).append(",");
        }
        if (this.getFavoritePages() != null) {
            sb.append("FavoritePages: ").append(this.getFavoritePages()).append(",");
        }
        if (this.getGuestRoleArn() != null) {
            sb.append("GuestRoleArn: ").append(this.getGuestRoleArn()).append(",");
        }
        if (this.getIdentityPoolId() != null) {
            sb.append("IdentityPoolId: ").append(this.getIdentityPoolId()).append(",");
        }
        if (this.getIncludedPages() != null) {
            sb.append("IncludedPages: ").append(this.getIncludedPages()).append(",");
        }
        if (this.getSessionSampleRate() != null) {
            sb.append("SessionSampleRate: ").append(this.getSessionSampleRate()).append(",");
        }
        if (this.getTelemetries() != null) {
            sb.append("Telemetries: ").append(this.getTelemetries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppMonitorConfiguration)) {
            return false;
        }
        AppMonitorConfiguration other = (AppMonitorConfiguration)obj;
        if (other.getAllowCookies() == null ^ this.getAllowCookies() == null) {
            return false;
        }
        if (other.getAllowCookies() != null && !other.getAllowCookies().equals(this.getAllowCookies())) {
            return false;
        }
        if (other.getEnableXRay() == null ^ this.getEnableXRay() == null) {
            return false;
        }
        if (other.getEnableXRay() != null && !other.getEnableXRay().equals(this.getEnableXRay())) {
            return false;
        }
        if (other.getExcludedPages() == null ^ this.getExcludedPages() == null) {
            return false;
        }
        if (other.getExcludedPages() != null && !other.getExcludedPages().equals(this.getExcludedPages())) {
            return false;
        }
        if (other.getFavoritePages() == null ^ this.getFavoritePages() == null) {
            return false;
        }
        if (other.getFavoritePages() != null && !other.getFavoritePages().equals(this.getFavoritePages())) {
            return false;
        }
        if (other.getGuestRoleArn() == null ^ this.getGuestRoleArn() == null) {
            return false;
        }
        if (other.getGuestRoleArn() != null && !other.getGuestRoleArn().equals(this.getGuestRoleArn())) {
            return false;
        }
        if (other.getIdentityPoolId() == null ^ this.getIdentityPoolId() == null) {
            return false;
        }
        if (other.getIdentityPoolId() != null && !other.getIdentityPoolId().equals(this.getIdentityPoolId())) {
            return false;
        }
        if (other.getIncludedPages() == null ^ this.getIncludedPages() == null) {
            return false;
        }
        if (other.getIncludedPages() != null && !other.getIncludedPages().equals(this.getIncludedPages())) {
            return false;
        }
        if (other.getSessionSampleRate() == null ^ this.getSessionSampleRate() == null) {
            return false;
        }
        if (other.getSessionSampleRate() != null && !other.getSessionSampleRate().equals(this.getSessionSampleRate())) {
            return false;
        }
        if (other.getTelemetries() == null ^ this.getTelemetries() == null) {
            return false;
        }
        return other.getTelemetries() == null || other.getTelemetries().equals(this.getTelemetries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowCookies() == null ? 0 : this.getAllowCookies().hashCode());
        hashCode = 31 * hashCode + (this.getEnableXRay() == null ? 0 : this.getEnableXRay().hashCode());
        hashCode = 31 * hashCode + (this.getExcludedPages() == null ? 0 : this.getExcludedPages().hashCode());
        hashCode = 31 * hashCode + (this.getFavoritePages() == null ? 0 : this.getFavoritePages().hashCode());
        hashCode = 31 * hashCode + (this.getGuestRoleArn() == null ? 0 : this.getGuestRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getIdentityPoolId() == null ? 0 : this.getIdentityPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getIncludedPages() == null ? 0 : this.getIncludedPages().hashCode());
        hashCode = 31 * hashCode + (this.getSessionSampleRate() == null ? 0 : this.getSessionSampleRate().hashCode());
        hashCode = 31 * hashCode + (this.getTelemetries() == null ? 0 : this.getTelemetries().hashCode());
        return hashCode;
    }

    public AppMonitorConfiguration clone() {
        try {
            return (AppMonitorConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppMonitorConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

