/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen;

import com.amazonaws.codegen.IntermediateModelBuilder;
import com.amazonaws.codegen.IntermediateModelShapeProcessor;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.intermediate.OperationModel;
import com.amazonaws.codegen.model.intermediate.ReturnTypeModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.model.intermediate.ShapeUnmarshaller;
import com.amazonaws.codegen.model.intermediate.VariableModel;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.Output;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.naming.NamingStrategy;
import java.util.HashMap;
import java.util.Map;

public class AddEmptyOutputShape
implements IntermediateModelShapeProcessor {
    private final ServiceModel serviceModel;
    private final CustomizationConfig customizationConfig;
    private final NamingStrategy namingStrategy;

    public AddEmptyOutputShape(IntermediateModelBuilder builder) {
        this.serviceModel = builder.getService();
        this.customizationConfig = builder.getCustomConfig();
        this.namingStrategy = builder.getNamingStrategy();
    }

    @Override
    public Map<String, ShapeModel> process(Map<String, OperationModel> currentOperations, Map<String, ShapeModel> currentShapes) {
        if (this.customizationConfig.useModeledOutputShapeNames()) {
            return currentShapes;
        }
        return this.addEmptyOutputShapes(currentOperations);
    }

    private Map<String, ShapeModel> addEmptyOutputShapes(Map<String, OperationModel> currentOperations) {
        Map<String, Operation> operations = this.serviceModel.getOperations();
        HashMap<String, ShapeModel> emptyOutputShapes = new HashMap<String, ShapeModel>();
        for (Map.Entry<String, Operation> entry : operations.entrySet()) {
            String operationName = entry.getKey();
            Operation operation = entry.getValue();
            Output output = operation.getOutput();
            if (output != null) continue;
            String outputShape = operationName + "Result";
            OperationModel operationModel = currentOperations.get(operationName);
            operationModel.setReturnType(new ReturnTypeModel(outputShape));
            ShapeModel shape = new ShapeModel(outputShape).withType(ShapeType.Response.getValue());
            shape.setShapeName(outputShape);
            VariableModel outputVariable = new VariableModel(this.namingStrategy.getVariableName(outputShape), outputShape);
            shape.setVariable(outputVariable);
            shape.setUnmarshaller(new ShapeUnmarshaller());
            emptyOutputShapes.put(outputShape, shape);
        }
        return emptyOutputShapes;
    }
}

