/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.customization.processors;

import com.amazonaws.codegen.customization.CodegenCustomizationProcessor;
import com.amazonaws.codegen.model.config.customization.OperationModifier;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.MemberModel;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.customization.ArtificialResultWrapper;
import com.amazonaws.codegen.model.service.Member;
import com.amazonaws.codegen.model.service.Operation;
import com.amazonaws.codegen.model.service.ServiceModel;
import com.amazonaws.codegen.model.service.Shape;
import com.amazonaws.codegen.model.service.ShapeTypes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class OperationModifiersProcessor
implements CodegenCustomizationProcessor {
    private final Map<String, OperationModifier> operationModifiers;
    private final Set<String> createdWrapperShapes = new HashSet<String>();

    OperationModifiersProcessor(Map<String, OperationModifier> operationModifiers) {
        this.operationModifiers = operationModifiers;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (this.operationModifiers == null) {
            return;
        }
        for (Map.Entry<String, OperationModifier> entry : this.operationModifiers.entrySet()) {
            String operationName = entry.getKey();
            OperationModifier modifier = entry.getValue();
            if (modifier.isExclude()) {
                this.preprocess_Exclude(serviceModel, operationName);
                continue;
            }
            if (!modifier.isUseWrappingResult()) continue;
            String createdWrapperShape = this.preprocess_CreateResultWrapperShape(serviceModel, operationName, modifier);
            this.createdWrapperShapes.add(createdWrapperShape);
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.operationModifiers == null) {
            return;
        }
        for (ShapeModel shape : intermediateModel.getShapes().values()) {
            if (!this.createdWrapperShapes.contains(shape.getC2jName())) continue;
            if (shape.getMembers().size() != 1) {
                throw new IllegalStateException("Result wrapper " + shape.getShapeName() + " has not just one member!");
            }
            MemberModel wrappedMember = shape.getMembers().get(0);
            shape.getCustomization().setArtificialResultWrapper(this.createArtificialResultWrapperInfo(shape, wrappedMember));
        }
    }

    private void preprocess_Exclude(ServiceModel serviceModel, String operationName) {
        serviceModel.getOperations().remove(operationName);
    }

    private String preprocess_CreateResultWrapperShape(ServiceModel serviceModel, String operationName, OperationModifier modifier) {
        String wrappedShapeName = modifier.getWrappedResultShape();
        Shape wrappedShape = serviceModel.getShapes().get(wrappedShapeName);
        String wrapperShapeName = operationName + "Result";
        String wrappedAsMember = modifier.getWrappedResultMember();
        if (serviceModel.getShapes().containsKey(wrapperShapeName)) {
            throw new IllegalStateException(wrapperShapeName + " shape already exists in the service model.");
        }
        Shape wrapperShape = this.createWrapperShape(wrapperShapeName, wrappedShapeName, wrappedShape, wrappedAsMember);
        serviceModel.getShapes().put(wrapperShapeName, wrapperShape);
        Operation operation = serviceModel.getOperations().get(operationName);
        operation.getOutput().setShape(wrapperShapeName);
        return wrapperShapeName;
    }

    private Shape createWrapperShape(String wrapperShapeName, String wrappedShapeName, Shape wrapped, String wrappedAsMember) {
        Shape wrapper = new Shape();
        wrapper.setType(ShapeTypes.Structure.getName());
        wrapper.setDocumentation("A simple result wrapper around the " + wrappedShapeName + " object that was sent over the wire.");
        Member member = new Member();
        member.setShape(wrappedShapeName);
        member.setDocumentation(wrapped.getDocumentation());
        wrapper.setMembers(Collections.singletonMap(wrappedAsMember, member));
        return wrapper;
    }

    private ArtificialResultWrapper createArtificialResultWrapperInfo(ShapeModel shape, MemberModel wrappedMember) {
        ArtificialResultWrapper wrapper = new ArtificialResultWrapper();
        wrapper.setWrappedMemberName(wrappedMember.getName());
        wrapper.setWrappedMemberSimpleType(wrappedMember.getVariable().getSimpleType());
        return wrapper;
    }
}

