/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codeartifact.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codeartifact.model.PackageFormat;
import com.amazonaws.services.codeartifact.model.PackageGroupAssociationType;
import com.amazonaws.services.codeartifact.model.transform.AssociatedPackageMarshaller;
import java.io.Serializable;

public class AssociatedPackage
implements Serializable,
Cloneable,
StructuredPojo {
    private String format;
    private String namespace;
    private String packageValue;
    private String associationType;

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public AssociatedPackage withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public AssociatedPackage withFormat(PackageFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public AssociatedPackage withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setPackage(String packageValue) {
        this.packageValue = packageValue;
    }

    public String getPackage() {
        return this.packageValue;
    }

    public AssociatedPackage withPackage(String packageValue) {
        this.setPackage(packageValue);
        return this;
    }

    public void setAssociationType(String associationType) {
        this.associationType = associationType;
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public AssociatedPackage withAssociationType(String associationType) {
        this.setAssociationType(associationType);
        return this;
    }

    public AssociatedPackage withAssociationType(PackageGroupAssociationType associationType) {
        this.associationType = associationType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getPackage() != null) {
            sb.append("Package: ").append(this.getPackage()).append(",");
        }
        if (this.getAssociationType() != null) {
            sb.append("AssociationType: ").append(this.getAssociationType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedPackage)) {
            return false;
        }
        AssociatedPackage other = (AssociatedPackage)obj;
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getPackage() == null ^ this.getPackage() == null) {
            return false;
        }
        if (other.getPackage() != null && !other.getPackage().equals(this.getPackage())) {
            return false;
        }
        if (other.getAssociationType() == null ^ this.getAssociationType() == null) {
            return false;
        }
        return other.getAssociationType() == null || other.getAssociationType().equals(this.getAssociationType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getPackage() == null ? 0 : this.getPackage().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationType() == null ? 0 : this.getAssociationType().hashCode());
        return hashCode;
    }

    public AssociatedPackage clone() {
        try {
            return (AssociatedPackage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssociatedPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

