/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.CacheMode;
import com.amazonaws.services.codebuild.model.CacheType;
import com.amazonaws.services.codebuild.model.transform.ProjectCacheMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ProjectCache
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private String location;
    private List<String> modes;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public ProjectCache withType(String type) {
        this.setType(type);
        return this;
    }

    public ProjectCache withType(CacheType type) {
        this.type = type.toString();
        return this;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public ProjectCache withLocation(String location) {
        this.setLocation(location);
        return this;
    }

    public List<String> getModes() {
        return this.modes;
    }

    public void setModes(Collection<String> modes) {
        if (modes == null) {
            this.modes = null;
            return;
        }
        this.modes = new ArrayList<String>(modes);
    }

    public ProjectCache withModes(String ... modes) {
        if (this.modes == null) {
            this.setModes(new ArrayList<String>(modes.length));
        }
        for (String ele : modes) {
            this.modes.add(ele);
        }
        return this;
    }

    public ProjectCache withModes(Collection<String> modes) {
        this.setModes(modes);
        return this;
    }

    public ProjectCache withModes(CacheMode ... modes) {
        ArrayList<String> modesCopy = new ArrayList<String>(modes.length);
        for (CacheMode value : modes) {
            modesCopy.add(value.toString());
        }
        if (this.getModes() == null) {
            this.setModes(modesCopy);
        } else {
            this.getModes().addAll(modesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getLocation() != null) {
            sb.append("Location: ").append(this.getLocation()).append(",");
        }
        if (this.getModes() != null) {
            sb.append("Modes: ").append(this.getModes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectCache)) {
            return false;
        }
        ProjectCache other = (ProjectCache)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getLocation() == null ^ this.getLocation() == null) {
            return false;
        }
        if (other.getLocation() != null && !other.getLocation().equals(this.getLocation())) {
            return false;
        }
        if (other.getModes() == null ^ this.getModes() == null) {
            return false;
        }
        return other.getModes() == null || other.getModes().equals(this.getModes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getLocation() == null ? 0 : this.getLocation().hashCode());
        hashCode = 31 * hashCode + (this.getModes() == null ? 0 : this.getModes().hashCode());
        return hashCode;
    }

    public ProjectCache clone() {
        try {
            return (ProjectCache)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectCacheMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

