/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codebuild.model.TestCase;
import java.util.Date;

@SdkInternalApi
public class TestCaseMarshaller {
    private static final MarshallingInfo<String> REPORTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("reportArn").build();
    private static final MarshallingInfo<String> TESTRAWDATAPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("testRawDataPath").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Long> DURATIONINNANOSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("durationInNanoSeconds").build();
    private static final MarshallingInfo<String> MESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("message").build();
    private static final MarshallingInfo<Date> EXPIRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expired").timestampFormat("unixTimestamp").build();
    private static final TestCaseMarshaller instance = new TestCaseMarshaller();

    public static TestCaseMarshaller getInstance() {
        return instance;
    }

    public void marshall(TestCase testCase, ProtocolMarshaller protocolMarshaller) {
        if (testCase == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)testCase.getReportArn(), REPORTARN_BINDING);
            protocolMarshaller.marshall((Object)testCase.getTestRawDataPath(), TESTRAWDATAPATH_BINDING);
            protocolMarshaller.marshall((Object)testCase.getPrefix(), PREFIX_BINDING);
            protocolMarshaller.marshall((Object)testCase.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)testCase.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)testCase.getDurationInNanoSeconds(), DURATIONINNANOSECONDS_BINDING);
            protocolMarshaller.marshall((Object)testCase.getMessage(), MESSAGE_BINDING);
            protocolMarshaller.marshall((Object)testCase.getExpired(), EXPIRED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

