/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codegurureviewer.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codegurureviewer.model.KMSKeyDetails;
import com.amazonaws.services.codegurureviewer.model.Repository;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AssociateRepositoryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Repository repository;
    private String clientRequestToken;
    private Map<String, String> tags;
    private KMSKeyDetails kMSKeyDetails;

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public AssociateRepositoryRequest withRepository(Repository repository) {
        this.setRepository(repository);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public AssociateRepositoryRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public AssociateRepositoryRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public AssociateRepositoryRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public AssociateRepositoryRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setKMSKeyDetails(KMSKeyDetails kMSKeyDetails) {
        this.kMSKeyDetails = kMSKeyDetails;
    }

    public KMSKeyDetails getKMSKeyDetails() {
        return this.kMSKeyDetails;
    }

    public AssociateRepositoryRequest withKMSKeyDetails(KMSKeyDetails kMSKeyDetails) {
        this.setKMSKeyDetails(kMSKeyDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRepository() != null) {
            sb.append("Repository: ").append(this.getRepository()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getKMSKeyDetails() != null) {
            sb.append("KMSKeyDetails: ").append(this.getKMSKeyDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRepositoryRequest)) {
            return false;
        }
        AssociateRepositoryRequest other = (AssociateRepositoryRequest)obj;
        if (other.getRepository() == null ^ this.getRepository() == null) {
            return false;
        }
        if (other.getRepository() != null && !other.getRepository().equals(this.getRepository())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getKMSKeyDetails() == null ^ this.getKMSKeyDetails() == null) {
            return false;
        }
        return other.getKMSKeyDetails() == null || other.getKMSKeyDetails().equals(this.getKMSKeyDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRepository() == null ? 0 : this.getRepository().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getKMSKeyDetails() == null ? 0 : this.getKMSKeyDetails().hashCode());
        return hashCode;
    }

    public AssociateRepositoryRequest clone() {
        return (AssociateRepositoryRequest)super.clone();
    }
}

