/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.GitBranchFilterCriteria;
import com.amazonaws.services.codepipeline.model.GitFilePathFilterCriteria;
import com.amazonaws.services.codepipeline.model.GitTagFilterCriteria;
import com.amazonaws.services.codepipeline.model.transform.GitPushFilterMarshaller;
import java.io.Serializable;

public class GitPushFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private GitTagFilterCriteria tags;
    private GitBranchFilterCriteria branches;
    private GitFilePathFilterCriteria filePaths;

    public void setTags(GitTagFilterCriteria tags) {
        this.tags = tags;
    }

    public GitTagFilterCriteria getTags() {
        return this.tags;
    }

    public GitPushFilter withTags(GitTagFilterCriteria tags) {
        this.setTags(tags);
        return this;
    }

    public void setBranches(GitBranchFilterCriteria branches) {
        this.branches = branches;
    }

    public GitBranchFilterCriteria getBranches() {
        return this.branches;
    }

    public GitPushFilter withBranches(GitBranchFilterCriteria branches) {
        this.setBranches(branches);
        return this;
    }

    public void setFilePaths(GitFilePathFilterCriteria filePaths) {
        this.filePaths = filePaths;
    }

    public GitFilePathFilterCriteria getFilePaths() {
        return this.filePaths;
    }

    public GitPushFilter withFilePaths(GitFilePathFilterCriteria filePaths) {
        this.setFilePaths(filePaths);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getBranches() != null) {
            sb.append("Branches: ").append(this.getBranches()).append(",");
        }
        if (this.getFilePaths() != null) {
            sb.append("FilePaths: ").append(this.getFilePaths());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitPushFilter)) {
            return false;
        }
        GitPushFilter other = (GitPushFilter)obj;
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getBranches() == null ^ this.getBranches() == null) {
            return false;
        }
        if (other.getBranches() != null && !other.getBranches().equals(this.getBranches())) {
            return false;
        }
        if (other.getFilePaths() == null ^ this.getFilePaths() == null) {
            return false;
        }
        return other.getFilePaths() == null || other.getFilePaths().equals(this.getFilePaths());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getBranches() == null ? 0 : this.getBranches().hashCode());
        hashCode = 31 * hashCode + (this.getFilePaths() == null ? 0 : this.getFilePaths().hashCode());
        return hashCode;
    }

    public GitPushFilter clone() {
        try {
            return (GitPushFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GitPushFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

