/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.dataexchange.AWSDataExchange;
import com.amazonaws.services.dataexchange.AWSDataExchangeClientBuilder;
import com.amazonaws.services.dataexchange.model.AWSDataExchangeException;
import com.amazonaws.services.dataexchange.model.CancelJobRequest;
import com.amazonaws.services.dataexchange.model.CancelJobResult;
import com.amazonaws.services.dataexchange.model.CreateDataSetRequest;
import com.amazonaws.services.dataexchange.model.CreateDataSetResult;
import com.amazonaws.services.dataexchange.model.CreateEventActionRequest;
import com.amazonaws.services.dataexchange.model.CreateEventActionResult;
import com.amazonaws.services.dataexchange.model.CreateJobRequest;
import com.amazonaws.services.dataexchange.model.CreateJobResult;
import com.amazonaws.services.dataexchange.model.CreateRevisionRequest;
import com.amazonaws.services.dataexchange.model.CreateRevisionResult;
import com.amazonaws.services.dataexchange.model.DeleteAssetRequest;
import com.amazonaws.services.dataexchange.model.DeleteAssetResult;
import com.amazonaws.services.dataexchange.model.DeleteDataSetRequest;
import com.amazonaws.services.dataexchange.model.DeleteDataSetResult;
import com.amazonaws.services.dataexchange.model.DeleteEventActionRequest;
import com.amazonaws.services.dataexchange.model.DeleteEventActionResult;
import com.amazonaws.services.dataexchange.model.DeleteRevisionRequest;
import com.amazonaws.services.dataexchange.model.DeleteRevisionResult;
import com.amazonaws.services.dataexchange.model.GetAssetRequest;
import com.amazonaws.services.dataexchange.model.GetAssetResult;
import com.amazonaws.services.dataexchange.model.GetDataSetRequest;
import com.amazonaws.services.dataexchange.model.GetDataSetResult;
import com.amazonaws.services.dataexchange.model.GetEventActionRequest;
import com.amazonaws.services.dataexchange.model.GetEventActionResult;
import com.amazonaws.services.dataexchange.model.GetJobRequest;
import com.amazonaws.services.dataexchange.model.GetJobResult;
import com.amazonaws.services.dataexchange.model.GetRevisionRequest;
import com.amazonaws.services.dataexchange.model.GetRevisionResult;
import com.amazonaws.services.dataexchange.model.ListDataSetRevisionsRequest;
import com.amazonaws.services.dataexchange.model.ListDataSetRevisionsResult;
import com.amazonaws.services.dataexchange.model.ListDataSetsRequest;
import com.amazonaws.services.dataexchange.model.ListDataSetsResult;
import com.amazonaws.services.dataexchange.model.ListEventActionsRequest;
import com.amazonaws.services.dataexchange.model.ListEventActionsResult;
import com.amazonaws.services.dataexchange.model.ListJobsRequest;
import com.amazonaws.services.dataexchange.model.ListJobsResult;
import com.amazonaws.services.dataexchange.model.ListRevisionAssetsRequest;
import com.amazonaws.services.dataexchange.model.ListRevisionAssetsResult;
import com.amazonaws.services.dataexchange.model.ListTagsForResourceRequest;
import com.amazonaws.services.dataexchange.model.ListTagsForResourceResult;
import com.amazonaws.services.dataexchange.model.StartJobRequest;
import com.amazonaws.services.dataexchange.model.StartJobResult;
import com.amazonaws.services.dataexchange.model.TagResourceRequest;
import com.amazonaws.services.dataexchange.model.TagResourceResult;
import com.amazonaws.services.dataexchange.model.UntagResourceRequest;
import com.amazonaws.services.dataexchange.model.UntagResourceResult;
import com.amazonaws.services.dataexchange.model.UpdateAssetRequest;
import com.amazonaws.services.dataexchange.model.UpdateAssetResult;
import com.amazonaws.services.dataexchange.model.UpdateDataSetRequest;
import com.amazonaws.services.dataexchange.model.UpdateDataSetResult;
import com.amazonaws.services.dataexchange.model.UpdateEventActionRequest;
import com.amazonaws.services.dataexchange.model.UpdateEventActionResult;
import com.amazonaws.services.dataexchange.model.UpdateRevisionRequest;
import com.amazonaws.services.dataexchange.model.UpdateRevisionResult;
import com.amazonaws.services.dataexchange.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.CancelJobRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.CancelJobResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.CreateDataSetRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.CreateDataSetResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.CreateEventActionRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.CreateEventActionResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.CreateJobRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.CreateJobResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.CreateRevisionRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.CreateRevisionResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.DeleteAssetRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.DeleteAssetResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.DeleteDataSetRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.DeleteDataSetResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.DeleteEventActionRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.DeleteEventActionResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.DeleteRevisionRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.DeleteRevisionResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetAssetRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetAssetResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetDataSetRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetDataSetResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetEventActionRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetEventActionResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetJobRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetJobResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetRevisionRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.GetRevisionResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListDataSetRevisionsRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListDataSetRevisionsResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListDataSetsRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListDataSetsResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListEventActionsRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListEventActionsResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListJobsRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListJobsResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListRevisionAssetsRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListRevisionAssetsResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ServiceLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.StartJobRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.StartJobResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.UpdateAssetRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.UpdateAssetResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.UpdateDataSetRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.UpdateDataSetResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.UpdateEventActionRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.UpdateEventActionResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.UpdateRevisionRequestProtocolMarshaller;
import com.amazonaws.services.dataexchange.model.transform.UpdateRevisionResultJsonUnmarshaller;
import com.amazonaws.services.dataexchange.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSDataExchangeClient
extends AmazonWebServiceClient
implements AWSDataExchange {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSDataExchange.class);
    private static final String DEFAULT_SIGNING_NAME = "dataexchange";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceLimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceLimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSDataExchangeException.class));

    public static AWSDataExchangeClientBuilder builder() {
        return AWSDataExchangeClientBuilder.standard();
    }

    AWSDataExchangeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSDataExchangeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("dataexchange.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/dataexchange/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/dataexchange/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelJobResult cancelJob(CancelJobRequest request) {
        request = (CancelJobRequest)this.beforeClientExecution(request);
        return this.executeCancelJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelJobResult executeCancelJob(CancelJobRequest cancelJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJobRequestProtocolMarshaller(protocolFactory).marshall((CancelJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelJobResult cancelJobResult = (CancelJobResult)response.getAwsResponse();
            return cancelJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDataSetResult createDataSet(CreateDataSetRequest request) {
        request = (CreateDataSetRequest)this.beforeClientExecution(request);
        return this.executeCreateDataSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDataSetResult executeCreateDataSet(CreateDataSetRequest createDataSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDataSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDataSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDataSetRequestProtocolMarshaller(protocolFactory).marshall((CreateDataSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDataSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDataSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDataSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDataSetResult createDataSetResult = (CreateDataSetResult)response.getAwsResponse();
            return createDataSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateEventActionResult createEventAction(CreateEventActionRequest request) {
        request = (CreateEventActionRequest)this.beforeClientExecution(request);
        return this.executeCreateEventAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateEventActionResult executeCreateEventAction(CreateEventActionRequest createEventActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEventActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEventActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEventActionRequestProtocolMarshaller(protocolFactory).marshall((CreateEventActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createEventActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateEventAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEventActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateEventActionResult createEventActionResult = (CreateEventActionResult)response.getAwsResponse();
            return createEventActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest request) {
        request = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executeCreateJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateJobResult executeCreateJob(CreateJobRequest createJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestProtocolMarshaller(protocolFactory).marshall((CreateJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)createJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateJobResult createJobResult = (CreateJobResult)response.getAwsResponse();
            return createJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateRevisionResult createRevision(CreateRevisionRequest request) {
        request = (CreateRevisionRequest)this.beforeClientExecution(request);
        return this.executeCreateRevision(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateRevisionResult executeCreateRevision(CreateRevisionRequest createRevisionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRevisionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRevisionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRevisionRequestProtocolMarshaller(protocolFactory).marshall((CreateRevisionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRevisionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateRevision");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRevisionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRevisionResult createRevisionResult = (CreateRevisionResult)response.getAwsResponse();
            return createRevisionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAssetResult deleteAsset(DeleteAssetRequest request) {
        request = (DeleteAssetRequest)this.beforeClientExecution(request);
        return this.executeDeleteAsset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAssetResult executeDeleteAsset(DeleteAssetRequest deleteAssetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAssetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAssetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAssetRequestProtocolMarshaller(protocolFactory).marshall((DeleteAssetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAssetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAsset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAssetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAssetResult deleteAssetResult = (DeleteAssetResult)response.getAwsResponse();
            return deleteAssetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteDataSetResult deleteDataSet(DeleteDataSetRequest request) {
        request = (DeleteDataSetRequest)this.beforeClientExecution(request);
        return this.executeDeleteDataSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteDataSetResult executeDeleteDataSet(DeleteDataSetRequest deleteDataSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDataSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDataSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDataSetRequestProtocolMarshaller(protocolFactory).marshall((DeleteDataSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDataSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteDataSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteDataSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteDataSetResult deleteDataSetResult = (DeleteDataSetResult)response.getAwsResponse();
            return deleteDataSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEventActionResult deleteEventAction(DeleteEventActionRequest request) {
        request = (DeleteEventActionRequest)this.beforeClientExecution(request);
        return this.executeDeleteEventAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEventActionResult executeDeleteEventAction(DeleteEventActionRequest deleteEventActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEventActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEventActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEventActionRequestProtocolMarshaller(protocolFactory).marshall((DeleteEventActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEventActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEventAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEventActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEventActionResult deleteEventActionResult = (DeleteEventActionResult)response.getAwsResponse();
            return deleteEventActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRevisionResult deleteRevision(DeleteRevisionRequest request) {
        request = (DeleteRevisionRequest)this.beforeClientExecution(request);
        return this.executeDeleteRevision(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRevisionResult executeDeleteRevision(DeleteRevisionRequest deleteRevisionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRevisionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRevisionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRevisionRequestProtocolMarshaller(protocolFactory).marshall((DeleteRevisionRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRevisionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRevision");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRevisionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRevisionResult deleteRevisionResult = (DeleteRevisionResult)response.getAwsResponse();
            return deleteRevisionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAssetResult getAsset(GetAssetRequest request) {
        request = (GetAssetRequest)this.beforeClientExecution(request);
        return this.executeGetAsset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAssetResult executeGetAsset(GetAssetRequest getAssetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAssetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAssetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAssetRequestProtocolMarshaller(protocolFactory).marshall((GetAssetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAssetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAsset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAssetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAssetResult getAssetResult = (GetAssetResult)response.getAwsResponse();
            return getAssetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDataSetResult getDataSet(GetDataSetRequest request) {
        request = (GetDataSetRequest)this.beforeClientExecution(request);
        return this.executeGetDataSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDataSetResult executeGetDataSet(GetDataSetRequest getDataSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataSetRequestProtocolMarshaller(protocolFactory).marshall((GetDataSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDataSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDataSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDataSetResult getDataSetResult = (GetDataSetResult)response.getAwsResponse();
            return getDataSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetEventActionResult getEventAction(GetEventActionRequest request) {
        request = (GetEventActionRequest)this.beforeClientExecution(request);
        return this.executeGetEventAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetEventActionResult executeGetEventAction(GetEventActionRequest getEventActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getEventActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEventActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetEventActionRequestProtocolMarshaller(protocolFactory).marshall((GetEventActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getEventActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetEventAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEventActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetEventActionResult getEventActionResult = (GetEventActionResult)response.getAwsResponse();
            return getEventActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetJobResult getJob(GetJobRequest request) {
        request = (GetJobRequest)this.beforeClientExecution(request);
        return this.executeGetJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetJobResult executeGetJob(GetJobRequest getJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobRequestProtocolMarshaller(protocolFactory).marshall((GetJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetJobResult getJobResult = (GetJobResult)response.getAwsResponse();
            return getJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetRevisionResult getRevision(GetRevisionRequest request) {
        request = (GetRevisionRequest)this.beforeClientExecution(request);
        return this.executeGetRevision(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetRevisionResult executeGetRevision(GetRevisionRequest getRevisionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRevisionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRevisionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRevisionRequestProtocolMarshaller(protocolFactory).marshall((GetRevisionRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRevisionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetRevision");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRevisionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRevisionResult getRevisionResult = (GetRevisionResult)response.getAwsResponse();
            return getRevisionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataSetRevisionsResult listDataSetRevisions(ListDataSetRevisionsRequest request) {
        request = (ListDataSetRevisionsRequest)this.beforeClientExecution(request);
        return this.executeListDataSetRevisions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataSetRevisionsResult executeListDataSetRevisions(ListDataSetRevisionsRequest listDataSetRevisionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataSetRevisionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataSetRevisionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataSetRevisionsRequestProtocolMarshaller(protocolFactory).marshall((ListDataSetRevisionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDataSetRevisionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDataSetRevisions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataSetRevisionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataSetRevisionsResult listDataSetRevisionsResult = (ListDataSetRevisionsResult)response.getAwsResponse();
            return listDataSetRevisionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDataSetsResult listDataSets(ListDataSetsRequest request) {
        request = (ListDataSetsRequest)this.beforeClientExecution(request);
        return this.executeListDataSets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDataSetsResult executeListDataSets(ListDataSetsRequest listDataSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDataSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDataSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDataSetsRequestProtocolMarshaller(protocolFactory).marshall((ListDataSetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDataSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDataSets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDataSetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDataSetsResult listDataSetsResult = (ListDataSetsResult)response.getAwsResponse();
            return listDataSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEventActionsResult listEventActions(ListEventActionsRequest request) {
        request = (ListEventActionsRequest)this.beforeClientExecution(request);
        return this.executeListEventActions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEventActionsResult executeListEventActions(ListEventActionsRequest listEventActionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventActionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventActionsRequestProtocolMarshaller(protocolFactory).marshall((ListEventActionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEventActionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEventActions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEventActionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEventActionsResult listEventActionsResult = (ListEventActionsResult)response.getAwsResponse();
            return listEventActionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest request) {
        request = (ListJobsRequest)this.beforeClientExecution(request);
        return this.executeListJobs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListJobsResult executeListJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestProtocolMarshaller(protocolFactory).marshall((ListJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListJobs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRevisionAssetsResult listRevisionAssets(ListRevisionAssetsRequest request) {
        request = (ListRevisionAssetsRequest)this.beforeClientExecution(request);
        return this.executeListRevisionAssets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRevisionAssetsResult executeListRevisionAssets(ListRevisionAssetsRequest listRevisionAssetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRevisionAssetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRevisionAssetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRevisionAssetsRequestProtocolMarshaller(protocolFactory).marshall((ListRevisionAssetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRevisionAssetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRevisionAssets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRevisionAssetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRevisionAssetsResult listRevisionAssetsResult = (ListRevisionAssetsResult)response.getAwsResponse();
            return listRevisionAssetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartJobResult startJob(StartJobRequest request) {
        request = (StartJobRequest)this.beforeClientExecution(request);
        return this.executeStartJob(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartJobResult executeStartJob(StartJobRequest startJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartJobRequestProtocolMarshaller(protocolFactory).marshall((StartJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)startJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartJob");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartJobResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartJobResult startJobResult = (StartJobResult)response.getAwsResponse();
            return startJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateAssetResult updateAsset(UpdateAssetRequest request) {
        request = (UpdateAssetRequest)this.beforeClientExecution(request);
        return this.executeUpdateAsset(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateAssetResult executeUpdateAsset(UpdateAssetRequest updateAssetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAssetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateAssetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateAssetRequestProtocolMarshaller(protocolFactory).marshall((UpdateAssetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateAssetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateAsset");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateAssetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateAssetResult updateAssetResult = (UpdateAssetResult)response.getAwsResponse();
            return updateAssetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDataSetResult updateDataSet(UpdateDataSetRequest request) {
        request = (UpdateDataSetRequest)this.beforeClientExecution(request);
        return this.executeUpdateDataSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDataSetResult executeUpdateDataSet(UpdateDataSetRequest updateDataSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDataSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDataSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDataSetRequestProtocolMarshaller(protocolFactory).marshall((UpdateDataSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDataSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDataSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDataSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDataSetResult updateDataSetResult = (UpdateDataSetResult)response.getAwsResponse();
            return updateDataSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateEventActionResult updateEventAction(UpdateEventActionRequest request) {
        request = (UpdateEventActionRequest)this.beforeClientExecution(request);
        return this.executeUpdateEventAction(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateEventActionResult executeUpdateEventAction(UpdateEventActionRequest updateEventActionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEventActionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateEventActionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateEventActionRequestProtocolMarshaller(protocolFactory).marshall((UpdateEventActionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateEventActionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateEventAction");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEventActionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateEventActionResult updateEventActionResult = (UpdateEventActionResult)response.getAwsResponse();
            return updateEventActionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRevisionResult updateRevision(UpdateRevisionRequest request) {
        request = (UpdateRevisionRequest)this.beforeClientExecution(request);
        return this.executeUpdateRevision(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRevisionResult executeUpdateRevision(UpdateRevisionRequest updateRevisionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRevisionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRevisionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRevisionRequestProtocolMarshaller(protocolFactory).marshall((UpdateRevisionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRevisionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"DataExchange");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateRevision");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRevisionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRevisionResult updateRevisionResult = (UpdateRevisionResult)response.getAwsResponse();
            return updateRevisionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

