/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ebs;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ebs.AmazonEBSAsync;
import com.amazonaws.services.ebs.AmazonEBSAsyncClientBuilder;
import com.amazonaws.services.ebs.AmazonEBSClient;
import com.amazonaws.services.ebs.model.CompleteSnapshotRequest;
import com.amazonaws.services.ebs.model.CompleteSnapshotResult;
import com.amazonaws.services.ebs.model.GetSnapshotBlockRequest;
import com.amazonaws.services.ebs.model.GetSnapshotBlockResult;
import com.amazonaws.services.ebs.model.ListChangedBlocksRequest;
import com.amazonaws.services.ebs.model.ListChangedBlocksResult;
import com.amazonaws.services.ebs.model.ListSnapshotBlocksRequest;
import com.amazonaws.services.ebs.model.ListSnapshotBlocksResult;
import com.amazonaws.services.ebs.model.PutSnapshotBlockRequest;
import com.amazonaws.services.ebs.model.PutSnapshotBlockResult;
import com.amazonaws.services.ebs.model.StartSnapshotRequest;
import com.amazonaws.services.ebs.model.StartSnapshotResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonEBSAsyncClient
extends AmazonEBSClient
implements AmazonEBSAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonEBSAsyncClientBuilder asyncBuilder() {
        return AmazonEBSAsyncClientBuilder.standard();
    }

    AmazonEBSAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonEBSAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CompleteSnapshotResult> completeSnapshotAsync(CompleteSnapshotRequest request) {
        return this.completeSnapshotAsync(request, null);
    }

    @Override
    public Future<CompleteSnapshotResult> completeSnapshotAsync(CompleteSnapshotRequest request, final AsyncHandler<CompleteSnapshotRequest, CompleteSnapshotResult> asyncHandler) {
        final CompleteSnapshotRequest finalRequest = (CompleteSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CompleteSnapshotResult>(){

            @Override
            public CompleteSnapshotResult call() throws Exception {
                CompleteSnapshotResult result = null;
                try {
                    result = AmazonEBSAsyncClient.this.executeCompleteSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSnapshotBlockResult> getSnapshotBlockAsync(GetSnapshotBlockRequest request) {
        return this.getSnapshotBlockAsync(request, null);
    }

    @Override
    public Future<GetSnapshotBlockResult> getSnapshotBlockAsync(GetSnapshotBlockRequest request, final AsyncHandler<GetSnapshotBlockRequest, GetSnapshotBlockResult> asyncHandler) {
        final GetSnapshotBlockRequest finalRequest = (GetSnapshotBlockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSnapshotBlockResult>(){

            @Override
            public GetSnapshotBlockResult call() throws Exception {
                GetSnapshotBlockResult result = null;
                try {
                    result = AmazonEBSAsyncClient.this.executeGetSnapshotBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChangedBlocksResult> listChangedBlocksAsync(ListChangedBlocksRequest request) {
        return this.listChangedBlocksAsync(request, null);
    }

    @Override
    public Future<ListChangedBlocksResult> listChangedBlocksAsync(ListChangedBlocksRequest request, final AsyncHandler<ListChangedBlocksRequest, ListChangedBlocksResult> asyncHandler) {
        final ListChangedBlocksRequest finalRequest = (ListChangedBlocksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChangedBlocksResult>(){

            @Override
            public ListChangedBlocksResult call() throws Exception {
                ListChangedBlocksResult result = null;
                try {
                    result = AmazonEBSAsyncClient.this.executeListChangedBlocks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSnapshotBlocksResult> listSnapshotBlocksAsync(ListSnapshotBlocksRequest request) {
        return this.listSnapshotBlocksAsync(request, null);
    }

    @Override
    public Future<ListSnapshotBlocksResult> listSnapshotBlocksAsync(ListSnapshotBlocksRequest request, final AsyncHandler<ListSnapshotBlocksRequest, ListSnapshotBlocksResult> asyncHandler) {
        final ListSnapshotBlocksRequest finalRequest = (ListSnapshotBlocksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSnapshotBlocksResult>(){

            @Override
            public ListSnapshotBlocksResult call() throws Exception {
                ListSnapshotBlocksResult result = null;
                try {
                    result = AmazonEBSAsyncClient.this.executeListSnapshotBlocks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutSnapshotBlockResult> putSnapshotBlockAsync(PutSnapshotBlockRequest request) {
        return this.putSnapshotBlockAsync(request, null);
    }

    @Override
    public Future<PutSnapshotBlockResult> putSnapshotBlockAsync(PutSnapshotBlockRequest request, final AsyncHandler<PutSnapshotBlockRequest, PutSnapshotBlockResult> asyncHandler) {
        final PutSnapshotBlockRequest finalRequest = (PutSnapshotBlockRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutSnapshotBlockResult>(){

            @Override
            public PutSnapshotBlockResult call() throws Exception {
                PutSnapshotBlockResult result = null;
                try {
                    result = AmazonEBSAsyncClient.this.executePutSnapshotBlock(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSnapshotResult> startSnapshotAsync(StartSnapshotRequest request) {
        return this.startSnapshotAsync(request, null);
    }

    @Override
    public Future<StartSnapshotResult> startSnapshotAsync(StartSnapshotRequest request, final AsyncHandler<StartSnapshotRequest, StartSnapshotResult> asyncHandler) {
        final StartSnapshotRequest finalRequest = (StartSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSnapshotResult>(){

            @Override
            public StartSnapshotResult call() throws Exception {
                StartSnapshotResult result = null;
                try {
                    result = AmazonEBSAsyncClient.this.executeStartSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

