/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderAsync;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderAsyncClientBuilder;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoderClient;
import com.amazonaws.services.elastictranscoder.model.CancelJobRequest;
import com.amazonaws.services.elastictranscoder.model.CancelJobResult;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.CreateJobResult;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePresetResult;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineResult;
import com.amazonaws.services.elastictranscoder.model.DeletePresetRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePresetResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusResult;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesRequest;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesResult;
import com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.amazonaws.services.elastictranscoder.model.ListPresetsResult;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.services.elastictranscoder.model.ReadJobResult;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPresetResult;
import com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.amazonaws.services.elastictranscoder.model.TestRoleResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonElasticTranscoderAsyncClient
extends AmazonElasticTranscoderClient
implements AmazonElasticTranscoderAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonElasticTranscoderAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonElasticTranscoderAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonElasticTranscoderAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonElasticTranscoderAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonElasticTranscoderAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonElasticTranscoderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonElasticTranscoderAsyncClientBuilder asyncBuilder() {
        return AmazonElasticTranscoderAsyncClientBuilder.standard();
    }

    AmazonElasticTranscoderAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonElasticTranscoderAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request) {
        return this.cancelJobAsync(request, null);
    }

    @Override
    public Future<CancelJobResult> cancelJobAsync(CancelJobRequest request, final AsyncHandler<CancelJobRequest, CancelJobResult> asyncHandler) {
        final CancelJobRequest finalRequest = (CancelJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelJobResult>(){

            @Override
            public CancelJobResult call() throws Exception {
                CancelJobResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeCancelJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request) {
        return this.createJobAsync(request, null);
    }

    @Override
    public Future<CreateJobResult> createJobAsync(CreateJobRequest request, final AsyncHandler<CreateJobRequest, CreateJobResult> asyncHandler) {
        final CreateJobRequest finalRequest = (CreateJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateJobResult>(){

            @Override
            public CreateJobResult call() throws Exception {
                CreateJobResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeCreateJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineAsync(request, null);
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        final CreatePipelineRequest finalRequest = (CreatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeCreatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePresetResult> createPresetAsync(CreatePresetRequest request) {
        return this.createPresetAsync(request, null);
    }

    @Override
    public Future<CreatePresetResult> createPresetAsync(CreatePresetRequest request, final AsyncHandler<CreatePresetRequest, CreatePresetResult> asyncHandler) {
        final CreatePresetRequest finalRequest = (CreatePresetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePresetResult>(){

            @Override
            public CreatePresetResult call() throws Exception {
                CreatePresetResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeCreatePreset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineAsync(request, null);
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request, final AsyncHandler<DeletePipelineRequest, DeletePipelineResult> asyncHandler) {
        final DeletePipelineRequest finalRequest = (DeletePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePipelineResult>(){

            @Override
            public DeletePipelineResult call() throws Exception {
                DeletePipelineResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeDeletePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePresetResult> deletePresetAsync(DeletePresetRequest request) {
        return this.deletePresetAsync(request, null);
    }

    @Override
    public Future<DeletePresetResult> deletePresetAsync(DeletePresetRequest request, final AsyncHandler<DeletePresetRequest, DeletePresetResult> asyncHandler) {
        final DeletePresetRequest finalRequest = (DeletePresetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePresetResult>(){

            @Override
            public DeletePresetResult call() throws Exception {
                DeletePresetResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeDeletePreset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsByPipelineResult> listJobsByPipelineAsync(ListJobsByPipelineRequest request) {
        return this.listJobsByPipelineAsync(request, null);
    }

    @Override
    public Future<ListJobsByPipelineResult> listJobsByPipelineAsync(ListJobsByPipelineRequest request, final AsyncHandler<ListJobsByPipelineRequest, ListJobsByPipelineResult> asyncHandler) {
        final ListJobsByPipelineRequest finalRequest = (ListJobsByPipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobsByPipelineResult>(){

            @Override
            public ListJobsByPipelineResult call() throws Exception {
                ListJobsByPipelineResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeListJobsByPipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsByStatusResult> listJobsByStatusAsync(ListJobsByStatusRequest request) {
        return this.listJobsByStatusAsync(request, null);
    }

    @Override
    public Future<ListJobsByStatusResult> listJobsByStatusAsync(ListJobsByStatusRequest request, final AsyncHandler<ListJobsByStatusRequest, ListJobsByStatusResult> asyncHandler) {
        final ListJobsByStatusRequest finalRequest = (ListJobsByStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListJobsByStatusResult>(){

            @Override
            public ListJobsByStatusResult call() throws Exception {
                ListJobsByStatusResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeListJobsByStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request) {
        return this.listPipelinesAsync(request, null);
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        final ListPipelinesRequest finalRequest = (ListPipelinesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeListPipelines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync() {
        return this.listPipelinesAsync(new ListPipelinesRequest());
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.listPipelinesAsync(new ListPipelinesRequest(), asyncHandler);
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(ListPresetsRequest request) {
        return this.listPresetsAsync(request, null);
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(ListPresetsRequest request, final AsyncHandler<ListPresetsRequest, ListPresetsResult> asyncHandler) {
        final ListPresetsRequest finalRequest = (ListPresetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPresetsResult>(){

            @Override
            public ListPresetsResult call() throws Exception {
                ListPresetsResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeListPresets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync() {
        return this.listPresetsAsync(new ListPresetsRequest());
    }

    @Override
    public Future<ListPresetsResult> listPresetsAsync(AsyncHandler<ListPresetsRequest, ListPresetsResult> asyncHandler) {
        return this.listPresetsAsync(new ListPresetsRequest(), asyncHandler);
    }

    @Override
    public Future<ReadJobResult> readJobAsync(ReadJobRequest request) {
        return this.readJobAsync(request, null);
    }

    @Override
    public Future<ReadJobResult> readJobAsync(ReadJobRequest request, final AsyncHandler<ReadJobRequest, ReadJobResult> asyncHandler) {
        final ReadJobRequest finalRequest = (ReadJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReadJobResult>(){

            @Override
            public ReadJobResult call() throws Exception {
                ReadJobResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeReadJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReadPipelineResult> readPipelineAsync(ReadPipelineRequest request) {
        return this.readPipelineAsync(request, null);
    }

    @Override
    public Future<ReadPipelineResult> readPipelineAsync(ReadPipelineRequest request, final AsyncHandler<ReadPipelineRequest, ReadPipelineResult> asyncHandler) {
        final ReadPipelineRequest finalRequest = (ReadPipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReadPipelineResult>(){

            @Override
            public ReadPipelineResult call() throws Exception {
                ReadPipelineResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeReadPipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReadPresetResult> readPresetAsync(ReadPresetRequest request) {
        return this.readPresetAsync(request, null);
    }

    @Override
    public Future<ReadPresetResult> readPresetAsync(ReadPresetRequest request, final AsyncHandler<ReadPresetRequest, ReadPresetResult> asyncHandler) {
        final ReadPresetRequest finalRequest = (ReadPresetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReadPresetResult>(){

            @Override
            public ReadPresetResult call() throws Exception {
                ReadPresetResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeReadPreset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    @Deprecated
    public Future<TestRoleResult> testRoleAsync(TestRoleRequest request) {
        return this.testRoleAsync(request, null);
    }

    @Override
    @Deprecated
    public Future<TestRoleResult> testRoleAsync(TestRoleRequest request, final AsyncHandler<TestRoleRequest, TestRoleResult> asyncHandler) {
        final TestRoleRequest finalRequest = (TestRoleRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TestRoleResult>(){

            @Override
            public TestRoleResult call() throws Exception {
                TestRoleResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeTestRole(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request) {
        return this.updatePipelineAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) {
        final UpdatePipelineRequest finalRequest = (UpdatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeUpdatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineNotificationsResult> updatePipelineNotificationsAsync(UpdatePipelineNotificationsRequest request) {
        return this.updatePipelineNotificationsAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineNotificationsResult> updatePipelineNotificationsAsync(UpdatePipelineNotificationsRequest request, final AsyncHandler<UpdatePipelineNotificationsRequest, UpdatePipelineNotificationsResult> asyncHandler) {
        final UpdatePipelineNotificationsRequest finalRequest = (UpdatePipelineNotificationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePipelineNotificationsResult>(){

            @Override
            public UpdatePipelineNotificationsResult call() throws Exception {
                UpdatePipelineNotificationsResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeUpdatePipelineNotifications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineStatusResult> updatePipelineStatusAsync(UpdatePipelineStatusRequest request) {
        return this.updatePipelineStatusAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineStatusResult> updatePipelineStatusAsync(UpdatePipelineStatusRequest request, final AsyncHandler<UpdatePipelineStatusRequest, UpdatePipelineStatusResult> asyncHandler) {
        final UpdatePipelineStatusRequest finalRequest = (UpdatePipelineStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePipelineStatusResult>(){

            @Override
            public UpdatePipelineStatusResult call() throws Exception {
                UpdatePipelineStatusResult result = null;
                try {
                    result = AmazonElasticTranscoderAsyncClient.this.executeUpdatePipelineStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

