/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.iot.model.PolicyVersion;
import java.util.Date;

@SdkInternalApi
public class PolicyVersionMarshaller {
    private static final MarshallingInfo<String> VERSIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("versionId").build();
    private static final MarshallingInfo<Boolean> ISDEFAULTVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isDefaultVersion").build();
    private static final MarshallingInfo<Date> CREATEDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createDate").timestampFormat("unixTimestamp").build();
    private static final PolicyVersionMarshaller instance = new PolicyVersionMarshaller();

    public static PolicyVersionMarshaller getInstance() {
        return instance;
    }

    public void marshall(PolicyVersion policyVersion, ProtocolMarshaller protocolMarshaller) {
        if (policyVersion == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)policyVersion.getVersionId(), VERSIONID_BINDING);
            protocolMarshaller.marshall((Object)policyVersion.getIsDefaultVersion(), ISDEFAULTVERSION_BINDING);
            protocolMarshaller.marshall((Object)policyVersion.getCreateDate(), CREATEDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

