/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotanalytics;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.iotanalytics.AWSIoTAnalyticsAsync;
import com.amazonaws.services.iotanalytics.AWSIoTAnalyticsAsyncClientBuilder;
import com.amazonaws.services.iotanalytics.AWSIoTAnalyticsClient;
import com.amazonaws.services.iotanalytics.model.BatchPutMessageRequest;
import com.amazonaws.services.iotanalytics.model.BatchPutMessageResult;
import com.amazonaws.services.iotanalytics.model.CancelPipelineReprocessingRequest;
import com.amazonaws.services.iotanalytics.model.CancelPipelineReprocessingResult;
import com.amazonaws.services.iotanalytics.model.CreateChannelRequest;
import com.amazonaws.services.iotanalytics.model.CreateChannelResult;
import com.amazonaws.services.iotanalytics.model.CreateDatasetContentRequest;
import com.amazonaws.services.iotanalytics.model.CreateDatasetContentResult;
import com.amazonaws.services.iotanalytics.model.CreateDatasetRequest;
import com.amazonaws.services.iotanalytics.model.CreateDatasetResult;
import com.amazonaws.services.iotanalytics.model.CreateDatastoreRequest;
import com.amazonaws.services.iotanalytics.model.CreateDatastoreResult;
import com.amazonaws.services.iotanalytics.model.CreatePipelineRequest;
import com.amazonaws.services.iotanalytics.model.CreatePipelineResult;
import com.amazonaws.services.iotanalytics.model.DeleteChannelRequest;
import com.amazonaws.services.iotanalytics.model.DeleteChannelResult;
import com.amazonaws.services.iotanalytics.model.DeleteDatasetContentRequest;
import com.amazonaws.services.iotanalytics.model.DeleteDatasetContentResult;
import com.amazonaws.services.iotanalytics.model.DeleteDatasetRequest;
import com.amazonaws.services.iotanalytics.model.DeleteDatasetResult;
import com.amazonaws.services.iotanalytics.model.DeleteDatastoreRequest;
import com.amazonaws.services.iotanalytics.model.DeleteDatastoreResult;
import com.amazonaws.services.iotanalytics.model.DeletePipelineRequest;
import com.amazonaws.services.iotanalytics.model.DeletePipelineResult;
import com.amazonaws.services.iotanalytics.model.DescribeChannelRequest;
import com.amazonaws.services.iotanalytics.model.DescribeChannelResult;
import com.amazonaws.services.iotanalytics.model.DescribeDatasetRequest;
import com.amazonaws.services.iotanalytics.model.DescribeDatasetResult;
import com.amazonaws.services.iotanalytics.model.DescribeDatastoreRequest;
import com.amazonaws.services.iotanalytics.model.DescribeDatastoreResult;
import com.amazonaws.services.iotanalytics.model.DescribeLoggingOptionsRequest;
import com.amazonaws.services.iotanalytics.model.DescribeLoggingOptionsResult;
import com.amazonaws.services.iotanalytics.model.DescribePipelineRequest;
import com.amazonaws.services.iotanalytics.model.DescribePipelineResult;
import com.amazonaws.services.iotanalytics.model.GetDatasetContentRequest;
import com.amazonaws.services.iotanalytics.model.GetDatasetContentResult;
import com.amazonaws.services.iotanalytics.model.ListChannelsRequest;
import com.amazonaws.services.iotanalytics.model.ListChannelsResult;
import com.amazonaws.services.iotanalytics.model.ListDatasetContentsRequest;
import com.amazonaws.services.iotanalytics.model.ListDatasetContentsResult;
import com.amazonaws.services.iotanalytics.model.ListDatasetsRequest;
import com.amazonaws.services.iotanalytics.model.ListDatasetsResult;
import com.amazonaws.services.iotanalytics.model.ListDatastoresRequest;
import com.amazonaws.services.iotanalytics.model.ListDatastoresResult;
import com.amazonaws.services.iotanalytics.model.ListPipelinesRequest;
import com.amazonaws.services.iotanalytics.model.ListPipelinesResult;
import com.amazonaws.services.iotanalytics.model.ListTagsForResourceRequest;
import com.amazonaws.services.iotanalytics.model.ListTagsForResourceResult;
import com.amazonaws.services.iotanalytics.model.PutLoggingOptionsRequest;
import com.amazonaws.services.iotanalytics.model.PutLoggingOptionsResult;
import com.amazonaws.services.iotanalytics.model.RunPipelineActivityRequest;
import com.amazonaws.services.iotanalytics.model.RunPipelineActivityResult;
import com.amazonaws.services.iotanalytics.model.SampleChannelDataRequest;
import com.amazonaws.services.iotanalytics.model.SampleChannelDataResult;
import com.amazonaws.services.iotanalytics.model.StartPipelineReprocessingRequest;
import com.amazonaws.services.iotanalytics.model.StartPipelineReprocessingResult;
import com.amazonaws.services.iotanalytics.model.TagResourceRequest;
import com.amazonaws.services.iotanalytics.model.TagResourceResult;
import com.amazonaws.services.iotanalytics.model.UntagResourceRequest;
import com.amazonaws.services.iotanalytics.model.UntagResourceResult;
import com.amazonaws.services.iotanalytics.model.UpdateChannelRequest;
import com.amazonaws.services.iotanalytics.model.UpdateChannelResult;
import com.amazonaws.services.iotanalytics.model.UpdateDatasetRequest;
import com.amazonaws.services.iotanalytics.model.UpdateDatasetResult;
import com.amazonaws.services.iotanalytics.model.UpdateDatastoreRequest;
import com.amazonaws.services.iotanalytics.model.UpdateDatastoreResult;
import com.amazonaws.services.iotanalytics.model.UpdatePipelineRequest;
import com.amazonaws.services.iotanalytics.model.UpdatePipelineResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSIoTAnalyticsAsyncClient
extends AWSIoTAnalyticsClient
implements AWSIoTAnalyticsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSIoTAnalyticsAsyncClientBuilder asyncBuilder() {
        return AWSIoTAnalyticsAsyncClientBuilder.standard();
    }

    AWSIoTAnalyticsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchPutMessageResult> batchPutMessageAsync(BatchPutMessageRequest request) {
        return this.batchPutMessageAsync(request, null);
    }

    @Override
    public Future<BatchPutMessageResult> batchPutMessageAsync(BatchPutMessageRequest request, final AsyncHandler<BatchPutMessageRequest, BatchPutMessageResult> asyncHandler) {
        final BatchPutMessageRequest finalRequest = (BatchPutMessageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchPutMessageResult>(){

            @Override
            public BatchPutMessageResult call() throws Exception {
                BatchPutMessageResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeBatchPutMessage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelPipelineReprocessingResult> cancelPipelineReprocessingAsync(CancelPipelineReprocessingRequest request) {
        return this.cancelPipelineReprocessingAsync(request, null);
    }

    @Override
    public Future<CancelPipelineReprocessingResult> cancelPipelineReprocessingAsync(CancelPipelineReprocessingRequest request, final AsyncHandler<CancelPipelineReprocessingRequest, CancelPipelineReprocessingResult> asyncHandler) {
        final CancelPipelineReprocessingRequest finalRequest = (CancelPipelineReprocessingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelPipelineReprocessingResult>(){

            @Override
            public CancelPipelineReprocessingResult call() throws Exception {
                CancelPipelineReprocessingResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeCancelPipelineReprocessing(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelAsync(request, null);
    }

    @Override
    public Future<CreateChannelResult> createChannelAsync(CreateChannelRequest request, final AsyncHandler<CreateChannelRequest, CreateChannelResult> asyncHandler) {
        final CreateChannelRequest finalRequest = (CreateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateChannelResult>(){

            @Override
            public CreateChannelResult call() throws Exception {
                CreateChannelResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeCreateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request) {
        return this.createDatasetAsync(request, null);
    }

    @Override
    public Future<CreateDatasetResult> createDatasetAsync(CreateDatasetRequest request, final AsyncHandler<CreateDatasetRequest, CreateDatasetResult> asyncHandler) {
        final CreateDatasetRequest finalRequest = (CreateDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatasetResult>(){

            @Override
            public CreateDatasetResult call() throws Exception {
                CreateDatasetResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeCreateDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDatasetContentResult> createDatasetContentAsync(CreateDatasetContentRequest request) {
        return this.createDatasetContentAsync(request, null);
    }

    @Override
    public Future<CreateDatasetContentResult> createDatasetContentAsync(CreateDatasetContentRequest request, final AsyncHandler<CreateDatasetContentRequest, CreateDatasetContentResult> asyncHandler) {
        final CreateDatasetContentRequest finalRequest = (CreateDatasetContentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatasetContentResult>(){

            @Override
            public CreateDatasetContentResult call() throws Exception {
                CreateDatasetContentResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeCreateDatasetContent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDatastoreResult> createDatastoreAsync(CreateDatastoreRequest request) {
        return this.createDatastoreAsync(request, null);
    }

    @Override
    public Future<CreateDatastoreResult> createDatastoreAsync(CreateDatastoreRequest request, final AsyncHandler<CreateDatastoreRequest, CreateDatastoreResult> asyncHandler) {
        final CreateDatastoreRequest finalRequest = (CreateDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDatastoreResult>(){

            @Override
            public CreateDatastoreResult call() throws Exception {
                CreateDatastoreResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeCreateDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineAsync(request, null);
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        final CreatePipelineRequest finalRequest = (CreatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeCreatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelAsync(request, null);
    }

    @Override
    public Future<DeleteChannelResult> deleteChannelAsync(DeleteChannelRequest request, final AsyncHandler<DeleteChannelRequest, DeleteChannelResult> asyncHandler) {
        final DeleteChannelRequest finalRequest = (DeleteChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteChannelResult>(){

            @Override
            public DeleteChannelResult call() throws Exception {
                DeleteChannelResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDeleteChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetAsync(request, null);
    }

    @Override
    public Future<DeleteDatasetResult> deleteDatasetAsync(DeleteDatasetRequest request, final AsyncHandler<DeleteDatasetRequest, DeleteDatasetResult> asyncHandler) {
        final DeleteDatasetRequest finalRequest = (DeleteDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatasetResult>(){

            @Override
            public DeleteDatasetResult call() throws Exception {
                DeleteDatasetResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDeleteDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatasetContentResult> deleteDatasetContentAsync(DeleteDatasetContentRequest request) {
        return this.deleteDatasetContentAsync(request, null);
    }

    @Override
    public Future<DeleteDatasetContentResult> deleteDatasetContentAsync(DeleteDatasetContentRequest request, final AsyncHandler<DeleteDatasetContentRequest, DeleteDatasetContentResult> asyncHandler) {
        final DeleteDatasetContentRequest finalRequest = (DeleteDatasetContentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatasetContentResult>(){

            @Override
            public DeleteDatasetContentResult call() throws Exception {
                DeleteDatasetContentResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDeleteDatasetContent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDatastoreResult> deleteDatastoreAsync(DeleteDatastoreRequest request) {
        return this.deleteDatastoreAsync(request, null);
    }

    @Override
    public Future<DeleteDatastoreResult> deleteDatastoreAsync(DeleteDatastoreRequest request, final AsyncHandler<DeleteDatastoreRequest, DeleteDatastoreResult> asyncHandler) {
        final DeleteDatastoreRequest finalRequest = (DeleteDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDatastoreResult>(){

            @Override
            public DeleteDatastoreResult call() throws Exception {
                DeleteDatastoreResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDeleteDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineAsync(request, null);
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request, final AsyncHandler<DeletePipelineRequest, DeletePipelineResult> asyncHandler) {
        final DeletePipelineRequest finalRequest = (DeletePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePipelineResult>(){

            @Override
            public DeletePipelineResult call() throws Exception {
                DeletePipelineResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDeletePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request) {
        return this.describeChannelAsync(request, null);
    }

    @Override
    public Future<DescribeChannelResult> describeChannelAsync(DescribeChannelRequest request, final AsyncHandler<DescribeChannelRequest, DescribeChannelResult> asyncHandler) {
        final DescribeChannelRequest finalRequest = (DescribeChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeChannelResult>(){

            @Override
            public DescribeChannelResult call() throws Exception {
                DescribeChannelResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDescribeChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(DescribeDatasetRequest request) {
        return this.describeDatasetAsync(request, null);
    }

    @Override
    public Future<DescribeDatasetResult> describeDatasetAsync(DescribeDatasetRequest request, final AsyncHandler<DescribeDatasetRequest, DescribeDatasetResult> asyncHandler) {
        final DescribeDatasetRequest finalRequest = (DescribeDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDatasetResult>(){

            @Override
            public DescribeDatasetResult call() throws Exception {
                DescribeDatasetResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDescribeDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDatastoreResult> describeDatastoreAsync(DescribeDatastoreRequest request) {
        return this.describeDatastoreAsync(request, null);
    }

    @Override
    public Future<DescribeDatastoreResult> describeDatastoreAsync(DescribeDatastoreRequest request, final AsyncHandler<DescribeDatastoreRequest, DescribeDatastoreResult> asyncHandler) {
        final DescribeDatastoreRequest finalRequest = (DescribeDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDatastoreResult>(){

            @Override
            public DescribeDatastoreResult call() throws Exception {
                DescribeDatastoreResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDescribeDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLoggingOptionsResult> describeLoggingOptionsAsync(DescribeLoggingOptionsRequest request) {
        return this.describeLoggingOptionsAsync(request, null);
    }

    @Override
    public Future<DescribeLoggingOptionsResult> describeLoggingOptionsAsync(DescribeLoggingOptionsRequest request, final AsyncHandler<DescribeLoggingOptionsRequest, DescribeLoggingOptionsResult> asyncHandler) {
        final DescribeLoggingOptionsRequest finalRequest = (DescribeLoggingOptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeLoggingOptionsResult>(){

            @Override
            public DescribeLoggingOptionsResult call() throws Exception {
                DescribeLoggingOptionsResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDescribeLoggingOptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePipelineResult> describePipelineAsync(DescribePipelineRequest request) {
        return this.describePipelineAsync(request, null);
    }

    @Override
    public Future<DescribePipelineResult> describePipelineAsync(DescribePipelineRequest request, final AsyncHandler<DescribePipelineRequest, DescribePipelineResult> asyncHandler) {
        final DescribePipelineRequest finalRequest = (DescribePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePipelineResult>(){

            @Override
            public DescribePipelineResult call() throws Exception {
                DescribePipelineResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeDescribePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDatasetContentResult> getDatasetContentAsync(GetDatasetContentRequest request) {
        return this.getDatasetContentAsync(request, null);
    }

    @Override
    public Future<GetDatasetContentResult> getDatasetContentAsync(GetDatasetContentRequest request, final AsyncHandler<GetDatasetContentRequest, GetDatasetContentResult> asyncHandler) {
        final GetDatasetContentRequest finalRequest = (GetDatasetContentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDatasetContentResult>(){

            @Override
            public GetDatasetContentResult call() throws Exception {
                GetDatasetContentResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeGetDatasetContent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request) {
        return this.listChannelsAsync(request, null);
    }

    @Override
    public Future<ListChannelsResult> listChannelsAsync(ListChannelsRequest request, final AsyncHandler<ListChannelsRequest, ListChannelsResult> asyncHandler) {
        final ListChannelsRequest finalRequest = (ListChannelsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChannelsResult>(){

            @Override
            public ListChannelsResult call() throws Exception {
                ListChannelsResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeListChannels(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetContentsResult> listDatasetContentsAsync(ListDatasetContentsRequest request) {
        return this.listDatasetContentsAsync(request, null);
    }

    @Override
    public Future<ListDatasetContentsResult> listDatasetContentsAsync(ListDatasetContentsRequest request, final AsyncHandler<ListDatasetContentsRequest, ListDatasetContentsResult> asyncHandler) {
        final ListDatasetContentsRequest finalRequest = (ListDatasetContentsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatasetContentsResult>(){

            @Override
            public ListDatasetContentsResult call() throws Exception {
                ListDatasetContentsResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeListDatasetContents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request) {
        return this.listDatasetsAsync(request, null);
    }

    @Override
    public Future<ListDatasetsResult> listDatasetsAsync(ListDatasetsRequest request, final AsyncHandler<ListDatasetsRequest, ListDatasetsResult> asyncHandler) {
        final ListDatasetsRequest finalRequest = (ListDatasetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatasetsResult>(){

            @Override
            public ListDatasetsResult call() throws Exception {
                ListDatasetsResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeListDatasets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListDatastoresResult> listDatastoresAsync(ListDatastoresRequest request) {
        return this.listDatastoresAsync(request, null);
    }

    @Override
    public Future<ListDatastoresResult> listDatastoresAsync(ListDatastoresRequest request, final AsyncHandler<ListDatastoresRequest, ListDatastoresResult> asyncHandler) {
        final ListDatastoresRequest finalRequest = (ListDatastoresRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListDatastoresResult>(){

            @Override
            public ListDatastoresResult call() throws Exception {
                ListDatastoresResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeListDatastores(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request) {
        return this.listPipelinesAsync(request, null);
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        final ListPipelinesRequest finalRequest = (ListPipelinesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeListPipelines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutLoggingOptionsResult> putLoggingOptionsAsync(PutLoggingOptionsRequest request) {
        return this.putLoggingOptionsAsync(request, null);
    }

    @Override
    public Future<PutLoggingOptionsResult> putLoggingOptionsAsync(PutLoggingOptionsRequest request, final AsyncHandler<PutLoggingOptionsRequest, PutLoggingOptionsResult> asyncHandler) {
        final PutLoggingOptionsRequest finalRequest = (PutLoggingOptionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutLoggingOptionsResult>(){

            @Override
            public PutLoggingOptionsResult call() throws Exception {
                PutLoggingOptionsResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executePutLoggingOptions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RunPipelineActivityResult> runPipelineActivityAsync(RunPipelineActivityRequest request) {
        return this.runPipelineActivityAsync(request, null);
    }

    @Override
    public Future<RunPipelineActivityResult> runPipelineActivityAsync(RunPipelineActivityRequest request, final AsyncHandler<RunPipelineActivityRequest, RunPipelineActivityResult> asyncHandler) {
        final RunPipelineActivityRequest finalRequest = (RunPipelineActivityRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RunPipelineActivityResult>(){

            @Override
            public RunPipelineActivityResult call() throws Exception {
                RunPipelineActivityResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeRunPipelineActivity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SampleChannelDataResult> sampleChannelDataAsync(SampleChannelDataRequest request) {
        return this.sampleChannelDataAsync(request, null);
    }

    @Override
    public Future<SampleChannelDataResult> sampleChannelDataAsync(SampleChannelDataRequest request, final AsyncHandler<SampleChannelDataRequest, SampleChannelDataResult> asyncHandler) {
        final SampleChannelDataRequest finalRequest = (SampleChannelDataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SampleChannelDataResult>(){

            @Override
            public SampleChannelDataResult call() throws Exception {
                SampleChannelDataResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeSampleChannelData(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartPipelineReprocessingResult> startPipelineReprocessingAsync(StartPipelineReprocessingRequest request) {
        return this.startPipelineReprocessingAsync(request, null);
    }

    @Override
    public Future<StartPipelineReprocessingResult> startPipelineReprocessingAsync(StartPipelineReprocessingRequest request, final AsyncHandler<StartPipelineReprocessingRequest, StartPipelineReprocessingResult> asyncHandler) {
        final StartPipelineReprocessingRequest finalRequest = (StartPipelineReprocessingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartPipelineReprocessingResult>(){

            @Override
            public StartPipelineReprocessingResult call() throws Exception {
                StartPipelineReprocessingResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeStartPipelineReprocessing(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelAsync(request, null);
    }

    @Override
    public Future<UpdateChannelResult> updateChannelAsync(UpdateChannelRequest request, final AsyncHandler<UpdateChannelRequest, UpdateChannelResult> asyncHandler) {
        final UpdateChannelRequest finalRequest = (UpdateChannelRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateChannelResult>(){

            @Override
            public UpdateChannelResult call() throws Exception {
                UpdateChannelResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeUpdateChannel(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDatasetResult> updateDatasetAsync(UpdateDatasetRequest request) {
        return this.updateDatasetAsync(request, null);
    }

    @Override
    public Future<UpdateDatasetResult> updateDatasetAsync(UpdateDatasetRequest request, final AsyncHandler<UpdateDatasetRequest, UpdateDatasetResult> asyncHandler) {
        final UpdateDatasetRequest finalRequest = (UpdateDatasetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDatasetResult>(){

            @Override
            public UpdateDatasetResult call() throws Exception {
                UpdateDatasetResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeUpdateDataset(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDatastoreResult> updateDatastoreAsync(UpdateDatastoreRequest request) {
        return this.updateDatastoreAsync(request, null);
    }

    @Override
    public Future<UpdateDatastoreResult> updateDatastoreAsync(UpdateDatastoreRequest request, final AsyncHandler<UpdateDatastoreRequest, UpdateDatastoreResult> asyncHandler) {
        final UpdateDatastoreRequest finalRequest = (UpdateDatastoreRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDatastoreResult>(){

            @Override
            public UpdateDatastoreResult call() throws Exception {
                UpdateDatastoreResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeUpdateDatastore(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request) {
        return this.updatePipelineAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) {
        final UpdatePipelineRequest finalRequest = (UpdatePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result = null;
                try {
                    result = AWSIoTAnalyticsAsyncClient.this.executeUpdatePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

