/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.machinelearning.model.Prediction;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.Map;

public class PredictionJsonMarshaller {
    private static PredictionJsonMarshaller instance;

    public void marshall(Prediction prediction, SdkJsonGenerator jsonGenerator) {
        if (prediction == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap detailsMap;
            SdkInternalMap predictedScoresMap;
            jsonGenerator.writeStartObject();
            if (prediction.getPredictedLabel() != null) {
                jsonGenerator.writeFieldName("predictedLabel").writeValue(prediction.getPredictedLabel());
            }
            if (prediction.getPredictedValue() != null) {
                jsonGenerator.writeFieldName("predictedValue").writeValue((double)prediction.getPredictedValue().floatValue());
            }
            if (!(predictedScoresMap = (SdkInternalMap)prediction.getPredictedScores()).isEmpty() || !predictedScoresMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("predictedScores");
                jsonGenerator.writeStartObject();
                for (Map.Entry predictedScoresMapValue : predictedScoresMap.entrySet()) {
                    if (predictedScoresMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)predictedScoresMapValue.getKey());
                    jsonGenerator.writeValue((double)((Float)predictedScoresMapValue.getValue()).floatValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (!(detailsMap = (SdkInternalMap)prediction.getDetails()).isEmpty() || !detailsMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("details");
                jsonGenerator.writeStartObject();
                for (Map.Entry detailsMapValue : detailsMap.entrySet()) {
                    if (detailsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)detailsMapValue.getKey());
                    jsonGenerator.writeValue((String)detailsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PredictionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PredictionJsonMarshaller();
        }
        return instance;
    }
}

