/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.machinelearning.model.DataSource;
import com.amazonaws.services.machinelearning.model.transform.RDSMetadataJsonMarshaller;
import com.amazonaws.services.machinelearning.model.transform.RedshiftMetadataJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class DataSourceJsonMarshaller {
    private static DataSourceJsonMarshaller instance;

    public void marshall(DataSource dataSource, StructuredJsonGenerator jsonGenerator) {
        if (dataSource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (dataSource.getDataSourceId() != null) {
                jsonGenerator.writeFieldName("DataSourceId").writeValue(dataSource.getDataSourceId());
            }
            if (dataSource.getDataLocationS3() != null) {
                jsonGenerator.writeFieldName("DataLocationS3").writeValue(dataSource.getDataLocationS3());
            }
            if (dataSource.getDataRearrangement() != null) {
                jsonGenerator.writeFieldName("DataRearrangement").writeValue(dataSource.getDataRearrangement());
            }
            if (dataSource.getCreatedByIamUser() != null) {
                jsonGenerator.writeFieldName("CreatedByIamUser").writeValue(dataSource.getCreatedByIamUser());
            }
            if (dataSource.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(dataSource.getCreatedAt());
            }
            if (dataSource.getLastUpdatedAt() != null) {
                jsonGenerator.writeFieldName("LastUpdatedAt").writeValue(dataSource.getLastUpdatedAt());
            }
            if (dataSource.getDataSizeInBytes() != null) {
                jsonGenerator.writeFieldName("DataSizeInBytes").writeValue(dataSource.getDataSizeInBytes().longValue());
            }
            if (dataSource.getNumberOfFiles() != null) {
                jsonGenerator.writeFieldName("NumberOfFiles").writeValue(dataSource.getNumberOfFiles().longValue());
            }
            if (dataSource.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(dataSource.getName());
            }
            if (dataSource.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(dataSource.getStatus());
            }
            if (dataSource.getMessage() != null) {
                jsonGenerator.writeFieldName("Message").writeValue(dataSource.getMessage());
            }
            if (dataSource.getRedshiftMetadata() != null) {
                jsonGenerator.writeFieldName("RedshiftMetadata");
                RedshiftMetadataJsonMarshaller.getInstance().marshall(dataSource.getRedshiftMetadata(), jsonGenerator);
            }
            if (dataSource.getRDSMetadata() != null) {
                jsonGenerator.writeFieldName("RDSMetadata");
                RDSMetadataJsonMarshaller.getInstance().marshall(dataSource.getRDSMetadata(), jsonGenerator);
            }
            if (dataSource.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(dataSource.getRoleARN());
            }
            if (dataSource.getComputeStatistics() != null) {
                jsonGenerator.writeFieldName("ComputeStatistics").writeValue(dataSource.getComputeStatistics().booleanValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DataSourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DataSourceJsonMarshaller();
        }
        return instance;
    }
}

