/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.machinelearning.model.DescribeDataSourcesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeDataSourcesRequestMarshaller
implements Marshaller<Request<DescribeDataSourcesRequest>, DescribeDataSourcesRequest> {
    public Request<DescribeDataSourcesRequest> marshall(DescribeDataSourcesRequest describeDataSourcesRequest) {
        if (describeDataSourcesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDataSourcesRequest, "AmazonMachineLearning");
        request.addHeader("X-Amz-Target", "AmazonML_20141212.DescribeDataSources");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (describeDataSourcesRequest.getFilterVariable() != null) {
                jsonGenerator.writeFieldName("FilterVariable").writeValue(describeDataSourcesRequest.getFilterVariable());
            }
            if (describeDataSourcesRequest.getEQ() != null) {
                jsonGenerator.writeFieldName("EQ").writeValue(describeDataSourcesRequest.getEQ());
            }
            if (describeDataSourcesRequest.getGT() != null) {
                jsonGenerator.writeFieldName("GT").writeValue(describeDataSourcesRequest.getGT());
            }
            if (describeDataSourcesRequest.getLT() != null) {
                jsonGenerator.writeFieldName("LT").writeValue(describeDataSourcesRequest.getLT());
            }
            if (describeDataSourcesRequest.getGE() != null) {
                jsonGenerator.writeFieldName("GE").writeValue(describeDataSourcesRequest.getGE());
            }
            if (describeDataSourcesRequest.getLE() != null) {
                jsonGenerator.writeFieldName("LE").writeValue(describeDataSourcesRequest.getLE());
            }
            if (describeDataSourcesRequest.getNE() != null) {
                jsonGenerator.writeFieldName("NE").writeValue(describeDataSourcesRequest.getNE());
            }
            if (describeDataSourcesRequest.getPrefix() != null) {
                jsonGenerator.writeFieldName("Prefix").writeValue(describeDataSourcesRequest.getPrefix());
            }
            if (describeDataSourcesRequest.getSortOrder() != null) {
                jsonGenerator.writeFieldName("SortOrder").writeValue(describeDataSourcesRequest.getSortOrder());
            }
            if (describeDataSourcesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeDataSourcesRequest.getNextToken());
            }
            if (describeDataSourcesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeDataSourcesRequest.getLimit().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

