/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkfirewall.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkfirewall.model.Dimension;
import com.amazonaws.services.networkfirewall.model.transform.PublishMetricActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PublishMetricAction
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Dimension> dimensions;

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Collection<Dimension> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new ArrayList<Dimension>(dimensions);
    }

    public PublishMetricAction withDimensions(Dimension ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new ArrayList<Dimension>(dimensions.length));
        }
        for (Dimension ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public PublishMetricAction withDimensions(Collection<Dimension> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishMetricAction)) {
            return false;
        }
        PublishMetricAction other = (PublishMetricAction)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        return other.getDimensions() == null || other.getDimensions().equals(this.getDimensions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        return hashCode;
    }

    public PublishMetricAction clone() {
        try {
            return (PublishMetricAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PublishMetricActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

