/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.paymentcryptography.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.paymentcryptography.model.KeyAttributes;
import com.amazonaws.services.paymentcryptography.model.transform.TrustedCertificatePublicKeyMarshaller;
import java.io.Serializable;

public class TrustedCertificatePublicKey
implements Serializable,
Cloneable,
StructuredPojo {
    private KeyAttributes keyAttributes;
    private String publicKeyCertificate;
    private String certificateAuthorityPublicKeyIdentifier;

    public void setKeyAttributes(KeyAttributes keyAttributes) {
        this.keyAttributes = keyAttributes;
    }

    public KeyAttributes getKeyAttributes() {
        return this.keyAttributes;
    }

    public TrustedCertificatePublicKey withKeyAttributes(KeyAttributes keyAttributes) {
        this.setKeyAttributes(keyAttributes);
        return this;
    }

    public void setPublicKeyCertificate(String publicKeyCertificate) {
        this.publicKeyCertificate = publicKeyCertificate;
    }

    public String getPublicKeyCertificate() {
        return this.publicKeyCertificate;
    }

    public TrustedCertificatePublicKey withPublicKeyCertificate(String publicKeyCertificate) {
        this.setPublicKeyCertificate(publicKeyCertificate);
        return this;
    }

    public void setCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
        this.certificateAuthorityPublicKeyIdentifier = certificateAuthorityPublicKeyIdentifier;
    }

    public String getCertificateAuthorityPublicKeyIdentifier() {
        return this.certificateAuthorityPublicKeyIdentifier;
    }

    public TrustedCertificatePublicKey withCertificateAuthorityPublicKeyIdentifier(String certificateAuthorityPublicKeyIdentifier) {
        this.setCertificateAuthorityPublicKeyIdentifier(certificateAuthorityPublicKeyIdentifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKeyAttributes() != null) {
            sb.append("KeyAttributes: ").append(this.getKeyAttributes()).append(",");
        }
        if (this.getPublicKeyCertificate() != null) {
            sb.append("PublicKeyCertificate: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCertificateAuthorityPublicKeyIdentifier() != null) {
            sb.append("CertificateAuthorityPublicKeyIdentifier: ").append(this.getCertificateAuthorityPublicKeyIdentifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustedCertificatePublicKey)) {
            return false;
        }
        TrustedCertificatePublicKey other = (TrustedCertificatePublicKey)obj;
        if (other.getKeyAttributes() == null ^ this.getKeyAttributes() == null) {
            return false;
        }
        if (other.getKeyAttributes() != null && !other.getKeyAttributes().equals(this.getKeyAttributes())) {
            return false;
        }
        if (other.getPublicKeyCertificate() == null ^ this.getPublicKeyCertificate() == null) {
            return false;
        }
        if (other.getPublicKeyCertificate() != null && !other.getPublicKeyCertificate().equals(this.getPublicKeyCertificate())) {
            return false;
        }
        if (other.getCertificateAuthorityPublicKeyIdentifier() == null ^ this.getCertificateAuthorityPublicKeyIdentifier() == null) {
            return false;
        }
        return other.getCertificateAuthorityPublicKeyIdentifier() == null || other.getCertificateAuthorityPublicKeyIdentifier().equals(this.getCertificateAuthorityPublicKeyIdentifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKeyAttributes() == null ? 0 : this.getKeyAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getPublicKeyCertificate() == null ? 0 : this.getPublicKeyCertificate().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateAuthorityPublicKeyIdentifier() == null ? 0 : this.getCertificateAuthorityPublicKeyIdentifier().hashCode());
        return hashCode;
    }

    public TrustedCertificatePublicKey clone() {
        try {
            return (TrustedCertificatePublicKey)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TrustedCertificatePublicKeyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

