/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.personalize.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.personalize.model.RecommenderSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRecommendersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<RecommenderSummary> recommenders;
    private String nextToken;

    public List<RecommenderSummary> getRecommenders() {
        return this.recommenders;
    }

    public void setRecommenders(Collection<RecommenderSummary> recommenders) {
        if (recommenders == null) {
            this.recommenders = null;
            return;
        }
        this.recommenders = new ArrayList<RecommenderSummary>(recommenders);
    }

    public ListRecommendersResult withRecommenders(RecommenderSummary ... recommenders) {
        if (this.recommenders == null) {
            this.setRecommenders(new ArrayList<RecommenderSummary>(recommenders.length));
        }
        for (RecommenderSummary ele : recommenders) {
            this.recommenders.add(ele);
        }
        return this;
    }

    public ListRecommendersResult withRecommenders(Collection<RecommenderSummary> recommenders) {
        this.setRecommenders(recommenders);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRecommendersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRecommenders() != null) {
            sb.append("Recommenders: ").append(this.getRecommenders()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendersResult)) {
            return false;
        }
        ListRecommendersResult other = (ListRecommendersResult)obj;
        if (other.getRecommenders() == null ^ this.getRecommenders() == null) {
            return false;
        }
        if (other.getRecommenders() != null && !other.getRecommenders().equals(this.getRecommenders())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRecommenders() == null ? 0 : this.getRecommenders().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListRecommendersResult clone() {
        try {
            return (ListRecommendersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

