/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rdsdata.model.ArrayValue;
import java.util.List;

@SdkInternalApi
public class ArrayValueMarshaller {
    private static final MarshallingInfo<List> BOOLEANVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("booleanValues").build();
    private static final MarshallingInfo<List> LONGVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("longValues").build();
    private static final MarshallingInfo<List> DOUBLEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("doubleValues").build();
    private static final MarshallingInfo<List> STRINGVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stringValues").build();
    private static final MarshallingInfo<List> ARRAYVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arrayValues").build();
    private static final ArrayValueMarshaller instance = new ArrayValueMarshaller();

    public static ArrayValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(ArrayValue arrayValue, ProtocolMarshaller protocolMarshaller) {
        if (arrayValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(arrayValue.getBooleanValues(), BOOLEANVALUES_BINDING);
            protocolMarshaller.marshall(arrayValue.getLongValues(), LONGVALUES_BINDING);
            protocolMarshaller.marshall(arrayValue.getDoubleValues(), DOUBLEVALUES_BINDING);
            protocolMarshaller.marshall(arrayValue.getStringValues(), STRINGVALUES_BINDING);
            protocolMarshaller.marshall(arrayValue.getArrayValues(), ARRAYVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

