/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftserverless.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.redshiftserverless.model.Schedule;
import java.util.Date;

@SdkInternalApi
public class ScheduleMarshaller {
    private static final MarshallingInfo<Date> AT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("at").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> CRON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cron").build();
    private static final ScheduleMarshaller instance = new ScheduleMarshaller();

    public static ScheduleMarshaller getInstance() {
        return instance;
    }

    public void marshall(Schedule schedule, ProtocolMarshaller protocolMarshaller) {
        if (schedule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)schedule.getAt(), AT_BINDING);
            protocolMarshaller.marshall((Object)schedule.getCron(), CRON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

