/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.AutoMLJobCompletionCriteria;
import com.amazonaws.services.sagemaker.model.HolidayConfigAttributes;
import com.amazonaws.services.sagemaker.model.TimeSeriesConfig;
import com.amazonaws.services.sagemaker.model.TimeSeriesTransformations;
import com.amazonaws.services.sagemaker.model.transform.TimeSeriesForecastingJobConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TimeSeriesForecastingJobConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private String featureSpecificationS3Uri;
    private AutoMLJobCompletionCriteria completionCriteria;
    private String forecastFrequency;
    private Integer forecastHorizon;
    private List<String> forecastQuantiles;
    private TimeSeriesTransformations transformations;
    private TimeSeriesConfig timeSeriesConfig;
    private List<HolidayConfigAttributes> holidayConfig;

    public void setFeatureSpecificationS3Uri(String featureSpecificationS3Uri) {
        this.featureSpecificationS3Uri = featureSpecificationS3Uri;
    }

    public String getFeatureSpecificationS3Uri() {
        return this.featureSpecificationS3Uri;
    }

    public TimeSeriesForecastingJobConfig withFeatureSpecificationS3Uri(String featureSpecificationS3Uri) {
        this.setFeatureSpecificationS3Uri(featureSpecificationS3Uri);
        return this;
    }

    public void setCompletionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
        this.completionCriteria = completionCriteria;
    }

    public AutoMLJobCompletionCriteria getCompletionCriteria() {
        return this.completionCriteria;
    }

    public TimeSeriesForecastingJobConfig withCompletionCriteria(AutoMLJobCompletionCriteria completionCriteria) {
        this.setCompletionCriteria(completionCriteria);
        return this;
    }

    public void setForecastFrequency(String forecastFrequency) {
        this.forecastFrequency = forecastFrequency;
    }

    public String getForecastFrequency() {
        return this.forecastFrequency;
    }

    public TimeSeriesForecastingJobConfig withForecastFrequency(String forecastFrequency) {
        this.setForecastFrequency(forecastFrequency);
        return this;
    }

    public void setForecastHorizon(Integer forecastHorizon) {
        this.forecastHorizon = forecastHorizon;
    }

    public Integer getForecastHorizon() {
        return this.forecastHorizon;
    }

    public TimeSeriesForecastingJobConfig withForecastHorizon(Integer forecastHorizon) {
        this.setForecastHorizon(forecastHorizon);
        return this;
    }

    public List<String> getForecastQuantiles() {
        return this.forecastQuantiles;
    }

    public void setForecastQuantiles(Collection<String> forecastQuantiles) {
        if (forecastQuantiles == null) {
            this.forecastQuantiles = null;
            return;
        }
        this.forecastQuantiles = new ArrayList<String>(forecastQuantiles);
    }

    public TimeSeriesForecastingJobConfig withForecastQuantiles(String ... forecastQuantiles) {
        if (this.forecastQuantiles == null) {
            this.setForecastQuantiles(new ArrayList<String>(forecastQuantiles.length));
        }
        for (String ele : forecastQuantiles) {
            this.forecastQuantiles.add(ele);
        }
        return this;
    }

    public TimeSeriesForecastingJobConfig withForecastQuantiles(Collection<String> forecastQuantiles) {
        this.setForecastQuantiles(forecastQuantiles);
        return this;
    }

    public void setTransformations(TimeSeriesTransformations transformations) {
        this.transformations = transformations;
    }

    public TimeSeriesTransformations getTransformations() {
        return this.transformations;
    }

    public TimeSeriesForecastingJobConfig withTransformations(TimeSeriesTransformations transformations) {
        this.setTransformations(transformations);
        return this;
    }

    public void setTimeSeriesConfig(TimeSeriesConfig timeSeriesConfig) {
        this.timeSeriesConfig = timeSeriesConfig;
    }

    public TimeSeriesConfig getTimeSeriesConfig() {
        return this.timeSeriesConfig;
    }

    public TimeSeriesForecastingJobConfig withTimeSeriesConfig(TimeSeriesConfig timeSeriesConfig) {
        this.setTimeSeriesConfig(timeSeriesConfig);
        return this;
    }

    public List<HolidayConfigAttributes> getHolidayConfig() {
        return this.holidayConfig;
    }

    public void setHolidayConfig(Collection<HolidayConfigAttributes> holidayConfig) {
        if (holidayConfig == null) {
            this.holidayConfig = null;
            return;
        }
        this.holidayConfig = new ArrayList<HolidayConfigAttributes>(holidayConfig);
    }

    public TimeSeriesForecastingJobConfig withHolidayConfig(HolidayConfigAttributes ... holidayConfig) {
        if (this.holidayConfig == null) {
            this.setHolidayConfig(new ArrayList<HolidayConfigAttributes>(holidayConfig.length));
        }
        for (HolidayConfigAttributes ele : holidayConfig) {
            this.holidayConfig.add(ele);
        }
        return this;
    }

    public TimeSeriesForecastingJobConfig withHolidayConfig(Collection<HolidayConfigAttributes> holidayConfig) {
        this.setHolidayConfig(holidayConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFeatureSpecificationS3Uri() != null) {
            sb.append("FeatureSpecificationS3Uri: ").append(this.getFeatureSpecificationS3Uri()).append(",");
        }
        if (this.getCompletionCriteria() != null) {
            sb.append("CompletionCriteria: ").append(this.getCompletionCriteria()).append(",");
        }
        if (this.getForecastFrequency() != null) {
            sb.append("ForecastFrequency: ").append(this.getForecastFrequency()).append(",");
        }
        if (this.getForecastHorizon() != null) {
            sb.append("ForecastHorizon: ").append(this.getForecastHorizon()).append(",");
        }
        if (this.getForecastQuantiles() != null) {
            sb.append("ForecastQuantiles: ").append(this.getForecastQuantiles()).append(",");
        }
        if (this.getTransformations() != null) {
            sb.append("Transformations: ").append(this.getTransformations()).append(",");
        }
        if (this.getTimeSeriesConfig() != null) {
            sb.append("TimeSeriesConfig: ").append(this.getTimeSeriesConfig()).append(",");
        }
        if (this.getHolidayConfig() != null) {
            sb.append("HolidayConfig: ").append(this.getHolidayConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesForecastingJobConfig)) {
            return false;
        }
        TimeSeriesForecastingJobConfig other = (TimeSeriesForecastingJobConfig)obj;
        if (other.getFeatureSpecificationS3Uri() == null ^ this.getFeatureSpecificationS3Uri() == null) {
            return false;
        }
        if (other.getFeatureSpecificationS3Uri() != null && !other.getFeatureSpecificationS3Uri().equals(this.getFeatureSpecificationS3Uri())) {
            return false;
        }
        if (other.getCompletionCriteria() == null ^ this.getCompletionCriteria() == null) {
            return false;
        }
        if (other.getCompletionCriteria() != null && !other.getCompletionCriteria().equals(this.getCompletionCriteria())) {
            return false;
        }
        if (other.getForecastFrequency() == null ^ this.getForecastFrequency() == null) {
            return false;
        }
        if (other.getForecastFrequency() != null && !other.getForecastFrequency().equals(this.getForecastFrequency())) {
            return false;
        }
        if (other.getForecastHorizon() == null ^ this.getForecastHorizon() == null) {
            return false;
        }
        if (other.getForecastHorizon() != null && !other.getForecastHorizon().equals(this.getForecastHorizon())) {
            return false;
        }
        if (other.getForecastQuantiles() == null ^ this.getForecastQuantiles() == null) {
            return false;
        }
        if (other.getForecastQuantiles() != null && !other.getForecastQuantiles().equals(this.getForecastQuantiles())) {
            return false;
        }
        if (other.getTransformations() == null ^ this.getTransformations() == null) {
            return false;
        }
        if (other.getTransformations() != null && !other.getTransformations().equals(this.getTransformations())) {
            return false;
        }
        if (other.getTimeSeriesConfig() == null ^ this.getTimeSeriesConfig() == null) {
            return false;
        }
        if (other.getTimeSeriesConfig() != null && !other.getTimeSeriesConfig().equals(this.getTimeSeriesConfig())) {
            return false;
        }
        if (other.getHolidayConfig() == null ^ this.getHolidayConfig() == null) {
            return false;
        }
        return other.getHolidayConfig() == null || other.getHolidayConfig().equals(this.getHolidayConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFeatureSpecificationS3Uri() == null ? 0 : this.getFeatureSpecificationS3Uri().hashCode());
        hashCode = 31 * hashCode + (this.getCompletionCriteria() == null ? 0 : this.getCompletionCriteria().hashCode());
        hashCode = 31 * hashCode + (this.getForecastFrequency() == null ? 0 : this.getForecastFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getForecastHorizon() == null ? 0 : this.getForecastHorizon().hashCode());
        hashCode = 31 * hashCode + (this.getForecastQuantiles() == null ? 0 : this.getForecastQuantiles().hashCode());
        hashCode = 31 * hashCode + (this.getTransformations() == null ? 0 : this.getTransformations().hashCode());
        hashCode = 31 * hashCode + (this.getTimeSeriesConfig() == null ? 0 : this.getTimeSeriesConfig().hashCode());
        hashCode = 31 * hashCode + (this.getHolidayConfig() == null ? 0 : this.getHolidayConfig().hashCode());
        return hashCode;
    }

    public TimeSeriesForecastingJobConfig clone() {
        try {
            return (TimeSeriesForecastingJobConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeSeriesForecastingJobConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

