/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codesamples;

import com.amazonaws.codesamples.CodeSample;
import com.amazonaws.codesamples.exception.SampleParsingException;
import com.amazonaws.util.ParsingUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplesParser {
    private static final Pattern BEGIN_SAMPLE_PATTERN = Pattern.compile("//\\s*BEGIN_SAMPLE:([^.]+)\\.([^.]+)$");
    private static final Pattern END_SAMPLE_PATTERN = Pattern.compile("//\\s*END_SAMPLE");
    private static final Pattern BEGIN_HIDDEN_PATTERN = Pattern.compile("//\\s*BEGIN_HIDDEN");
    private static final Pattern END_HIDDEN_PATTERN = Pattern.compile("//\\s*END_HIDDEN");
    private static final Pattern TITLE_PATTERN = Pattern.compile("//\\s*TITLE:(.*)$");
    private static final Pattern DESCRIPTION_PATTERN = Pattern.compile("//\\s*DESCRIPTION:(.*)$");

    public static List<CodeSample> getSamples(File[] files, String targetExtension) throws Exception {
        if (files == null) {
            throw new SampleParsingException("Must provide a non-null set of files to parse");
        }
        ArrayList<CodeSample> samples = new ArrayList<CodeSample>();
        SamplesParser.parseFiles(files, targetExtension, samples);
        return samples;
    }

    public static List<CodeSample> getSamples(File file) throws Exception {
        if (file == null || !file.exists()) {
            throw new SampleParsingException("Must provide a valid existing file to parse");
        }
        ArrayList<CodeSample> samples = new ArrayList<CodeSample>();
        SamplesParser.parseFile(file, samples);
        return samples;
    }

    private static void parseFiles(File[] files, String targetExtension, List<CodeSample> samples) throws Exception {
        for (File file : files) {
            if (file.isDirectory()) {
                SamplesParser.parseFiles(file.listFiles(), targetExtension, samples);
                continue;
            }
            if (!ParsingUtils.fileMatchesExtension(file, targetExtension)) continue;
            SamplesParser.parseFile(file, samples);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseFile(File sourceFile, List<CodeSample> samples) throws Exception {
        String line = null;
        CodeSample curSample = null;
        boolean inSample = false;
        boolean hidden = false;
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(new FileReader(sourceFile));
            while ((line = ((LineNumberReader)reader).readLine()) != null) {
                String trimmedLine = line.trim();
                Matcher beginSampleMatcher = BEGIN_SAMPLE_PATTERN.matcher(trimmedLine);
                Matcher endSampleMatcher = END_SAMPLE_PATTERN.matcher(trimmedLine);
                Matcher beginHiddenMatcher = BEGIN_HIDDEN_PATTERN.matcher(trimmedLine);
                Matcher endHiddenMatcher = END_HIDDEN_PATTERN.matcher(trimmedLine);
                Matcher titleMatcher = TITLE_PATTERN.matcher(trimmedLine);
                Matcher descriptionMatcher = DESCRIPTION_PATTERN.matcher(trimmedLine);
                if (beginSampleMatcher.find()) {
                    if (inSample) {
                        throw new SampleParsingException("Found a BEGIN_SAMPLE tag while already within a sample block", sourceFile, ((LineNumberReader)reader).getLineNumber());
                    }
                    inSample = true;
                    String serviceName = beginSampleMatcher.group(1);
                    String sampleId = beginSampleMatcher.group(2);
                    curSample = new CodeSample(sampleId, serviceName);
                    continue;
                }
                if (endSampleMatcher.find()) {
                    if (inSample) {
                        ParsingUtils.assertFieldHasContent("title", curSample.getTitle());
                        ParsingUtils.assertFieldHasContent("description", curSample.getDescription());
                        ParsingUtils.assertFieldHasContent("content", curSample.getFormattedCode());
                        if (hidden) {
                            throw new SampleParsingException("Sample was still hidden when END_SAMPLE tag was encountered", sourceFile, ((LineNumberReader)reader).getLineNumber());
                        }
                        samples.add(curSample);
                        inSample = false;
                        continue;
                    }
                    throw new SampleParsingException("Found a END_SAMPLE tag while not within a sample block", sourceFile, ((LineNumberReader)reader).getLineNumber());
                }
                if (beginHiddenMatcher.find()) {
                    if (hidden) {
                        throw new SampleParsingException("Found a BEGIN_HIDDEN tag while already within a hidden block", sourceFile, ((LineNumberReader)reader).getLineNumber());
                    }
                    hidden = true;
                    continue;
                }
                if (endHiddenMatcher.find()) {
                    if (!hidden) {
                        throw new SampleParsingException("Found a END_HIDDEN tag while not within a hidden block", sourceFile, ((LineNumberReader)reader).getLineNumber());
                    }
                    hidden = false;
                    continue;
                }
                if (titleMatcher.find()) {
                    if (!inSample) {
                        throw new SampleParsingException("Found a TITLE tag while not within a sample block", sourceFile, ((LineNumberReader)reader).getLineNumber());
                    }
                    curSample.setTitle(titleMatcher.group(1));
                    continue;
                }
                if (descriptionMatcher.find()) {
                    if (!inSample) {
                        throw new SampleParsingException("Found a DESCRIPTION tag while not within a sample block", sourceFile, ((LineNumberReader)reader).getLineNumber());
                    }
                    curSample.setDescription(descriptionMatcher.group(1));
                    continue;
                }
                if (!inSample || hidden) continue;
                curSample.appendLine(line);
            }
            if (inSample) {
                throw new SampleParsingException("Hit EOF with sample still open: " + curSample.getId(), sourceFile, ((LineNumberReader)reader).getLineNumber());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

