/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A collection of attributes that are applied to all active Security Hub-aggregated findings and that result in a
 * subset of findings that are included in this insight.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsSecurityFindingFilters"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsSecurityFindingFilters implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider)
     * after this provider's product (solution that generates findings) is registered with Security Hub.
     * </p>
     */
    private java.util.List<StringFilter> productArn;
    /**
     * <p>
     * The AWS account ID that a finding is generated in.
     * </p>
     */
    private java.util.List<StringFilter> awsAccountId;
    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     */
    private java.util.List<StringFilter> id;
    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plug-in, etc.
     * </p>
     */
    private java.util.List<StringFilter> generatorId;
    /**
     * <p>
     * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     * </p>
     */
    private java.util.List<StringFilter> type;
    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential
     * security issue that a finding captured.
     * </p>
     */
    private java.util.List<DateFilter> firstObservedAt;
    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
     * potential security issue that a finding captured.
     * </p>
     */
    private java.util.List<DateFilter> lastObservedAt;
    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security
     * issue that a finding captured.
     * </p>
     */
    private java.util.List<DateFilter> createdAt;
    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     * record.
     * </p>
     */
    private java.util.List<DateFilter> updatedAt;
    /**
     * <p>
     * The native severity as defined by the security-findings provider's solution that generated the finding.
     * </p>
     */
    private java.util.List<NumberFilter> severityProduct;
    /**
     * <p>
     * The normalized severity of a finding.
     * </p>
     */
    private java.util.List<NumberFilter> severityNormalized;
    /**
     * <p>
     * The label of a finding's severity.
     * </p>
     */
    private java.util.List<StringFilter> severityLabel;
    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0
     * means zero percent confidence and 100 means 100 percent confidence.
     * </p>
     */
    private java.util.List<NumberFilter> confidence;
    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     * </p>
     */
    private java.util.List<NumberFilter> criticality;
    /**
     * <p>
     * A finding's title.
     * </p>
     */
    private java.util.List<StringFilter> title;
    /**
     * <p>
     * A finding's description.
     * </p>
     */
    private java.util.List<StringFilter> description;
    /**
     * <p>
     * The recommendation of what to do about the issue described in a finding.
     * </p>
     */
    private java.util.List<StringFilter> recommendationText;
    /**
     * <p>
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     * </p>
     */
    private java.util.List<StringFilter> sourceUrl;
    /**
     * <p>
     * A data type where security-findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     */
    private java.util.List<MapFilter> productFields;
    /**
     * <p>
     * The name of the solution (product) that generates findings.
     * </p>
     */
    private java.util.List<StringFilter> productName;
    /**
     * <p>
     * The name of the findings provider (company) that owns the solution (product) that generates findings.
     * </p>
     */
    private java.util.List<StringFilter> companyName;
    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     */
    private java.util.List<MapFilter> userDefinedFields;
    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     */
    private java.util.List<StringFilter> malwareName;
    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     */
    private java.util.List<StringFilter> malwareType;
    /**
     * <p>
     * The filesystem path of the malware that was observed.
     * </p>
     */
    private java.util.List<StringFilter> malwarePath;
    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     */
    private java.util.List<StringFilter> malwareState;
    /**
     * <p>
     * Indicates the direction of network traffic associated with a finding.
     * </p>
     */
    private java.util.List<StringFilter> networkDirection;
    /**
     * <p>
     * The protocol of network-related information about a finding.
     * </p>
     */
    private java.util.List<StringFilter> networkProtocol;
    /**
     * <p>
     * The source IPv4 address of network-related information about a finding.
     * </p>
     */
    private java.util.List<IpFilter> networkSourceIpV4;
    /**
     * <p>
     * The source IPv6 address of network-related information about a finding.
     * </p>
     */
    private java.util.List<IpFilter> networkSourceIpV6;
    /**
     * <p>
     * The source port of network-related information about a finding.
     * </p>
     */
    private java.util.List<NumberFilter> networkSourcePort;
    /**
     * <p>
     * The source domain of network-related information about a finding.
     * </p>
     */
    private java.util.List<StringFilter> networkSourceDomain;
    /**
     * <p>
     * The source media access control (MAC) address of network-related information about a finding.
     * </p>
     */
    private java.util.List<StringFilter> networkSourceMac;
    /**
     * <p>
     * The destination IPv4 address of network-related information about a finding.
     * </p>
     */
    private java.util.List<IpFilter> networkDestinationIpV4;
    /**
     * <p>
     * The destination IPv6 address of network-related information about a finding.
     * </p>
     */
    private java.util.List<IpFilter> networkDestinationIpV6;
    /**
     * <p>
     * The destination port of network-related information about a finding.
     * </p>
     */
    private java.util.List<NumberFilter> networkDestinationPort;
    /**
     * <p>
     * The destination domain of network-related information about a finding.
     * </p>
     */
    private java.util.List<StringFilter> networkDestinationDomain;
    /**
     * <p>
     * The name of the process.
     * </p>
     */
    private java.util.List<StringFilter> processName;
    /**
     * <p>
     * The path to the process executable.
     * </p>
     */
    private java.util.List<StringFilter> processPath;
    /**
     * <p>
     * The process ID.
     * </p>
     */
    private java.util.List<NumberFilter> processPid;
    /**
     * <p>
     * The parent process ID.
     * </p>
     */
    private java.util.List<NumberFilter> processParentPid;
    /**
     * <p>
     * The date/time that the process was launched.
     * </p>
     */
    private java.util.List<DateFilter> processLaunchedAt;
    /**
     * <p>
     * The date/time that the process was terminated.
     * </p>
     */
    private java.util.List<DateFilter> processTerminatedAt;
    /**
     * <p>
     * The type of a threat intel indicator.
     * </p>
     */
    private java.util.List<StringFilter> threatIntelIndicatorType;
    /**
     * <p>
     * The value of a threat intel indicator.
     * </p>
     */
    private java.util.List<StringFilter> threatIntelIndicatorValue;
    /**
     * <p>
     * The category of a threat intel indicator.
     * </p>
     */
    private java.util.List<StringFilter> threatIntelIndicatorCategory;
    /**
     * <p>
     * The date/time of the last observation of a threat intel indicator.
     * </p>
     */
    private java.util.List<DateFilter> threatIntelIndicatorLastObservedAt;
    /**
     * <p>
     * The source of the threat intel.
     * </p>
     */
    private java.util.List<StringFilter> threatIntelIndicatorSource;
    /**
     * <p>
     * The URL for more details from the source of the threat intel.
     * </p>
     */
    private java.util.List<StringFilter> threatIntelIndicatorSourceUrl;
    /**
     * <p>
     * Specifies the type of the resource that details are provided for.
     * </p>
     */
    private java.util.List<StringFilter> resourceType;
    /**
     * <p>
     * The canonical identifier for the given resource type.
     * </p>
     */
    private java.util.List<StringFilter> resourceId;
    /**
     * <p>
     * The canonical AWS partition name that the Region is assigned to.
     * </p>
     */
    private java.util.List<StringFilter> resourcePartition;
    /**
     * <p>
     * The canonical AWS external Region name where this resource is located.
     * </p>
     */
    private java.util.List<StringFilter> resourceRegion;
    /**
     * <p>
     * A list of AWS tags associated with a resource at the time the finding was processed.
     * </p>
     */
    private java.util.List<MapFilter> resourceTags;
    /**
     * <p>
     * The instance type of the instance.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsEc2InstanceType;
    /**
     * <p>
     * The Amazon Machine Image (AMI) ID of the instance.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsEc2InstanceImageId;
    /**
     * <p>
     * The IPv4 addresses associated with the instance.
     * </p>
     */
    private java.util.List<IpFilter> resourceAwsEc2InstanceIpV4Addresses;
    /**
     * <p>
     * The IPv6 addresses associated with the instance.
     * </p>
     */
    private java.util.List<IpFilter> resourceAwsEc2InstanceIpV6Addresses;
    /**
     * <p>
     * The key name associated with the instance.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsEc2InstanceKeyName;
    /**
     * <p>
     * The IAM profile ARN of the instance.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsEc2InstanceIamInstanceProfileArn;
    /**
     * <p>
     * The identifier of the VPC that the instance was launched in.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsEc2InstanceVpcId;
    /**
     * <p>
     * The identifier of the subnet that the instance was launched in.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsEc2InstanceSubnetId;
    /**
     * <p>
     * The date/time the instance was launched.
     * </p>
     */
    private java.util.List<DateFilter> resourceAwsEc2InstanceLaunchedAt;
    /**
     * <p>
     * The canonical user ID of the owner of the S3 bucket.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsS3BucketOwnerId;
    /**
     * <p>
     * The display name of the owner of the S3 bucket.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsS3BucketOwnerName;
    /**
     * <p>
     * The user associated with the IAM access key related to a finding.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsIamAccessKeyUserName;
    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     */
    private java.util.List<StringFilter> resourceAwsIamAccessKeyStatus;
    /**
     * <p>
     * The creation date/time of the IAM access key related to a finding.
     * </p>
     */
    private java.util.List<DateFilter> resourceAwsIamAccessKeyCreatedAt;
    /**
     * <p>
     * The name of the container related to a finding.
     * </p>
     */
    private java.util.List<StringFilter> resourceContainerName;
    /**
     * <p>
     * The identifier of the image related to a finding.
     * </p>
     */
    private java.util.List<StringFilter> resourceContainerImageId;
    /**
     * <p>
     * The name of the image related to a finding.
     * </p>
     */
    private java.util.List<StringFilter> resourceContainerImageName;
    /**
     * <p>
     * The date/time that the container was started.
     * </p>
     */
    private java.util.List<DateFilter> resourceContainerLaunchedAt;
    /**
     * <p>
     * The details of a resource that doesn't have a specific subfield for the resource type defined.
     * </p>
     */
    private java.util.List<MapFilter> resourceDetailsOther;
    /**
     * <p>
     * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported
     * standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     * </p>
     */
    private java.util.List<StringFilter> complianceStatus;
    /**
     * <p>
     * The veracity of a finding.
     * </p>
     */
    private java.util.List<StringFilter> verificationState;
    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     */
    private java.util.List<StringFilter> workflowState;
    /**
     * <p>
     * The updated record state for the finding.
     * </p>
     */
    private java.util.List<StringFilter> recordState;
    /**
     * <p>
     * The ARN of the solution that generated a related finding.
     * </p>
     */
    private java.util.List<StringFilter> relatedFindingsProductArn;
    /**
     * <p>
     * The solution-generated identifier for a related finding.
     * </p>
     */
    private java.util.List<StringFilter> relatedFindingsId;
    /**
     * <p>
     * The text of a note.
     * </p>
     */
    private java.util.List<StringFilter> noteText;
    /**
     * <p>
     * The timestamp of when the note was updated.
     * </p>
     */
    private java.util.List<DateFilter> noteUpdatedAt;
    /**
     * <p>
     * The principal that created a note.
     * </p>
     */
    private java.util.List<StringFilter> noteUpdatedBy;
    /**
     * <p>
     * A keyword for a finding.
     * </p>
     */
    private java.util.List<KeywordFilter> keyword;

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider)
     * after this provider's product (solution that generates findings) is registered with Security Hub.
     * </p>
     * 
     * @return The ARN generated by Security Hub that uniquely identifies a third-party company (security findings
     *         provider) after this provider's product (solution that generates findings) is registered with Security
     *         Hub.
     */

    public java.util.List<StringFilter> getProductArn() {
        return productArn;
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider)
     * after this provider's product (solution that generates findings) is registered with Security Hub.
     * </p>
     * 
     * @param productArn
     *        The ARN generated by Security Hub that uniquely identifies a third-party company (security findings
     *        provider) after this provider's product (solution that generates findings) is registered with Security
     *        Hub.
     */

    public void setProductArn(java.util.Collection<StringFilter> productArn) {
        if (productArn == null) {
            this.productArn = null;
            return;
        }

        this.productArn = new java.util.ArrayList<StringFilter>(productArn);
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider)
     * after this provider's product (solution that generates findings) is registered with Security Hub.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProductArn(java.util.Collection)} or {@link #withProductArn(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param productArn
     *        The ARN generated by Security Hub that uniquely identifies a third-party company (security findings
     *        provider) after this provider's product (solution that generates findings) is registered with Security
     *        Hub.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProductArn(StringFilter... productArn) {
        if (this.productArn == null) {
            setProductArn(new java.util.ArrayList<StringFilter>(productArn.length));
        }
        for (StringFilter ele : productArn) {
            this.productArn.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The ARN generated by Security Hub that uniquely identifies a third-party company (security findings provider)
     * after this provider's product (solution that generates findings) is registered with Security Hub.
     * </p>
     * 
     * @param productArn
     *        The ARN generated by Security Hub that uniquely identifies a third-party company (security findings
     *        provider) after this provider's product (solution that generates findings) is registered with Security
     *        Hub.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProductArn(java.util.Collection<StringFilter> productArn) {
        setProductArn(productArn);
        return this;
    }

    /**
     * <p>
     * The AWS account ID that a finding is generated in.
     * </p>
     * 
     * @return The AWS account ID that a finding is generated in.
     */

    public java.util.List<StringFilter> getAwsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The AWS account ID that a finding is generated in.
     * </p>
     * 
     * @param awsAccountId
     *        The AWS account ID that a finding is generated in.
     */

    public void setAwsAccountId(java.util.Collection<StringFilter> awsAccountId) {
        if (awsAccountId == null) {
            this.awsAccountId = null;
            return;
        }

        this.awsAccountId = new java.util.ArrayList<StringFilter>(awsAccountId);
    }

    /**
     * <p>
     * The AWS account ID that a finding is generated in.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAwsAccountId(java.util.Collection)} or {@link #withAwsAccountId(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param awsAccountId
     *        The AWS account ID that a finding is generated in.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withAwsAccountId(StringFilter... awsAccountId) {
        if (this.awsAccountId == null) {
            setAwsAccountId(new java.util.ArrayList<StringFilter>(awsAccountId.length));
        }
        for (StringFilter ele : awsAccountId) {
            this.awsAccountId.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The AWS account ID that a finding is generated in.
     * </p>
     * 
     * @param awsAccountId
     *        The AWS account ID that a finding is generated in.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withAwsAccountId(java.util.Collection<StringFilter> awsAccountId) {
        setAwsAccountId(awsAccountId);
        return this;
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * 
     * @return The security findings provider-specific identifier for a finding.
     */

    public java.util.List<StringFilter> getId() {
        return id;
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * 
     * @param id
     *        The security findings provider-specific identifier for a finding.
     */

    public void setId(java.util.Collection<StringFilter> id) {
        if (id == null) {
            this.id = null;
            return;
        }

        this.id = new java.util.ArrayList<StringFilter>(id);
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setId(java.util.Collection)} or {@link #withId(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param id
     *        The security findings provider-specific identifier for a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withId(StringFilter... id) {
        if (this.id == null) {
            setId(new java.util.ArrayList<StringFilter>(id.length));
        }
        for (StringFilter ele : id) {
            this.id.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The security findings provider-specific identifier for a finding.
     * </p>
     * 
     * @param id
     *        The security findings provider-specific identifier for a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withId(java.util.Collection<StringFilter> id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plug-in, etc.
     * </p>
     * 
     * @return The identifier for the solution-specific component (a discrete unit of logic) that generated a finding.
     *         In various security-findings providers' solutions, this generator can be called a rule, a check, a
     *         detector, a plug-in, etc.
     */

    public java.util.List<StringFilter> getGeneratorId() {
        return generatorId;
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plug-in, etc.
     * </p>
     * 
     * @param generatorId
     *        The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     *        various security-findings providers' solutions, this generator can be called a rule, a check, a detector,
     *        a plug-in, etc.
     */

    public void setGeneratorId(java.util.Collection<StringFilter> generatorId) {
        if (generatorId == null) {
            this.generatorId = null;
            return;
        }

        this.generatorId = new java.util.ArrayList<StringFilter>(generatorId);
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plug-in, etc.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setGeneratorId(java.util.Collection)} or {@link #withGeneratorId(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param generatorId
     *        The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     *        various security-findings providers' solutions, this generator can be called a rule, a check, a detector,
     *        a plug-in, etc.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withGeneratorId(StringFilter... generatorId) {
        if (this.generatorId == null) {
            setGeneratorId(new java.util.ArrayList<StringFilter>(generatorId.length));
        }
        for (StringFilter ele : generatorId) {
            this.generatorId.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     * various security-findings providers' solutions, this generator can be called a rule, a check, a detector, a
     * plug-in, etc.
     * </p>
     * 
     * @param generatorId
     *        The identifier for the solution-specific component (a discrete unit of logic) that generated a finding. In
     *        various security-findings providers' solutions, this generator can be called a rule, a check, a detector,
     *        a plug-in, etc.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withGeneratorId(java.util.Collection<StringFilter> generatorId) {
        setGeneratorId(generatorId);
        return this;
    }

    /**
     * <p>
     * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     * </p>
     * 
     * @return A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     */

    public java.util.List<StringFilter> getType() {
        return type;
    }

    /**
     * <p>
     * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     * </p>
     * 
     * @param type
     *        A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     */

    public void setType(java.util.Collection<StringFilter> type) {
        if (type == null) {
            this.type = null;
            return;
        }

        this.type = new java.util.ArrayList<StringFilter>(type);
    }

    /**
     * <p>
     * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setType(java.util.Collection)} or {@link #withType(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param type
     *        A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withType(StringFilter... type) {
        if (this.type == null) {
            setType(new java.util.ArrayList<StringFilter>(type.length));
        }
        for (StringFilter ele : type) {
            this.type.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     * </p>
     * 
     * @param type
     *        A finding type in the format of <code>namespace/category/classifier</code> that classifies a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withType(java.util.Collection<StringFilter> type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential
     * security issue that a finding captured.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
     *         potential security issue that a finding captured.
     */

    public java.util.List<DateFilter> getFirstObservedAt() {
        return firstObservedAt;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential
     * security issue that a finding captured.
     * </p>
     * 
     * @param firstObservedAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
     *        potential security issue that a finding captured.
     */

    public void setFirstObservedAt(java.util.Collection<DateFilter> firstObservedAt) {
        if (firstObservedAt == null) {
            this.firstObservedAt = null;
            return;
        }

        this.firstObservedAt = new java.util.ArrayList<DateFilter>(firstObservedAt);
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential
     * security issue that a finding captured.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setFirstObservedAt(java.util.Collection)} or {@link #withFirstObservedAt(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param firstObservedAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
     *        potential security issue that a finding captured.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withFirstObservedAt(DateFilter... firstObservedAt) {
        if (this.firstObservedAt == null) {
            setFirstObservedAt(new java.util.ArrayList<DateFilter>(firstObservedAt.length));
        }
        for (DateFilter ele : firstObservedAt) {
            this.firstObservedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the potential
     * security issue that a finding captured.
     * </p>
     * 
     * @param firstObservedAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider first observed the
     *        potential security issue that a finding captured.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withFirstObservedAt(java.util.Collection<DateFilter> firstObservedAt) {
        setFirstObservedAt(firstObservedAt);
        return this;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
     * potential security issue that a finding captured.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed
     *         the potential security issue that a finding captured.
     */

    public java.util.List<DateFilter> getLastObservedAt() {
        return lastObservedAt;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
     * potential security issue that a finding captured.
     * </p>
     * 
     * @param lastObservedAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed
     *        the potential security issue that a finding captured.
     */

    public void setLastObservedAt(java.util.Collection<DateFilter> lastObservedAt) {
        if (lastObservedAt == null) {
            this.lastObservedAt = null;
            return;
        }

        this.lastObservedAt = new java.util.ArrayList<DateFilter>(lastObservedAt);
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
     * potential security issue that a finding captured.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setLastObservedAt(java.util.Collection)} or {@link #withLastObservedAt(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param lastObservedAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed
     *        the potential security issue that a finding captured.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withLastObservedAt(DateFilter... lastObservedAt) {
        if (this.lastObservedAt == null) {
            setLastObservedAt(new java.util.ArrayList<DateFilter>(lastObservedAt.length));
        }
        for (DateFilter ele : lastObservedAt) {
            this.lastObservedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed the
     * potential security issue that a finding captured.
     * </p>
     * 
     * @param lastObservedAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider most recently observed
     *        the potential security issue that a finding captured.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withLastObservedAt(java.util.Collection<DateFilter> lastObservedAt) {
        setLastObservedAt(lastObservedAt);
        return this;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security
     * issue that a finding captured.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential
     *         security issue that a finding captured.
     */

    public java.util.List<DateFilter> getCreatedAt() {
        return createdAt;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security
     * issue that a finding captured.
     * </p>
     * 
     * @param createdAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential
     *        security issue that a finding captured.
     */

    public void setCreatedAt(java.util.Collection<DateFilter> createdAt) {
        if (createdAt == null) {
            this.createdAt = null;
            return;
        }

        this.createdAt = new java.util.ArrayList<DateFilter>(createdAt);
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security
     * issue that a finding captured.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCreatedAt(java.util.Collection)} or {@link #withCreatedAt(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param createdAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential
     *        security issue that a finding captured.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withCreatedAt(DateFilter... createdAt) {
        if (this.createdAt == null) {
            setCreatedAt(new java.util.ArrayList<DateFilter>(createdAt.length));
        }
        for (DateFilter ele : createdAt) {
            this.createdAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential security
     * issue that a finding captured.
     * </p>
     * 
     * @param createdAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider captured the potential
     *        security issue that a finding captured.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withCreatedAt(java.util.Collection<DateFilter> createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     * record.
     * </p>
     * 
     * @return An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the
     *         finding record.
     */

    public java.util.List<DateFilter> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     * record.
     * </p>
     * 
     * @param updatedAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     *        record.
     */

    public void setUpdatedAt(java.util.Collection<DateFilter> updatedAt) {
        if (updatedAt == null) {
            this.updatedAt = null;
            return;
        }

        this.updatedAt = new java.util.ArrayList<DateFilter>(updatedAt);
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     * record.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setUpdatedAt(java.util.Collection)} or {@link #withUpdatedAt(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param updatedAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     *        record.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withUpdatedAt(DateFilter... updatedAt) {
        if (this.updatedAt == null) {
            setUpdatedAt(new java.util.ArrayList<DateFilter>(updatedAt.length));
        }
        for (DateFilter ele : updatedAt) {
            this.updatedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     * record.
     * </p>
     * 
     * @param updatedAt
     *        An ISO8601-formatted timestamp that indicates when the security-findings provider last updated the finding
     *        record.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withUpdatedAt(java.util.Collection<DateFilter> updatedAt) {
        setUpdatedAt(updatedAt);
        return this;
    }

    /**
     * <p>
     * The native severity as defined by the security-findings provider's solution that generated the finding.
     * </p>
     * 
     * @return The native severity as defined by the security-findings provider's solution that generated the finding.
     */

    public java.util.List<NumberFilter> getSeverityProduct() {
        return severityProduct;
    }

    /**
     * <p>
     * The native severity as defined by the security-findings provider's solution that generated the finding.
     * </p>
     * 
     * @param severityProduct
     *        The native severity as defined by the security-findings provider's solution that generated the finding.
     */

    public void setSeverityProduct(java.util.Collection<NumberFilter> severityProduct) {
        if (severityProduct == null) {
            this.severityProduct = null;
            return;
        }

        this.severityProduct = new java.util.ArrayList<NumberFilter>(severityProduct);
    }

    /**
     * <p>
     * The native severity as defined by the security-findings provider's solution that generated the finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSeverityProduct(java.util.Collection)} or {@link #withSeverityProduct(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param severityProduct
     *        The native severity as defined by the security-findings provider's solution that generated the finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withSeverityProduct(NumberFilter... severityProduct) {
        if (this.severityProduct == null) {
            setSeverityProduct(new java.util.ArrayList<NumberFilter>(severityProduct.length));
        }
        for (NumberFilter ele : severityProduct) {
            this.severityProduct.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The native severity as defined by the security-findings provider's solution that generated the finding.
     * </p>
     * 
     * @param severityProduct
     *        The native severity as defined by the security-findings provider's solution that generated the finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withSeverityProduct(java.util.Collection<NumberFilter> severityProduct) {
        setSeverityProduct(severityProduct);
        return this;
    }

    /**
     * <p>
     * The normalized severity of a finding.
     * </p>
     * 
     * @return The normalized severity of a finding.
     */

    public java.util.List<NumberFilter> getSeverityNormalized() {
        return severityNormalized;
    }

    /**
     * <p>
     * The normalized severity of a finding.
     * </p>
     * 
     * @param severityNormalized
     *        The normalized severity of a finding.
     */

    public void setSeverityNormalized(java.util.Collection<NumberFilter> severityNormalized) {
        if (severityNormalized == null) {
            this.severityNormalized = null;
            return;
        }

        this.severityNormalized = new java.util.ArrayList<NumberFilter>(severityNormalized);
    }

    /**
     * <p>
     * The normalized severity of a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSeverityNormalized(java.util.Collection)} or {@link #withSeverityNormalized(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param severityNormalized
     *        The normalized severity of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withSeverityNormalized(NumberFilter... severityNormalized) {
        if (this.severityNormalized == null) {
            setSeverityNormalized(new java.util.ArrayList<NumberFilter>(severityNormalized.length));
        }
        for (NumberFilter ele : severityNormalized) {
            this.severityNormalized.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The normalized severity of a finding.
     * </p>
     * 
     * @param severityNormalized
     *        The normalized severity of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withSeverityNormalized(java.util.Collection<NumberFilter> severityNormalized) {
        setSeverityNormalized(severityNormalized);
        return this;
    }

    /**
     * <p>
     * The label of a finding's severity.
     * </p>
     * 
     * @return The label of a finding's severity.
     */

    public java.util.List<StringFilter> getSeverityLabel() {
        return severityLabel;
    }

    /**
     * <p>
     * The label of a finding's severity.
     * </p>
     * 
     * @param severityLabel
     *        The label of a finding's severity.
     */

    public void setSeverityLabel(java.util.Collection<StringFilter> severityLabel) {
        if (severityLabel == null) {
            this.severityLabel = null;
            return;
        }

        this.severityLabel = new java.util.ArrayList<StringFilter>(severityLabel);
    }

    /**
     * <p>
     * The label of a finding's severity.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSeverityLabel(java.util.Collection)} or {@link #withSeverityLabel(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param severityLabel
     *        The label of a finding's severity.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withSeverityLabel(StringFilter... severityLabel) {
        if (this.severityLabel == null) {
            setSeverityLabel(new java.util.ArrayList<StringFilter>(severityLabel.length));
        }
        for (StringFilter ele : severityLabel) {
            this.severityLabel.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The label of a finding's severity.
     * </p>
     * 
     * @param severityLabel
     *        The label of a finding's severity.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withSeverityLabel(java.util.Collection<StringFilter> severityLabel) {
        setSeverityLabel(severityLabel);
        return this;
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0
     * means zero percent confidence and 100 means 100 percent confidence.
     * </p>
     * 
     * @return A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *         behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
     *         scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     */

    public java.util.List<NumberFilter> getConfidence() {
        return confidence;
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0
     * means zero percent confidence and 100 means 100 percent confidence.
     * </p>
     * 
     * @param confidence
     *        A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *        behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
     *        scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     */

    public void setConfidence(java.util.Collection<NumberFilter> confidence) {
        if (confidence == null) {
            this.confidence = null;
            return;
        }

        this.confidence = new java.util.ArrayList<NumberFilter>(confidence);
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0
     * means zero percent confidence and 100 means 100 percent confidence.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setConfidence(java.util.Collection)} or {@link #withConfidence(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param confidence
     *        A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *        behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
     *        scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withConfidence(NumberFilter... confidence) {
        if (this.confidence == null) {
            setConfidence(new java.util.ArrayList<NumberFilter>(confidence.length));
        }
        for (NumberFilter ele : confidence) {
            this.confidence.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior
     * or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0
     * means zero percent confidence and 100 means 100 percent confidence.
     * </p>
     * 
     * @param confidence
     *        A finding's confidence. Confidence is defined as the likelihood that a finding accurately identifies the
     *        behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio
     *        scale, where 0 means zero percent confidence and 100 means 100 percent confidence.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withConfidence(java.util.Collection<NumberFilter> confidence) {
        setConfidence(confidence);
        return this;
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     * </p>
     * 
     * @return The level of importance assigned to the resources associated with the finding. A score of 0 means that
     *         the underlying resources have no criticality, and a score of 100 is reserved for the most critical
     *         resources.
     */

    public java.util.List<NumberFilter> getCriticality() {
        return criticality;
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     * </p>
     * 
     * @param criticality
     *        The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     *        underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     */

    public void setCriticality(java.util.Collection<NumberFilter> criticality) {
        if (criticality == null) {
            this.criticality = null;
            return;
        }

        this.criticality = new java.util.ArrayList<NumberFilter>(criticality);
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCriticality(java.util.Collection)} or {@link #withCriticality(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param criticality
     *        The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     *        underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withCriticality(NumberFilter... criticality) {
        if (this.criticality == null) {
            setCriticality(new java.util.ArrayList<NumberFilter>(criticality.length));
        }
        for (NumberFilter ele : criticality) {
            this.criticality.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     * underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     * </p>
     * 
     * @param criticality
     *        The level of importance assigned to the resources associated with the finding. A score of 0 means that the
     *        underlying resources have no criticality, and a score of 100 is reserved for the most critical resources.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withCriticality(java.util.Collection<NumberFilter> criticality) {
        setCriticality(criticality);
        return this;
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * 
     * @return A finding's title.
     */

    public java.util.List<StringFilter> getTitle() {
        return title;
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * 
     * @param title
     *        A finding's title.
     */

    public void setTitle(java.util.Collection<StringFilter> title) {
        if (title == null) {
            this.title = null;
            return;
        }

        this.title = new java.util.ArrayList<StringFilter>(title);
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTitle(java.util.Collection)} or {@link #withTitle(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param title
     *        A finding's title.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withTitle(StringFilter... title) {
        if (this.title == null) {
            setTitle(new java.util.ArrayList<StringFilter>(title.length));
        }
        for (StringFilter ele : title) {
            this.title.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A finding's title.
     * </p>
     * 
     * @param title
     *        A finding's title.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withTitle(java.util.Collection<StringFilter> title) {
        setTitle(title);
        return this;
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * 
     * @return A finding's description.
     */

    public java.util.List<StringFilter> getDescription() {
        return description;
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * 
     * @param description
     *        A finding's description.
     */

    public void setDescription(java.util.Collection<StringFilter> description) {
        if (description == null) {
            this.description = null;
            return;
        }

        this.description = new java.util.ArrayList<StringFilter>(description);
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setDescription(java.util.Collection)} or {@link #withDescription(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param description
     *        A finding's description.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withDescription(StringFilter... description) {
        if (this.description == null) {
            setDescription(new java.util.ArrayList<StringFilter>(description.length));
        }
        for (StringFilter ele : description) {
            this.description.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A finding's description.
     * </p>
     * 
     * @param description
     *        A finding's description.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withDescription(java.util.Collection<StringFilter> description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The recommendation of what to do about the issue described in a finding.
     * </p>
     * 
     * @return The recommendation of what to do about the issue described in a finding.
     */

    public java.util.List<StringFilter> getRecommendationText() {
        return recommendationText;
    }

    /**
     * <p>
     * The recommendation of what to do about the issue described in a finding.
     * </p>
     * 
     * @param recommendationText
     *        The recommendation of what to do about the issue described in a finding.
     */

    public void setRecommendationText(java.util.Collection<StringFilter> recommendationText) {
        if (recommendationText == null) {
            this.recommendationText = null;
            return;
        }

        this.recommendationText = new java.util.ArrayList<StringFilter>(recommendationText);
    }

    /**
     * <p>
     * The recommendation of what to do about the issue described in a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRecommendationText(java.util.Collection)} or {@link #withRecommendationText(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param recommendationText
     *        The recommendation of what to do about the issue described in a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withRecommendationText(StringFilter... recommendationText) {
        if (this.recommendationText == null) {
            setRecommendationText(new java.util.ArrayList<StringFilter>(recommendationText.length));
        }
        for (StringFilter ele : recommendationText) {
            this.recommendationText.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The recommendation of what to do about the issue described in a finding.
     * </p>
     * 
     * @param recommendationText
     *        The recommendation of what to do about the issue described in a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withRecommendationText(java.util.Collection<StringFilter> recommendationText) {
        setRecommendationText(recommendationText);
        return this;
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     * </p>
     * 
     * @return A URL that links to a page about the current finding in the security-findings provider's solution.
     */

    public java.util.List<StringFilter> getSourceUrl() {
        return sourceUrl;
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     * </p>
     * 
     * @param sourceUrl
     *        A URL that links to a page about the current finding in the security-findings provider's solution.
     */

    public void setSourceUrl(java.util.Collection<StringFilter> sourceUrl) {
        if (sourceUrl == null) {
            this.sourceUrl = null;
            return;
        }

        this.sourceUrl = new java.util.ArrayList<StringFilter>(sourceUrl);
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSourceUrl(java.util.Collection)} or {@link #withSourceUrl(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param sourceUrl
     *        A URL that links to a page about the current finding in the security-findings provider's solution.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withSourceUrl(StringFilter... sourceUrl) {
        if (this.sourceUrl == null) {
            setSourceUrl(new java.util.ArrayList<StringFilter>(sourceUrl.length));
        }
        for (StringFilter ele : sourceUrl) {
            this.sourceUrl.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A URL that links to a page about the current finding in the security-findings provider's solution.
     * </p>
     * 
     * @param sourceUrl
     *        A URL that links to a page about the current finding in the security-findings provider's solution.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withSourceUrl(java.util.Collection<StringFilter> sourceUrl) {
        setSourceUrl(sourceUrl);
        return this;
    }

    /**
     * <p>
     * A data type where security-findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * 
     * @return A data type where security-findings providers can include additional solution-specific details that
     *         aren't part of the defined <code>AwsSecurityFinding</code> format.
     */

    public java.util.List<MapFilter> getProductFields() {
        return productFields;
    }

    /**
     * <p>
     * A data type where security-findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * 
     * @param productFields
     *        A data type where security-findings providers can include additional solution-specific details that aren't
     *        part of the defined <code>AwsSecurityFinding</code> format.
     */

    public void setProductFields(java.util.Collection<MapFilter> productFields) {
        if (productFields == null) {
            this.productFields = null;
            return;
        }

        this.productFields = new java.util.ArrayList<MapFilter>(productFields);
    }

    /**
     * <p>
     * A data type where security-findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProductFields(java.util.Collection)} or {@link #withProductFields(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param productFields
     *        A data type where security-findings providers can include additional solution-specific details that aren't
     *        part of the defined <code>AwsSecurityFinding</code> format.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProductFields(MapFilter... productFields) {
        if (this.productFields == null) {
            setProductFields(new java.util.ArrayList<MapFilter>(productFields.length));
        }
        for (MapFilter ele : productFields) {
            this.productFields.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A data type where security-findings providers can include additional solution-specific details that aren't part
     * of the defined <code>AwsSecurityFinding</code> format.
     * </p>
     * 
     * @param productFields
     *        A data type where security-findings providers can include additional solution-specific details that aren't
     *        part of the defined <code>AwsSecurityFinding</code> format.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProductFields(java.util.Collection<MapFilter> productFields) {
        setProductFields(productFields);
        return this;
    }

    /**
     * <p>
     * The name of the solution (product) that generates findings.
     * </p>
     * 
     * @return The name of the solution (product) that generates findings.
     */

    public java.util.List<StringFilter> getProductName() {
        return productName;
    }

    /**
     * <p>
     * The name of the solution (product) that generates findings.
     * </p>
     * 
     * @param productName
     *        The name of the solution (product) that generates findings.
     */

    public void setProductName(java.util.Collection<StringFilter> productName) {
        if (productName == null) {
            this.productName = null;
            return;
        }

        this.productName = new java.util.ArrayList<StringFilter>(productName);
    }

    /**
     * <p>
     * The name of the solution (product) that generates findings.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProductName(java.util.Collection)} or {@link #withProductName(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param productName
     *        The name of the solution (product) that generates findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProductName(StringFilter... productName) {
        if (this.productName == null) {
            setProductName(new java.util.ArrayList<StringFilter>(productName.length));
        }
        for (StringFilter ele : productName) {
            this.productName.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The name of the solution (product) that generates findings.
     * </p>
     * 
     * @param productName
     *        The name of the solution (product) that generates findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProductName(java.util.Collection<StringFilter> productName) {
        setProductName(productName);
        return this;
    }

    /**
     * <p>
     * The name of the findings provider (company) that owns the solution (product) that generates findings.
     * </p>
     * 
     * @return The name of the findings provider (company) that owns the solution (product) that generates findings.
     */

    public java.util.List<StringFilter> getCompanyName() {
        return companyName;
    }

    /**
     * <p>
     * The name of the findings provider (company) that owns the solution (product) that generates findings.
     * </p>
     * 
     * @param companyName
     *        The name of the findings provider (company) that owns the solution (product) that generates findings.
     */

    public void setCompanyName(java.util.Collection<StringFilter> companyName) {
        if (companyName == null) {
            this.companyName = null;
            return;
        }

        this.companyName = new java.util.ArrayList<StringFilter>(companyName);
    }

    /**
     * <p>
     * The name of the findings provider (company) that owns the solution (product) that generates findings.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCompanyName(java.util.Collection)} or {@link #withCompanyName(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param companyName
     *        The name of the findings provider (company) that owns the solution (product) that generates findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withCompanyName(StringFilter... companyName) {
        if (this.companyName == null) {
            setCompanyName(new java.util.ArrayList<StringFilter>(companyName.length));
        }
        for (StringFilter ele : companyName) {
            this.companyName.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The name of the findings provider (company) that owns the solution (product) that generates findings.
     * </p>
     * 
     * @param companyName
     *        The name of the findings provider (company) that owns the solution (product) that generates findings.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withCompanyName(java.util.Collection<StringFilter> companyName) {
        setCompanyName(companyName);
        return this;
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * 
     * @return A list of name/value string pairs associated with the finding. These are custom, user-defined fields
     *         added to a finding.
     */

    public java.util.List<MapFilter> getUserDefinedFields() {
        return userDefinedFields;
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * 
     * @param userDefinedFields
     *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields added
     *        to a finding.
     */

    public void setUserDefinedFields(java.util.Collection<MapFilter> userDefinedFields) {
        if (userDefinedFields == null) {
            this.userDefinedFields = null;
            return;
        }

        this.userDefinedFields = new java.util.ArrayList<MapFilter>(userDefinedFields);
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setUserDefinedFields(java.util.Collection)} or {@link #withUserDefinedFields(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param userDefinedFields
     *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields added
     *        to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withUserDefinedFields(MapFilter... userDefinedFields) {
        if (this.userDefinedFields == null) {
            setUserDefinedFields(new java.util.ArrayList<MapFilter>(userDefinedFields.length));
        }
        for (MapFilter ele : userDefinedFields) {
            this.userDefinedFields.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a
     * finding.
     * </p>
     * 
     * @param userDefinedFields
     *        A list of name/value string pairs associated with the finding. These are custom, user-defined fields added
     *        to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withUserDefinedFields(java.util.Collection<MapFilter> userDefinedFields) {
        setUserDefinedFields(userDefinedFields);
        return this;
    }

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     * 
     * @return The name of the malware that was observed.
     */

    public java.util.List<StringFilter> getMalwareName() {
        return malwareName;
    }

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     * 
     * @param malwareName
     *        The name of the malware that was observed.
     */

    public void setMalwareName(java.util.Collection<StringFilter> malwareName) {
        if (malwareName == null) {
            this.malwareName = null;
            return;
        }

        this.malwareName = new java.util.ArrayList<StringFilter>(malwareName);
    }

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setMalwareName(java.util.Collection)} or {@link #withMalwareName(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param malwareName
     *        The name of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withMalwareName(StringFilter... malwareName) {
        if (this.malwareName == null) {
            setMalwareName(new java.util.ArrayList<StringFilter>(malwareName.length));
        }
        for (StringFilter ele : malwareName) {
            this.malwareName.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The name of the malware that was observed.
     * </p>
     * 
     * @param malwareName
     *        The name of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withMalwareName(java.util.Collection<StringFilter> malwareName) {
        setMalwareName(malwareName);
        return this;
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * 
     * @return The type of the malware that was observed.
     */

    public java.util.List<StringFilter> getMalwareType() {
        return malwareType;
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * 
     * @param malwareType
     *        The type of the malware that was observed.
     */

    public void setMalwareType(java.util.Collection<StringFilter> malwareType) {
        if (malwareType == null) {
            this.malwareType = null;
            return;
        }

        this.malwareType = new java.util.ArrayList<StringFilter>(malwareType);
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setMalwareType(java.util.Collection)} or {@link #withMalwareType(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param malwareType
     *        The type of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withMalwareType(StringFilter... malwareType) {
        if (this.malwareType == null) {
            setMalwareType(new java.util.ArrayList<StringFilter>(malwareType.length));
        }
        for (StringFilter ele : malwareType) {
            this.malwareType.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The type of the malware that was observed.
     * </p>
     * 
     * @param malwareType
     *        The type of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withMalwareType(java.util.Collection<StringFilter> malwareType) {
        setMalwareType(malwareType);
        return this;
    }

    /**
     * <p>
     * The filesystem path of the malware that was observed.
     * </p>
     * 
     * @return The filesystem path of the malware that was observed.
     */

    public java.util.List<StringFilter> getMalwarePath() {
        return malwarePath;
    }

    /**
     * <p>
     * The filesystem path of the malware that was observed.
     * </p>
     * 
     * @param malwarePath
     *        The filesystem path of the malware that was observed.
     */

    public void setMalwarePath(java.util.Collection<StringFilter> malwarePath) {
        if (malwarePath == null) {
            this.malwarePath = null;
            return;
        }

        this.malwarePath = new java.util.ArrayList<StringFilter>(malwarePath);
    }

    /**
     * <p>
     * The filesystem path of the malware that was observed.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setMalwarePath(java.util.Collection)} or {@link #withMalwarePath(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param malwarePath
     *        The filesystem path of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withMalwarePath(StringFilter... malwarePath) {
        if (this.malwarePath == null) {
            setMalwarePath(new java.util.ArrayList<StringFilter>(malwarePath.length));
        }
        for (StringFilter ele : malwarePath) {
            this.malwarePath.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The filesystem path of the malware that was observed.
     * </p>
     * 
     * @param malwarePath
     *        The filesystem path of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withMalwarePath(java.util.Collection<StringFilter> malwarePath) {
        setMalwarePath(malwarePath);
        return this;
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * 
     * @return The state of the malware that was observed.
     */

    public java.util.List<StringFilter> getMalwareState() {
        return malwareState;
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * 
     * @param malwareState
     *        The state of the malware that was observed.
     */

    public void setMalwareState(java.util.Collection<StringFilter> malwareState) {
        if (malwareState == null) {
            this.malwareState = null;
            return;
        }

        this.malwareState = new java.util.ArrayList<StringFilter>(malwareState);
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setMalwareState(java.util.Collection)} or {@link #withMalwareState(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param malwareState
     *        The state of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withMalwareState(StringFilter... malwareState) {
        if (this.malwareState == null) {
            setMalwareState(new java.util.ArrayList<StringFilter>(malwareState.length));
        }
        for (StringFilter ele : malwareState) {
            this.malwareState.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The state of the malware that was observed.
     * </p>
     * 
     * @param malwareState
     *        The state of the malware that was observed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withMalwareState(java.util.Collection<StringFilter> malwareState) {
        setMalwareState(malwareState);
        return this;
    }

    /**
     * <p>
     * Indicates the direction of network traffic associated with a finding.
     * </p>
     * 
     * @return Indicates the direction of network traffic associated with a finding.
     */

    public java.util.List<StringFilter> getNetworkDirection() {
        return networkDirection;
    }

    /**
     * <p>
     * Indicates the direction of network traffic associated with a finding.
     * </p>
     * 
     * @param networkDirection
     *        Indicates the direction of network traffic associated with a finding.
     */

    public void setNetworkDirection(java.util.Collection<StringFilter> networkDirection) {
        if (networkDirection == null) {
            this.networkDirection = null;
            return;
        }

        this.networkDirection = new java.util.ArrayList<StringFilter>(networkDirection);
    }

    /**
     * <p>
     * Indicates the direction of network traffic associated with a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkDirection(java.util.Collection)} or {@link #withNetworkDirection(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param networkDirection
     *        Indicates the direction of network traffic associated with a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDirection(StringFilter... networkDirection) {
        if (this.networkDirection == null) {
            setNetworkDirection(new java.util.ArrayList<StringFilter>(networkDirection.length));
        }
        for (StringFilter ele : networkDirection) {
            this.networkDirection.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Indicates the direction of network traffic associated with a finding.
     * </p>
     * 
     * @param networkDirection
     *        Indicates the direction of network traffic associated with a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDirection(java.util.Collection<StringFilter> networkDirection) {
        setNetworkDirection(networkDirection);
        return this;
    }

    /**
     * <p>
     * The protocol of network-related information about a finding.
     * </p>
     * 
     * @return The protocol of network-related information about a finding.
     */

    public java.util.List<StringFilter> getNetworkProtocol() {
        return networkProtocol;
    }

    /**
     * <p>
     * The protocol of network-related information about a finding.
     * </p>
     * 
     * @param networkProtocol
     *        The protocol of network-related information about a finding.
     */

    public void setNetworkProtocol(java.util.Collection<StringFilter> networkProtocol) {
        if (networkProtocol == null) {
            this.networkProtocol = null;
            return;
        }

        this.networkProtocol = new java.util.ArrayList<StringFilter>(networkProtocol);
    }

    /**
     * <p>
     * The protocol of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkProtocol(java.util.Collection)} or {@link #withNetworkProtocol(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param networkProtocol
     *        The protocol of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkProtocol(StringFilter... networkProtocol) {
        if (this.networkProtocol == null) {
            setNetworkProtocol(new java.util.ArrayList<StringFilter>(networkProtocol.length));
        }
        for (StringFilter ele : networkProtocol) {
            this.networkProtocol.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The protocol of network-related information about a finding.
     * </p>
     * 
     * @param networkProtocol
     *        The protocol of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkProtocol(java.util.Collection<StringFilter> networkProtocol) {
        setNetworkProtocol(networkProtocol);
        return this;
    }

    /**
     * <p>
     * The source IPv4 address of network-related information about a finding.
     * </p>
     * 
     * @return The source IPv4 address of network-related information about a finding.
     */

    public java.util.List<IpFilter> getNetworkSourceIpV4() {
        return networkSourceIpV4;
    }

    /**
     * <p>
     * The source IPv4 address of network-related information about a finding.
     * </p>
     * 
     * @param networkSourceIpV4
     *        The source IPv4 address of network-related information about a finding.
     */

    public void setNetworkSourceIpV4(java.util.Collection<IpFilter> networkSourceIpV4) {
        if (networkSourceIpV4 == null) {
            this.networkSourceIpV4 = null;
            return;
        }

        this.networkSourceIpV4 = new java.util.ArrayList<IpFilter>(networkSourceIpV4);
    }

    /**
     * <p>
     * The source IPv4 address of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkSourceIpV4(java.util.Collection)} or {@link #withNetworkSourceIpV4(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param networkSourceIpV4
     *        The source IPv4 address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourceIpV4(IpFilter... networkSourceIpV4) {
        if (this.networkSourceIpV4 == null) {
            setNetworkSourceIpV4(new java.util.ArrayList<IpFilter>(networkSourceIpV4.length));
        }
        for (IpFilter ele : networkSourceIpV4) {
            this.networkSourceIpV4.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The source IPv4 address of network-related information about a finding.
     * </p>
     * 
     * @param networkSourceIpV4
     *        The source IPv4 address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourceIpV4(java.util.Collection<IpFilter> networkSourceIpV4) {
        setNetworkSourceIpV4(networkSourceIpV4);
        return this;
    }

    /**
     * <p>
     * The source IPv6 address of network-related information about a finding.
     * </p>
     * 
     * @return The source IPv6 address of network-related information about a finding.
     */

    public java.util.List<IpFilter> getNetworkSourceIpV6() {
        return networkSourceIpV6;
    }

    /**
     * <p>
     * The source IPv6 address of network-related information about a finding.
     * </p>
     * 
     * @param networkSourceIpV6
     *        The source IPv6 address of network-related information about a finding.
     */

    public void setNetworkSourceIpV6(java.util.Collection<IpFilter> networkSourceIpV6) {
        if (networkSourceIpV6 == null) {
            this.networkSourceIpV6 = null;
            return;
        }

        this.networkSourceIpV6 = new java.util.ArrayList<IpFilter>(networkSourceIpV6);
    }

    /**
     * <p>
     * The source IPv6 address of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkSourceIpV6(java.util.Collection)} or {@link #withNetworkSourceIpV6(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param networkSourceIpV6
     *        The source IPv6 address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourceIpV6(IpFilter... networkSourceIpV6) {
        if (this.networkSourceIpV6 == null) {
            setNetworkSourceIpV6(new java.util.ArrayList<IpFilter>(networkSourceIpV6.length));
        }
        for (IpFilter ele : networkSourceIpV6) {
            this.networkSourceIpV6.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The source IPv6 address of network-related information about a finding.
     * </p>
     * 
     * @param networkSourceIpV6
     *        The source IPv6 address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourceIpV6(java.util.Collection<IpFilter> networkSourceIpV6) {
        setNetworkSourceIpV6(networkSourceIpV6);
        return this;
    }

    /**
     * <p>
     * The source port of network-related information about a finding.
     * </p>
     * 
     * @return The source port of network-related information about a finding.
     */

    public java.util.List<NumberFilter> getNetworkSourcePort() {
        return networkSourcePort;
    }

    /**
     * <p>
     * The source port of network-related information about a finding.
     * </p>
     * 
     * @param networkSourcePort
     *        The source port of network-related information about a finding.
     */

    public void setNetworkSourcePort(java.util.Collection<NumberFilter> networkSourcePort) {
        if (networkSourcePort == null) {
            this.networkSourcePort = null;
            return;
        }

        this.networkSourcePort = new java.util.ArrayList<NumberFilter>(networkSourcePort);
    }

    /**
     * <p>
     * The source port of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkSourcePort(java.util.Collection)} or {@link #withNetworkSourcePort(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param networkSourcePort
     *        The source port of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourcePort(NumberFilter... networkSourcePort) {
        if (this.networkSourcePort == null) {
            setNetworkSourcePort(new java.util.ArrayList<NumberFilter>(networkSourcePort.length));
        }
        for (NumberFilter ele : networkSourcePort) {
            this.networkSourcePort.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The source port of network-related information about a finding.
     * </p>
     * 
     * @param networkSourcePort
     *        The source port of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourcePort(java.util.Collection<NumberFilter> networkSourcePort) {
        setNetworkSourcePort(networkSourcePort);
        return this;
    }

    /**
     * <p>
     * The source domain of network-related information about a finding.
     * </p>
     * 
     * @return The source domain of network-related information about a finding.
     */

    public java.util.List<StringFilter> getNetworkSourceDomain() {
        return networkSourceDomain;
    }

    /**
     * <p>
     * The source domain of network-related information about a finding.
     * </p>
     * 
     * @param networkSourceDomain
     *        The source domain of network-related information about a finding.
     */

    public void setNetworkSourceDomain(java.util.Collection<StringFilter> networkSourceDomain) {
        if (networkSourceDomain == null) {
            this.networkSourceDomain = null;
            return;
        }

        this.networkSourceDomain = new java.util.ArrayList<StringFilter>(networkSourceDomain);
    }

    /**
     * <p>
     * The source domain of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkSourceDomain(java.util.Collection)} or {@link #withNetworkSourceDomain(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param networkSourceDomain
     *        The source domain of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourceDomain(StringFilter... networkSourceDomain) {
        if (this.networkSourceDomain == null) {
            setNetworkSourceDomain(new java.util.ArrayList<StringFilter>(networkSourceDomain.length));
        }
        for (StringFilter ele : networkSourceDomain) {
            this.networkSourceDomain.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The source domain of network-related information about a finding.
     * </p>
     * 
     * @param networkSourceDomain
     *        The source domain of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourceDomain(java.util.Collection<StringFilter> networkSourceDomain) {
        setNetworkSourceDomain(networkSourceDomain);
        return this;
    }

    /**
     * <p>
     * The source media access control (MAC) address of network-related information about a finding.
     * </p>
     * 
     * @return The source media access control (MAC) address of network-related information about a finding.
     */

    public java.util.List<StringFilter> getNetworkSourceMac() {
        return networkSourceMac;
    }

    /**
     * <p>
     * The source media access control (MAC) address of network-related information about a finding.
     * </p>
     * 
     * @param networkSourceMac
     *        The source media access control (MAC) address of network-related information about a finding.
     */

    public void setNetworkSourceMac(java.util.Collection<StringFilter> networkSourceMac) {
        if (networkSourceMac == null) {
            this.networkSourceMac = null;
            return;
        }

        this.networkSourceMac = new java.util.ArrayList<StringFilter>(networkSourceMac);
    }

    /**
     * <p>
     * The source media access control (MAC) address of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkSourceMac(java.util.Collection)} or {@link #withNetworkSourceMac(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param networkSourceMac
     *        The source media access control (MAC) address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourceMac(StringFilter... networkSourceMac) {
        if (this.networkSourceMac == null) {
            setNetworkSourceMac(new java.util.ArrayList<StringFilter>(networkSourceMac.length));
        }
        for (StringFilter ele : networkSourceMac) {
            this.networkSourceMac.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The source media access control (MAC) address of network-related information about a finding.
     * </p>
     * 
     * @param networkSourceMac
     *        The source media access control (MAC) address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkSourceMac(java.util.Collection<StringFilter> networkSourceMac) {
        setNetworkSourceMac(networkSourceMac);
        return this;
    }

    /**
     * <p>
     * The destination IPv4 address of network-related information about a finding.
     * </p>
     * 
     * @return The destination IPv4 address of network-related information about a finding.
     */

    public java.util.List<IpFilter> getNetworkDestinationIpV4() {
        return networkDestinationIpV4;
    }

    /**
     * <p>
     * The destination IPv4 address of network-related information about a finding.
     * </p>
     * 
     * @param networkDestinationIpV4
     *        The destination IPv4 address of network-related information about a finding.
     */

    public void setNetworkDestinationIpV4(java.util.Collection<IpFilter> networkDestinationIpV4) {
        if (networkDestinationIpV4 == null) {
            this.networkDestinationIpV4 = null;
            return;
        }

        this.networkDestinationIpV4 = new java.util.ArrayList<IpFilter>(networkDestinationIpV4);
    }

    /**
     * <p>
     * The destination IPv4 address of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkDestinationIpV4(java.util.Collection)} or
     * {@link #withNetworkDestinationIpV4(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param networkDestinationIpV4
     *        The destination IPv4 address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDestinationIpV4(IpFilter... networkDestinationIpV4) {
        if (this.networkDestinationIpV4 == null) {
            setNetworkDestinationIpV4(new java.util.ArrayList<IpFilter>(networkDestinationIpV4.length));
        }
        for (IpFilter ele : networkDestinationIpV4) {
            this.networkDestinationIpV4.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The destination IPv4 address of network-related information about a finding.
     * </p>
     * 
     * @param networkDestinationIpV4
     *        The destination IPv4 address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDestinationIpV4(java.util.Collection<IpFilter> networkDestinationIpV4) {
        setNetworkDestinationIpV4(networkDestinationIpV4);
        return this;
    }

    /**
     * <p>
     * The destination IPv6 address of network-related information about a finding.
     * </p>
     * 
     * @return The destination IPv6 address of network-related information about a finding.
     */

    public java.util.List<IpFilter> getNetworkDestinationIpV6() {
        return networkDestinationIpV6;
    }

    /**
     * <p>
     * The destination IPv6 address of network-related information about a finding.
     * </p>
     * 
     * @param networkDestinationIpV6
     *        The destination IPv6 address of network-related information about a finding.
     */

    public void setNetworkDestinationIpV6(java.util.Collection<IpFilter> networkDestinationIpV6) {
        if (networkDestinationIpV6 == null) {
            this.networkDestinationIpV6 = null;
            return;
        }

        this.networkDestinationIpV6 = new java.util.ArrayList<IpFilter>(networkDestinationIpV6);
    }

    /**
     * <p>
     * The destination IPv6 address of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkDestinationIpV6(java.util.Collection)} or
     * {@link #withNetworkDestinationIpV6(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param networkDestinationIpV6
     *        The destination IPv6 address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDestinationIpV6(IpFilter... networkDestinationIpV6) {
        if (this.networkDestinationIpV6 == null) {
            setNetworkDestinationIpV6(new java.util.ArrayList<IpFilter>(networkDestinationIpV6.length));
        }
        for (IpFilter ele : networkDestinationIpV6) {
            this.networkDestinationIpV6.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The destination IPv6 address of network-related information about a finding.
     * </p>
     * 
     * @param networkDestinationIpV6
     *        The destination IPv6 address of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDestinationIpV6(java.util.Collection<IpFilter> networkDestinationIpV6) {
        setNetworkDestinationIpV6(networkDestinationIpV6);
        return this;
    }

    /**
     * <p>
     * The destination port of network-related information about a finding.
     * </p>
     * 
     * @return The destination port of network-related information about a finding.
     */

    public java.util.List<NumberFilter> getNetworkDestinationPort() {
        return networkDestinationPort;
    }

    /**
     * <p>
     * The destination port of network-related information about a finding.
     * </p>
     * 
     * @param networkDestinationPort
     *        The destination port of network-related information about a finding.
     */

    public void setNetworkDestinationPort(java.util.Collection<NumberFilter> networkDestinationPort) {
        if (networkDestinationPort == null) {
            this.networkDestinationPort = null;
            return;
        }

        this.networkDestinationPort = new java.util.ArrayList<NumberFilter>(networkDestinationPort);
    }

    /**
     * <p>
     * The destination port of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkDestinationPort(java.util.Collection)} or
     * {@link #withNetworkDestinationPort(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param networkDestinationPort
     *        The destination port of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDestinationPort(NumberFilter... networkDestinationPort) {
        if (this.networkDestinationPort == null) {
            setNetworkDestinationPort(new java.util.ArrayList<NumberFilter>(networkDestinationPort.length));
        }
        for (NumberFilter ele : networkDestinationPort) {
            this.networkDestinationPort.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The destination port of network-related information about a finding.
     * </p>
     * 
     * @param networkDestinationPort
     *        The destination port of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDestinationPort(java.util.Collection<NumberFilter> networkDestinationPort) {
        setNetworkDestinationPort(networkDestinationPort);
        return this;
    }

    /**
     * <p>
     * The destination domain of network-related information about a finding.
     * </p>
     * 
     * @return The destination domain of network-related information about a finding.
     */

    public java.util.List<StringFilter> getNetworkDestinationDomain() {
        return networkDestinationDomain;
    }

    /**
     * <p>
     * The destination domain of network-related information about a finding.
     * </p>
     * 
     * @param networkDestinationDomain
     *        The destination domain of network-related information about a finding.
     */

    public void setNetworkDestinationDomain(java.util.Collection<StringFilter> networkDestinationDomain) {
        if (networkDestinationDomain == null) {
            this.networkDestinationDomain = null;
            return;
        }

        this.networkDestinationDomain = new java.util.ArrayList<StringFilter>(networkDestinationDomain);
    }

    /**
     * <p>
     * The destination domain of network-related information about a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNetworkDestinationDomain(java.util.Collection)} or
     * {@link #withNetworkDestinationDomain(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param networkDestinationDomain
     *        The destination domain of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDestinationDomain(StringFilter... networkDestinationDomain) {
        if (this.networkDestinationDomain == null) {
            setNetworkDestinationDomain(new java.util.ArrayList<StringFilter>(networkDestinationDomain.length));
        }
        for (StringFilter ele : networkDestinationDomain) {
            this.networkDestinationDomain.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The destination domain of network-related information about a finding.
     * </p>
     * 
     * @param networkDestinationDomain
     *        The destination domain of network-related information about a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNetworkDestinationDomain(java.util.Collection<StringFilter> networkDestinationDomain) {
        setNetworkDestinationDomain(networkDestinationDomain);
        return this;
    }

    /**
     * <p>
     * The name of the process.
     * </p>
     * 
     * @return The name of the process.
     */

    public java.util.List<StringFilter> getProcessName() {
        return processName;
    }

    /**
     * <p>
     * The name of the process.
     * </p>
     * 
     * @param processName
     *        The name of the process.
     */

    public void setProcessName(java.util.Collection<StringFilter> processName) {
        if (processName == null) {
            this.processName = null;
            return;
        }

        this.processName = new java.util.ArrayList<StringFilter>(processName);
    }

    /**
     * <p>
     * The name of the process.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProcessName(java.util.Collection)} or {@link #withProcessName(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param processName
     *        The name of the process.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessName(StringFilter... processName) {
        if (this.processName == null) {
            setProcessName(new java.util.ArrayList<StringFilter>(processName.length));
        }
        for (StringFilter ele : processName) {
            this.processName.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The name of the process.
     * </p>
     * 
     * @param processName
     *        The name of the process.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessName(java.util.Collection<StringFilter> processName) {
        setProcessName(processName);
        return this;
    }

    /**
     * <p>
     * The path to the process executable.
     * </p>
     * 
     * @return The path to the process executable.
     */

    public java.util.List<StringFilter> getProcessPath() {
        return processPath;
    }

    /**
     * <p>
     * The path to the process executable.
     * </p>
     * 
     * @param processPath
     *        The path to the process executable.
     */

    public void setProcessPath(java.util.Collection<StringFilter> processPath) {
        if (processPath == null) {
            this.processPath = null;
            return;
        }

        this.processPath = new java.util.ArrayList<StringFilter>(processPath);
    }

    /**
     * <p>
     * The path to the process executable.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProcessPath(java.util.Collection)} or {@link #withProcessPath(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param processPath
     *        The path to the process executable.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessPath(StringFilter... processPath) {
        if (this.processPath == null) {
            setProcessPath(new java.util.ArrayList<StringFilter>(processPath.length));
        }
        for (StringFilter ele : processPath) {
            this.processPath.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The path to the process executable.
     * </p>
     * 
     * @param processPath
     *        The path to the process executable.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessPath(java.util.Collection<StringFilter> processPath) {
        setProcessPath(processPath);
        return this;
    }

    /**
     * <p>
     * The process ID.
     * </p>
     * 
     * @return The process ID.
     */

    public java.util.List<NumberFilter> getProcessPid() {
        return processPid;
    }

    /**
     * <p>
     * The process ID.
     * </p>
     * 
     * @param processPid
     *        The process ID.
     */

    public void setProcessPid(java.util.Collection<NumberFilter> processPid) {
        if (processPid == null) {
            this.processPid = null;
            return;
        }

        this.processPid = new java.util.ArrayList<NumberFilter>(processPid);
    }

    /**
     * <p>
     * The process ID.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProcessPid(java.util.Collection)} or {@link #withProcessPid(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param processPid
     *        The process ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessPid(NumberFilter... processPid) {
        if (this.processPid == null) {
            setProcessPid(new java.util.ArrayList<NumberFilter>(processPid.length));
        }
        for (NumberFilter ele : processPid) {
            this.processPid.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The process ID.
     * </p>
     * 
     * @param processPid
     *        The process ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessPid(java.util.Collection<NumberFilter> processPid) {
        setProcessPid(processPid);
        return this;
    }

    /**
     * <p>
     * The parent process ID.
     * </p>
     * 
     * @return The parent process ID.
     */

    public java.util.List<NumberFilter> getProcessParentPid() {
        return processParentPid;
    }

    /**
     * <p>
     * The parent process ID.
     * </p>
     * 
     * @param processParentPid
     *        The parent process ID.
     */

    public void setProcessParentPid(java.util.Collection<NumberFilter> processParentPid) {
        if (processParentPid == null) {
            this.processParentPid = null;
            return;
        }

        this.processParentPid = new java.util.ArrayList<NumberFilter>(processParentPid);
    }

    /**
     * <p>
     * The parent process ID.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProcessParentPid(java.util.Collection)} or {@link #withProcessParentPid(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param processParentPid
     *        The parent process ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessParentPid(NumberFilter... processParentPid) {
        if (this.processParentPid == null) {
            setProcessParentPid(new java.util.ArrayList<NumberFilter>(processParentPid.length));
        }
        for (NumberFilter ele : processParentPid) {
            this.processParentPid.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The parent process ID.
     * </p>
     * 
     * @param processParentPid
     *        The parent process ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessParentPid(java.util.Collection<NumberFilter> processParentPid) {
        setProcessParentPid(processParentPid);
        return this;
    }

    /**
     * <p>
     * The date/time that the process was launched.
     * </p>
     * 
     * @return The date/time that the process was launched.
     */

    public java.util.List<DateFilter> getProcessLaunchedAt() {
        return processLaunchedAt;
    }

    /**
     * <p>
     * The date/time that the process was launched.
     * </p>
     * 
     * @param processLaunchedAt
     *        The date/time that the process was launched.
     */

    public void setProcessLaunchedAt(java.util.Collection<DateFilter> processLaunchedAt) {
        if (processLaunchedAt == null) {
            this.processLaunchedAt = null;
            return;
        }

        this.processLaunchedAt = new java.util.ArrayList<DateFilter>(processLaunchedAt);
    }

    /**
     * <p>
     * The date/time that the process was launched.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProcessLaunchedAt(java.util.Collection)} or {@link #withProcessLaunchedAt(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param processLaunchedAt
     *        The date/time that the process was launched.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessLaunchedAt(DateFilter... processLaunchedAt) {
        if (this.processLaunchedAt == null) {
            setProcessLaunchedAt(new java.util.ArrayList<DateFilter>(processLaunchedAt.length));
        }
        for (DateFilter ele : processLaunchedAt) {
            this.processLaunchedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The date/time that the process was launched.
     * </p>
     * 
     * @param processLaunchedAt
     *        The date/time that the process was launched.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessLaunchedAt(java.util.Collection<DateFilter> processLaunchedAt) {
        setProcessLaunchedAt(processLaunchedAt);
        return this;
    }

    /**
     * <p>
     * The date/time that the process was terminated.
     * </p>
     * 
     * @return The date/time that the process was terminated.
     */

    public java.util.List<DateFilter> getProcessTerminatedAt() {
        return processTerminatedAt;
    }

    /**
     * <p>
     * The date/time that the process was terminated.
     * </p>
     * 
     * @param processTerminatedAt
     *        The date/time that the process was terminated.
     */

    public void setProcessTerminatedAt(java.util.Collection<DateFilter> processTerminatedAt) {
        if (processTerminatedAt == null) {
            this.processTerminatedAt = null;
            return;
        }

        this.processTerminatedAt = new java.util.ArrayList<DateFilter>(processTerminatedAt);
    }

    /**
     * <p>
     * The date/time that the process was terminated.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setProcessTerminatedAt(java.util.Collection)} or {@link #withProcessTerminatedAt(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param processTerminatedAt
     *        The date/time that the process was terminated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessTerminatedAt(DateFilter... processTerminatedAt) {
        if (this.processTerminatedAt == null) {
            setProcessTerminatedAt(new java.util.ArrayList<DateFilter>(processTerminatedAt.length));
        }
        for (DateFilter ele : processTerminatedAt) {
            this.processTerminatedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The date/time that the process was terminated.
     * </p>
     * 
     * @param processTerminatedAt
     *        The date/time that the process was terminated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withProcessTerminatedAt(java.util.Collection<DateFilter> processTerminatedAt) {
        setProcessTerminatedAt(processTerminatedAt);
        return this;
    }

    /**
     * <p>
     * The type of a threat intel indicator.
     * </p>
     * 
     * @return The type of a threat intel indicator.
     */

    public java.util.List<StringFilter> getThreatIntelIndicatorType() {
        return threatIntelIndicatorType;
    }

    /**
     * <p>
     * The type of a threat intel indicator.
     * </p>
     * 
     * @param threatIntelIndicatorType
     *        The type of a threat intel indicator.
     */

    public void setThreatIntelIndicatorType(java.util.Collection<StringFilter> threatIntelIndicatorType) {
        if (threatIntelIndicatorType == null) {
            this.threatIntelIndicatorType = null;
            return;
        }

        this.threatIntelIndicatorType = new java.util.ArrayList<StringFilter>(threatIntelIndicatorType);
    }

    /**
     * <p>
     * The type of a threat intel indicator.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setThreatIntelIndicatorType(java.util.Collection)} or
     * {@link #withThreatIntelIndicatorType(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param threatIntelIndicatorType
     *        The type of a threat intel indicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorType(StringFilter... threatIntelIndicatorType) {
        if (this.threatIntelIndicatorType == null) {
            setThreatIntelIndicatorType(new java.util.ArrayList<StringFilter>(threatIntelIndicatorType.length));
        }
        for (StringFilter ele : threatIntelIndicatorType) {
            this.threatIntelIndicatorType.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The type of a threat intel indicator.
     * </p>
     * 
     * @param threatIntelIndicatorType
     *        The type of a threat intel indicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorType(java.util.Collection<StringFilter> threatIntelIndicatorType) {
        setThreatIntelIndicatorType(threatIntelIndicatorType);
        return this;
    }

    /**
     * <p>
     * The value of a threat intel indicator.
     * </p>
     * 
     * @return The value of a threat intel indicator.
     */

    public java.util.List<StringFilter> getThreatIntelIndicatorValue() {
        return threatIntelIndicatorValue;
    }

    /**
     * <p>
     * The value of a threat intel indicator.
     * </p>
     * 
     * @param threatIntelIndicatorValue
     *        The value of a threat intel indicator.
     */

    public void setThreatIntelIndicatorValue(java.util.Collection<StringFilter> threatIntelIndicatorValue) {
        if (threatIntelIndicatorValue == null) {
            this.threatIntelIndicatorValue = null;
            return;
        }

        this.threatIntelIndicatorValue = new java.util.ArrayList<StringFilter>(threatIntelIndicatorValue);
    }

    /**
     * <p>
     * The value of a threat intel indicator.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setThreatIntelIndicatorValue(java.util.Collection)} or
     * {@link #withThreatIntelIndicatorValue(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param threatIntelIndicatorValue
     *        The value of a threat intel indicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorValue(StringFilter... threatIntelIndicatorValue) {
        if (this.threatIntelIndicatorValue == null) {
            setThreatIntelIndicatorValue(new java.util.ArrayList<StringFilter>(threatIntelIndicatorValue.length));
        }
        for (StringFilter ele : threatIntelIndicatorValue) {
            this.threatIntelIndicatorValue.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The value of a threat intel indicator.
     * </p>
     * 
     * @param threatIntelIndicatorValue
     *        The value of a threat intel indicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorValue(java.util.Collection<StringFilter> threatIntelIndicatorValue) {
        setThreatIntelIndicatorValue(threatIntelIndicatorValue);
        return this;
    }

    /**
     * <p>
     * The category of a threat intel indicator.
     * </p>
     * 
     * @return The category of a threat intel indicator.
     */

    public java.util.List<StringFilter> getThreatIntelIndicatorCategory() {
        return threatIntelIndicatorCategory;
    }

    /**
     * <p>
     * The category of a threat intel indicator.
     * </p>
     * 
     * @param threatIntelIndicatorCategory
     *        The category of a threat intel indicator.
     */

    public void setThreatIntelIndicatorCategory(java.util.Collection<StringFilter> threatIntelIndicatorCategory) {
        if (threatIntelIndicatorCategory == null) {
            this.threatIntelIndicatorCategory = null;
            return;
        }

        this.threatIntelIndicatorCategory = new java.util.ArrayList<StringFilter>(threatIntelIndicatorCategory);
    }

    /**
     * <p>
     * The category of a threat intel indicator.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setThreatIntelIndicatorCategory(java.util.Collection)} or
     * {@link #withThreatIntelIndicatorCategory(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param threatIntelIndicatorCategory
     *        The category of a threat intel indicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorCategory(StringFilter... threatIntelIndicatorCategory) {
        if (this.threatIntelIndicatorCategory == null) {
            setThreatIntelIndicatorCategory(new java.util.ArrayList<StringFilter>(threatIntelIndicatorCategory.length));
        }
        for (StringFilter ele : threatIntelIndicatorCategory) {
            this.threatIntelIndicatorCategory.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The category of a threat intel indicator.
     * </p>
     * 
     * @param threatIntelIndicatorCategory
     *        The category of a threat intel indicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorCategory(java.util.Collection<StringFilter> threatIntelIndicatorCategory) {
        setThreatIntelIndicatorCategory(threatIntelIndicatorCategory);
        return this;
    }

    /**
     * <p>
     * The date/time of the last observation of a threat intel indicator.
     * </p>
     * 
     * @return The date/time of the last observation of a threat intel indicator.
     */

    public java.util.List<DateFilter> getThreatIntelIndicatorLastObservedAt() {
        return threatIntelIndicatorLastObservedAt;
    }

    /**
     * <p>
     * The date/time of the last observation of a threat intel indicator.
     * </p>
     * 
     * @param threatIntelIndicatorLastObservedAt
     *        The date/time of the last observation of a threat intel indicator.
     */

    public void setThreatIntelIndicatorLastObservedAt(java.util.Collection<DateFilter> threatIntelIndicatorLastObservedAt) {
        if (threatIntelIndicatorLastObservedAt == null) {
            this.threatIntelIndicatorLastObservedAt = null;
            return;
        }

        this.threatIntelIndicatorLastObservedAt = new java.util.ArrayList<DateFilter>(threatIntelIndicatorLastObservedAt);
    }

    /**
     * <p>
     * The date/time of the last observation of a threat intel indicator.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setThreatIntelIndicatorLastObservedAt(java.util.Collection)} or
     * {@link #withThreatIntelIndicatorLastObservedAt(java.util.Collection)} if you want to override the existing
     * values.
     * </p>
     * 
     * @param threatIntelIndicatorLastObservedAt
     *        The date/time of the last observation of a threat intel indicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorLastObservedAt(DateFilter... threatIntelIndicatorLastObservedAt) {
        if (this.threatIntelIndicatorLastObservedAt == null) {
            setThreatIntelIndicatorLastObservedAt(new java.util.ArrayList<DateFilter>(threatIntelIndicatorLastObservedAt.length));
        }
        for (DateFilter ele : threatIntelIndicatorLastObservedAt) {
            this.threatIntelIndicatorLastObservedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The date/time of the last observation of a threat intel indicator.
     * </p>
     * 
     * @param threatIntelIndicatorLastObservedAt
     *        The date/time of the last observation of a threat intel indicator.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorLastObservedAt(java.util.Collection<DateFilter> threatIntelIndicatorLastObservedAt) {
        setThreatIntelIndicatorLastObservedAt(threatIntelIndicatorLastObservedAt);
        return this;
    }

    /**
     * <p>
     * The source of the threat intel.
     * </p>
     * 
     * @return The source of the threat intel.
     */

    public java.util.List<StringFilter> getThreatIntelIndicatorSource() {
        return threatIntelIndicatorSource;
    }

    /**
     * <p>
     * The source of the threat intel.
     * </p>
     * 
     * @param threatIntelIndicatorSource
     *        The source of the threat intel.
     */

    public void setThreatIntelIndicatorSource(java.util.Collection<StringFilter> threatIntelIndicatorSource) {
        if (threatIntelIndicatorSource == null) {
            this.threatIntelIndicatorSource = null;
            return;
        }

        this.threatIntelIndicatorSource = new java.util.ArrayList<StringFilter>(threatIntelIndicatorSource);
    }

    /**
     * <p>
     * The source of the threat intel.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setThreatIntelIndicatorSource(java.util.Collection)} or
     * {@link #withThreatIntelIndicatorSource(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param threatIntelIndicatorSource
     *        The source of the threat intel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorSource(StringFilter... threatIntelIndicatorSource) {
        if (this.threatIntelIndicatorSource == null) {
            setThreatIntelIndicatorSource(new java.util.ArrayList<StringFilter>(threatIntelIndicatorSource.length));
        }
        for (StringFilter ele : threatIntelIndicatorSource) {
            this.threatIntelIndicatorSource.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The source of the threat intel.
     * </p>
     * 
     * @param threatIntelIndicatorSource
     *        The source of the threat intel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorSource(java.util.Collection<StringFilter> threatIntelIndicatorSource) {
        setThreatIntelIndicatorSource(threatIntelIndicatorSource);
        return this;
    }

    /**
     * <p>
     * The URL for more details from the source of the threat intel.
     * </p>
     * 
     * @return The URL for more details from the source of the threat intel.
     */

    public java.util.List<StringFilter> getThreatIntelIndicatorSourceUrl() {
        return threatIntelIndicatorSourceUrl;
    }

    /**
     * <p>
     * The URL for more details from the source of the threat intel.
     * </p>
     * 
     * @param threatIntelIndicatorSourceUrl
     *        The URL for more details from the source of the threat intel.
     */

    public void setThreatIntelIndicatorSourceUrl(java.util.Collection<StringFilter> threatIntelIndicatorSourceUrl) {
        if (threatIntelIndicatorSourceUrl == null) {
            this.threatIntelIndicatorSourceUrl = null;
            return;
        }

        this.threatIntelIndicatorSourceUrl = new java.util.ArrayList<StringFilter>(threatIntelIndicatorSourceUrl);
    }

    /**
     * <p>
     * The URL for more details from the source of the threat intel.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setThreatIntelIndicatorSourceUrl(java.util.Collection)} or
     * {@link #withThreatIntelIndicatorSourceUrl(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param threatIntelIndicatorSourceUrl
     *        The URL for more details from the source of the threat intel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorSourceUrl(StringFilter... threatIntelIndicatorSourceUrl) {
        if (this.threatIntelIndicatorSourceUrl == null) {
            setThreatIntelIndicatorSourceUrl(new java.util.ArrayList<StringFilter>(threatIntelIndicatorSourceUrl.length));
        }
        for (StringFilter ele : threatIntelIndicatorSourceUrl) {
            this.threatIntelIndicatorSourceUrl.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The URL for more details from the source of the threat intel.
     * </p>
     * 
     * @param threatIntelIndicatorSourceUrl
     *        The URL for more details from the source of the threat intel.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withThreatIntelIndicatorSourceUrl(java.util.Collection<StringFilter> threatIntelIndicatorSourceUrl) {
        setThreatIntelIndicatorSourceUrl(threatIntelIndicatorSourceUrl);
        return this;
    }

    /**
     * <p>
     * Specifies the type of the resource that details are provided for.
     * </p>
     * 
     * @return Specifies the type of the resource that details are provided for.
     */

    public java.util.List<StringFilter> getResourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Specifies the type of the resource that details are provided for.
     * </p>
     * 
     * @param resourceType
     *        Specifies the type of the resource that details are provided for.
     */

    public void setResourceType(java.util.Collection<StringFilter> resourceType) {
        if (resourceType == null) {
            this.resourceType = null;
            return;
        }

        this.resourceType = new java.util.ArrayList<StringFilter>(resourceType);
    }

    /**
     * <p>
     * Specifies the type of the resource that details are provided for.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceType(java.util.Collection)} or {@link #withResourceType(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param resourceType
     *        Specifies the type of the resource that details are provided for.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceType(StringFilter... resourceType) {
        if (this.resourceType == null) {
            setResourceType(new java.util.ArrayList<StringFilter>(resourceType.length));
        }
        for (StringFilter ele : resourceType) {
            this.resourceType.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Specifies the type of the resource that details are provided for.
     * </p>
     * 
     * @param resourceType
     *        Specifies the type of the resource that details are provided for.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceType(java.util.Collection<StringFilter> resourceType) {
        setResourceType(resourceType);
        return this;
    }

    /**
     * <p>
     * The canonical identifier for the given resource type.
     * </p>
     * 
     * @return The canonical identifier for the given resource type.
     */

    public java.util.List<StringFilter> getResourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The canonical identifier for the given resource type.
     * </p>
     * 
     * @param resourceId
     *        The canonical identifier for the given resource type.
     */

    public void setResourceId(java.util.Collection<StringFilter> resourceId) {
        if (resourceId == null) {
            this.resourceId = null;
            return;
        }

        this.resourceId = new java.util.ArrayList<StringFilter>(resourceId);
    }

    /**
     * <p>
     * The canonical identifier for the given resource type.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceId(java.util.Collection)} or {@link #withResourceId(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param resourceId
     *        The canonical identifier for the given resource type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceId(StringFilter... resourceId) {
        if (this.resourceId == null) {
            setResourceId(new java.util.ArrayList<StringFilter>(resourceId.length));
        }
        for (StringFilter ele : resourceId) {
            this.resourceId.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The canonical identifier for the given resource type.
     * </p>
     * 
     * @param resourceId
     *        The canonical identifier for the given resource type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceId(java.util.Collection<StringFilter> resourceId) {
        setResourceId(resourceId);
        return this;
    }

    /**
     * <p>
     * The canonical AWS partition name that the Region is assigned to.
     * </p>
     * 
     * @return The canonical AWS partition name that the Region is assigned to.
     */

    public java.util.List<StringFilter> getResourcePartition() {
        return resourcePartition;
    }

    /**
     * <p>
     * The canonical AWS partition name that the Region is assigned to.
     * </p>
     * 
     * @param resourcePartition
     *        The canonical AWS partition name that the Region is assigned to.
     */

    public void setResourcePartition(java.util.Collection<StringFilter> resourcePartition) {
        if (resourcePartition == null) {
            this.resourcePartition = null;
            return;
        }

        this.resourcePartition = new java.util.ArrayList<StringFilter>(resourcePartition);
    }

    /**
     * <p>
     * The canonical AWS partition name that the Region is assigned to.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourcePartition(java.util.Collection)} or {@link #withResourcePartition(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param resourcePartition
     *        The canonical AWS partition name that the Region is assigned to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourcePartition(StringFilter... resourcePartition) {
        if (this.resourcePartition == null) {
            setResourcePartition(new java.util.ArrayList<StringFilter>(resourcePartition.length));
        }
        for (StringFilter ele : resourcePartition) {
            this.resourcePartition.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The canonical AWS partition name that the Region is assigned to.
     * </p>
     * 
     * @param resourcePartition
     *        The canonical AWS partition name that the Region is assigned to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourcePartition(java.util.Collection<StringFilter> resourcePartition) {
        setResourcePartition(resourcePartition);
        return this;
    }

    /**
     * <p>
     * The canonical AWS external Region name where this resource is located.
     * </p>
     * 
     * @return The canonical AWS external Region name where this resource is located.
     */

    public java.util.List<StringFilter> getResourceRegion() {
        return resourceRegion;
    }

    /**
     * <p>
     * The canonical AWS external Region name where this resource is located.
     * </p>
     * 
     * @param resourceRegion
     *        The canonical AWS external Region name where this resource is located.
     */

    public void setResourceRegion(java.util.Collection<StringFilter> resourceRegion) {
        if (resourceRegion == null) {
            this.resourceRegion = null;
            return;
        }

        this.resourceRegion = new java.util.ArrayList<StringFilter>(resourceRegion);
    }

    /**
     * <p>
     * The canonical AWS external Region name where this resource is located.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceRegion(java.util.Collection)} or {@link #withResourceRegion(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param resourceRegion
     *        The canonical AWS external Region name where this resource is located.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceRegion(StringFilter... resourceRegion) {
        if (this.resourceRegion == null) {
            setResourceRegion(new java.util.ArrayList<StringFilter>(resourceRegion.length));
        }
        for (StringFilter ele : resourceRegion) {
            this.resourceRegion.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The canonical AWS external Region name where this resource is located.
     * </p>
     * 
     * @param resourceRegion
     *        The canonical AWS external Region name where this resource is located.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceRegion(java.util.Collection<StringFilter> resourceRegion) {
        setResourceRegion(resourceRegion);
        return this;
    }

    /**
     * <p>
     * A list of AWS tags associated with a resource at the time the finding was processed.
     * </p>
     * 
     * @return A list of AWS tags associated with a resource at the time the finding was processed.
     */

    public java.util.List<MapFilter> getResourceTags() {
        return resourceTags;
    }

    /**
     * <p>
     * A list of AWS tags associated with a resource at the time the finding was processed.
     * </p>
     * 
     * @param resourceTags
     *        A list of AWS tags associated with a resource at the time the finding was processed.
     */

    public void setResourceTags(java.util.Collection<MapFilter> resourceTags) {
        if (resourceTags == null) {
            this.resourceTags = null;
            return;
        }

        this.resourceTags = new java.util.ArrayList<MapFilter>(resourceTags);
    }

    /**
     * <p>
     * A list of AWS tags associated with a resource at the time the finding was processed.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceTags(java.util.Collection)} or {@link #withResourceTags(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param resourceTags
     *        A list of AWS tags associated with a resource at the time the finding was processed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceTags(MapFilter... resourceTags) {
        if (this.resourceTags == null) {
            setResourceTags(new java.util.ArrayList<MapFilter>(resourceTags.length));
        }
        for (MapFilter ele : resourceTags) {
            this.resourceTags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of AWS tags associated with a resource at the time the finding was processed.
     * </p>
     * 
     * @param resourceTags
     *        A list of AWS tags associated with a resource at the time the finding was processed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceTags(java.util.Collection<MapFilter> resourceTags) {
        setResourceTags(resourceTags);
        return this;
    }

    /**
     * <p>
     * The instance type of the instance.
     * </p>
     * 
     * @return The instance type of the instance.
     */

    public java.util.List<StringFilter> getResourceAwsEc2InstanceType() {
        return resourceAwsEc2InstanceType;
    }

    /**
     * <p>
     * The instance type of the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceType
     *        The instance type of the instance.
     */

    public void setResourceAwsEc2InstanceType(java.util.Collection<StringFilter> resourceAwsEc2InstanceType) {
        if (resourceAwsEc2InstanceType == null) {
            this.resourceAwsEc2InstanceType = null;
            return;
        }

        this.resourceAwsEc2InstanceType = new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceType);
    }

    /**
     * <p>
     * The instance type of the instance.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsEc2InstanceType(java.util.Collection)} or
     * {@link #withResourceAwsEc2InstanceType(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsEc2InstanceType
     *        The instance type of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceType(StringFilter... resourceAwsEc2InstanceType) {
        if (this.resourceAwsEc2InstanceType == null) {
            setResourceAwsEc2InstanceType(new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceType.length));
        }
        for (StringFilter ele : resourceAwsEc2InstanceType) {
            this.resourceAwsEc2InstanceType.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The instance type of the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceType
     *        The instance type of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceType(java.util.Collection<StringFilter> resourceAwsEc2InstanceType) {
        setResourceAwsEc2InstanceType(resourceAwsEc2InstanceType);
        return this;
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) ID of the instance.
     * </p>
     * 
     * @return The Amazon Machine Image (AMI) ID of the instance.
     */

    public java.util.List<StringFilter> getResourceAwsEc2InstanceImageId() {
        return resourceAwsEc2InstanceImageId;
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) ID of the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceImageId
     *        The Amazon Machine Image (AMI) ID of the instance.
     */

    public void setResourceAwsEc2InstanceImageId(java.util.Collection<StringFilter> resourceAwsEc2InstanceImageId) {
        if (resourceAwsEc2InstanceImageId == null) {
            this.resourceAwsEc2InstanceImageId = null;
            return;
        }

        this.resourceAwsEc2InstanceImageId = new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceImageId);
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) ID of the instance.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsEc2InstanceImageId(java.util.Collection)} or
     * {@link #withResourceAwsEc2InstanceImageId(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsEc2InstanceImageId
     *        The Amazon Machine Image (AMI) ID of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceImageId(StringFilter... resourceAwsEc2InstanceImageId) {
        if (this.resourceAwsEc2InstanceImageId == null) {
            setResourceAwsEc2InstanceImageId(new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceImageId.length));
        }
        for (StringFilter ele : resourceAwsEc2InstanceImageId) {
            this.resourceAwsEc2InstanceImageId.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Amazon Machine Image (AMI) ID of the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceImageId
     *        The Amazon Machine Image (AMI) ID of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceImageId(java.util.Collection<StringFilter> resourceAwsEc2InstanceImageId) {
        setResourceAwsEc2InstanceImageId(resourceAwsEc2InstanceImageId);
        return this;
    }

    /**
     * <p>
     * The IPv4 addresses associated with the instance.
     * </p>
     * 
     * @return The IPv4 addresses associated with the instance.
     */

    public java.util.List<IpFilter> getResourceAwsEc2InstanceIpV4Addresses() {
        return resourceAwsEc2InstanceIpV4Addresses;
    }

    /**
     * <p>
     * The IPv4 addresses associated with the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceIpV4Addresses
     *        The IPv4 addresses associated with the instance.
     */

    public void setResourceAwsEc2InstanceIpV4Addresses(java.util.Collection<IpFilter> resourceAwsEc2InstanceIpV4Addresses) {
        if (resourceAwsEc2InstanceIpV4Addresses == null) {
            this.resourceAwsEc2InstanceIpV4Addresses = null;
            return;
        }

        this.resourceAwsEc2InstanceIpV4Addresses = new java.util.ArrayList<IpFilter>(resourceAwsEc2InstanceIpV4Addresses);
    }

    /**
     * <p>
     * The IPv4 addresses associated with the instance.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsEc2InstanceIpV4Addresses(java.util.Collection)} or
     * {@link #withResourceAwsEc2InstanceIpV4Addresses(java.util.Collection)} if you want to override the existing
     * values.
     * </p>
     * 
     * @param resourceAwsEc2InstanceIpV4Addresses
     *        The IPv4 addresses associated with the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceIpV4Addresses(IpFilter... resourceAwsEc2InstanceIpV4Addresses) {
        if (this.resourceAwsEc2InstanceIpV4Addresses == null) {
            setResourceAwsEc2InstanceIpV4Addresses(new java.util.ArrayList<IpFilter>(resourceAwsEc2InstanceIpV4Addresses.length));
        }
        for (IpFilter ele : resourceAwsEc2InstanceIpV4Addresses) {
            this.resourceAwsEc2InstanceIpV4Addresses.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The IPv4 addresses associated with the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceIpV4Addresses
     *        The IPv4 addresses associated with the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceIpV4Addresses(java.util.Collection<IpFilter> resourceAwsEc2InstanceIpV4Addresses) {
        setResourceAwsEc2InstanceIpV4Addresses(resourceAwsEc2InstanceIpV4Addresses);
        return this;
    }

    /**
     * <p>
     * The IPv6 addresses associated with the instance.
     * </p>
     * 
     * @return The IPv6 addresses associated with the instance.
     */

    public java.util.List<IpFilter> getResourceAwsEc2InstanceIpV6Addresses() {
        return resourceAwsEc2InstanceIpV6Addresses;
    }

    /**
     * <p>
     * The IPv6 addresses associated with the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceIpV6Addresses
     *        The IPv6 addresses associated with the instance.
     */

    public void setResourceAwsEc2InstanceIpV6Addresses(java.util.Collection<IpFilter> resourceAwsEc2InstanceIpV6Addresses) {
        if (resourceAwsEc2InstanceIpV6Addresses == null) {
            this.resourceAwsEc2InstanceIpV6Addresses = null;
            return;
        }

        this.resourceAwsEc2InstanceIpV6Addresses = new java.util.ArrayList<IpFilter>(resourceAwsEc2InstanceIpV6Addresses);
    }

    /**
     * <p>
     * The IPv6 addresses associated with the instance.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsEc2InstanceIpV6Addresses(java.util.Collection)} or
     * {@link #withResourceAwsEc2InstanceIpV6Addresses(java.util.Collection)} if you want to override the existing
     * values.
     * </p>
     * 
     * @param resourceAwsEc2InstanceIpV6Addresses
     *        The IPv6 addresses associated with the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceIpV6Addresses(IpFilter... resourceAwsEc2InstanceIpV6Addresses) {
        if (this.resourceAwsEc2InstanceIpV6Addresses == null) {
            setResourceAwsEc2InstanceIpV6Addresses(new java.util.ArrayList<IpFilter>(resourceAwsEc2InstanceIpV6Addresses.length));
        }
        for (IpFilter ele : resourceAwsEc2InstanceIpV6Addresses) {
            this.resourceAwsEc2InstanceIpV6Addresses.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The IPv6 addresses associated with the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceIpV6Addresses
     *        The IPv6 addresses associated with the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceIpV6Addresses(java.util.Collection<IpFilter> resourceAwsEc2InstanceIpV6Addresses) {
        setResourceAwsEc2InstanceIpV6Addresses(resourceAwsEc2InstanceIpV6Addresses);
        return this;
    }

    /**
     * <p>
     * The key name associated with the instance.
     * </p>
     * 
     * @return The key name associated with the instance.
     */

    public java.util.List<StringFilter> getResourceAwsEc2InstanceKeyName() {
        return resourceAwsEc2InstanceKeyName;
    }

    /**
     * <p>
     * The key name associated with the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceKeyName
     *        The key name associated with the instance.
     */

    public void setResourceAwsEc2InstanceKeyName(java.util.Collection<StringFilter> resourceAwsEc2InstanceKeyName) {
        if (resourceAwsEc2InstanceKeyName == null) {
            this.resourceAwsEc2InstanceKeyName = null;
            return;
        }

        this.resourceAwsEc2InstanceKeyName = new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceKeyName);
    }

    /**
     * <p>
     * The key name associated with the instance.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsEc2InstanceKeyName(java.util.Collection)} or
     * {@link #withResourceAwsEc2InstanceKeyName(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsEc2InstanceKeyName
     *        The key name associated with the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceKeyName(StringFilter... resourceAwsEc2InstanceKeyName) {
        if (this.resourceAwsEc2InstanceKeyName == null) {
            setResourceAwsEc2InstanceKeyName(new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceKeyName.length));
        }
        for (StringFilter ele : resourceAwsEc2InstanceKeyName) {
            this.resourceAwsEc2InstanceKeyName.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The key name associated with the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceKeyName
     *        The key name associated with the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceKeyName(java.util.Collection<StringFilter> resourceAwsEc2InstanceKeyName) {
        setResourceAwsEc2InstanceKeyName(resourceAwsEc2InstanceKeyName);
        return this;
    }

    /**
     * <p>
     * The IAM profile ARN of the instance.
     * </p>
     * 
     * @return The IAM profile ARN of the instance.
     */

    public java.util.List<StringFilter> getResourceAwsEc2InstanceIamInstanceProfileArn() {
        return resourceAwsEc2InstanceIamInstanceProfileArn;
    }

    /**
     * <p>
     * The IAM profile ARN of the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceIamInstanceProfileArn
     *        The IAM profile ARN of the instance.
     */

    public void setResourceAwsEc2InstanceIamInstanceProfileArn(java.util.Collection<StringFilter> resourceAwsEc2InstanceIamInstanceProfileArn) {
        if (resourceAwsEc2InstanceIamInstanceProfileArn == null) {
            this.resourceAwsEc2InstanceIamInstanceProfileArn = null;
            return;
        }

        this.resourceAwsEc2InstanceIamInstanceProfileArn = new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceIamInstanceProfileArn);
    }

    /**
     * <p>
     * The IAM profile ARN of the instance.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsEc2InstanceIamInstanceProfileArn(java.util.Collection)} or
     * {@link #withResourceAwsEc2InstanceIamInstanceProfileArn(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param resourceAwsEc2InstanceIamInstanceProfileArn
     *        The IAM profile ARN of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceIamInstanceProfileArn(StringFilter... resourceAwsEc2InstanceIamInstanceProfileArn) {
        if (this.resourceAwsEc2InstanceIamInstanceProfileArn == null) {
            setResourceAwsEc2InstanceIamInstanceProfileArn(new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceIamInstanceProfileArn.length));
        }
        for (StringFilter ele : resourceAwsEc2InstanceIamInstanceProfileArn) {
            this.resourceAwsEc2InstanceIamInstanceProfileArn.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The IAM profile ARN of the instance.
     * </p>
     * 
     * @param resourceAwsEc2InstanceIamInstanceProfileArn
     *        The IAM profile ARN of the instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceIamInstanceProfileArn(
            java.util.Collection<StringFilter> resourceAwsEc2InstanceIamInstanceProfileArn) {
        setResourceAwsEc2InstanceIamInstanceProfileArn(resourceAwsEc2InstanceIamInstanceProfileArn);
        return this;
    }

    /**
     * <p>
     * The identifier of the VPC that the instance was launched in.
     * </p>
     * 
     * @return The identifier of the VPC that the instance was launched in.
     */

    public java.util.List<StringFilter> getResourceAwsEc2InstanceVpcId() {
        return resourceAwsEc2InstanceVpcId;
    }

    /**
     * <p>
     * The identifier of the VPC that the instance was launched in.
     * </p>
     * 
     * @param resourceAwsEc2InstanceVpcId
     *        The identifier of the VPC that the instance was launched in.
     */

    public void setResourceAwsEc2InstanceVpcId(java.util.Collection<StringFilter> resourceAwsEc2InstanceVpcId) {
        if (resourceAwsEc2InstanceVpcId == null) {
            this.resourceAwsEc2InstanceVpcId = null;
            return;
        }

        this.resourceAwsEc2InstanceVpcId = new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceVpcId);
    }

    /**
     * <p>
     * The identifier of the VPC that the instance was launched in.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsEc2InstanceVpcId(java.util.Collection)} or
     * {@link #withResourceAwsEc2InstanceVpcId(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsEc2InstanceVpcId
     *        The identifier of the VPC that the instance was launched in.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceVpcId(StringFilter... resourceAwsEc2InstanceVpcId) {
        if (this.resourceAwsEc2InstanceVpcId == null) {
            setResourceAwsEc2InstanceVpcId(new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceVpcId.length));
        }
        for (StringFilter ele : resourceAwsEc2InstanceVpcId) {
            this.resourceAwsEc2InstanceVpcId.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The identifier of the VPC that the instance was launched in.
     * </p>
     * 
     * @param resourceAwsEc2InstanceVpcId
     *        The identifier of the VPC that the instance was launched in.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceVpcId(java.util.Collection<StringFilter> resourceAwsEc2InstanceVpcId) {
        setResourceAwsEc2InstanceVpcId(resourceAwsEc2InstanceVpcId);
        return this;
    }

    /**
     * <p>
     * The identifier of the subnet that the instance was launched in.
     * </p>
     * 
     * @return The identifier of the subnet that the instance was launched in.
     */

    public java.util.List<StringFilter> getResourceAwsEc2InstanceSubnetId() {
        return resourceAwsEc2InstanceSubnetId;
    }

    /**
     * <p>
     * The identifier of the subnet that the instance was launched in.
     * </p>
     * 
     * @param resourceAwsEc2InstanceSubnetId
     *        The identifier of the subnet that the instance was launched in.
     */

    public void setResourceAwsEc2InstanceSubnetId(java.util.Collection<StringFilter> resourceAwsEc2InstanceSubnetId) {
        if (resourceAwsEc2InstanceSubnetId == null) {
            this.resourceAwsEc2InstanceSubnetId = null;
            return;
        }

        this.resourceAwsEc2InstanceSubnetId = new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceSubnetId);
    }

    /**
     * <p>
     * The identifier of the subnet that the instance was launched in.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsEc2InstanceSubnetId(java.util.Collection)} or
     * {@link #withResourceAwsEc2InstanceSubnetId(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsEc2InstanceSubnetId
     *        The identifier of the subnet that the instance was launched in.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceSubnetId(StringFilter... resourceAwsEc2InstanceSubnetId) {
        if (this.resourceAwsEc2InstanceSubnetId == null) {
            setResourceAwsEc2InstanceSubnetId(new java.util.ArrayList<StringFilter>(resourceAwsEc2InstanceSubnetId.length));
        }
        for (StringFilter ele : resourceAwsEc2InstanceSubnetId) {
            this.resourceAwsEc2InstanceSubnetId.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The identifier of the subnet that the instance was launched in.
     * </p>
     * 
     * @param resourceAwsEc2InstanceSubnetId
     *        The identifier of the subnet that the instance was launched in.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceSubnetId(java.util.Collection<StringFilter> resourceAwsEc2InstanceSubnetId) {
        setResourceAwsEc2InstanceSubnetId(resourceAwsEc2InstanceSubnetId);
        return this;
    }

    /**
     * <p>
     * The date/time the instance was launched.
     * </p>
     * 
     * @return The date/time the instance was launched.
     */

    public java.util.List<DateFilter> getResourceAwsEc2InstanceLaunchedAt() {
        return resourceAwsEc2InstanceLaunchedAt;
    }

    /**
     * <p>
     * The date/time the instance was launched.
     * </p>
     * 
     * @param resourceAwsEc2InstanceLaunchedAt
     *        The date/time the instance was launched.
     */

    public void setResourceAwsEc2InstanceLaunchedAt(java.util.Collection<DateFilter> resourceAwsEc2InstanceLaunchedAt) {
        if (resourceAwsEc2InstanceLaunchedAt == null) {
            this.resourceAwsEc2InstanceLaunchedAt = null;
            return;
        }

        this.resourceAwsEc2InstanceLaunchedAt = new java.util.ArrayList<DateFilter>(resourceAwsEc2InstanceLaunchedAt);
    }

    /**
     * <p>
     * The date/time the instance was launched.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsEc2InstanceLaunchedAt(java.util.Collection)} or
     * {@link #withResourceAwsEc2InstanceLaunchedAt(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsEc2InstanceLaunchedAt
     *        The date/time the instance was launched.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceLaunchedAt(DateFilter... resourceAwsEc2InstanceLaunchedAt) {
        if (this.resourceAwsEc2InstanceLaunchedAt == null) {
            setResourceAwsEc2InstanceLaunchedAt(new java.util.ArrayList<DateFilter>(resourceAwsEc2InstanceLaunchedAt.length));
        }
        for (DateFilter ele : resourceAwsEc2InstanceLaunchedAt) {
            this.resourceAwsEc2InstanceLaunchedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The date/time the instance was launched.
     * </p>
     * 
     * @param resourceAwsEc2InstanceLaunchedAt
     *        The date/time the instance was launched.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsEc2InstanceLaunchedAt(java.util.Collection<DateFilter> resourceAwsEc2InstanceLaunchedAt) {
        setResourceAwsEc2InstanceLaunchedAt(resourceAwsEc2InstanceLaunchedAt);
        return this;
    }

    /**
     * <p>
     * The canonical user ID of the owner of the S3 bucket.
     * </p>
     * 
     * @return The canonical user ID of the owner of the S3 bucket.
     */

    public java.util.List<StringFilter> getResourceAwsS3BucketOwnerId() {
        return resourceAwsS3BucketOwnerId;
    }

    /**
     * <p>
     * The canonical user ID of the owner of the S3 bucket.
     * </p>
     * 
     * @param resourceAwsS3BucketOwnerId
     *        The canonical user ID of the owner of the S3 bucket.
     */

    public void setResourceAwsS3BucketOwnerId(java.util.Collection<StringFilter> resourceAwsS3BucketOwnerId) {
        if (resourceAwsS3BucketOwnerId == null) {
            this.resourceAwsS3BucketOwnerId = null;
            return;
        }

        this.resourceAwsS3BucketOwnerId = new java.util.ArrayList<StringFilter>(resourceAwsS3BucketOwnerId);
    }

    /**
     * <p>
     * The canonical user ID of the owner of the S3 bucket.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsS3BucketOwnerId(java.util.Collection)} or
     * {@link #withResourceAwsS3BucketOwnerId(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsS3BucketOwnerId
     *        The canonical user ID of the owner of the S3 bucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsS3BucketOwnerId(StringFilter... resourceAwsS3BucketOwnerId) {
        if (this.resourceAwsS3BucketOwnerId == null) {
            setResourceAwsS3BucketOwnerId(new java.util.ArrayList<StringFilter>(resourceAwsS3BucketOwnerId.length));
        }
        for (StringFilter ele : resourceAwsS3BucketOwnerId) {
            this.resourceAwsS3BucketOwnerId.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The canonical user ID of the owner of the S3 bucket.
     * </p>
     * 
     * @param resourceAwsS3BucketOwnerId
     *        The canonical user ID of the owner of the S3 bucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsS3BucketOwnerId(java.util.Collection<StringFilter> resourceAwsS3BucketOwnerId) {
        setResourceAwsS3BucketOwnerId(resourceAwsS3BucketOwnerId);
        return this;
    }

    /**
     * <p>
     * The display name of the owner of the S3 bucket.
     * </p>
     * 
     * @return The display name of the owner of the S3 bucket.
     */

    public java.util.List<StringFilter> getResourceAwsS3BucketOwnerName() {
        return resourceAwsS3BucketOwnerName;
    }

    /**
     * <p>
     * The display name of the owner of the S3 bucket.
     * </p>
     * 
     * @param resourceAwsS3BucketOwnerName
     *        The display name of the owner of the S3 bucket.
     */

    public void setResourceAwsS3BucketOwnerName(java.util.Collection<StringFilter> resourceAwsS3BucketOwnerName) {
        if (resourceAwsS3BucketOwnerName == null) {
            this.resourceAwsS3BucketOwnerName = null;
            return;
        }

        this.resourceAwsS3BucketOwnerName = new java.util.ArrayList<StringFilter>(resourceAwsS3BucketOwnerName);
    }

    /**
     * <p>
     * The display name of the owner of the S3 bucket.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsS3BucketOwnerName(java.util.Collection)} or
     * {@link #withResourceAwsS3BucketOwnerName(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsS3BucketOwnerName
     *        The display name of the owner of the S3 bucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsS3BucketOwnerName(StringFilter... resourceAwsS3BucketOwnerName) {
        if (this.resourceAwsS3BucketOwnerName == null) {
            setResourceAwsS3BucketOwnerName(new java.util.ArrayList<StringFilter>(resourceAwsS3BucketOwnerName.length));
        }
        for (StringFilter ele : resourceAwsS3BucketOwnerName) {
            this.resourceAwsS3BucketOwnerName.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The display name of the owner of the S3 bucket.
     * </p>
     * 
     * @param resourceAwsS3BucketOwnerName
     *        The display name of the owner of the S3 bucket.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsS3BucketOwnerName(java.util.Collection<StringFilter> resourceAwsS3BucketOwnerName) {
        setResourceAwsS3BucketOwnerName(resourceAwsS3BucketOwnerName);
        return this;
    }

    /**
     * <p>
     * The user associated with the IAM access key related to a finding.
     * </p>
     * 
     * @return The user associated with the IAM access key related to a finding.
     */

    public java.util.List<StringFilter> getResourceAwsIamAccessKeyUserName() {
        return resourceAwsIamAccessKeyUserName;
    }

    /**
     * <p>
     * The user associated with the IAM access key related to a finding.
     * </p>
     * 
     * @param resourceAwsIamAccessKeyUserName
     *        The user associated with the IAM access key related to a finding.
     */

    public void setResourceAwsIamAccessKeyUserName(java.util.Collection<StringFilter> resourceAwsIamAccessKeyUserName) {
        if (resourceAwsIamAccessKeyUserName == null) {
            this.resourceAwsIamAccessKeyUserName = null;
            return;
        }

        this.resourceAwsIamAccessKeyUserName = new java.util.ArrayList<StringFilter>(resourceAwsIamAccessKeyUserName);
    }

    /**
     * <p>
     * The user associated with the IAM access key related to a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsIamAccessKeyUserName(java.util.Collection)} or
     * {@link #withResourceAwsIamAccessKeyUserName(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsIamAccessKeyUserName
     *        The user associated with the IAM access key related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsIamAccessKeyUserName(StringFilter... resourceAwsIamAccessKeyUserName) {
        if (this.resourceAwsIamAccessKeyUserName == null) {
            setResourceAwsIamAccessKeyUserName(new java.util.ArrayList<StringFilter>(resourceAwsIamAccessKeyUserName.length));
        }
        for (StringFilter ele : resourceAwsIamAccessKeyUserName) {
            this.resourceAwsIamAccessKeyUserName.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The user associated with the IAM access key related to a finding.
     * </p>
     * 
     * @param resourceAwsIamAccessKeyUserName
     *        The user associated with the IAM access key related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsIamAccessKeyUserName(java.util.Collection<StringFilter> resourceAwsIamAccessKeyUserName) {
        setResourceAwsIamAccessKeyUserName(resourceAwsIamAccessKeyUserName);
        return this;
    }

    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     * 
     * @return The status of the IAM access key related to a finding.
     */

    public java.util.List<StringFilter> getResourceAwsIamAccessKeyStatus() {
        return resourceAwsIamAccessKeyStatus;
    }

    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     * 
     * @param resourceAwsIamAccessKeyStatus
     *        The status of the IAM access key related to a finding.
     */

    public void setResourceAwsIamAccessKeyStatus(java.util.Collection<StringFilter> resourceAwsIamAccessKeyStatus) {
        if (resourceAwsIamAccessKeyStatus == null) {
            this.resourceAwsIamAccessKeyStatus = null;
            return;
        }

        this.resourceAwsIamAccessKeyStatus = new java.util.ArrayList<StringFilter>(resourceAwsIamAccessKeyStatus);
    }

    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsIamAccessKeyStatus(java.util.Collection)} or
     * {@link #withResourceAwsIamAccessKeyStatus(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsIamAccessKeyStatus
     *        The status of the IAM access key related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsIamAccessKeyStatus(StringFilter... resourceAwsIamAccessKeyStatus) {
        if (this.resourceAwsIamAccessKeyStatus == null) {
            setResourceAwsIamAccessKeyStatus(new java.util.ArrayList<StringFilter>(resourceAwsIamAccessKeyStatus.length));
        }
        for (StringFilter ele : resourceAwsIamAccessKeyStatus) {
            this.resourceAwsIamAccessKeyStatus.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The status of the IAM access key related to a finding.
     * </p>
     * 
     * @param resourceAwsIamAccessKeyStatus
     *        The status of the IAM access key related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsIamAccessKeyStatus(java.util.Collection<StringFilter> resourceAwsIamAccessKeyStatus) {
        setResourceAwsIamAccessKeyStatus(resourceAwsIamAccessKeyStatus);
        return this;
    }

    /**
     * <p>
     * The creation date/time of the IAM access key related to a finding.
     * </p>
     * 
     * @return The creation date/time of the IAM access key related to a finding.
     */

    public java.util.List<DateFilter> getResourceAwsIamAccessKeyCreatedAt() {
        return resourceAwsIamAccessKeyCreatedAt;
    }

    /**
     * <p>
     * The creation date/time of the IAM access key related to a finding.
     * </p>
     * 
     * @param resourceAwsIamAccessKeyCreatedAt
     *        The creation date/time of the IAM access key related to a finding.
     */

    public void setResourceAwsIamAccessKeyCreatedAt(java.util.Collection<DateFilter> resourceAwsIamAccessKeyCreatedAt) {
        if (resourceAwsIamAccessKeyCreatedAt == null) {
            this.resourceAwsIamAccessKeyCreatedAt = null;
            return;
        }

        this.resourceAwsIamAccessKeyCreatedAt = new java.util.ArrayList<DateFilter>(resourceAwsIamAccessKeyCreatedAt);
    }

    /**
     * <p>
     * The creation date/time of the IAM access key related to a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceAwsIamAccessKeyCreatedAt(java.util.Collection)} or
     * {@link #withResourceAwsIamAccessKeyCreatedAt(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceAwsIamAccessKeyCreatedAt
     *        The creation date/time of the IAM access key related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsIamAccessKeyCreatedAt(DateFilter... resourceAwsIamAccessKeyCreatedAt) {
        if (this.resourceAwsIamAccessKeyCreatedAt == null) {
            setResourceAwsIamAccessKeyCreatedAt(new java.util.ArrayList<DateFilter>(resourceAwsIamAccessKeyCreatedAt.length));
        }
        for (DateFilter ele : resourceAwsIamAccessKeyCreatedAt) {
            this.resourceAwsIamAccessKeyCreatedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The creation date/time of the IAM access key related to a finding.
     * </p>
     * 
     * @param resourceAwsIamAccessKeyCreatedAt
     *        The creation date/time of the IAM access key related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceAwsIamAccessKeyCreatedAt(java.util.Collection<DateFilter> resourceAwsIamAccessKeyCreatedAt) {
        setResourceAwsIamAccessKeyCreatedAt(resourceAwsIamAccessKeyCreatedAt);
        return this;
    }

    /**
     * <p>
     * The name of the container related to a finding.
     * </p>
     * 
     * @return The name of the container related to a finding.
     */

    public java.util.List<StringFilter> getResourceContainerName() {
        return resourceContainerName;
    }

    /**
     * <p>
     * The name of the container related to a finding.
     * </p>
     * 
     * @param resourceContainerName
     *        The name of the container related to a finding.
     */

    public void setResourceContainerName(java.util.Collection<StringFilter> resourceContainerName) {
        if (resourceContainerName == null) {
            this.resourceContainerName = null;
            return;
        }

        this.resourceContainerName = new java.util.ArrayList<StringFilter>(resourceContainerName);
    }

    /**
     * <p>
     * The name of the container related to a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceContainerName(java.util.Collection)} or
     * {@link #withResourceContainerName(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceContainerName
     *        The name of the container related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceContainerName(StringFilter... resourceContainerName) {
        if (this.resourceContainerName == null) {
            setResourceContainerName(new java.util.ArrayList<StringFilter>(resourceContainerName.length));
        }
        for (StringFilter ele : resourceContainerName) {
            this.resourceContainerName.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The name of the container related to a finding.
     * </p>
     * 
     * @param resourceContainerName
     *        The name of the container related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceContainerName(java.util.Collection<StringFilter> resourceContainerName) {
        setResourceContainerName(resourceContainerName);
        return this;
    }

    /**
     * <p>
     * The identifier of the image related to a finding.
     * </p>
     * 
     * @return The identifier of the image related to a finding.
     */

    public java.util.List<StringFilter> getResourceContainerImageId() {
        return resourceContainerImageId;
    }

    /**
     * <p>
     * The identifier of the image related to a finding.
     * </p>
     * 
     * @param resourceContainerImageId
     *        The identifier of the image related to a finding.
     */

    public void setResourceContainerImageId(java.util.Collection<StringFilter> resourceContainerImageId) {
        if (resourceContainerImageId == null) {
            this.resourceContainerImageId = null;
            return;
        }

        this.resourceContainerImageId = new java.util.ArrayList<StringFilter>(resourceContainerImageId);
    }

    /**
     * <p>
     * The identifier of the image related to a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceContainerImageId(java.util.Collection)} or
     * {@link #withResourceContainerImageId(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceContainerImageId
     *        The identifier of the image related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceContainerImageId(StringFilter... resourceContainerImageId) {
        if (this.resourceContainerImageId == null) {
            setResourceContainerImageId(new java.util.ArrayList<StringFilter>(resourceContainerImageId.length));
        }
        for (StringFilter ele : resourceContainerImageId) {
            this.resourceContainerImageId.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The identifier of the image related to a finding.
     * </p>
     * 
     * @param resourceContainerImageId
     *        The identifier of the image related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceContainerImageId(java.util.Collection<StringFilter> resourceContainerImageId) {
        setResourceContainerImageId(resourceContainerImageId);
        return this;
    }

    /**
     * <p>
     * The name of the image related to a finding.
     * </p>
     * 
     * @return The name of the image related to a finding.
     */

    public java.util.List<StringFilter> getResourceContainerImageName() {
        return resourceContainerImageName;
    }

    /**
     * <p>
     * The name of the image related to a finding.
     * </p>
     * 
     * @param resourceContainerImageName
     *        The name of the image related to a finding.
     */

    public void setResourceContainerImageName(java.util.Collection<StringFilter> resourceContainerImageName) {
        if (resourceContainerImageName == null) {
            this.resourceContainerImageName = null;
            return;
        }

        this.resourceContainerImageName = new java.util.ArrayList<StringFilter>(resourceContainerImageName);
    }

    /**
     * <p>
     * The name of the image related to a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceContainerImageName(java.util.Collection)} or
     * {@link #withResourceContainerImageName(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceContainerImageName
     *        The name of the image related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceContainerImageName(StringFilter... resourceContainerImageName) {
        if (this.resourceContainerImageName == null) {
            setResourceContainerImageName(new java.util.ArrayList<StringFilter>(resourceContainerImageName.length));
        }
        for (StringFilter ele : resourceContainerImageName) {
            this.resourceContainerImageName.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The name of the image related to a finding.
     * </p>
     * 
     * @param resourceContainerImageName
     *        The name of the image related to a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceContainerImageName(java.util.Collection<StringFilter> resourceContainerImageName) {
        setResourceContainerImageName(resourceContainerImageName);
        return this;
    }

    /**
     * <p>
     * The date/time that the container was started.
     * </p>
     * 
     * @return The date/time that the container was started.
     */

    public java.util.List<DateFilter> getResourceContainerLaunchedAt() {
        return resourceContainerLaunchedAt;
    }

    /**
     * <p>
     * The date/time that the container was started.
     * </p>
     * 
     * @param resourceContainerLaunchedAt
     *        The date/time that the container was started.
     */

    public void setResourceContainerLaunchedAt(java.util.Collection<DateFilter> resourceContainerLaunchedAt) {
        if (resourceContainerLaunchedAt == null) {
            this.resourceContainerLaunchedAt = null;
            return;
        }

        this.resourceContainerLaunchedAt = new java.util.ArrayList<DateFilter>(resourceContainerLaunchedAt);
    }

    /**
     * <p>
     * The date/time that the container was started.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceContainerLaunchedAt(java.util.Collection)} or
     * {@link #withResourceContainerLaunchedAt(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param resourceContainerLaunchedAt
     *        The date/time that the container was started.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceContainerLaunchedAt(DateFilter... resourceContainerLaunchedAt) {
        if (this.resourceContainerLaunchedAt == null) {
            setResourceContainerLaunchedAt(new java.util.ArrayList<DateFilter>(resourceContainerLaunchedAt.length));
        }
        for (DateFilter ele : resourceContainerLaunchedAt) {
            this.resourceContainerLaunchedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The date/time that the container was started.
     * </p>
     * 
     * @param resourceContainerLaunchedAt
     *        The date/time that the container was started.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceContainerLaunchedAt(java.util.Collection<DateFilter> resourceContainerLaunchedAt) {
        setResourceContainerLaunchedAt(resourceContainerLaunchedAt);
        return this;
    }

    /**
     * <p>
     * The details of a resource that doesn't have a specific subfield for the resource type defined.
     * </p>
     * 
     * @return The details of a resource that doesn't have a specific subfield for the resource type defined.
     */

    public java.util.List<MapFilter> getResourceDetailsOther() {
        return resourceDetailsOther;
    }

    /**
     * <p>
     * The details of a resource that doesn't have a specific subfield for the resource type defined.
     * </p>
     * 
     * @param resourceDetailsOther
     *        The details of a resource that doesn't have a specific subfield for the resource type defined.
     */

    public void setResourceDetailsOther(java.util.Collection<MapFilter> resourceDetailsOther) {
        if (resourceDetailsOther == null) {
            this.resourceDetailsOther = null;
            return;
        }

        this.resourceDetailsOther = new java.util.ArrayList<MapFilter>(resourceDetailsOther);
    }

    /**
     * <p>
     * The details of a resource that doesn't have a specific subfield for the resource type defined.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setResourceDetailsOther(java.util.Collection)} or {@link #withResourceDetailsOther(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param resourceDetailsOther
     *        The details of a resource that doesn't have a specific subfield for the resource type defined.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceDetailsOther(MapFilter... resourceDetailsOther) {
        if (this.resourceDetailsOther == null) {
            setResourceDetailsOther(new java.util.ArrayList<MapFilter>(resourceDetailsOther.length));
        }
        for (MapFilter ele : resourceDetailsOther) {
            this.resourceDetailsOther.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The details of a resource that doesn't have a specific subfield for the resource type defined.
     * </p>
     * 
     * @param resourceDetailsOther
     *        The details of a resource that doesn't have a specific subfield for the resource type defined.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withResourceDetailsOther(java.util.Collection<MapFilter> resourceDetailsOther) {
        setResourceDetailsOther(resourceDetailsOther);
        return this;
    }

    /**
     * <p>
     * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported
     * standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     * </p>
     * 
     * @return Exclusive to findings that are generated as the result of a check run against a specific rule in a
     *         supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     */

    public java.util.List<StringFilter> getComplianceStatus() {
        return complianceStatus;
    }

    /**
     * <p>
     * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported
     * standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     * </p>
     * 
     * @param complianceStatus
     *        Exclusive to findings that are generated as the result of a check run against a specific rule in a
     *        supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     */

    public void setComplianceStatus(java.util.Collection<StringFilter> complianceStatus) {
        if (complianceStatus == null) {
            this.complianceStatus = null;
            return;
        }

        this.complianceStatus = new java.util.ArrayList<StringFilter>(complianceStatus);
    }

    /**
     * <p>
     * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported
     * standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setComplianceStatus(java.util.Collection)} or {@link #withComplianceStatus(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param complianceStatus
     *        Exclusive to findings that are generated as the result of a check run against a specific rule in a
     *        supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withComplianceStatus(StringFilter... complianceStatus) {
        if (this.complianceStatus == null) {
            setComplianceStatus(new java.util.ArrayList<StringFilter>(complianceStatus.length));
        }
        for (StringFilter ele : complianceStatus) {
            this.complianceStatus.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Exclusive to findings that are generated as the result of a check run against a specific rule in a supported
     * standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     * </p>
     * 
     * @param complianceStatus
     *        Exclusive to findings that are generated as the result of a check run against a specific rule in a
     *        supported standard (for example, CIS AWS Foundations). Contains compliance-related finding details.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withComplianceStatus(java.util.Collection<StringFilter> complianceStatus) {
        setComplianceStatus(complianceStatus);
        return this;
    }

    /**
     * <p>
     * The veracity of a finding.
     * </p>
     * 
     * @return The veracity of a finding.
     */

    public java.util.List<StringFilter> getVerificationState() {
        return verificationState;
    }

    /**
     * <p>
     * The veracity of a finding.
     * </p>
     * 
     * @param verificationState
     *        The veracity of a finding.
     */

    public void setVerificationState(java.util.Collection<StringFilter> verificationState) {
        if (verificationState == null) {
            this.verificationState = null;
            return;
        }

        this.verificationState = new java.util.ArrayList<StringFilter>(verificationState);
    }

    /**
     * <p>
     * The veracity of a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setVerificationState(java.util.Collection)} or {@link #withVerificationState(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param verificationState
     *        The veracity of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withVerificationState(StringFilter... verificationState) {
        if (this.verificationState == null) {
            setVerificationState(new java.util.ArrayList<StringFilter>(verificationState.length));
        }
        for (StringFilter ele : verificationState) {
            this.verificationState.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The veracity of a finding.
     * </p>
     * 
     * @param verificationState
     *        The veracity of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withVerificationState(java.util.Collection<StringFilter> verificationState) {
        setVerificationState(verificationState);
        return this;
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * 
     * @return The workflow state of a finding.
     */

    public java.util.List<StringFilter> getWorkflowState() {
        return workflowState;
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * 
     * @param workflowState
     *        The workflow state of a finding.
     */

    public void setWorkflowState(java.util.Collection<StringFilter> workflowState) {
        if (workflowState == null) {
            this.workflowState = null;
            return;
        }

        this.workflowState = new java.util.ArrayList<StringFilter>(workflowState);
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setWorkflowState(java.util.Collection)} or {@link #withWorkflowState(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param workflowState
     *        The workflow state of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withWorkflowState(StringFilter... workflowState) {
        if (this.workflowState == null) {
            setWorkflowState(new java.util.ArrayList<StringFilter>(workflowState.length));
        }
        for (StringFilter ele : workflowState) {
            this.workflowState.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The workflow state of a finding.
     * </p>
     * 
     * @param workflowState
     *        The workflow state of a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withWorkflowState(java.util.Collection<StringFilter> workflowState) {
        setWorkflowState(workflowState);
        return this;
    }

    /**
     * <p>
     * The updated record state for the finding.
     * </p>
     * 
     * @return The updated record state for the finding.
     */

    public java.util.List<StringFilter> getRecordState() {
        return recordState;
    }

    /**
     * <p>
     * The updated record state for the finding.
     * </p>
     * 
     * @param recordState
     *        The updated record state for the finding.
     */

    public void setRecordState(java.util.Collection<StringFilter> recordState) {
        if (recordState == null) {
            this.recordState = null;
            return;
        }

        this.recordState = new java.util.ArrayList<StringFilter>(recordState);
    }

    /**
     * <p>
     * The updated record state for the finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRecordState(java.util.Collection)} or {@link #withRecordState(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param recordState
     *        The updated record state for the finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withRecordState(StringFilter... recordState) {
        if (this.recordState == null) {
            setRecordState(new java.util.ArrayList<StringFilter>(recordState.length));
        }
        for (StringFilter ele : recordState) {
            this.recordState.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The updated record state for the finding.
     * </p>
     * 
     * @param recordState
     *        The updated record state for the finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withRecordState(java.util.Collection<StringFilter> recordState) {
        setRecordState(recordState);
        return this;
    }

    /**
     * <p>
     * The ARN of the solution that generated a related finding.
     * </p>
     * 
     * @return The ARN of the solution that generated a related finding.
     */

    public java.util.List<StringFilter> getRelatedFindingsProductArn() {
        return relatedFindingsProductArn;
    }

    /**
     * <p>
     * The ARN of the solution that generated a related finding.
     * </p>
     * 
     * @param relatedFindingsProductArn
     *        The ARN of the solution that generated a related finding.
     */

    public void setRelatedFindingsProductArn(java.util.Collection<StringFilter> relatedFindingsProductArn) {
        if (relatedFindingsProductArn == null) {
            this.relatedFindingsProductArn = null;
            return;
        }

        this.relatedFindingsProductArn = new java.util.ArrayList<StringFilter>(relatedFindingsProductArn);
    }

    /**
     * <p>
     * The ARN of the solution that generated a related finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRelatedFindingsProductArn(java.util.Collection)} or
     * {@link #withRelatedFindingsProductArn(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param relatedFindingsProductArn
     *        The ARN of the solution that generated a related finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withRelatedFindingsProductArn(StringFilter... relatedFindingsProductArn) {
        if (this.relatedFindingsProductArn == null) {
            setRelatedFindingsProductArn(new java.util.ArrayList<StringFilter>(relatedFindingsProductArn.length));
        }
        for (StringFilter ele : relatedFindingsProductArn) {
            this.relatedFindingsProductArn.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The ARN of the solution that generated a related finding.
     * </p>
     * 
     * @param relatedFindingsProductArn
     *        The ARN of the solution that generated a related finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withRelatedFindingsProductArn(java.util.Collection<StringFilter> relatedFindingsProductArn) {
        setRelatedFindingsProductArn(relatedFindingsProductArn);
        return this;
    }

    /**
     * <p>
     * The solution-generated identifier for a related finding.
     * </p>
     * 
     * @return The solution-generated identifier for a related finding.
     */

    public java.util.List<StringFilter> getRelatedFindingsId() {
        return relatedFindingsId;
    }

    /**
     * <p>
     * The solution-generated identifier for a related finding.
     * </p>
     * 
     * @param relatedFindingsId
     *        The solution-generated identifier for a related finding.
     */

    public void setRelatedFindingsId(java.util.Collection<StringFilter> relatedFindingsId) {
        if (relatedFindingsId == null) {
            this.relatedFindingsId = null;
            return;
        }

        this.relatedFindingsId = new java.util.ArrayList<StringFilter>(relatedFindingsId);
    }

    /**
     * <p>
     * The solution-generated identifier for a related finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRelatedFindingsId(java.util.Collection)} or {@link #withRelatedFindingsId(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param relatedFindingsId
     *        The solution-generated identifier for a related finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withRelatedFindingsId(StringFilter... relatedFindingsId) {
        if (this.relatedFindingsId == null) {
            setRelatedFindingsId(new java.util.ArrayList<StringFilter>(relatedFindingsId.length));
        }
        for (StringFilter ele : relatedFindingsId) {
            this.relatedFindingsId.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The solution-generated identifier for a related finding.
     * </p>
     * 
     * @param relatedFindingsId
     *        The solution-generated identifier for a related finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withRelatedFindingsId(java.util.Collection<StringFilter> relatedFindingsId) {
        setRelatedFindingsId(relatedFindingsId);
        return this;
    }

    /**
     * <p>
     * The text of a note.
     * </p>
     * 
     * @return The text of a note.
     */

    public java.util.List<StringFilter> getNoteText() {
        return noteText;
    }

    /**
     * <p>
     * The text of a note.
     * </p>
     * 
     * @param noteText
     *        The text of a note.
     */

    public void setNoteText(java.util.Collection<StringFilter> noteText) {
        if (noteText == null) {
            this.noteText = null;
            return;
        }

        this.noteText = new java.util.ArrayList<StringFilter>(noteText);
    }

    /**
     * <p>
     * The text of a note.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNoteText(java.util.Collection)} or {@link #withNoteText(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param noteText
     *        The text of a note.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNoteText(StringFilter... noteText) {
        if (this.noteText == null) {
            setNoteText(new java.util.ArrayList<StringFilter>(noteText.length));
        }
        for (StringFilter ele : noteText) {
            this.noteText.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The text of a note.
     * </p>
     * 
     * @param noteText
     *        The text of a note.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNoteText(java.util.Collection<StringFilter> noteText) {
        setNoteText(noteText);
        return this;
    }

    /**
     * <p>
     * The timestamp of when the note was updated.
     * </p>
     * 
     * @return The timestamp of when the note was updated.
     */

    public java.util.List<DateFilter> getNoteUpdatedAt() {
        return noteUpdatedAt;
    }

    /**
     * <p>
     * The timestamp of when the note was updated.
     * </p>
     * 
     * @param noteUpdatedAt
     *        The timestamp of when the note was updated.
     */

    public void setNoteUpdatedAt(java.util.Collection<DateFilter> noteUpdatedAt) {
        if (noteUpdatedAt == null) {
            this.noteUpdatedAt = null;
            return;
        }

        this.noteUpdatedAt = new java.util.ArrayList<DateFilter>(noteUpdatedAt);
    }

    /**
     * <p>
     * The timestamp of when the note was updated.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNoteUpdatedAt(java.util.Collection)} or {@link #withNoteUpdatedAt(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param noteUpdatedAt
     *        The timestamp of when the note was updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNoteUpdatedAt(DateFilter... noteUpdatedAt) {
        if (this.noteUpdatedAt == null) {
            setNoteUpdatedAt(new java.util.ArrayList<DateFilter>(noteUpdatedAt.length));
        }
        for (DateFilter ele : noteUpdatedAt) {
            this.noteUpdatedAt.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The timestamp of when the note was updated.
     * </p>
     * 
     * @param noteUpdatedAt
     *        The timestamp of when the note was updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNoteUpdatedAt(java.util.Collection<DateFilter> noteUpdatedAt) {
        setNoteUpdatedAt(noteUpdatedAt);
        return this;
    }

    /**
     * <p>
     * The principal that created a note.
     * </p>
     * 
     * @return The principal that created a note.
     */

    public java.util.List<StringFilter> getNoteUpdatedBy() {
        return noteUpdatedBy;
    }

    /**
     * <p>
     * The principal that created a note.
     * </p>
     * 
     * @param noteUpdatedBy
     *        The principal that created a note.
     */

    public void setNoteUpdatedBy(java.util.Collection<StringFilter> noteUpdatedBy) {
        if (noteUpdatedBy == null) {
            this.noteUpdatedBy = null;
            return;
        }

        this.noteUpdatedBy = new java.util.ArrayList<StringFilter>(noteUpdatedBy);
    }

    /**
     * <p>
     * The principal that created a note.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNoteUpdatedBy(java.util.Collection)} or {@link #withNoteUpdatedBy(java.util.Collection)} if you want
     * to override the existing values.
     * </p>
     * 
     * @param noteUpdatedBy
     *        The principal that created a note.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNoteUpdatedBy(StringFilter... noteUpdatedBy) {
        if (this.noteUpdatedBy == null) {
            setNoteUpdatedBy(new java.util.ArrayList<StringFilter>(noteUpdatedBy.length));
        }
        for (StringFilter ele : noteUpdatedBy) {
            this.noteUpdatedBy.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The principal that created a note.
     * </p>
     * 
     * @param noteUpdatedBy
     *        The principal that created a note.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withNoteUpdatedBy(java.util.Collection<StringFilter> noteUpdatedBy) {
        setNoteUpdatedBy(noteUpdatedBy);
        return this;
    }

    /**
     * <p>
     * A keyword for a finding.
     * </p>
     * 
     * @return A keyword for a finding.
     */

    public java.util.List<KeywordFilter> getKeyword() {
        return keyword;
    }

    /**
     * <p>
     * A keyword for a finding.
     * </p>
     * 
     * @param keyword
     *        A keyword for a finding.
     */

    public void setKeyword(java.util.Collection<KeywordFilter> keyword) {
        if (keyword == null) {
            this.keyword = null;
            return;
        }

        this.keyword = new java.util.ArrayList<KeywordFilter>(keyword);
    }

    /**
     * <p>
     * A keyword for a finding.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setKeyword(java.util.Collection)} or {@link #withKeyword(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param keyword
     *        A keyword for a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withKeyword(KeywordFilter... keyword) {
        if (this.keyword == null) {
            setKeyword(new java.util.ArrayList<KeywordFilter>(keyword.length));
        }
        for (KeywordFilter ele : keyword) {
            this.keyword.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A keyword for a finding.
     * </p>
     * 
     * @param keyword
     *        A keyword for a finding.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsSecurityFindingFilters withKeyword(java.util.Collection<KeywordFilter> keyword) {
        setKeyword(keyword);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getProductArn() != null)
            sb.append("ProductArn: ").append(getProductArn()).append(",");
        if (getAwsAccountId() != null)
            sb.append("AwsAccountId: ").append(getAwsAccountId()).append(",");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getGeneratorId() != null)
            sb.append("GeneratorId: ").append(getGeneratorId()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getFirstObservedAt() != null)
            sb.append("FirstObservedAt: ").append(getFirstObservedAt()).append(",");
        if (getLastObservedAt() != null)
            sb.append("LastObservedAt: ").append(getLastObservedAt()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getUpdatedAt() != null)
            sb.append("UpdatedAt: ").append(getUpdatedAt()).append(",");
        if (getSeverityProduct() != null)
            sb.append("SeverityProduct: ").append(getSeverityProduct()).append(",");
        if (getSeverityNormalized() != null)
            sb.append("SeverityNormalized: ").append(getSeverityNormalized()).append(",");
        if (getSeverityLabel() != null)
            sb.append("SeverityLabel: ").append(getSeverityLabel()).append(",");
        if (getConfidence() != null)
            sb.append("Confidence: ").append(getConfidence()).append(",");
        if (getCriticality() != null)
            sb.append("Criticality: ").append(getCriticality()).append(",");
        if (getTitle() != null)
            sb.append("Title: ").append(getTitle()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getRecommendationText() != null)
            sb.append("RecommendationText: ").append(getRecommendationText()).append(",");
        if (getSourceUrl() != null)
            sb.append("SourceUrl: ").append(getSourceUrl()).append(",");
        if (getProductFields() != null)
            sb.append("ProductFields: ").append(getProductFields()).append(",");
        if (getProductName() != null)
            sb.append("ProductName: ").append(getProductName()).append(",");
        if (getCompanyName() != null)
            sb.append("CompanyName: ").append(getCompanyName()).append(",");
        if (getUserDefinedFields() != null)
            sb.append("UserDefinedFields: ").append(getUserDefinedFields()).append(",");
        if (getMalwareName() != null)
            sb.append("MalwareName: ").append(getMalwareName()).append(",");
        if (getMalwareType() != null)
            sb.append("MalwareType: ").append(getMalwareType()).append(",");
        if (getMalwarePath() != null)
            sb.append("MalwarePath: ").append(getMalwarePath()).append(",");
        if (getMalwareState() != null)
            sb.append("MalwareState: ").append(getMalwareState()).append(",");
        if (getNetworkDirection() != null)
            sb.append("NetworkDirection: ").append(getNetworkDirection()).append(",");
        if (getNetworkProtocol() != null)
            sb.append("NetworkProtocol: ").append(getNetworkProtocol()).append(",");
        if (getNetworkSourceIpV4() != null)
            sb.append("NetworkSourceIpV4: ").append(getNetworkSourceIpV4()).append(",");
        if (getNetworkSourceIpV6() != null)
            sb.append("NetworkSourceIpV6: ").append(getNetworkSourceIpV6()).append(",");
        if (getNetworkSourcePort() != null)
            sb.append("NetworkSourcePort: ").append(getNetworkSourcePort()).append(",");
        if (getNetworkSourceDomain() != null)
            sb.append("NetworkSourceDomain: ").append(getNetworkSourceDomain()).append(",");
        if (getNetworkSourceMac() != null)
            sb.append("NetworkSourceMac: ").append(getNetworkSourceMac()).append(",");
        if (getNetworkDestinationIpV4() != null)
            sb.append("NetworkDestinationIpV4: ").append(getNetworkDestinationIpV4()).append(",");
        if (getNetworkDestinationIpV6() != null)
            sb.append("NetworkDestinationIpV6: ").append(getNetworkDestinationIpV6()).append(",");
        if (getNetworkDestinationPort() != null)
            sb.append("NetworkDestinationPort: ").append(getNetworkDestinationPort()).append(",");
        if (getNetworkDestinationDomain() != null)
            sb.append("NetworkDestinationDomain: ").append(getNetworkDestinationDomain()).append(",");
        if (getProcessName() != null)
            sb.append("ProcessName: ").append(getProcessName()).append(",");
        if (getProcessPath() != null)
            sb.append("ProcessPath: ").append(getProcessPath()).append(",");
        if (getProcessPid() != null)
            sb.append("ProcessPid: ").append(getProcessPid()).append(",");
        if (getProcessParentPid() != null)
            sb.append("ProcessParentPid: ").append(getProcessParentPid()).append(",");
        if (getProcessLaunchedAt() != null)
            sb.append("ProcessLaunchedAt: ").append(getProcessLaunchedAt()).append(",");
        if (getProcessTerminatedAt() != null)
            sb.append("ProcessTerminatedAt: ").append(getProcessTerminatedAt()).append(",");
        if (getThreatIntelIndicatorType() != null)
            sb.append("ThreatIntelIndicatorType: ").append(getThreatIntelIndicatorType()).append(",");
        if (getThreatIntelIndicatorValue() != null)
            sb.append("ThreatIntelIndicatorValue: ").append(getThreatIntelIndicatorValue()).append(",");
        if (getThreatIntelIndicatorCategory() != null)
            sb.append("ThreatIntelIndicatorCategory: ").append(getThreatIntelIndicatorCategory()).append(",");
        if (getThreatIntelIndicatorLastObservedAt() != null)
            sb.append("ThreatIntelIndicatorLastObservedAt: ").append(getThreatIntelIndicatorLastObservedAt()).append(",");
        if (getThreatIntelIndicatorSource() != null)
            sb.append("ThreatIntelIndicatorSource: ").append(getThreatIntelIndicatorSource()).append(",");
        if (getThreatIntelIndicatorSourceUrl() != null)
            sb.append("ThreatIntelIndicatorSourceUrl: ").append(getThreatIntelIndicatorSourceUrl()).append(",");
        if (getResourceType() != null)
            sb.append("ResourceType: ").append(getResourceType()).append(",");
        if (getResourceId() != null)
            sb.append("ResourceId: ").append(getResourceId()).append(",");
        if (getResourcePartition() != null)
            sb.append("ResourcePartition: ").append(getResourcePartition()).append(",");
        if (getResourceRegion() != null)
            sb.append("ResourceRegion: ").append(getResourceRegion()).append(",");
        if (getResourceTags() != null)
            sb.append("ResourceTags: ").append(getResourceTags()).append(",");
        if (getResourceAwsEc2InstanceType() != null)
            sb.append("ResourceAwsEc2InstanceType: ").append(getResourceAwsEc2InstanceType()).append(",");
        if (getResourceAwsEc2InstanceImageId() != null)
            sb.append("ResourceAwsEc2InstanceImageId: ").append(getResourceAwsEc2InstanceImageId()).append(",");
        if (getResourceAwsEc2InstanceIpV4Addresses() != null)
            sb.append("ResourceAwsEc2InstanceIpV4Addresses: ").append(getResourceAwsEc2InstanceIpV4Addresses()).append(",");
        if (getResourceAwsEc2InstanceIpV6Addresses() != null)
            sb.append("ResourceAwsEc2InstanceIpV6Addresses: ").append(getResourceAwsEc2InstanceIpV6Addresses()).append(",");
        if (getResourceAwsEc2InstanceKeyName() != null)
            sb.append("ResourceAwsEc2InstanceKeyName: ").append(getResourceAwsEc2InstanceKeyName()).append(",");
        if (getResourceAwsEc2InstanceIamInstanceProfileArn() != null)
            sb.append("ResourceAwsEc2InstanceIamInstanceProfileArn: ").append(getResourceAwsEc2InstanceIamInstanceProfileArn()).append(",");
        if (getResourceAwsEc2InstanceVpcId() != null)
            sb.append("ResourceAwsEc2InstanceVpcId: ").append(getResourceAwsEc2InstanceVpcId()).append(",");
        if (getResourceAwsEc2InstanceSubnetId() != null)
            sb.append("ResourceAwsEc2InstanceSubnetId: ").append(getResourceAwsEc2InstanceSubnetId()).append(",");
        if (getResourceAwsEc2InstanceLaunchedAt() != null)
            sb.append("ResourceAwsEc2InstanceLaunchedAt: ").append(getResourceAwsEc2InstanceLaunchedAt()).append(",");
        if (getResourceAwsS3BucketOwnerId() != null)
            sb.append("ResourceAwsS3BucketOwnerId: ").append(getResourceAwsS3BucketOwnerId()).append(",");
        if (getResourceAwsS3BucketOwnerName() != null)
            sb.append("ResourceAwsS3BucketOwnerName: ").append(getResourceAwsS3BucketOwnerName()).append(",");
        if (getResourceAwsIamAccessKeyUserName() != null)
            sb.append("ResourceAwsIamAccessKeyUserName: ").append(getResourceAwsIamAccessKeyUserName()).append(",");
        if (getResourceAwsIamAccessKeyStatus() != null)
            sb.append("ResourceAwsIamAccessKeyStatus: ").append(getResourceAwsIamAccessKeyStatus()).append(",");
        if (getResourceAwsIamAccessKeyCreatedAt() != null)
            sb.append("ResourceAwsIamAccessKeyCreatedAt: ").append(getResourceAwsIamAccessKeyCreatedAt()).append(",");
        if (getResourceContainerName() != null)
            sb.append("ResourceContainerName: ").append(getResourceContainerName()).append(",");
        if (getResourceContainerImageId() != null)
            sb.append("ResourceContainerImageId: ").append(getResourceContainerImageId()).append(",");
        if (getResourceContainerImageName() != null)
            sb.append("ResourceContainerImageName: ").append(getResourceContainerImageName()).append(",");
        if (getResourceContainerLaunchedAt() != null)
            sb.append("ResourceContainerLaunchedAt: ").append(getResourceContainerLaunchedAt()).append(",");
        if (getResourceDetailsOther() != null)
            sb.append("ResourceDetailsOther: ").append(getResourceDetailsOther()).append(",");
        if (getComplianceStatus() != null)
            sb.append("ComplianceStatus: ").append(getComplianceStatus()).append(",");
        if (getVerificationState() != null)
            sb.append("VerificationState: ").append(getVerificationState()).append(",");
        if (getWorkflowState() != null)
            sb.append("WorkflowState: ").append(getWorkflowState()).append(",");
        if (getRecordState() != null)
            sb.append("RecordState: ").append(getRecordState()).append(",");
        if (getRelatedFindingsProductArn() != null)
            sb.append("RelatedFindingsProductArn: ").append(getRelatedFindingsProductArn()).append(",");
        if (getRelatedFindingsId() != null)
            sb.append("RelatedFindingsId: ").append(getRelatedFindingsId()).append(",");
        if (getNoteText() != null)
            sb.append("NoteText: ").append(getNoteText()).append(",");
        if (getNoteUpdatedAt() != null)
            sb.append("NoteUpdatedAt: ").append(getNoteUpdatedAt()).append(",");
        if (getNoteUpdatedBy() != null)
            sb.append("NoteUpdatedBy: ").append(getNoteUpdatedBy()).append(",");
        if (getKeyword() != null)
            sb.append("Keyword: ").append(getKeyword());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsSecurityFindingFilters == false)
            return false;
        AwsSecurityFindingFilters other = (AwsSecurityFindingFilters) obj;
        if (other.getProductArn() == null ^ this.getProductArn() == null)
            return false;
        if (other.getProductArn() != null && other.getProductArn().equals(this.getProductArn()) == false)
            return false;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null)
            return false;
        if (other.getAwsAccountId() != null && other.getAwsAccountId().equals(this.getAwsAccountId()) == false)
            return false;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getGeneratorId() == null ^ this.getGeneratorId() == null)
            return false;
        if (other.getGeneratorId() != null && other.getGeneratorId().equals(this.getGeneratorId()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getFirstObservedAt() == null ^ this.getFirstObservedAt() == null)
            return false;
        if (other.getFirstObservedAt() != null && other.getFirstObservedAt().equals(this.getFirstObservedAt()) == false)
            return false;
        if (other.getLastObservedAt() == null ^ this.getLastObservedAt() == null)
            return false;
        if (other.getLastObservedAt() != null && other.getLastObservedAt().equals(this.getLastObservedAt()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getUpdatedAt() == null ^ this.getUpdatedAt() == null)
            return false;
        if (other.getUpdatedAt() != null && other.getUpdatedAt().equals(this.getUpdatedAt()) == false)
            return false;
        if (other.getSeverityProduct() == null ^ this.getSeverityProduct() == null)
            return false;
        if (other.getSeverityProduct() != null && other.getSeverityProduct().equals(this.getSeverityProduct()) == false)
            return false;
        if (other.getSeverityNormalized() == null ^ this.getSeverityNormalized() == null)
            return false;
        if (other.getSeverityNormalized() != null && other.getSeverityNormalized().equals(this.getSeverityNormalized()) == false)
            return false;
        if (other.getSeverityLabel() == null ^ this.getSeverityLabel() == null)
            return false;
        if (other.getSeverityLabel() != null && other.getSeverityLabel().equals(this.getSeverityLabel()) == false)
            return false;
        if (other.getConfidence() == null ^ this.getConfidence() == null)
            return false;
        if (other.getConfidence() != null && other.getConfidence().equals(this.getConfidence()) == false)
            return false;
        if (other.getCriticality() == null ^ this.getCriticality() == null)
            return false;
        if (other.getCriticality() != null && other.getCriticality().equals(this.getCriticality()) == false)
            return false;
        if (other.getTitle() == null ^ this.getTitle() == null)
            return false;
        if (other.getTitle() != null && other.getTitle().equals(this.getTitle()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getRecommendationText() == null ^ this.getRecommendationText() == null)
            return false;
        if (other.getRecommendationText() != null && other.getRecommendationText().equals(this.getRecommendationText()) == false)
            return false;
        if (other.getSourceUrl() == null ^ this.getSourceUrl() == null)
            return false;
        if (other.getSourceUrl() != null && other.getSourceUrl().equals(this.getSourceUrl()) == false)
            return false;
        if (other.getProductFields() == null ^ this.getProductFields() == null)
            return false;
        if (other.getProductFields() != null && other.getProductFields().equals(this.getProductFields()) == false)
            return false;
        if (other.getProductName() == null ^ this.getProductName() == null)
            return false;
        if (other.getProductName() != null && other.getProductName().equals(this.getProductName()) == false)
            return false;
        if (other.getCompanyName() == null ^ this.getCompanyName() == null)
            return false;
        if (other.getCompanyName() != null && other.getCompanyName().equals(this.getCompanyName()) == false)
            return false;
        if (other.getUserDefinedFields() == null ^ this.getUserDefinedFields() == null)
            return false;
        if (other.getUserDefinedFields() != null && other.getUserDefinedFields().equals(this.getUserDefinedFields()) == false)
            return false;
        if (other.getMalwareName() == null ^ this.getMalwareName() == null)
            return false;
        if (other.getMalwareName() != null && other.getMalwareName().equals(this.getMalwareName()) == false)
            return false;
        if (other.getMalwareType() == null ^ this.getMalwareType() == null)
            return false;
        if (other.getMalwareType() != null && other.getMalwareType().equals(this.getMalwareType()) == false)
            return false;
        if (other.getMalwarePath() == null ^ this.getMalwarePath() == null)
            return false;
        if (other.getMalwarePath() != null && other.getMalwarePath().equals(this.getMalwarePath()) == false)
            return false;
        if (other.getMalwareState() == null ^ this.getMalwareState() == null)
            return false;
        if (other.getMalwareState() != null && other.getMalwareState().equals(this.getMalwareState()) == false)
            return false;
        if (other.getNetworkDirection() == null ^ this.getNetworkDirection() == null)
            return false;
        if (other.getNetworkDirection() != null && other.getNetworkDirection().equals(this.getNetworkDirection()) == false)
            return false;
        if (other.getNetworkProtocol() == null ^ this.getNetworkProtocol() == null)
            return false;
        if (other.getNetworkProtocol() != null && other.getNetworkProtocol().equals(this.getNetworkProtocol()) == false)
            return false;
        if (other.getNetworkSourceIpV4() == null ^ this.getNetworkSourceIpV4() == null)
            return false;
        if (other.getNetworkSourceIpV4() != null && other.getNetworkSourceIpV4().equals(this.getNetworkSourceIpV4()) == false)
            return false;
        if (other.getNetworkSourceIpV6() == null ^ this.getNetworkSourceIpV6() == null)
            return false;
        if (other.getNetworkSourceIpV6() != null && other.getNetworkSourceIpV6().equals(this.getNetworkSourceIpV6()) == false)
            return false;
        if (other.getNetworkSourcePort() == null ^ this.getNetworkSourcePort() == null)
            return false;
        if (other.getNetworkSourcePort() != null && other.getNetworkSourcePort().equals(this.getNetworkSourcePort()) == false)
            return false;
        if (other.getNetworkSourceDomain() == null ^ this.getNetworkSourceDomain() == null)
            return false;
        if (other.getNetworkSourceDomain() != null && other.getNetworkSourceDomain().equals(this.getNetworkSourceDomain()) == false)
            return false;
        if (other.getNetworkSourceMac() == null ^ this.getNetworkSourceMac() == null)
            return false;
        if (other.getNetworkSourceMac() != null && other.getNetworkSourceMac().equals(this.getNetworkSourceMac()) == false)
            return false;
        if (other.getNetworkDestinationIpV4() == null ^ this.getNetworkDestinationIpV4() == null)
            return false;
        if (other.getNetworkDestinationIpV4() != null && other.getNetworkDestinationIpV4().equals(this.getNetworkDestinationIpV4()) == false)
            return false;
        if (other.getNetworkDestinationIpV6() == null ^ this.getNetworkDestinationIpV6() == null)
            return false;
        if (other.getNetworkDestinationIpV6() != null && other.getNetworkDestinationIpV6().equals(this.getNetworkDestinationIpV6()) == false)
            return false;
        if (other.getNetworkDestinationPort() == null ^ this.getNetworkDestinationPort() == null)
            return false;
        if (other.getNetworkDestinationPort() != null && other.getNetworkDestinationPort().equals(this.getNetworkDestinationPort()) == false)
            return false;
        if (other.getNetworkDestinationDomain() == null ^ this.getNetworkDestinationDomain() == null)
            return false;
        if (other.getNetworkDestinationDomain() != null && other.getNetworkDestinationDomain().equals(this.getNetworkDestinationDomain()) == false)
            return false;
        if (other.getProcessName() == null ^ this.getProcessName() == null)
            return false;
        if (other.getProcessName() != null && other.getProcessName().equals(this.getProcessName()) == false)
            return false;
        if (other.getProcessPath() == null ^ this.getProcessPath() == null)
            return false;
        if (other.getProcessPath() != null && other.getProcessPath().equals(this.getProcessPath()) == false)
            return false;
        if (other.getProcessPid() == null ^ this.getProcessPid() == null)
            return false;
        if (other.getProcessPid() != null && other.getProcessPid().equals(this.getProcessPid()) == false)
            return false;
        if (other.getProcessParentPid() == null ^ this.getProcessParentPid() == null)
            return false;
        if (other.getProcessParentPid() != null && other.getProcessParentPid().equals(this.getProcessParentPid()) == false)
            return false;
        if (other.getProcessLaunchedAt() == null ^ this.getProcessLaunchedAt() == null)
            return false;
        if (other.getProcessLaunchedAt() != null && other.getProcessLaunchedAt().equals(this.getProcessLaunchedAt()) == false)
            return false;
        if (other.getProcessTerminatedAt() == null ^ this.getProcessTerminatedAt() == null)
            return false;
        if (other.getProcessTerminatedAt() != null && other.getProcessTerminatedAt().equals(this.getProcessTerminatedAt()) == false)
            return false;
        if (other.getThreatIntelIndicatorType() == null ^ this.getThreatIntelIndicatorType() == null)
            return false;
        if (other.getThreatIntelIndicatorType() != null && other.getThreatIntelIndicatorType().equals(this.getThreatIntelIndicatorType()) == false)
            return false;
        if (other.getThreatIntelIndicatorValue() == null ^ this.getThreatIntelIndicatorValue() == null)
            return false;
        if (other.getThreatIntelIndicatorValue() != null && other.getThreatIntelIndicatorValue().equals(this.getThreatIntelIndicatorValue()) == false)
            return false;
        if (other.getThreatIntelIndicatorCategory() == null ^ this.getThreatIntelIndicatorCategory() == null)
            return false;
        if (other.getThreatIntelIndicatorCategory() != null && other.getThreatIntelIndicatorCategory().equals(this.getThreatIntelIndicatorCategory()) == false)
            return false;
        if (other.getThreatIntelIndicatorLastObservedAt() == null ^ this.getThreatIntelIndicatorLastObservedAt() == null)
            return false;
        if (other.getThreatIntelIndicatorLastObservedAt() != null
                && other.getThreatIntelIndicatorLastObservedAt().equals(this.getThreatIntelIndicatorLastObservedAt()) == false)
            return false;
        if (other.getThreatIntelIndicatorSource() == null ^ this.getThreatIntelIndicatorSource() == null)
            return false;
        if (other.getThreatIntelIndicatorSource() != null && other.getThreatIntelIndicatorSource().equals(this.getThreatIntelIndicatorSource()) == false)
            return false;
        if (other.getThreatIntelIndicatorSourceUrl() == null ^ this.getThreatIntelIndicatorSourceUrl() == null)
            return false;
        if (other.getThreatIntelIndicatorSourceUrl() != null
                && other.getThreatIntelIndicatorSourceUrl().equals(this.getThreatIntelIndicatorSourceUrl()) == false)
            return false;
        if (other.getResourceType() == null ^ this.getResourceType() == null)
            return false;
        if (other.getResourceType() != null && other.getResourceType().equals(this.getResourceType()) == false)
            return false;
        if (other.getResourceId() == null ^ this.getResourceId() == null)
            return false;
        if (other.getResourceId() != null && other.getResourceId().equals(this.getResourceId()) == false)
            return false;
        if (other.getResourcePartition() == null ^ this.getResourcePartition() == null)
            return false;
        if (other.getResourcePartition() != null && other.getResourcePartition().equals(this.getResourcePartition()) == false)
            return false;
        if (other.getResourceRegion() == null ^ this.getResourceRegion() == null)
            return false;
        if (other.getResourceRegion() != null && other.getResourceRegion().equals(this.getResourceRegion()) == false)
            return false;
        if (other.getResourceTags() == null ^ this.getResourceTags() == null)
            return false;
        if (other.getResourceTags() != null && other.getResourceTags().equals(this.getResourceTags()) == false)
            return false;
        if (other.getResourceAwsEc2InstanceType() == null ^ this.getResourceAwsEc2InstanceType() == null)
            return false;
        if (other.getResourceAwsEc2InstanceType() != null && other.getResourceAwsEc2InstanceType().equals(this.getResourceAwsEc2InstanceType()) == false)
            return false;
        if (other.getResourceAwsEc2InstanceImageId() == null ^ this.getResourceAwsEc2InstanceImageId() == null)
            return false;
        if (other.getResourceAwsEc2InstanceImageId() != null
                && other.getResourceAwsEc2InstanceImageId().equals(this.getResourceAwsEc2InstanceImageId()) == false)
            return false;
        if (other.getResourceAwsEc2InstanceIpV4Addresses() == null ^ this.getResourceAwsEc2InstanceIpV4Addresses() == null)
            return false;
        if (other.getResourceAwsEc2InstanceIpV4Addresses() != null
                && other.getResourceAwsEc2InstanceIpV4Addresses().equals(this.getResourceAwsEc2InstanceIpV4Addresses()) == false)
            return false;
        if (other.getResourceAwsEc2InstanceIpV6Addresses() == null ^ this.getResourceAwsEc2InstanceIpV6Addresses() == null)
            return false;
        if (other.getResourceAwsEc2InstanceIpV6Addresses() != null
                && other.getResourceAwsEc2InstanceIpV6Addresses().equals(this.getResourceAwsEc2InstanceIpV6Addresses()) == false)
            return false;
        if (other.getResourceAwsEc2InstanceKeyName() == null ^ this.getResourceAwsEc2InstanceKeyName() == null)
            return false;
        if (other.getResourceAwsEc2InstanceKeyName() != null
                && other.getResourceAwsEc2InstanceKeyName().equals(this.getResourceAwsEc2InstanceKeyName()) == false)
            return false;
        if (other.getResourceAwsEc2InstanceIamInstanceProfileArn() == null ^ this.getResourceAwsEc2InstanceIamInstanceProfileArn() == null)
            return false;
        if (other.getResourceAwsEc2InstanceIamInstanceProfileArn() != null
                && other.getResourceAwsEc2InstanceIamInstanceProfileArn().equals(this.getResourceAwsEc2InstanceIamInstanceProfileArn()) == false)
            return false;
        if (other.getResourceAwsEc2InstanceVpcId() == null ^ this.getResourceAwsEc2InstanceVpcId() == null)
            return false;
        if (other.getResourceAwsEc2InstanceVpcId() != null && other.getResourceAwsEc2InstanceVpcId().equals(this.getResourceAwsEc2InstanceVpcId()) == false)
            return false;
        if (other.getResourceAwsEc2InstanceSubnetId() == null ^ this.getResourceAwsEc2InstanceSubnetId() == null)
            return false;
        if (other.getResourceAwsEc2InstanceSubnetId() != null
                && other.getResourceAwsEc2InstanceSubnetId().equals(this.getResourceAwsEc2InstanceSubnetId()) == false)
            return false;
        if (other.getResourceAwsEc2InstanceLaunchedAt() == null ^ this.getResourceAwsEc2InstanceLaunchedAt() == null)
            return false;
        if (other.getResourceAwsEc2InstanceLaunchedAt() != null
                && other.getResourceAwsEc2InstanceLaunchedAt().equals(this.getResourceAwsEc2InstanceLaunchedAt()) == false)
            return false;
        if (other.getResourceAwsS3BucketOwnerId() == null ^ this.getResourceAwsS3BucketOwnerId() == null)
            return false;
        if (other.getResourceAwsS3BucketOwnerId() != null && other.getResourceAwsS3BucketOwnerId().equals(this.getResourceAwsS3BucketOwnerId()) == false)
            return false;
        if (other.getResourceAwsS3BucketOwnerName() == null ^ this.getResourceAwsS3BucketOwnerName() == null)
            return false;
        if (other.getResourceAwsS3BucketOwnerName() != null && other.getResourceAwsS3BucketOwnerName().equals(this.getResourceAwsS3BucketOwnerName()) == false)
            return false;
        if (other.getResourceAwsIamAccessKeyUserName() == null ^ this.getResourceAwsIamAccessKeyUserName() == null)
            return false;
        if (other.getResourceAwsIamAccessKeyUserName() != null
                && other.getResourceAwsIamAccessKeyUserName().equals(this.getResourceAwsIamAccessKeyUserName()) == false)
            return false;
        if (other.getResourceAwsIamAccessKeyStatus() == null ^ this.getResourceAwsIamAccessKeyStatus() == null)
            return false;
        if (other.getResourceAwsIamAccessKeyStatus() != null
                && other.getResourceAwsIamAccessKeyStatus().equals(this.getResourceAwsIamAccessKeyStatus()) == false)
            return false;
        if (other.getResourceAwsIamAccessKeyCreatedAt() == null ^ this.getResourceAwsIamAccessKeyCreatedAt() == null)
            return false;
        if (other.getResourceAwsIamAccessKeyCreatedAt() != null
                && other.getResourceAwsIamAccessKeyCreatedAt().equals(this.getResourceAwsIamAccessKeyCreatedAt()) == false)
            return false;
        if (other.getResourceContainerName() == null ^ this.getResourceContainerName() == null)
            return false;
        if (other.getResourceContainerName() != null && other.getResourceContainerName().equals(this.getResourceContainerName()) == false)
            return false;
        if (other.getResourceContainerImageId() == null ^ this.getResourceContainerImageId() == null)
            return false;
        if (other.getResourceContainerImageId() != null && other.getResourceContainerImageId().equals(this.getResourceContainerImageId()) == false)
            return false;
        if (other.getResourceContainerImageName() == null ^ this.getResourceContainerImageName() == null)
            return false;
        if (other.getResourceContainerImageName() != null && other.getResourceContainerImageName().equals(this.getResourceContainerImageName()) == false)
            return false;
        if (other.getResourceContainerLaunchedAt() == null ^ this.getResourceContainerLaunchedAt() == null)
            return false;
        if (other.getResourceContainerLaunchedAt() != null && other.getResourceContainerLaunchedAt().equals(this.getResourceContainerLaunchedAt()) == false)
            return false;
        if (other.getResourceDetailsOther() == null ^ this.getResourceDetailsOther() == null)
            return false;
        if (other.getResourceDetailsOther() != null && other.getResourceDetailsOther().equals(this.getResourceDetailsOther()) == false)
            return false;
        if (other.getComplianceStatus() == null ^ this.getComplianceStatus() == null)
            return false;
        if (other.getComplianceStatus() != null && other.getComplianceStatus().equals(this.getComplianceStatus()) == false)
            return false;
        if (other.getVerificationState() == null ^ this.getVerificationState() == null)
            return false;
        if (other.getVerificationState() != null && other.getVerificationState().equals(this.getVerificationState()) == false)
            return false;
        if (other.getWorkflowState() == null ^ this.getWorkflowState() == null)
            return false;
        if (other.getWorkflowState() != null && other.getWorkflowState().equals(this.getWorkflowState()) == false)
            return false;
        if (other.getRecordState() == null ^ this.getRecordState() == null)
            return false;
        if (other.getRecordState() != null && other.getRecordState().equals(this.getRecordState()) == false)
            return false;
        if (other.getRelatedFindingsProductArn() == null ^ this.getRelatedFindingsProductArn() == null)
            return false;
        if (other.getRelatedFindingsProductArn() != null && other.getRelatedFindingsProductArn().equals(this.getRelatedFindingsProductArn()) == false)
            return false;
        if (other.getRelatedFindingsId() == null ^ this.getRelatedFindingsId() == null)
            return false;
        if (other.getRelatedFindingsId() != null && other.getRelatedFindingsId().equals(this.getRelatedFindingsId()) == false)
            return false;
        if (other.getNoteText() == null ^ this.getNoteText() == null)
            return false;
        if (other.getNoteText() != null && other.getNoteText().equals(this.getNoteText()) == false)
            return false;
        if (other.getNoteUpdatedAt() == null ^ this.getNoteUpdatedAt() == null)
            return false;
        if (other.getNoteUpdatedAt() != null && other.getNoteUpdatedAt().equals(this.getNoteUpdatedAt()) == false)
            return false;
        if (other.getNoteUpdatedBy() == null ^ this.getNoteUpdatedBy() == null)
            return false;
        if (other.getNoteUpdatedBy() != null && other.getNoteUpdatedBy().equals(this.getNoteUpdatedBy()) == false)
            return false;
        if (other.getKeyword() == null ^ this.getKeyword() == null)
            return false;
        if (other.getKeyword() != null && other.getKeyword().equals(this.getKeyword()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getProductArn() == null) ? 0 : getProductArn().hashCode());
        hashCode = prime * hashCode + ((getAwsAccountId() == null) ? 0 : getAwsAccountId().hashCode());
        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getGeneratorId() == null) ? 0 : getGeneratorId().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getFirstObservedAt() == null) ? 0 : getFirstObservedAt().hashCode());
        hashCode = prime * hashCode + ((getLastObservedAt() == null) ? 0 : getLastObservedAt().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        hashCode = prime * hashCode + ((getSeverityProduct() == null) ? 0 : getSeverityProduct().hashCode());
        hashCode = prime * hashCode + ((getSeverityNormalized() == null) ? 0 : getSeverityNormalized().hashCode());
        hashCode = prime * hashCode + ((getSeverityLabel() == null) ? 0 : getSeverityLabel().hashCode());
        hashCode = prime * hashCode + ((getConfidence() == null) ? 0 : getConfidence().hashCode());
        hashCode = prime * hashCode + ((getCriticality() == null) ? 0 : getCriticality().hashCode());
        hashCode = prime * hashCode + ((getTitle() == null) ? 0 : getTitle().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getRecommendationText() == null) ? 0 : getRecommendationText().hashCode());
        hashCode = prime * hashCode + ((getSourceUrl() == null) ? 0 : getSourceUrl().hashCode());
        hashCode = prime * hashCode + ((getProductFields() == null) ? 0 : getProductFields().hashCode());
        hashCode = prime * hashCode + ((getProductName() == null) ? 0 : getProductName().hashCode());
        hashCode = prime * hashCode + ((getCompanyName() == null) ? 0 : getCompanyName().hashCode());
        hashCode = prime * hashCode + ((getUserDefinedFields() == null) ? 0 : getUserDefinedFields().hashCode());
        hashCode = prime * hashCode + ((getMalwareName() == null) ? 0 : getMalwareName().hashCode());
        hashCode = prime * hashCode + ((getMalwareType() == null) ? 0 : getMalwareType().hashCode());
        hashCode = prime * hashCode + ((getMalwarePath() == null) ? 0 : getMalwarePath().hashCode());
        hashCode = prime * hashCode + ((getMalwareState() == null) ? 0 : getMalwareState().hashCode());
        hashCode = prime * hashCode + ((getNetworkDirection() == null) ? 0 : getNetworkDirection().hashCode());
        hashCode = prime * hashCode + ((getNetworkProtocol() == null) ? 0 : getNetworkProtocol().hashCode());
        hashCode = prime * hashCode + ((getNetworkSourceIpV4() == null) ? 0 : getNetworkSourceIpV4().hashCode());
        hashCode = prime * hashCode + ((getNetworkSourceIpV6() == null) ? 0 : getNetworkSourceIpV6().hashCode());
        hashCode = prime * hashCode + ((getNetworkSourcePort() == null) ? 0 : getNetworkSourcePort().hashCode());
        hashCode = prime * hashCode + ((getNetworkSourceDomain() == null) ? 0 : getNetworkSourceDomain().hashCode());
        hashCode = prime * hashCode + ((getNetworkSourceMac() == null) ? 0 : getNetworkSourceMac().hashCode());
        hashCode = prime * hashCode + ((getNetworkDestinationIpV4() == null) ? 0 : getNetworkDestinationIpV4().hashCode());
        hashCode = prime * hashCode + ((getNetworkDestinationIpV6() == null) ? 0 : getNetworkDestinationIpV6().hashCode());
        hashCode = prime * hashCode + ((getNetworkDestinationPort() == null) ? 0 : getNetworkDestinationPort().hashCode());
        hashCode = prime * hashCode + ((getNetworkDestinationDomain() == null) ? 0 : getNetworkDestinationDomain().hashCode());
        hashCode = prime * hashCode + ((getProcessName() == null) ? 0 : getProcessName().hashCode());
        hashCode = prime * hashCode + ((getProcessPath() == null) ? 0 : getProcessPath().hashCode());
        hashCode = prime * hashCode + ((getProcessPid() == null) ? 0 : getProcessPid().hashCode());
        hashCode = prime * hashCode + ((getProcessParentPid() == null) ? 0 : getProcessParentPid().hashCode());
        hashCode = prime * hashCode + ((getProcessLaunchedAt() == null) ? 0 : getProcessLaunchedAt().hashCode());
        hashCode = prime * hashCode + ((getProcessTerminatedAt() == null) ? 0 : getProcessTerminatedAt().hashCode());
        hashCode = prime * hashCode + ((getThreatIntelIndicatorType() == null) ? 0 : getThreatIntelIndicatorType().hashCode());
        hashCode = prime * hashCode + ((getThreatIntelIndicatorValue() == null) ? 0 : getThreatIntelIndicatorValue().hashCode());
        hashCode = prime * hashCode + ((getThreatIntelIndicatorCategory() == null) ? 0 : getThreatIntelIndicatorCategory().hashCode());
        hashCode = prime * hashCode + ((getThreatIntelIndicatorLastObservedAt() == null) ? 0 : getThreatIntelIndicatorLastObservedAt().hashCode());
        hashCode = prime * hashCode + ((getThreatIntelIndicatorSource() == null) ? 0 : getThreatIntelIndicatorSource().hashCode());
        hashCode = prime * hashCode + ((getThreatIntelIndicatorSourceUrl() == null) ? 0 : getThreatIntelIndicatorSourceUrl().hashCode());
        hashCode = prime * hashCode + ((getResourceType() == null) ? 0 : getResourceType().hashCode());
        hashCode = prime * hashCode + ((getResourceId() == null) ? 0 : getResourceId().hashCode());
        hashCode = prime * hashCode + ((getResourcePartition() == null) ? 0 : getResourcePartition().hashCode());
        hashCode = prime * hashCode + ((getResourceRegion() == null) ? 0 : getResourceRegion().hashCode());
        hashCode = prime * hashCode + ((getResourceTags() == null) ? 0 : getResourceTags().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsEc2InstanceType() == null) ? 0 : getResourceAwsEc2InstanceType().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsEc2InstanceImageId() == null) ? 0 : getResourceAwsEc2InstanceImageId().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsEc2InstanceIpV4Addresses() == null) ? 0 : getResourceAwsEc2InstanceIpV4Addresses().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsEc2InstanceIpV6Addresses() == null) ? 0 : getResourceAwsEc2InstanceIpV6Addresses().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsEc2InstanceKeyName() == null) ? 0 : getResourceAwsEc2InstanceKeyName().hashCode());
        hashCode = prime * hashCode
                + ((getResourceAwsEc2InstanceIamInstanceProfileArn() == null) ? 0 : getResourceAwsEc2InstanceIamInstanceProfileArn().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsEc2InstanceVpcId() == null) ? 0 : getResourceAwsEc2InstanceVpcId().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsEc2InstanceSubnetId() == null) ? 0 : getResourceAwsEc2InstanceSubnetId().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsEc2InstanceLaunchedAt() == null) ? 0 : getResourceAwsEc2InstanceLaunchedAt().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsS3BucketOwnerId() == null) ? 0 : getResourceAwsS3BucketOwnerId().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsS3BucketOwnerName() == null) ? 0 : getResourceAwsS3BucketOwnerName().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsIamAccessKeyUserName() == null) ? 0 : getResourceAwsIamAccessKeyUserName().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsIamAccessKeyStatus() == null) ? 0 : getResourceAwsIamAccessKeyStatus().hashCode());
        hashCode = prime * hashCode + ((getResourceAwsIamAccessKeyCreatedAt() == null) ? 0 : getResourceAwsIamAccessKeyCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getResourceContainerName() == null) ? 0 : getResourceContainerName().hashCode());
        hashCode = prime * hashCode + ((getResourceContainerImageId() == null) ? 0 : getResourceContainerImageId().hashCode());
        hashCode = prime * hashCode + ((getResourceContainerImageName() == null) ? 0 : getResourceContainerImageName().hashCode());
        hashCode = prime * hashCode + ((getResourceContainerLaunchedAt() == null) ? 0 : getResourceContainerLaunchedAt().hashCode());
        hashCode = prime * hashCode + ((getResourceDetailsOther() == null) ? 0 : getResourceDetailsOther().hashCode());
        hashCode = prime * hashCode + ((getComplianceStatus() == null) ? 0 : getComplianceStatus().hashCode());
        hashCode = prime * hashCode + ((getVerificationState() == null) ? 0 : getVerificationState().hashCode());
        hashCode = prime * hashCode + ((getWorkflowState() == null) ? 0 : getWorkflowState().hashCode());
        hashCode = prime * hashCode + ((getRecordState() == null) ? 0 : getRecordState().hashCode());
        hashCode = prime * hashCode + ((getRelatedFindingsProductArn() == null) ? 0 : getRelatedFindingsProductArn().hashCode());
        hashCode = prime * hashCode + ((getRelatedFindingsId() == null) ? 0 : getRelatedFindingsId().hashCode());
        hashCode = prime * hashCode + ((getNoteText() == null) ? 0 : getNoteText().hashCode());
        hashCode = prime * hashCode + ((getNoteUpdatedAt() == null) ? 0 : getNoteUpdatedAt().hashCode());
        hashCode = prime * hashCode + ((getNoteUpdatedBy() == null) ? 0 : getNoteUpdatedBy().hashCode());
        hashCode = prime * hashCode + ((getKeyword() == null) ? 0 : getKeyword().hashCode());
        return hashCode;
    }

    @Override
    public AwsSecurityFindingFilters clone() {
        try {
            return (AwsSecurityFindingFilters) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsSecurityFindingFiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
