/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An object that contains information on the status of Kubernetes data sources for the detector.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsGuardDutyDetectorDataSourcesKubernetesDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsGuardDutyDetectorDataSourcesKubernetesDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Describes whether Kubernetes audit logs are activated as a data source for the detector.
     * </p>
     */
    private AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails auditLogs;

    /**
     * <p>
     * Describes whether Kubernetes audit logs are activated as a data source for the detector.
     * </p>
     * 
     * @param auditLogs
     *        Describes whether Kubernetes audit logs are activated as a data source for the detector.
     */

    public void setAuditLogs(AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails auditLogs) {
        this.auditLogs = auditLogs;
    }

    /**
     * <p>
     * Describes whether Kubernetes audit logs are activated as a data source for the detector.
     * </p>
     * 
     * @return Describes whether Kubernetes audit logs are activated as a data source for the detector.
     */

    public AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails getAuditLogs() {
        return this.auditLogs;
    }

    /**
     * <p>
     * Describes whether Kubernetes audit logs are activated as a data source for the detector.
     * </p>
     * 
     * @param auditLogs
     *        Describes whether Kubernetes audit logs are activated as a data source for the detector.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsGuardDutyDetectorDataSourcesKubernetesDetails withAuditLogs(AwsGuardDutyDetectorDataSourcesKubernetesAuditLogsDetails auditLogs) {
        setAuditLogs(auditLogs);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAuditLogs() != null)
            sb.append("AuditLogs: ").append(getAuditLogs());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsGuardDutyDetectorDataSourcesKubernetesDetails == false)
            return false;
        AwsGuardDutyDetectorDataSourcesKubernetesDetails other = (AwsGuardDutyDetectorDataSourcesKubernetesDetails) obj;
        if (other.getAuditLogs() == null ^ this.getAuditLogs() == null)
            return false;
        if (other.getAuditLogs() != null && other.getAuditLogs().equals(this.getAuditLogs()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAuditLogs() == null) ? 0 : getAuditLogs().hashCode());
        return hashCode;
    }

    @Override
    public AwsGuardDutyDetectorDataSourcesKubernetesDetails clone() {
        try {
            return (AwsGuardDutyDetectorDataSourcesKubernetesDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsGuardDutyDetectorDataSourcesKubernetesDetailsMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
