/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub;

import javax.annotation.Generated;

import com.amazonaws.services.securityhub.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSSecurityHub}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSSecurityHub implements AWSSecurityHub {

    protected AbstractAWSSecurityHub() {
    }

    @Override
    public AcceptAdministratorInvitationResult acceptAdministratorInvitation(AcceptAdministratorInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public AcceptInvitationResult acceptInvitation(AcceptInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeleteAutomationRulesResult batchDeleteAutomationRules(BatchDeleteAutomationRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDisableStandardsResult batchDisableStandards(BatchDisableStandardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchEnableStandardsResult batchEnableStandards(BatchEnableStandardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetAutomationRulesResult batchGetAutomationRules(BatchGetAutomationRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetConfigurationPolicyAssociationsResult batchGetConfigurationPolicyAssociations(BatchGetConfigurationPolicyAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetSecurityControlsResult batchGetSecurityControls(BatchGetSecurityControlsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetStandardsControlAssociationsResult batchGetStandardsControlAssociations(BatchGetStandardsControlAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchImportFindingsResult batchImportFindings(BatchImportFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateAutomationRulesResult batchUpdateAutomationRules(BatchUpdateAutomationRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateFindingsResult batchUpdateFindings(BatchUpdateFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateStandardsControlAssociationsResult batchUpdateStandardsControlAssociations(BatchUpdateStandardsControlAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateActionTargetResult createActionTarget(CreateActionTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAutomationRuleResult createAutomationRule(CreateAutomationRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConfigurationPolicyResult createConfigurationPolicy(CreateConfigurationPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFindingAggregatorResult createFindingAggregator(CreateFindingAggregatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInsightResult createInsight(CreateInsightRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMembersResult createMembers(CreateMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeclineInvitationsResult declineInvitations(DeclineInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteActionTargetResult deleteActionTarget(DeleteActionTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConfigurationPolicyResult deleteConfigurationPolicy(DeleteConfigurationPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFindingAggregatorResult deleteFindingAggregator(DeleteFindingAggregatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInsightResult deleteInsight(DeleteInsightRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInvitationsResult deleteInvitations(DeleteInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMembersResult deleteMembers(DeleteMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeActionTargetsResult describeActionTargets(DescribeActionTargetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeHubResult describeHub(DescribeHubRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeOrganizationConfigurationResult describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeProductsResult describeProducts(DescribeProductsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeStandardsResult describeStandards(DescribeStandardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeStandardsControlsResult describeStandardsControls(DescribeStandardsControlsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableImportFindingsForProductResult disableImportFindingsForProduct(DisableImportFindingsForProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableOrganizationAdminAccountResult disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableSecurityHubResult disableSecurityHub(DisableSecurityHubRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateFromAdministratorAccountResult disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public DisassociateFromMasterAccountResult disassociateFromMasterAccount(DisassociateFromMasterAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMembersResult disassociateMembers(DisassociateMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableImportFindingsForProductResult enableImportFindingsForProduct(EnableImportFindingsForProductRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableOrganizationAdminAccountResult enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableSecurityHubResult enableSecurityHub(EnableSecurityHubRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAdministratorAccountResult getAdministratorAccount(GetAdministratorAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfigurationPolicyResult getConfigurationPolicy(GetConfigurationPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfigurationPolicyAssociationResult getConfigurationPolicyAssociation(GetConfigurationPolicyAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEnabledStandardsResult getEnabledStandards(GetEnabledStandardsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingAggregatorResult getFindingAggregator(GetFindingAggregatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingHistoryResult getFindingHistory(GetFindingHistoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingsResult getFindings(GetFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInsightResultsResult getInsightResults(GetInsightResultsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInsightsResult getInsights(GetInsightsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInvitationsCountResult getInvitationsCount(GetInvitationsCountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public GetMasterAccountResult getMasterAccount(GetMasterAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMembersResult getMembers(GetMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSecurityControlDefinitionResult getSecurityControlDefinition(GetSecurityControlDefinitionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public InviteMembersResult inviteMembers(InviteMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAutomationRulesResult listAutomationRules(ListAutomationRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConfigurationPoliciesResult listConfigurationPolicies(ListConfigurationPoliciesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConfigurationPolicyAssociationsResult listConfigurationPolicyAssociations(ListConfigurationPolicyAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEnabledProductsForImportResult listEnabledProductsForImport(ListEnabledProductsForImportRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFindingAggregatorsResult listFindingAggregators(ListFindingAggregatorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInvitationsResult listInvitations(ListInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOrganizationAdminAccountsResult listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSecurityControlDefinitionsResult listSecurityControlDefinitions(ListSecurityControlDefinitionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListStandardsControlAssociationsResult listStandardsControlAssociations(ListStandardsControlAssociationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartConfigurationPolicyAssociationResult startConfigurationPolicyAssociation(StartConfigurationPolicyAssociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartConfigurationPolicyDisassociationResult startConfigurationPolicyDisassociation(StartConfigurationPolicyDisassociationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateActionTargetResult updateActionTarget(UpdateActionTargetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConfigurationPolicyResult updateConfigurationPolicy(UpdateConfigurationPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFindingAggregatorResult updateFindingAggregator(UpdateFindingAggregatorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFindingsResult updateFindings(UpdateFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInsightResult updateInsight(UpdateInsightRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateOrganizationConfigurationResult updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSecurityControlResult updateSecurityControl(UpdateSecurityControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSecurityHubConfigurationResult updateSecurityHubConfiguration(UpdateSecurityHubConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateStandardsControlResult updateStandardsControl(UpdateStandardsControlRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
