/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workdocs;

import javax.annotation.Generated;

import com.amazonaws.services.workdocs.model.*;

/**
 * Abstract implementation of {@code AmazonWorkDocsAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonWorkDocsAsync extends AbstractAmazonWorkDocs implements AmazonWorkDocsAsync {

    protected AbstractAmazonWorkDocsAsync() {
    }

    @Override
    public java.util.concurrent.Future<AbortDocumentVersionUploadResult> abortDocumentVersionUploadAsync(AbortDocumentVersionUploadRequest request) {

        return abortDocumentVersionUploadAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AbortDocumentVersionUploadResult> abortDocumentVersionUploadAsync(AbortDocumentVersionUploadRequest request,
            com.amazonaws.handlers.AsyncHandler<AbortDocumentVersionUploadRequest, AbortDocumentVersionUploadResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ActivateUserResult> activateUserAsync(ActivateUserRequest request) {

        return activateUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ActivateUserResult> activateUserAsync(ActivateUserRequest request,
            com.amazonaws.handlers.AsyncHandler<ActivateUserRequest, ActivateUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<AddResourcePermissionsResult> addResourcePermissionsAsync(AddResourcePermissionsRequest request) {

        return addResourcePermissionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AddResourcePermissionsResult> addResourcePermissionsAsync(AddResourcePermissionsRequest request,
            com.amazonaws.handlers.AsyncHandler<AddResourcePermissionsRequest, AddResourcePermissionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateCommentResult> createCommentAsync(CreateCommentRequest request) {

        return createCommentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateCommentResult> createCommentAsync(CreateCommentRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateCommentRequest, CreateCommentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateCustomMetadataResult> createCustomMetadataAsync(CreateCustomMetadataRequest request) {

        return createCustomMetadataAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateCustomMetadataResult> createCustomMetadataAsync(CreateCustomMetadataRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateCustomMetadataRequest, CreateCustomMetadataResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateFolderResult> createFolderAsync(CreateFolderRequest request) {

        return createFolderAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateFolderResult> createFolderAsync(CreateFolderRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateFolderRequest, CreateFolderResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateLabelsResult> createLabelsAsync(CreateLabelsRequest request) {

        return createLabelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateLabelsResult> createLabelsAsync(CreateLabelsRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateLabelsRequest, CreateLabelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateNotificationSubscriptionResult> createNotificationSubscriptionAsync(CreateNotificationSubscriptionRequest request) {

        return createNotificationSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateNotificationSubscriptionResult> createNotificationSubscriptionAsync(CreateNotificationSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateNotificationSubscriptionRequest, CreateNotificationSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateUserResult> createUserAsync(CreateUserRequest request) {

        return createUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateUserResult> createUserAsync(CreateUserRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateUserRequest, CreateUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeactivateUserResult> deactivateUserAsync(DeactivateUserRequest request) {

        return deactivateUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeactivateUserResult> deactivateUserAsync(DeactivateUserRequest request,
            com.amazonaws.handlers.AsyncHandler<DeactivateUserRequest, DeactivateUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteCommentResult> deleteCommentAsync(DeleteCommentRequest request) {

        return deleteCommentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteCommentResult> deleteCommentAsync(DeleteCommentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteCommentRequest, DeleteCommentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteCustomMetadataResult> deleteCustomMetadataAsync(DeleteCustomMetadataRequest request) {

        return deleteCustomMetadataAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteCustomMetadataResult> deleteCustomMetadataAsync(DeleteCustomMetadataRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteCustomMetadataRequest, DeleteCustomMetadataResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDocumentResult> deleteDocumentAsync(DeleteDocumentRequest request) {

        return deleteDocumentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDocumentResult> deleteDocumentAsync(DeleteDocumentRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDocumentRequest, DeleteDocumentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteFolderResult> deleteFolderAsync(DeleteFolderRequest request) {

        return deleteFolderAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteFolderResult> deleteFolderAsync(DeleteFolderRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteFolderRequest, DeleteFolderResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteFolderContentsResult> deleteFolderContentsAsync(DeleteFolderContentsRequest request) {

        return deleteFolderContentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteFolderContentsResult> deleteFolderContentsAsync(DeleteFolderContentsRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteFolderContentsRequest, DeleteFolderContentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteLabelsResult> deleteLabelsAsync(DeleteLabelsRequest request) {

        return deleteLabelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteLabelsResult> deleteLabelsAsync(DeleteLabelsRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteLabelsRequest, DeleteLabelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteNotificationSubscriptionResult> deleteNotificationSubscriptionAsync(DeleteNotificationSubscriptionRequest request) {

        return deleteNotificationSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteNotificationSubscriptionResult> deleteNotificationSubscriptionAsync(DeleteNotificationSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteNotificationSubscriptionRequest, DeleteNotificationSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {

        return deleteUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeActivitiesResult> describeActivitiesAsync(DescribeActivitiesRequest request) {

        return describeActivitiesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeActivitiesResult> describeActivitiesAsync(DescribeActivitiesRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeActivitiesRequest, DescribeActivitiesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeCommentsResult> describeCommentsAsync(DescribeCommentsRequest request) {

        return describeCommentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeCommentsResult> describeCommentsAsync(DescribeCommentsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeCommentsRequest, DescribeCommentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeDocumentVersionsResult> describeDocumentVersionsAsync(DescribeDocumentVersionsRequest request) {

        return describeDocumentVersionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeDocumentVersionsResult> describeDocumentVersionsAsync(DescribeDocumentVersionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeDocumentVersionsRequest, DescribeDocumentVersionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeFolderContentsResult> describeFolderContentsAsync(DescribeFolderContentsRequest request) {

        return describeFolderContentsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeFolderContentsResult> describeFolderContentsAsync(DescribeFolderContentsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeFolderContentsRequest, DescribeFolderContentsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeNotificationSubscriptionsResult> describeNotificationSubscriptionsAsync(
            DescribeNotificationSubscriptionsRequest request) {

        return describeNotificationSubscriptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeNotificationSubscriptionsResult> describeNotificationSubscriptionsAsync(
            DescribeNotificationSubscriptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeNotificationSubscriptionsRequest, DescribeNotificationSubscriptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeResourcePermissionsResult> describeResourcePermissionsAsync(DescribeResourcePermissionsRequest request) {

        return describeResourcePermissionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeResourcePermissionsResult> describeResourcePermissionsAsync(DescribeResourcePermissionsRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeResourcePermissionsRequest, DescribeResourcePermissionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeRootFoldersResult> describeRootFoldersAsync(DescribeRootFoldersRequest request) {

        return describeRootFoldersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeRootFoldersResult> describeRootFoldersAsync(DescribeRootFoldersRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeRootFoldersRequest, DescribeRootFoldersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeUsersResult> describeUsersAsync(DescribeUsersRequest request) {

        return describeUsersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeUsersResult> describeUsersAsync(DescribeUsersRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeUsersRequest, DescribeUsersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetCurrentUserResult> getCurrentUserAsync(GetCurrentUserRequest request) {

        return getCurrentUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetCurrentUserResult> getCurrentUserAsync(GetCurrentUserRequest request,
            com.amazonaws.handlers.AsyncHandler<GetCurrentUserRequest, GetCurrentUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDocumentResult> getDocumentAsync(GetDocumentRequest request) {

        return getDocumentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDocumentResult> getDocumentAsync(GetDocumentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDocumentRequest, GetDocumentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDocumentPathResult> getDocumentPathAsync(GetDocumentPathRequest request) {

        return getDocumentPathAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDocumentPathResult> getDocumentPathAsync(GetDocumentPathRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDocumentPathRequest, GetDocumentPathResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDocumentVersionResult> getDocumentVersionAsync(GetDocumentVersionRequest request) {

        return getDocumentVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDocumentVersionResult> getDocumentVersionAsync(GetDocumentVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDocumentVersionRequest, GetDocumentVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetFolderResult> getFolderAsync(GetFolderRequest request) {

        return getFolderAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetFolderResult> getFolderAsync(GetFolderRequest request,
            com.amazonaws.handlers.AsyncHandler<GetFolderRequest, GetFolderResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetFolderPathResult> getFolderPathAsync(GetFolderPathRequest request) {

        return getFolderPathAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetFolderPathResult> getFolderPathAsync(GetFolderPathRequest request,
            com.amazonaws.handlers.AsyncHandler<GetFolderPathRequest, GetFolderPathResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<InitiateDocumentVersionUploadResult> initiateDocumentVersionUploadAsync(InitiateDocumentVersionUploadRequest request) {

        return initiateDocumentVersionUploadAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<InitiateDocumentVersionUploadResult> initiateDocumentVersionUploadAsync(InitiateDocumentVersionUploadRequest request,
            com.amazonaws.handlers.AsyncHandler<InitiateDocumentVersionUploadRequest, InitiateDocumentVersionUploadResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RemoveAllResourcePermissionsResult> removeAllResourcePermissionsAsync(RemoveAllResourcePermissionsRequest request) {

        return removeAllResourcePermissionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RemoveAllResourcePermissionsResult> removeAllResourcePermissionsAsync(RemoveAllResourcePermissionsRequest request,
            com.amazonaws.handlers.AsyncHandler<RemoveAllResourcePermissionsRequest, RemoveAllResourcePermissionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RemoveResourcePermissionResult> removeResourcePermissionAsync(RemoveResourcePermissionRequest request) {

        return removeResourcePermissionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RemoveResourcePermissionResult> removeResourcePermissionAsync(RemoveResourcePermissionRequest request,
            com.amazonaws.handlers.AsyncHandler<RemoveResourcePermissionRequest, RemoveResourcePermissionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDocumentResult> updateDocumentAsync(UpdateDocumentRequest request) {

        return updateDocumentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDocumentResult> updateDocumentAsync(UpdateDocumentRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDocumentRequest, UpdateDocumentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDocumentVersionResult> updateDocumentVersionAsync(UpdateDocumentVersionRequest request) {

        return updateDocumentVersionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDocumentVersionResult> updateDocumentVersionAsync(UpdateDocumentVersionRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDocumentVersionRequest, UpdateDocumentVersionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateFolderResult> updateFolderAsync(UpdateFolderRequest request) {

        return updateFolderAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateFolderResult> updateFolderAsync(UpdateFolderRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateFolderRequest, UpdateFolderResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request) {

        return updateUserAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateUserResult> updateUserAsync(UpdateUserRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateUserRequest, UpdateUserResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
