/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workdocs;

import javax.annotation.Generated;

import com.amazonaws.services.workdocs.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonWorkDocs}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonWorkDocs implements AmazonWorkDocs {

    protected AbstractAmazonWorkDocs() {
    }

    @Override
    public AbortDocumentVersionUploadResult abortDocumentVersionUpload(AbortDocumentVersionUploadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ActivateUserResult activateUser(ActivateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AddResourcePermissionsResult addResourcePermissions(AddResourcePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCommentResult createComment(CreateCommentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCustomMetadataResult createCustomMetadata(CreateCustomMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFolderResult createFolder(CreateFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLabelsResult createLabels(CreateLabelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateNotificationSubscriptionResult createNotificationSubscription(CreateNotificationSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeactivateUserResult deactivateUser(DeactivateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCommentResult deleteComment(DeleteCommentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCustomMetadataResult deleteCustomMetadata(DeleteCustomMetadataRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteDocumentResult deleteDocument(DeleteDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFolderResult deleteFolder(DeleteFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFolderContentsResult deleteFolderContents(DeleteFolderContentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLabelsResult deleteLabels(DeleteLabelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteNotificationSubscriptionResult deleteNotificationSubscription(DeleteNotificationSubscriptionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeActivitiesResult describeActivities(DescribeActivitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCommentsResult describeComments(DescribeCommentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeDocumentVersionsResult describeDocumentVersions(DescribeDocumentVersionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeFolderContentsResult describeFolderContents(DescribeFolderContentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGroupsResult describeGroups(DescribeGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeNotificationSubscriptionsResult describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeResourcePermissionsResult describeResourcePermissions(DescribeResourcePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeRootFoldersResult describeRootFolders(DescribeRootFoldersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeUsersResult describeUsers(DescribeUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCurrentUserResult getCurrentUser(GetCurrentUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDocumentResult getDocument(GetDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDocumentPathResult getDocumentPath(GetDocumentPathRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDocumentVersionResult getDocumentVersion(GetDocumentVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFolderResult getFolder(GetFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFolderPathResult getFolderPath(GetFolderPathRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public InitiateDocumentVersionUploadResult initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveAllResourcePermissionsResult removeAllResourcePermissions(RemoveAllResourcePermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RemoveResourcePermissionResult removeResourcePermission(RemoveResourcePermissionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDocumentResult updateDocument(UpdateDocumentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDocumentVersionResult updateDocumentVersion(UpdateDocumentVersionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFolderResult updateFolder(UpdateFolderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
