/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.tests;

import com.amazonaws.services.lambda.runtime.tests.EventLoader;
import com.amazonaws.services.lambda.runtime.tests.annotations.Event;
import com.amazonaws.services.lambda.runtime.tests.annotations.Events;
import com.amazonaws.services.lambda.runtime.tests.annotations.HandlerParams;
import com.amazonaws.services.lambda.runtime.tests.annotations.Response;
import com.amazonaws.services.lambda.runtime.tests.annotations.Responses;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.AnnotationConsumer;

public class HandlerParamsArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<HandlerParams> {
    private Event event;
    private Response response;
    private Events events;
    private Responses responses;

    public void accept(HandlerParams handlerParams) {
        this.event = handlerParams.event();
        this.response = handlerParams.response();
        this.events = handlerParams.events();
        this.responses = handlerParams.responses();
    }

    public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
        if (!this.event.value().isEmpty() && this.response.value().isEmpty() || this.event.value().isEmpty() && !this.response.value().isEmpty()) {
            throw new IllegalStateException("You must use either Event & Response (singular) or Events & Responses (plural) annotations together, you cannot mix them");
        }
        if (ArrayUtils.isEmpty((Object[])this.events.events()) && StringUtils.isEmpty((CharSequence)this.events.folder()) && (StringUtils.isNotEmpty((CharSequence)this.responses.folder()) || ArrayUtils.isNotEmpty((Object[])this.responses.responses())) || ArrayUtils.isEmpty((Object[])this.responses.responses()) && StringUtils.isEmpty((CharSequence)this.responses.folder()) && (StringUtils.isNotEmpty((CharSequence)this.events.folder()) || ArrayUtils.isNotEmpty((Object[])this.events.events()))) {
            throw new IllegalStateException("You must use either Event & Response (singular) or Events & Responses (plural) annotations together, you cannot mix them");
        }
        if (!this.event.value().isEmpty() && !this.response.value().isEmpty()) {
            return Stream.of(Arguments.of((Object[])new Object[]{EventLoader.loadEvent(this.event.value(), this.event.type()), EventLoader.loadEvent(this.response.value(), this.response.type())}));
        }
        List<Object> eventList = this.getEvents();
        List<Object> responseList = this.getResponses();
        if (eventList == null || eventList.size() == 0 || responseList == null || responseList.size() == 0 || eventList.size() != responseList.size()) {
            throw new IllegalStateException("At least one event and one response should be provided, and you should have the exact same number of events and responses.");
        }
        Stream.Builder<Arguments> streamBuilder = Stream.builder();
        for (int i = 0; i < eventList.size(); ++i) {
            streamBuilder.add(Arguments.of((Object[])new Object[]{eventList.get(i), responseList.get(i)}));
        }
        return streamBuilder.build();
    }

    private List<Object> getResponses() throws IOException, URISyntaxException {
        List<Object> responseList;
        if (ArrayUtils.isNotEmpty((Object[])this.responses.responses())) {
            responseList = Arrays.stream(this.responses.responses()).map(response -> {
                Class<?> clazz = response.type() == Void.class ? this.responses.type() : response.type();
                return EventLoader.loadEvent(response.value(), clazz);
            }).collect(Collectors.toList());
        } else {
            Stream<Path> files = this.listFiles(this.responses.folder());
            responseList = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> EventLoader.loadEvent(path.toString(), this.responses.type())).collect(Collectors.toList());
        }
        return responseList;
    }

    private List<Object> getEvents() throws IOException, URISyntaxException {
        List<Object> eventList;
        if (ArrayUtils.isNotEmpty((Object[])this.events.events())) {
            eventList = Arrays.stream(this.events.events()).map(event -> {
                Class<?> clazz = event.type() == Void.class ? this.events.type() : event.type();
                return EventLoader.loadEvent(event.value(), clazz);
            }).collect(Collectors.toList());
        } else {
            Stream<Path> files = this.listFiles(this.events.folder());
            eventList = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> EventLoader.loadEvent(path.toString(), this.events.type())).collect(Collectors.toList());
        }
        return eventList;
    }

    private Stream<Path> listFiles(String folder) throws IOException, URISyntaxException {
        URL folderUrl = this.getClass().getResource(folder);
        if (folderUrl == null) {
            folderUrl = this.getClass().getClassLoader().getResource(folder);
        }
        if (folderUrl == null) {
            throw new IllegalArgumentException("Path " + folder + " cannot be found");
        }
        return Files.list(Paths.get(folderUrl.toURI())).sorted();
    }
}

