/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.http.Part;
import javax.ws.rs.core.MultivaluedHashMap;

public class AwsProxyRequestPart
implements Part {
    private String name;
    private String submittedFileName;
    private long size;
    private String contentType;
    private MultivaluedHashMap<String, String> headers;
    private byte[] content;

    public AwsProxyRequestPart(byte[] content) {
        this.content = content;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getSubmittedFileName() {
        return this.submittedFileName;
    }

    public long getSize() {
        return this.size;
    }

    public void write(String s) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(s);){
            fos.write(this.content);
        }
    }

    public void delete() throws IOException {
    }

    public String getHeader(String s) {
        return (String)this.headers.getFirst((Object)s);
    }

    public Collection<String> getHeaders(String s) {
        return this.headers.get((Object)s);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new MultivaluedHashMap();
        }
        if (this.headers.containsKey((Object)key)) {
            this.headers.add((Object)key, (Object)value);
        } else {
            this.headers.putSingle((Object)key, (Object)value);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSubmittedFileName(String submittedFileName) {
        this.submittedFileName = submittedFileName;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setHeaders(MultivaluedHashMap<String, String> headers) {
        this.headers = headers;
    }
}

