/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyRequestPart;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyServletContext;
import com.amazonaws.services.lambda.runtime.Context;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class AwsProxyHttpServletRequest
implements HttpServletRequest {
    private static final String HEADER_KEY_VALUE_SEPARATOR = "=";
    private static final String HEADER_VALUE_SEPARATOR = ";";
    private static final String FORM_DATA_SEPARATOR = "&";
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private static final String HEADER_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss z";
    private static final String ENCODING_VALUE_KEY = "charset";
    static final String CF_PROTOCOL_HEADER_NAME = "CloudFront-Forwarded-Proto";
    private AwsProxyRequest request;
    private Context lamdaContext;
    private SecurityContext securityContext;
    private Map<String, Object> attributes;
    private Map<String, List<String>> urlEncodedFormParameters;
    private Map<String, Part> multipartFormParameters;

    public AwsProxyHttpServletRequest(AwsProxyRequest awsProxyRequest, Context lamdaContext, SecurityContext awsSecurityContext) {
        this.request = awsProxyRequest;
        this.lamdaContext = lamdaContext;
        this.securityContext = awsSecurityContext;
        this.attributes = new HashMap<String, Object>();
        this.urlEncodedFormParameters = this.getFormUrlEncodedParametersMap();
        this.multipartFormParameters = this.getMultipartFormParametersMap();
    }

    public String getAuthType() {
        return this.securityContext.getAuthenticationScheme();
    }

    public Cookie[] getCookies() {
        String cookieHeader = this.getHeaderCaseInsensitive("Cookie");
        if (cookieHeader == null) {
            return new Cookie[0];
        }
        String[] cookies = cookieHeader.split(HEADER_VALUE_SEPARATOR);
        ArrayList<Cookie> output = new ArrayList<Cookie>();
        for (String curCookie : cookies) {
            String[] cookieKeyValue = curCookie.split(HEADER_KEY_VALUE_SEPARATOR);
            if (cookieKeyValue.length < 2) continue;
            output.add(new Cookie(cookieKeyValue[0].trim(), cookieKeyValue[1].trim()));
        }
        Cookie[] returnValue = new Cookie[output.size()];
        return output.toArray(returnValue);
    }

    public long getDateHeader(String s) {
        String dateString = this.getHeaderCaseInsensitive("Date");
        if (dateString == null) {
            return new Date().getTime();
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HEADER_DATE_FORMAT);
        try {
            return dateFormatter.parse(dateString).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date().getTime();
        }
    }

    public String getHeader(String s) {
        return this.getHeaderCaseInsensitive(s);
    }

    public Enumeration<String> getHeaders(String s) {
        String headerValue = this.getHeaderCaseInsensitive(s);
        if (headerValue == null) {
            return Collections.enumeration(new ArrayList());
        }
        ArrayList<String> valueCollection = new ArrayList<String>();
        valueCollection.add(headerValue);
        return Collections.enumeration(valueCollection);
    }

    public Enumeration<String> getHeaderNames() {
        if (this.request.getHeaders() == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.request.getHeaders().keySet());
    }

    public int getIntHeader(String s) {
        String headerValue = this.getHeaderCaseInsensitive(s);
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public String getMethod() {
        return this.request.getHttpMethod();
    }

    public String getPathInfo() {
        String pathInfo = this.getServletPath().replace(this.getContextPath(), "");
        if (!pathInfo.startsWith("/")) {
            pathInfo = "/" + pathInfo;
        }
        return pathInfo;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.request.getRequestContext().getStage();
    }

    public String getQueryString() {
        return this.request.getQueryString().isEmpty() ? null : this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.securityContext.getUserPrincipal().getName();
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return this.securityContext.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this.request.getPath();
    }

    public StringBuffer getRequestURL() {
        String url = "";
        url = url + this.getServerName();
        url = url + "/";
        url = url + this.getContextPath();
        url = url + "/";
        url = url + this.request.getPath();
        url = url.replaceAll("/+", "/");
        return new StringBuffer(this.getScheme() + "://" + url);
    }

    public String getServletPath() {
        return this.request.getPath();
    }

    public HttpSession getSession(boolean b) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return false;
    }

    public void login(String s, String s1) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.multipartFormParameters.values();
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.multipartFormParameters.get(s);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        return null;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        String contentTypeHeader = this.getHeaderCaseInsensitive("Content-Type");
        if (contentTypeHeader == null) {
            return null;
        }
        String[] contentTypeValues = contentTypeHeader.split(HEADER_VALUE_SEPARATOR);
        if (contentTypeValues.length <= 1) {
            return null;
        }
        for (String contentTypeValue : contentTypeValues) {
            if (!contentTypeValue.trim().startsWith(ENCODING_VALUE_KEY)) continue;
            String[] encodingValues = contentTypeValue.split(HEADER_KEY_VALUE_SEPARATOR);
            if (encodingValues.length <= 1) {
                return null;
            }
            return encodingValues[1];
        }
        return null;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        String currentContentType = this.request.getHeaders().get("Content-Type");
        if (currentContentType == null) {
            this.request.getHeaders().put("Content-Type", "; charset=" + s);
            return;
        }
        if (currentContentType.contains(HEADER_VALUE_SEPARATOR)) {
            String[] contentTypeValues = currentContentType.split(HEADER_VALUE_SEPARATOR);
            StringBuilder contentType = new StringBuilder(contentTypeValues[0]);
            for (String contentTypeValue : contentTypeValues) {
                if (contentTypeValue.trim().startsWith(ENCODING_VALUE_KEY)) {
                    contentType.append("; charset=" + s);
                    continue;
                }
                contentType.append("; " + contentTypeValue);
            }
            this.request.getHeaders().put("Content-Type", contentType.toString());
        } else {
            this.request.getHeaders().put("Content-Type", currentContentType + HEADER_VALUE_SEPARATOR + " " + ENCODING_VALUE_KEY + HEADER_KEY_VALUE_SEPARATOR + s);
        }
    }

    public int getContentLength() {
        String headerValue = this.getHeaderCaseInsensitive("Content-Length");
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public long getContentLengthLong() {
        String headerValue = this.getHeaderCaseInsensitive("Content-Length");
        if (headerValue == null) {
            return -1L;
        }
        return Long.parseLong(headerValue);
    }

    public String getContentType() {
        return this.getHeaderCaseInsensitive("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        byte[] bodyBytes = this.request.getBody().getBytes();
        if (this.request.isBase64Encoded()) {
            bodyBytes = Base64.getDecoder().decode(this.request.getBody());
        }
        final ByteArrayInputStream requestBodyStream = new ByteArrayInputStream(bodyBytes);
        return new ServletInputStream(){
            private ReadListener listener;

            public boolean isFinished() {
                return true;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readListener) {
                this.listener = readListener;
                try {
                    this.listener.onDataAvailable();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            public int read() throws IOException {
                int readByte = requestBodyStream.read();
                if (requestBodyStream.available() == 0 && this.listener != null) {
                    this.listener.onAllDataRead();
                }
                return readByte;
            }
        };
    }

    public String getParameter(String s) {
        String queryStringParameter = this.getQueryStringParameterCaseInsensitive(s);
        if (queryStringParameter != null) {
            return queryStringParameter;
        }
        String[] bodyParams = this.getFormBodyParameterCaseInsensitive(s);
        if (bodyParams == null || bodyParams.length == 0) {
            return null;
        }
        return bodyParams[0];
    }

    public Enumeration<String> getParameterNames() {
        ArrayList<String> paramNames = new ArrayList<String>();
        if (this.request.getQueryStringParameters() != null) {
            paramNames.addAll(this.request.getQueryStringParameters().keySet());
        }
        paramNames.addAll(this.urlEncodedFormParameters.keySet());
        return Collections.enumeration(paramNames);
    }

    public String[] getParameterValues(String s) {
        String[] formBodyValues;
        ArrayList<String> values = new ArrayList<String>();
        String queryStringValue = this.getQueryStringParameterCaseInsensitive(s);
        if (queryStringValue != null) {
            values.add(queryStringValue);
        }
        if ((formBodyValues = this.getFormBodyParameterCaseInsensitive(s)) != null) {
            values.addAll(Arrays.asList(formBodyValues));
        }
        if (values.size() == 0) {
            return null;
        }
        String[] valuesArray = new String[values.size()];
        valuesArray = values.toArray(valuesArray);
        return valuesArray;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> output = new HashMap<String, String[]>();
        Map<String, List<String>> params = this.urlEncodedFormParameters;
        if (params == null) {
            params = new HashMap<String, List<String>>();
        }
        if (this.request.getQueryStringParameters() != null) {
            for (Map.Entry<String, Object> entry : this.request.getQueryStringParameters().entrySet()) {
                if (params.containsKey(entry.getKey())) {
                    params.get(entry.getKey()).add((String)entry.getValue());
                    continue;
                }
                ArrayList<Object> valueList = new ArrayList<Object>();
                valueList.add(entry.getValue());
                params.put(entry.getKey(), valueList);
            }
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String[] valuesArray = new String[((List)entry.getValue()).size()];
            valuesArray = ((List)entry.getValue()).toArray(valuesArray);
            output.put(entry.getKey(), valuesArray);
        }
        return output;
    }

    public String getProtocol() {
        return null;
    }

    public String getScheme() {
        String headerValue = this.getHeaderCaseInsensitive(CF_PROTOCOL_HEADER_NAME);
        if (headerValue == null) {
            return "https";
        }
        return headerValue;
    }

    public String getServerName() {
        String name = this.getHeaderCaseInsensitive("Host");
        if (name == null || name.length() == 0) {
            name = "lambda.amazonaws.com";
        }
        return name;
    }

    public int getServerPort() {
        return this.getLocalPort();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new StringReader(this.request.getBody()));
    }

    public String getRemoteAddr() {
        return this.request.getRequestContext().getIdentity().getSourceIp();
    }

    public String getRemoteHost() {
        return this.getHeaderCaseInsensitive("Host");
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public Locale getLocale() {
        String localeHeader = this.getHeaderCaseInsensitive("Accept-Language");
        if (localeHeader == null) {
            return Locale.getDefault();
        }
        if (localeHeader.contains(HEADER_VALUE_SEPARATOR)) {
            localeHeader = localeHeader.split(HEADER_VALUE_SEPARATOR)[0].trim();
        }
        return new Locale(localeHeader);
    }

    public Enumeration<Locale> getLocales() {
        String localeHeader = this.getHeaderCaseInsensitive("Accept-Language");
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (localeHeader == null) {
            locales.add(Locale.getDefault());
        } else if (localeHeader.contains(HEADER_VALUE_SEPARATOR)) {
            for (String locale : localeHeader.split(HEADER_VALUE_SEPARATOR)) {
                locales.add(new Locale(locale.trim()));
            }
        } else {
            locales.add(new Locale(localeHeader.trim()));
        }
        return Collections.enumeration(locales);
    }

    public boolean isSecure() {
        return this.securityContext.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getRealPath(String s) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return "lambda.amazonaws.com";
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        int port = 0;
        if ("https".equals(this.getScheme())) {
            port = 443;
        } else if ("http".equals(this.getScheme())) {
            port = 80;
        }
        return port;
    }

    public ServletContext getServletContext() {
        return AwsProxyServletContext.getInstance(this.request, this.lamdaContext);
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    private String getHeaderCaseInsensitive(String key) {
        if (this.request.getHeaders() == null) {
            return null;
        }
        for (String requestHeaderKey : this.request.getHeaders().keySet()) {
            if (!key.toLowerCase().equals(requestHeaderKey.toLowerCase())) continue;
            return this.request.getHeaders().get(requestHeaderKey);
        }
        return null;
    }

    private String getQueryStringParameterCaseInsensitive(String key) {
        if (this.request.getQueryStringParameters() == null) {
            return null;
        }
        for (String requestParamKey : this.request.getQueryStringParameters().keySet()) {
            if (!key.toLowerCase().equals(requestParamKey.toLowerCase())) continue;
            return this.request.getQueryStringParameters().get(requestParamKey);
        }
        return null;
    }

    private String[] getFormBodyParameterCaseInsensitive(String key) {
        List<String> values = this.urlEncodedFormParameters.get(key);
        if (values != null) {
            String[] valuesArray = new String[values.size()];
            valuesArray = values.toArray(valuesArray);
            return valuesArray;
        }
        return null;
    }

    private Map<String, Part> getMultipartFormParametersMap() {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)this)) {
            return new HashMap<String, Part>();
        }
        TreeMap<String, Part> output = new TreeMap<String, Part>(String.CASE_INSENSITIVE_ORDER);
        ServletFileUpload upload = new ServletFileUpload();
        try {
            List items = upload.parseRequest((HttpServletRequest)this);
            for (FileItem item : items) {
                AwsProxyRequestPart newPart = new AwsProxyRequestPart(item.get());
                newPart.setName(item.getName());
                newPart.setSubmittedFileName(item.getFieldName());
                newPart.setContentType(item.getContentType());
                newPart.setSize(item.getSize());
                Iterator headerNamesIterator = item.getHeaders().getHeaderNames();
                while (headerNamesIterator.hasNext()) {
                    String headerName = (String)headerNamesIterator.next();
                    Iterator headerValuesIterator = item.getHeaders().getHeaders(headerName);
                    while (headerValuesIterator.hasNext()) {
                        newPart.addHeader(headerName, (String)headerValuesIterator.next());
                    }
                }
                output.put(item.getFieldName(), newPart);
            }
        }
        catch (FileUploadException e) {
            e.printStackTrace();
        }
        return output;
    }

    private Map<String, List<String>> getFormUrlEncodedParametersMap() {
        String rawBodyContent;
        String contentType = this.getContentType();
        if (contentType == null) {
            return new HashMap<String, List<String>>();
        }
        if (!contentType.startsWith("application/x-www-form-urlencoded") || !this.getMethod().toLowerCase().equals("post")) {
            return new HashMap<String, List<String>>();
        }
        try {
            rawBodyContent = URLDecoder.decode(this.request.getBody(), DEFAULT_CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            rawBodyContent = this.request.getBody();
        }
        TreeMap<String, List<String>> output = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String parameter : rawBodyContent.split(FORM_DATA_SEPARATOR)) {
            String[] parameterKeyValue = parameter.split(HEADER_KEY_VALUE_SEPARATOR);
            if (parameterKeyValue.length < 2) continue;
            List<String> values = new ArrayList<String>();
            if (output.containsKey(parameterKeyValue[0])) {
                values = (List)output.get(parameterKeyValue[0]);
            }
            values.add(parameterKeyValue[1]);
            output.put(parameterKeyValue[0], values);
        }
        return output;
    }
}

