/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.InvalidResponseObjectException;
import com.amazonaws.serverless.proxy.internal.ResponseWriter;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.Base64;

public class AwsProxyHttpServletResponseWriter
extends ResponseWriter<AwsHttpServletResponse, AwsProxyResponse> {
    @Override
    public AwsProxyResponse writeResponse(AwsHttpServletResponse containerResponse, Context lambdaContext) throws InvalidResponseObjectException {
        AwsProxyResponse awsProxyResponse = new AwsProxyResponse();
        if (containerResponse.getAwsResponseBodyString() != null) {
            String responseString;
            if (this.isValidUtf8(containerResponse.getAwsResponseBodyBytes())) {
                responseString = containerResponse.getAwsResponseBodyString();
            } else {
                responseString = Base64.getMimeEncoder().encodeToString(containerResponse.getAwsResponseBodyBytes());
                awsProxyResponse.setBase64Encoded(true);
            }
            awsProxyResponse.setBody(responseString);
        }
        awsProxyResponse.setHeaders(containerResponse.getAwsResponseHeaders());
        if (containerResponse.getStatus() <= 0) {
            awsProxyResponse.setStatusCode(200);
        } else {
            awsProxyResponse.setStatusCode(containerResponse.getStatus());
        }
        return awsProxyResponse;
    }
}

