/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyRequestDispatcher;
import com.amazonaws.serverless.proxy.internal.servlet.FilterHolder;
import com.amazonaws.services.lambda.runtime.Context;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;

public class AwsServletContext
implements ServletContext {
    public static final int SERVLET_API_MAJOR_VERSION = 3;
    public static final int SERVLET_API_MINOR_VERSION = 1;
    public static final String SERVER_INFO = "aws-serverless-java-container/3.1";
    private Map<String, FilterHolder> filters;
    private Context lambdaContext;
    private Map<String, Object> attributes;
    private Map<String, String> initParameters;
    private AwsLambdaServletContainerHandler containerHandler;
    private static AwsServletContext instance;

    public AwsServletContext(Context lambdaContext, AwsLambdaServletContainerHandler containerHandler) {
        this.lambdaContext = lambdaContext;
        this.containerHandler = containerHandler;
        this.attributes = new HashMap<String, Object>();
        this.initParameters = new HashMap<String, String>();
        this.filters = new LinkedHashMap<String, FilterHolder>();
    }

    public static void clearServletContextCache() {
        instance = null;
    }

    public String getContextPath() {
        return "/";
    }

    public ServletContext getContext(String s) {
        return this;
    }

    public int getMajorVersion() {
        return 3;
    }

    public int getMinorVersion() {
        return 1;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 1;
    }

    public String getMimeType(String s) {
        try {
            return Files.probeContentType(Paths.get(s, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Set<String> getResourcePaths(String s) {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String s) throws MalformedURLException {
        return this.getClass().getResource(s);
    }

    public InputStream getResourceAsStream(String s) {
        return this.getClass().getResourceAsStream(s);
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return new AwsProxyRequestDispatcher(s, this.containerHandler);
    }

    public RequestDispatcher getNamedDispatcher(String s) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Servlet getServlet(String s) throws ServletException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        throw new UnsupportedOperationException();
    }

    public void log(String s) {
        this.lambdaContext.getLogger().log(s);
    }

    @Deprecated
    public void log(Exception e, String s) {
        this.lambdaContext.getLogger().log(s);
        this.lambdaContext.getLogger().log(e.getMessage());
    }

    public void log(String s, Throwable throwable) {
        this.lambdaContext.getLogger().log(s);
        this.lambdaContext.getLogger().log(throwable.getMessage());
    }

    public String getRealPath(String s) {
        String absPath = null;
        URL fileUrl = ClassLoader.getSystemResource(s);
        if (fileUrl != null) {
            try {
                absPath = new File(fileUrl.toURI()).getAbsolutePath();
            }
            catch (URISyntaxException e) {
                this.lambdaContext.getLogger().log("Error while looking for real path: " + s + "\n" + e.getMessage());
            }
        }
        return absPath;
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public String getInitParameter(String s) {
        return this.initParameters.get(s);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public boolean setInitParameter(String s, String s1) {
        this.initParameters.put(s, s1);
        return true;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public String getServletContextName() {
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String s, String s1) {
        this.log("Called addServlet: " + s1);
        this.log("Implemented frameworks are responsible for registering servlets");
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String s, Servlet servlet) {
        this.log("Called addServlet: " + servlet.getClass().getName());
        this.log("Implemented frameworks are responsible for registering servlets");
        throw new UnsupportedOperationException();
    }

    public ServletRegistration.Dynamic addServlet(String s, Class<? extends Servlet> aClass) {
        this.log("Called addServlet: " + aClass.getName());
        this.log("Implemented frameworks are responsible for registering servlets");
        throw new UnsupportedOperationException();
    }

    public <T extends Servlet> T createServlet(Class<T> aClass) throws ServletException {
        this.log("Called createServlet: " + aClass.getName());
        this.log("Implemented frameworks are responsible for creating servlets");
        throw new UnsupportedOperationException();
    }

    public ServletRegistration getServletRegistration(String s) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String name, String filterClass) {
        try {
            Class<Filter> newFilterClass = this.getClassLoader().loadClass(filterClass);
            if (!newFilterClass.isAssignableFrom(Filter.class)) {
                throw new IllegalArgumentException(filterClass + " does not implement Filter");
            }
            Class<Filter> filterCastClass = newFilterClass;
            return this.addFilter(name, filterCastClass);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalStateException("Filter class " + filterClass + " not found");
        }
    }

    public FilterRegistration.Dynamic addFilter(String name, Filter filter) {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("Missing filter name");
        }
        if (this.filters.containsKey(name)) {
            return null;
        }
        FilterHolder newFilter = new FilterHolder(name, filter, this);
        this.filters.put(newFilter.getFilterName(), newFilter);
        return newFilter.getRegistration();
    }

    public FilterRegistration.Dynamic addFilter(String name, Class<? extends Filter> filterClass) {
        try {
            Filter newFilter = this.createFilter(filterClass);
            return this.addFilter(name, newFilter);
        }
        catch (ServletException e) {
            this.lambdaContext.getLogger().log("Could not register filter: " + e.getMessage());
            return null;
        }
    }

    public <T extends Filter> T createFilter(Class<T> aClass) throws ServletException {
        try {
            return (T)((Filter)aClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.lambdaContext.getLogger().log("Could not initialize filter class " + aClass.getName() + "\n" + e.getMessage());
            throw new ServletException();
        }
    }

    public FilterRegistration getFilterRegistration(String s) {
        if (!this.filters.containsKey(s)) {
            return null;
        }
        return this.filters.get(s).getRegistration();
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        LinkedHashMap<String, FilterHolder.Registration> registrations = new LinkedHashMap<String, FilterHolder.Registration>();
        for (String filter : this.filters.keySet()) {
            registrations.put(filter, this.filters.get(filter).getRegistration());
        }
        return registrations;
    }

    Map<String, FilterHolder> getFilterHolders() {
        return this.filters;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String s) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public void addListener(Class<? extends EventListener> aClass) {
    }

    public <T extends EventListener> T createListener(Class<T> aClass) throws ServletException {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public void declareRoles(String ... strings) {
    }

    public String getVirtualServerName() {
        return null;
    }
}

