/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.FilterHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterChainHolder
implements FilterChain {
    private List<FilterHolder> filters;
    private int currentFilter;

    public FilterChainHolder() {
        this(new ArrayList<FilterHolder>());
    }

    public FilterChainHolder(List<FilterHolder> allFilters) {
        this.filters = allFilters;
        this.currentFilter = -1;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        ++this.currentFilter;
        if (this.filters == null || this.filters.size() == 0 || this.currentFilter > this.filters.size() - 1) {
            return;
        }
        FilterHolder holder = this.filters.get(this.currentFilter);
        if (!holder.isFilterInitialized()) {
            holder.init();
        }
        holder.getFilter().doFilter(servletRequest, servletResponse, (FilterChain)this);
    }

    public void addFilter(FilterHolder newFilter) {
        this.filters.add(newFilter);
    }

    public int filterCount() {
        if (this.filters == null) {
            return 0;
        }
        return this.filters.size();
    }

    public FilterHolder getFilter(int idx) {
        if (this.filters == null) {
            return null;
        }
        return this.filters.get(idx);
    }
}

