/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.testutils;

import com.amazonaws.serverless.proxy.internal.model.ApiGatewayAuthorizerContext;
import com.amazonaws.serverless.proxy.internal.model.ApiGatewayRequestContext;
import com.amazonaws.serverless.proxy.internal.model.ApiGatewayRequestIdentity;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.internal.model.CognitoAuthorizerClaims;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;

public class AwsProxyRequestBuilder {
    private AwsProxyRequest request;
    private ObjectMapper mapper = new ObjectMapper();

    public AwsProxyRequestBuilder() {
        this(null, null);
    }

    public AwsProxyRequestBuilder(String path) {
        this(path, null);
    }

    public AwsProxyRequestBuilder(String path, String httpMethod) {
        this.request = new AwsProxyRequest();
        this.request.setHttpMethod(httpMethod);
        this.request.setPath(path);
        this.request.setQueryStringParameters(new HashMap<String, String>());
        this.request.setRequestContext(new ApiGatewayRequestContext());
        this.request.getRequestContext().setStage("test");
        ApiGatewayRequestIdentity identity = new ApiGatewayRequestIdentity();
        identity.setSourceIp("127.0.0.1");
        this.request.getRequestContext().setIdentity(identity);
    }

    public AwsProxyRequestBuilder stage(String stageName) {
        this.request.getRequestContext().setStage(stageName);
        return this;
    }

    public AwsProxyRequestBuilder method(String httpMethod) {
        this.request.setHttpMethod(httpMethod);
        return this;
    }

    public AwsProxyRequestBuilder path(String path) {
        this.request.setPath(path);
        return this;
    }

    public AwsProxyRequestBuilder json() {
        return this.header("Content-Type", "application/json");
    }

    public AwsProxyRequestBuilder form(String key, String value) {
        if (this.request.getHeaders() == null) {
            this.request.setHeaders(new HashMap<String, String>());
        }
        this.request.getHeaders().put("Content-Type", "application/x-www-form-urlencoded");
        String body = this.request.getBody();
        if (body == null) {
            body = "";
        }
        body = body + (body.equals("") ? "" : "&") + key + "=" + value;
        this.request.setBody(body);
        return this;
    }

    public AwsProxyRequestBuilder header(String key, String value) {
        if (this.request.getHeaders() == null) {
            this.request.setHeaders(new HashMap<String, String>());
        }
        this.request.getHeaders().put(key, value);
        return this;
    }

    public AwsProxyRequestBuilder queryString(String key, String value) {
        if (this.request.getQueryStringParameters() == null) {
            this.request.setQueryStringParameters(new HashMap<String, String>());
        }
        this.request.getQueryStringParameters().put(key, value);
        return this;
    }

    public AwsProxyRequestBuilder body(String body) {
        this.request.setBody(body);
        return this;
    }

    public AwsProxyRequestBuilder body(Object body) {
        if (this.request.getHeaders() != null && this.request.getHeaders().get("Content-Type").equals("application/json")) {
            try {
                return this.body(this.mapper.writeValueAsString(body));
            }
            catch (JsonProcessingException e) {
                throw new UnsupportedOperationException("Could not serialize object: " + e.getMessage());
            }
        }
        throw new UnsupportedOperationException("Unsupported content type in request");
    }

    public AwsProxyRequestBuilder binaryBody(InputStream is) throws IOException {
        this.request.setIsBase64Encoded(true);
        return this.body(Base64.getMimeEncoder().encodeToString(IOUtils.toByteArray((InputStream)is)));
    }

    public AwsProxyRequestBuilder authorizerPrincipal(String principal) {
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setPrincipalId(principal);
        return this;
    }

    public AwsProxyRequestBuilder authorizerContextValue(String key, String value) {
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setContextValue(key, value);
        return this;
    }

    public AwsProxyRequestBuilder cognitoUserPool(String identityId) {
        this.request.getRequestContext().getIdentity().setCognitoAuthenticationType("POOL");
        this.request.getRequestContext().getIdentity().setCognitoIdentityId(identityId);
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setClaims(new CognitoAuthorizerClaims());
        this.request.getRequestContext().getAuthorizer().getClaims().setSubject(identityId);
        return this;
    }

    public AwsProxyRequestBuilder cognitoIdentity(String identityId, String identityPoolId) {
        this.request.getRequestContext().getIdentity().setCognitoAuthenticationType("IDENTITY");
        this.request.getRequestContext().getIdentity().setCognitoIdentityId(identityId);
        this.request.getRequestContext().getIdentity().setCognitoIdentityPoolId(identityPoolId);
        return this;
    }

    public AwsProxyRequestBuilder cookie(String name, String value) {
        String cookies;
        if (this.request.getHeaders() == null) {
            this.request.setHeaders(new HashMap<String, String>());
        }
        if ((cookies = this.request.getHeaders().get("Cookie")) == null) {
            cookies = "";
        }
        cookies = cookies + (cookies.equals("") ? "" : "; ") + name + "=" + value;
        this.request.getHeaders().put("Cookie", cookies);
        return this;
    }

    public AwsProxyRequestBuilder scheme(String scheme) {
        if (this.request.getHeaders() == null) {
            this.request.setHeaders(new HashMap<String, String>());
        }
        this.request.getHeaders().put("CloudFront-Forwarded-Proto", scheme);
        return this;
    }

    public AwsProxyRequestBuilder serverName(String serverName) {
        if (this.request.getHeaders() == null) {
            this.request.setHeaders(new HashMap<String, String>());
        }
        this.request.getHeaders().put("Host", serverName);
        return this;
    }

    public AwsProxyRequestBuilder fromJsonString(String jsonContent) throws IOException {
        this.request = (AwsProxyRequest)this.mapper.readValue(jsonContent, AwsProxyRequest.class);
        return this;
    }

    public AwsProxyRequestBuilder fromJsonPath(String filePath) throws IOException {
        this.request = (AwsProxyRequest)this.mapper.readValue(new File(filePath), AwsProxyRequest.class);
        return this;
    }

    public AwsProxyRequest build() {
        return this.request;
    }
}

