/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal;

import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.CountDownLatch;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LambdaContainerHandler<RequestType, ResponseType, ContainerRequestType, ContainerResponseType> {
    public static final String SERVER_INFO = "aws-serverless-java-container";
    private RequestReader<RequestType, ContainerRequestType> requestReader;
    private ResponseWriter<ContainerResponseType, ResponseType> responseWriter;
    private SecurityContextWriter<RequestType> securityContextWriter;
    private ExceptionHandler<ResponseType> exceptionHandler;
    protected Context lambdaContext;
    private Logger log = LoggerFactory.getLogger(LambdaContainerHandler.class);
    private static ContainerConfig config = ContainerConfig.defaultConfig();
    private static volatile ObjectMapper objectMapper;

    protected LambdaContainerHandler(RequestReader<RequestType, ContainerRequestType> requestReader, ResponseWriter<ContainerResponseType, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler) {
        this.log.info("Starting Lambda Container Handler");
        this.requestReader = requestReader;
        this.responseWriter = responseWriter;
        this.securityContextWriter = securityContextWriter;
        this.exceptionHandler = exceptionHandler;
    }

    protected abstract ContainerResponseType getContainerResponse(ContainerRequestType var1, CountDownLatch var2);

    protected abstract void handleRequest(ContainerRequestType var1, ContainerResponseType var2, Context var3) throws Exception;

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
        }
        return objectMapper;
    }

    public void stripBasePath(String basePath) {
        config.setStripBasePath(true);
        config.setServiceBasePath(basePath);
    }

    public ResponseType proxy(RequestType request, Context context) {
        this.lambdaContext = context;
        try {
            SecurityContext securityContext = this.securityContextWriter.writeSecurityContext(request, context);
            CountDownLatch latch = new CountDownLatch(1);
            ContainerRequestType containerRequest = this.requestReader.readRequest(request, securityContext, context, config);
            ContainerResponseType containerResponse = this.getContainerResponse(containerRequest, latch);
            this.handleRequest(containerRequest, containerResponse, context);
            latch.await();
            return this.responseWriter.writeResponse(containerResponse, context);
        }
        catch (Exception e) {
            this.log.error("Error while handling request", (Throwable)e);
            return this.exceptionHandler.handle(e);
        }
    }

    public static ContainerConfig getContainerConfig() {
        return config;
    }
}

