/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyRequestPart;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsProxyHttpServletRequest
extends AwsHttpServletRequest {
    private AwsProxyRequest request;
    private SecurityContext securityContext;
    private Map<String, List<String>> urlEncodedFormParameters;
    private Map<String, Part> multipartFormParameters;
    private static Logger log = LoggerFactory.getLogger(AwsProxyHttpServletRequest.class);
    private ContainerConfig config;

    public AwsProxyHttpServletRequest(AwsProxyRequest awsProxyRequest, Context lambdaContext, SecurityContext awsSecurityContext) {
        this(awsProxyRequest, lambdaContext, awsSecurityContext, ContainerConfig.defaultConfig());
    }

    public AwsProxyHttpServletRequest(AwsProxyRequest awsProxyRequest, Context lambdaContext, SecurityContext awsSecurityContext, ContainerConfig config) {
        super(lambdaContext);
        this.request = awsProxyRequest;
        this.securityContext = awsSecurityContext;
        this.config = config;
        this.urlEncodedFormParameters = this.getFormUrlEncodedParametersMap();
        this.multipartFormParameters = this.getMultipartFormParametersMap();
    }

    public AwsProxyRequest getAwsProxyRequest() {
        return this.request;
    }

    public String getAuthType() {
        return this.securityContext.getAuthenticationScheme();
    }

    public Cookie[] getCookies() {
        String cookieHeader = this.getHeaderCaseInsensitive("Cookie");
        if (cookieHeader == null) {
            return new Cookie[0];
        }
        return this.parseCookieHeaderValue(cookieHeader);
    }

    public long getDateHeader(String s) {
        String dateString = this.getHeaderCaseInsensitive("Date");
        if (dateString == null) {
            return new Date().getTime();
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z");
        try {
            return dateFormatter.parse(dateString).getTime();
        }
        catch (ParseException e) {
            log.error("Could not parse date header", (Throwable)e);
            return new Date().getTime();
        }
    }

    public String getHeader(String s) {
        return this.getHeaderCaseInsensitive(s);
    }

    public Enumeration<String> getHeaders(String s) {
        String headerValue = this.getHeaderCaseInsensitive(s);
        if (headerValue == null) {
            return Collections.enumeration(new ArrayList());
        }
        ArrayList<String> valueCollection = new ArrayList<String>();
        valueCollection.add(headerValue);
        return Collections.enumeration(valueCollection);
    }

    public Enumeration<String> getHeaderNames() {
        if (this.request.getHeaders() == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.request.getHeaders().keySet());
    }

    public int getIntHeader(String s) {
        String headerValue = this.getHeaderCaseInsensitive(s);
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public String getMethod() {
        return this.request.getHttpMethod();
    }

    public String getPathInfo() {
        String pathInfo = this.cleanUri(this.request.getPath());
        return this.decodeRequestPath(pathInfo, LambdaContainerHandler.getContainerConfig());
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        if (this.config.isUseStageAsServletContext()) {
            String contextPath = this.cleanUri(this.request.getRequestContext().getStage());
            if (this.config.getServiceBasePath() != null) {
                contextPath = contextPath + this.cleanUri(this.config.getServiceBasePath());
            }
            return contextPath;
        }
        return "" + (this.config.getServiceBasePath() != null ? this.cleanUri(this.config.getServiceBasePath()) : "");
    }

    public String getQueryString() {
        return this.generateQueryString(this.request.getQueryStringParameters());
    }

    public String getRemoteUser() {
        return this.securityContext.getUserPrincipal().getName();
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return this.securityContext.getUserPrincipal();
    }

    public String getRequestURI() {
        return this.cleanUri(this.getContextPath()) + this.cleanUri(this.request.getPath());
    }

    public StringBuffer getRequestURL() {
        String url = "";
        url = url + this.getServerName();
        url = url + this.cleanUri(this.getContextPath());
        url = url + this.cleanUri(this.request.getPath());
        return new StringBuffer(this.getScheme() + "://" + url);
    }

    public String getServletPath() {
        return "";
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String s, String s1) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.multipartFormParameters.values();
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.multipartFormParameters.get(s);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        return null;
    }

    public String getCharacterEncoding() {
        String contentTypeHeader = this.getHeaderCaseInsensitive("Content-Type");
        if (contentTypeHeader == null) {
            return null;
        }
        String[] contentTypeValues = contentTypeHeader.split(";");
        if (contentTypeValues.length <= 1) {
            return null;
        }
        for (String contentTypeValue : contentTypeValues) {
            if (!contentTypeValue.trim().startsWith("charset")) continue;
            String[] encodingValues = contentTypeValue.split("=");
            if (encodingValues.length <= 1) {
                return null;
            }
            return encodingValues[1];
        }
        return null;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        String currentContentType = this.request.getHeaders().get("Content-Type");
        if (currentContentType == null) {
            this.request.getHeaders().put("Content-Type", "; charset=" + s);
            return;
        }
        if (currentContentType.contains(";")) {
            String[] contentTypeValues = currentContentType.split(";");
            StringBuilder contentType = new StringBuilder(contentTypeValues[0]);
            for (String contentTypeValue : contentTypeValues) {
                String contentTypeString = "; " + contentTypeValue;
                if (contentTypeValue.trim().startsWith("charset")) {
                    contentTypeString = "; charset=" + s;
                }
                contentType.append(contentTypeString);
            }
            this.request.getHeaders().put("Content-Type", contentType.toString());
        } else {
            this.request.getHeaders().put("Content-Type", currentContentType + ";" + " " + "charset" + "=" + s);
        }
    }

    public int getContentLength() {
        String headerValue = this.getHeaderCaseInsensitive("Content-Length");
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public long getContentLengthLong() {
        String headerValue = this.getHeaderCaseInsensitive("Content-Length");
        if (headerValue == null) {
            return -1L;
        }
        return Long.parseLong(headerValue);
    }

    public String getContentType() {
        return this.getHeaderCaseInsensitive("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.request.getBody() == null) {
            return null;
        }
        byte[] bodyBytes = null;
        bodyBytes = this.request.isBase64Encoded() ? Base64.getMimeDecoder().decode(this.request.getBody()) : this.request.getBody().getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream requestBodyStream = new ByteArrayInputStream(bodyBytes);
        return new AwsServletInputStream(requestBodyStream);
    }

    public String getParameter(String s) {
        String queryStringParameter = this.getQueryStringParameterCaseInsensitive(s);
        if (queryStringParameter != null) {
            return queryStringParameter;
        }
        String[] bodyParams = this.getFormBodyParameterCaseInsensitive(s);
        if (bodyParams == null || bodyParams.length == 0) {
            return null;
        }
        return bodyParams[0];
    }

    public Enumeration<String> getParameterNames() {
        ArrayList<String> paramNames = new ArrayList<String>();
        if (this.request.getQueryStringParameters() != null) {
            paramNames.addAll(this.request.getQueryStringParameters().keySet());
        }
        paramNames.addAll(this.urlEncodedFormParameters.keySet());
        return Collections.enumeration(paramNames);
    }

    public String[] getParameterValues(String s) {
        String[] formBodyValues;
        ArrayList<String> values = new ArrayList<String>();
        String queryStringValue = this.getQueryStringParameterCaseInsensitive(s);
        if (queryStringValue != null) {
            values.add(queryStringValue);
        }
        if ((formBodyValues = this.getFormBodyParameterCaseInsensitive(s)) != null) {
            values.addAll(Arrays.asList(formBodyValues));
        }
        if (values.size() == 0) {
            return new String[0];
        }
        String[] valuesArray = new String[values.size()];
        valuesArray = values.toArray(valuesArray);
        return valuesArray;
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> output = new HashMap<String, String[]>();
        Map<String, List<String>> params = this.urlEncodedFormParameters;
        if (params == null) {
            params = new HashMap<String, List<String>>();
        }
        if (this.request.getQueryStringParameters() != null) {
            for (Map.Entry<String, Object> entry : this.request.getQueryStringParameters().entrySet()) {
                if (params.containsKey(entry.getKey()) && !params.get(entry.getKey()).contains(entry.getValue())) {
                    params.get(entry.getKey()).add((String)entry.getValue());
                    continue;
                }
                ArrayList<Object> valueList = new ArrayList<Object>();
                valueList.add(entry.getValue());
                params.put(entry.getKey(), valueList);
            }
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String[] valuesArray = new String[((List)entry.getValue()).size()];
            valuesArray = ((List)entry.getValue()).toArray(valuesArray);
            output.put(entry.getKey(), valuesArray);
        }
        return output;
    }

    public String getProtocol() {
        return null;
    }

    public String getScheme() {
        String headerValue = this.getHeaderCaseInsensitive("CloudFront-Forwarded-Proto");
        if (headerValue == null) {
            return "https";
        }
        return headerValue;
    }

    @Override
    public String getServerName() {
        String name = this.getHeaderCaseInsensitive("Host");
        if (name == null || name.length() == 0) {
            name = "lambda.amazonaws.com";
        }
        return name;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new StringReader(this.request.getBody()));
    }

    public String getRemoteAddr() {
        return this.request.getRequestContext().getIdentity().getSourceIp();
    }

    public String getRemoteHost() {
        return this.getHeaderCaseInsensitive("Host");
    }

    public Locale getLocale() {
        List<Map.Entry<String, String>> values = this.parseHeaderValue(this.getHeaderCaseInsensitive("Accept-Language"));
        if (values.size() == 0) {
            return Locale.getDefault();
        }
        return new Locale(values.get(0).getValue());
    }

    public Enumeration<Locale> getLocales() {
        List<Map.Entry<String, String>> values = this.parseHeaderValue(this.getHeaderCaseInsensitive("Accept-Language"));
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (values.size() == 0) {
            locales.add(Locale.getDefault());
        } else {
            for (Map.Entry<String, String> locale : values) {
                locales.add(new Locale(locale.getValue()));
            }
        }
        return Collections.enumeration(locales);
    }

    public boolean isSecure() {
        return this.securityContext.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.getServletContext().getRequestDispatcher(s);
    }

    @Deprecated
    public String getRealPath(String s) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    private String getHeaderCaseInsensitive(String key) {
        if (this.request.getHeaders() == null) {
            return null;
        }
        for (String requestHeaderKey : this.request.getHeaders().keySet()) {
            if (!key.toLowerCase(Locale.ENGLISH).equals(requestHeaderKey.toLowerCase(Locale.ENGLISH))) continue;
            return this.request.getHeaders().get(requestHeaderKey);
        }
        return null;
    }

    private String getQueryStringParameterCaseInsensitive(String key) {
        if (this.request.getQueryStringParameters() == null) {
            return null;
        }
        for (String requestParamKey : this.request.getQueryStringParameters().keySet()) {
            if (!key.toLowerCase(Locale.ENGLISH).equals(requestParamKey.toLowerCase(Locale.ENGLISH))) continue;
            return this.request.getQueryStringParameters().get(requestParamKey);
        }
        return null;
    }

    private String[] getFormBodyParameterCaseInsensitive(String key) {
        List<String> values = this.urlEncodedFormParameters.get(key);
        if (values != null) {
            String[] valuesArray = new String[values.size()];
            valuesArray = values.toArray(valuesArray);
            return valuesArray;
        }
        return new String[0];
    }

    @SuppressFBWarnings(value={"FILE_UPLOAD_FILENAME"})
    private Map<String, Part> getMultipartFormParametersMap() {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)this)) {
            return new HashMap<String, Part>();
        }
        Timer.start("SERVLET_REQUEST_GET_MULTIPART_PARAMS");
        TreeMap<String, Part> output = new TreeMap<String, Part>(String.CASE_INSENSITIVE_ORDER);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        try {
            List items = upload.parseRequest((HttpServletRequest)this);
            for (FileItem item : items) {
                String fileName = SecurityUtils.getValidFilePath(item.getName(), true);
                AwsProxyRequestPart newPart = new AwsProxyRequestPart(item.get());
                newPart.setName(fileName);
                newPart.setSubmittedFileName(item.getFieldName());
                newPart.setContentType(item.getContentType());
                newPart.setSize(item.getSize());
                Iterator headerNamesIterator = item.getHeaders().getHeaderNames();
                while (headerNamesIterator.hasNext()) {
                    String headerName = (String)headerNamesIterator.next();
                    Iterator headerValuesIterator = item.getHeaders().getHeaders(headerName);
                    while (headerValuesIterator.hasNext()) {
                        newPart.addHeader(headerName, (String)headerValuesIterator.next());
                    }
                }
                output.put(item.getFieldName(), newPart);
            }
        }
        catch (FileUploadException e) {
            Timer.stop("SERVLET_REQUEST_GET_MULTIPART_PARAMS");
            log.error("Could not read multipart upload file", (Throwable)e);
        }
        Timer.stop("SERVLET_REQUEST_GET_MULTIPART_PARAMS");
        return output;
    }

    private String cleanUri(String uri) {
        String finalUri = uri;
        if (!finalUri.startsWith("/")) {
            finalUri = "/" + finalUri;
        }
        if (finalUri.endsWith("/")) {
            finalUri = finalUri.substring(0, finalUri.length() - 1);
        }
        finalUri = finalUri.replaceAll("/+", "/");
        return finalUri;
    }

    private Map<String, List<String>> getFormUrlEncodedParametersMap() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return new HashMap<String, List<String>>();
        }
        if (!contentType.startsWith("application/x-www-form-urlencoded") || !this.getMethod().toLowerCase(Locale.ENGLISH).equals("post")) {
            return new HashMap<String, List<String>>();
        }
        Timer.start("SERVLET_REQUEST_GET_FORM_PARAMS");
        String rawBodyContent = this.request.getBody();
        TreeMap<String, List<String>> output = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String parameter : rawBodyContent.split("&")) {
            String[] parameterKeyValue = parameter.split("=");
            if (parameterKeyValue.length < 2) continue;
            List<String> values = new ArrayList<String>();
            if (output.containsKey(parameterKeyValue[0])) {
                values = (List)output.get(parameterKeyValue[0]);
            }
            values.add(AwsProxyHttpServletRequest.decodeValueIfEncoded(parameterKeyValue[1]));
            output.put(AwsProxyHttpServletRequest.decodeValueIfEncoded(parameterKeyValue[0]), values);
        }
        Timer.stop("SERVLET_REQUEST_GET_FORM_PARAMS");
        return output;
    }

    public static String decodeValueIfEncoded(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, LambdaContainerHandler.getContainerConfig().getUriEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Could not decode body content - proceeding as if it was already decoded", (Throwable)e);
            return value;
        }
    }

    public static class AwsServletInputStream
    extends ServletInputStream {
        private InputStream bodyStream;
        private ReadListener listener;

        public AwsServletInputStream(InputStream body) {
            this.bodyStream = body;
        }

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            this.listener = readListener;
            try {
                this.listener.onDataAvailable();
            }
            catch (IOException e) {
                log.error("Data not available on input stream", (Throwable)e);
            }
        }

        public int read() throws IOException {
            int readByte = this.bodyStream.read();
            if (this.bodyStream.available() == 0 && this.listener != null) {
                this.listener.onAllDataRead();
            }
            return readByte;
        }
    }
}

