/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.LogFormatter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.SecurityContext;

public class ApacheCombinedServletLogFormatter<ContainerRequestType extends HttpServletRequest, ContainerResponseType extends HttpServletResponse>
implements LogFormatter<ContainerRequestType, ContainerResponseType> {
    DateTimeFormatter dateFormat = new DateTimeFormatterBuilder().parseCaseInsensitive().appendLiteral("[").appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral("/").appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral("/").appendValue(ChronoField.YEAR, 4).appendLiteral(":").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendOffset("+HHMM", "Z").optionalEnd().appendLiteral("]").toFormatter();

    @Override
    @SuppressFBWarnings(value={"SERVLET_HEADER_REFERER", "SERVLET_HEADER_USER_AGENT"})
    public String format(ContainerRequestType servletRequest, ContainerResponseType servletResponse, SecurityContext ctx) {
        StringBuilder logLineBuilder = new StringBuilder();
        ApiGatewayRequestContext gatewayContext = (ApiGatewayRequestContext)servletRequest.getAttribute("com.amazonaws.apigateway.request.context");
        logLineBuilder.append(servletRequest.getRemoteAddr());
        logLineBuilder.append(" ");
        if (gatewayContext != null) {
            if (gatewayContext.getIdentity().getUserArn() != null) {
                logLineBuilder.append(gatewayContext.getIdentity().getUserArn());
            } else {
                logLineBuilder.append("-");
            }
        } else {
            logLineBuilder.append("-");
        }
        logLineBuilder.append(" ");
        if (ctx != null && ctx.getUserPrincipal().getName() != null) {
            logLineBuilder.append(ctx.getUserPrincipal().getName());
            logLineBuilder.append(" ");
        }
        if (gatewayContext != null) {
            logLineBuilder.append(this.dateFormat.format(ZonedDateTime.of(LocalDateTime.ofEpochSecond(gatewayContext.getRequestTimeEpoch() / 1000L, 0, ZoneOffset.UTC), ZoneId.systemDefault())));
        } else {
            logLineBuilder.append(this.dateFormat.format(ZonedDateTime.now()));
        }
        logLineBuilder.append(" ");
        logLineBuilder.append("\"");
        logLineBuilder.append(servletRequest.getMethod().toUpperCase(Locale.ENGLISH));
        logLineBuilder.append(" ");
        logLineBuilder.append(servletRequest.getPathInfo());
        logLineBuilder.append(" ");
        logLineBuilder.append(servletRequest.getProtocol());
        logLineBuilder.append("\" ");
        logLineBuilder.append(servletResponse.getStatus());
        logLineBuilder.append(" ");
        if (servletResponse instanceof AwsHttpServletResponse) {
            AwsHttpServletResponse awsResponse = (AwsHttpServletResponse)servletResponse;
            if (awsResponse.getAwsResponseBodyBytes().length > 0) {
                logLineBuilder.append(awsResponse.getAwsResponseBodyBytes().length);
            } else {
                logLineBuilder.append("-");
            }
        } else {
            logLineBuilder.append("-");
        }
        logLineBuilder.append(" ");
        logLineBuilder.append("\"");
        if (servletRequest.getHeader("referer") != null) {
            logLineBuilder.append(servletRequest.getHeader("referer"));
        } else {
            logLineBuilder.append("-");
        }
        logLineBuilder.append("\" ");
        logLineBuilder.append("\"");
        if (servletRequest.getHeader("user-agent") != null) {
            logLineBuilder.append(servletRequest.getHeader("user-agent"));
        } else {
            logLineBuilder.append("-");
        }
        logLineBuilder.append("\" ");
        logLineBuilder.append("combined");
        return logLineBuilder.toString();
    }
}

