/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.jaxrs;

import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.CognitoAuthorizerClaims;
import com.amazonaws.services.lambda.runtime.Context;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;

public class AwsProxySecurityContext
implements SecurityContext {
    static final String AUTH_SCHEME_CUSTOM = "CUSTOM_AUTHORIZER";
    static final String AUTH_SCHEME_COGNITO_POOL = "COGNITO_USER_POOL";
    static final String AUTH_SCHEME_AWS_IAM = "AWS_IAM";
    static final String ALB_ACESS_TOKEN_HEADER = "x-amzn-oidc-accesstoken";
    static final String ALB_IDENTITY_HEADER = "x-amzn-oidc-identity";
    private Context lambdaContext;
    private AwsProxyRequest event;

    public Context getLambdaContext() {
        return this.lambdaContext;
    }

    public AwsProxyRequest getEvent() {
        return this.event;
    }

    public AwsProxySecurityContext(Context lambdaContext, AwsProxyRequest event) {
        this.lambdaContext = lambdaContext;
        this.event = event;
    }

    public Principal getUserPrincipal() {
        if (this.getAuthenticationScheme() == null) {
            return () -> null;
        }
        if (this.getAuthenticationScheme().equals(AUTH_SCHEME_CUSTOM) || this.getAuthenticationScheme().equals(AUTH_SCHEME_AWS_IAM)) {
            return () -> {
                if (this.getAuthenticationScheme().equals(AUTH_SCHEME_CUSTOM)) {
                    switch (this.event.getRequestSource()) {
                        case API_GATEWAY: {
                            return this.event.getRequestContext().getAuthorizer().getPrincipalId();
                        }
                        case ALB: {
                            return (String)this.event.getMultiValueHeaders().getFirst(ALB_IDENTITY_HEADER);
                        }
                    }
                } else if (this.getAuthenticationScheme().equals(AUTH_SCHEME_AWS_IAM)) {
                    if (this.event.getRequestContext().getIdentity().getCognitoIdentityId() != null) {
                        return this.event.getRequestContext().getIdentity().getCognitoIdentityId();
                    }
                    return this.event.getRequestContext().getIdentity().getUserArn();
                }
                return null;
            };
        }
        if (this.getAuthenticationScheme().equals(AUTH_SCHEME_COGNITO_POOL)) {
            return new CognitoUserPoolPrincipal(this.event.getRequestContext().getAuthorizer().getClaims());
        }
        throw new RuntimeException("Cannot recognize authorization scheme in event");
    }

    public boolean isUserInRole(String role) {
        return role.equals(this.event.getRequestContext().getIdentity().getUserArn());
    }

    public boolean isSecure() {
        return this.getAuthenticationScheme() != null;
    }

    public String getAuthenticationScheme() {
        switch (this.event.getRequestSource()) {
            case API_GATEWAY: {
                if (this.event.getRequestContext().getAuthorizer() != null && this.event.getRequestContext().getAuthorizer().getClaims() != null && this.event.getRequestContext().getAuthorizer().getClaims().getSubject() != null) {
                    return AUTH_SCHEME_COGNITO_POOL;
                }
                if (this.event.getRequestContext().getAuthorizer() != null) {
                    return AUTH_SCHEME_CUSTOM;
                }
                if (this.event.getRequestContext().getIdentity().getAccessKey() != null) {
                    return AUTH_SCHEME_AWS_IAM;
                }
                return null;
            }
            case ALB: {
                if (!this.event.getMultiValueHeaders().containsKey(ALB_ACESS_TOKEN_HEADER)) break;
                return AUTH_SCHEME_CUSTOM;
            }
        }
        return null;
    }

    public static class CognitoUserPoolPrincipal
    implements Principal {
        private CognitoAuthorizerClaims claims;

        CognitoUserPoolPrincipal(CognitoAuthorizerClaims c) {
            this.claims = c;
        }

        @Override
        public String getName() {
            return this.claims.getSubject();
        }

        public CognitoAuthorizerClaims getClaims() {
            return this.claims;
        }
    }
}

