/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;

public class FilterHolder {
    private Filter filter;
    private FilterConfig filterConfig = new Config();
    private Registration registration;
    private String filterName;
    private Map<String, String> initParameters;
    private ServletContext servletContext;
    private boolean filterInitialized;

    public FilterHolder(Filter newFilter, ServletContext context) {
        this(newFilter.getClass().getName(), newFilter, context);
    }

    public FilterHolder(String name, Filter newFilter, ServletContext context) {
        this.filter = newFilter;
        this.servletContext = context;
        this.filterInitialized = false;
        if (this.isAnnotated()) {
            this.filterName = this.readAnnotatedFilterName();
            this.initParameters = this.readAnnotatedInitParams();
            this.registration = new Registration(this.getAnnotation());
        } else {
            this.filterName = name;
            this.initParameters = new HashMap<String, String>();
            this.registration = new Registration();
        }
    }

    public void init() throws ServletException {
        this.getFilter().init(this.filterConfig);
        this.filterInitialized = true;
    }

    public boolean isFilterInitialized() {
        return this.filterInitialized;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isAnnotated() {
        return this.filter.getClass().isAnnotationPresent(WebFilter.class);
    }

    private String readAnnotatedFilterName() {
        if (this.isAnnotated()) {
            WebFilter regAnnotation = this.filter.getClass().getAnnotation(WebFilter.class);
            if (!"".equals(regAnnotation.filterName().trim())) {
                return regAnnotation.filterName();
            }
            return this.filter.getClass().getName();
        }
        return null;
    }

    private Map<String, String> readAnnotatedInitParams() {
        HashMap<String, String> initParams = new HashMap<String, String>();
        if (this.isAnnotated()) {
            WebFilter regAnnotation = this.filter.getClass().getAnnotation(WebFilter.class);
            for (WebInitParam param : regAnnotation.initParams()) {
                initParams.put(param.name(), param.value());
            }
        }
        return initParams;
    }

    private WebFilter getAnnotation() {
        if (this.isAnnotated()) {
            return this.filter.getClass().getAnnotation(WebFilter.class);
        }
        return null;
    }

    class Config
    implements FilterConfig {
        Config() {
        }

        public String getFilterName() {
            return FilterHolder.this.filterName;
        }

        public ServletContext getServletContext() {
            return FilterHolder.this.servletContext;
        }

        public String getInitParameter(String s) {
            return (String)FilterHolder.this.initParameters.get(s);
        }

        public Enumeration<String> getInitParameterNames() {
            return Collections.enumeration(FilterHolder.this.initParameters.keySet());
        }
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    protected class Registration
    implements FilterRegistration.Dynamic {
        private List<String> urlPatterns = new ArrayList<String>();
        private List<DispatcherType> dispatcherTypes = new ArrayList<DispatcherType>();
        private boolean asyncSupported;

        public Registration() {
            this.asyncSupported = false;
        }

        public Registration(WebFilter annotation) {
            EnumSet<DispatcherType> dispatchers = EnumSet.noneOf(DispatcherType.class);
            dispatchers.addAll(Arrays.asList(annotation.dispatcherTypes()));
            if (annotation.value().length > 0) {
                this.addMappingForUrlPatterns(dispatchers, true, annotation.value());
            }
            if (annotation.urlPatterns().length > 0) {
                this.addMappingForUrlPatterns(dispatchers, true, annotation.urlPatterns());
            }
            this.asyncSupported = annotation.asyncSupported();
        }

        public void setAsyncSupported(boolean b) {
            this.asyncSupported = b;
        }

        public void addMappingForServletNames(EnumSet<DispatcherType> types, boolean isLast, String ... servlets) {
            throw new UnsupportedOperationException();
        }

        public Collection<String> getServletNameMappings() {
            return null;
        }

        public void addMappingForUrlPatterns(EnumSet<DispatcherType> types, boolean isLast, String ... patterns) {
            if (types == null) {
                this.dispatcherTypes.add(DispatcherType.REQUEST);
            } else {
                this.dispatcherTypes.addAll(types);
            }
            for (String mapping : patterns) {
                if (this.validateMappingPath(mapping)) continue;
                throw new IllegalArgumentException("Invalid path mapping, wildcards should be the last part of a path: " + mapping);
            }
            if (isLast) {
                this.urlPatterns.addAll(Arrays.asList(patterns));
            } else {
                ArrayList<String> newUrlList = new ArrayList<String>();
                newUrlList.addAll(Arrays.asList(patterns));
                newUrlList.addAll(this.urlPatterns);
                this.urlPatterns = newUrlList;
            }
        }

        public Collection<String> getUrlPatternMappings() {
            return this.urlPatterns;
        }

        public String getName() {
            return FilterHolder.this.filterName;
        }

        public String getClassName() {
            return FilterHolder.this.filter.getClass().getName();
        }

        public boolean setInitParameter(String s, String s1) {
            if (FilterHolder.this.initParameters.get(s) != null) {
                return false;
            }
            FilterHolder.this.initParameters.put(s, s1);
            return true;
        }

        public String getInitParameter(String s) {
            return (String)FilterHolder.this.initParameters.get(s);
        }

        public Set<String> setInitParameters(Map<String, String> map) {
            LinkedHashSet<String> conflicts = new LinkedHashSet<String>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (FilterHolder.this.initParameters.get(entry.getKey()) != null) {
                    conflicts.add(entry.getKey());
                    continue;
                }
                FilterHolder.this.initParameters.put(entry.getKey(), entry.getValue());
            }
            return conflicts;
        }

        public Map<String, String> getInitParameters() {
            return FilterHolder.this.initParameters;
        }

        public List<DispatcherType> getDispatcherTypes() {
            return this.dispatcherTypes;
        }

        private boolean validateMappingPath(String mapping) {
            String[] parts = mapping.split("/");
            int wildcardPosition = -1;
            for (int i = 0; i < parts.length; ++i) {
                if (wildcardPosition > -1 && i > wildcardPosition) {
                    return false;
                }
                if (!parts[i].trim().equals("*")) continue;
                wildcardPosition = i;
            }
            return true;
        }
    }
}

