/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ContainerConfig {
    public static final String DEFAULT_URI_ENCODING = "UTF-8";
    public static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";
    private static final List<String> DEFAULT_FILE_PATHS = new ArrayList<String>(){
        {
            this.add("/tmp");
            this.add("/var/task");
        }
    };
    private String serviceBasePath;
    private boolean stripBasePath;
    private String uriEncoding;
    private String defaultContentCharset;
    private boolean consolidateSetCookieHeaders;
    private boolean useStageAsServletContext;
    private List<String> validFilePaths = new ArrayList<String>();
    private List<String> customDomainNames = new ArrayList<String>();
    private boolean queryStringCaseSensitive;
    private final HashSet<String> binaryContentTypes = new HashSet();

    public static ContainerConfig defaultConfig() {
        ContainerConfig configuration = new ContainerConfig();
        configuration.setStripBasePath(false);
        configuration.setUriEncoding(DEFAULT_URI_ENCODING);
        configuration.setConsolidateSetCookieHeaders(false);
        configuration.setUseStageAsServletContext(false);
        configuration.setValidFilePaths(DEFAULT_FILE_PATHS);
        configuration.setQueryStringCaseSensitive(false);
        configuration.addBinaryContentTypes("application/octet-stream", "image/jpeg", "image/png", "image/gif");
        configuration.setDefaultContentCharset(DEFAULT_CONTENT_CHARSET);
        return configuration;
    }

    public String getServiceBasePath() {
        return this.serviceBasePath;
    }

    public void setServiceBasePath(String serviceBasePath) {
        if (serviceBasePath == null) {
            this.serviceBasePath = null;
            return;
        }
        String finalBasePath = serviceBasePath;
        if (!finalBasePath.startsWith("/")) {
            finalBasePath = "/" + serviceBasePath;
        }
        if (finalBasePath.endsWith("/")) {
            finalBasePath = finalBasePath.substring(0, finalBasePath.length() - 1);
        }
        this.serviceBasePath = finalBasePath;
    }

    public boolean isStripBasePath() {
        return this.stripBasePath;
    }

    public void setStripBasePath(boolean stripBasePath) {
        this.stripBasePath = stripBasePath;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public void setUriEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public boolean isConsolidateSetCookieHeaders() {
        return this.consolidateSetCookieHeaders;
    }

    public void setConsolidateSetCookieHeaders(boolean consolidateSetCookieHeaders) {
        this.consolidateSetCookieHeaders = consolidateSetCookieHeaders;
    }

    public boolean isUseStageAsServletContext() {
        return this.useStageAsServletContext;
    }

    public void setUseStageAsServletContext(boolean useStageAsServletContext) {
        this.useStageAsServletContext = useStageAsServletContext;
    }

    public List<String> getValidFilePaths() {
        return this.validFilePaths;
    }

    public void setValidFilePaths(List<String> validFilePaths) {
        this.validFilePaths = validFilePaths;
    }

    public void addValidFilePath(String filePath) {
        this.validFilePaths.add(filePath);
    }

    public void addCustomDomain(String name) {
        this.customDomainNames.add(name);
    }

    public List<String> getCustomDomainNames() {
        return this.customDomainNames;
    }

    public void enableLocalhost() {
        this.customDomainNames.add("localhost");
    }

    public boolean isQueryStringCaseSensitive() {
        return this.queryStringCaseSensitive;
    }

    public void setQueryStringCaseSensitive(boolean queryStringCaseSensitive) {
        this.queryStringCaseSensitive = queryStringCaseSensitive;
    }

    public void addBinaryContentTypes(String ... contentTypes) {
        if (contentTypes != null) {
            this.binaryContentTypes.addAll(Arrays.asList(contentTypes));
        }
    }

    public boolean isBinaryContentType(String contentType) {
        return contentType != null && this.binaryContentTypes.contains(contentType.trim());
    }

    public String getDefaultContentCharset() {
        return this.defaultContentCharset;
    }

    public void setDefaultContentCharset(String defaultContentCharset) {
        this.defaultContentCharset = defaultContentCharset;
    }
}

