/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.InitializationWrapper;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncInitializationWrapper
extends InitializationWrapper {
    private int INIT_GRACE_TIME_MS = 250;
    private static final int LAMBDA_MAX_INIT_TIME_MS = 10000;
    private CountDownLatch initializationLatch;
    private long actualStartTime;
    private Logger log = LoggerFactory.getLogger(AsyncInitializationWrapper.class);

    public AsyncInitializationWrapper(long startTime) {
        this.actualStartTime = startTime;
    }

    public AsyncInitializationWrapper() {
        this.actualStartTime = ManagementFactory.getRuntimeMXBean().getStartTime();
        this.INIT_GRACE_TIME_MS = 150;
    }

    @Override
    public void start(LambdaContainerHandler handler) throws ContainerInitializationException {
        this.initializationLatch = new CountDownLatch(1);
        AsyncInitializer initializer = new AsyncInitializer(this.initializationLatch, handler);
        Thread initThread = new Thread(initializer);
        initThread.start();
        try {
            long curTime = Instant.now().toEpochMilli();
            long awaitTime = this.actualStartTime + 10000L - curTime - (long)this.INIT_GRACE_TIME_MS;
            this.log.info("Async initialization will wait for " + awaitTime + "ms");
            if (!this.initializationLatch.await(awaitTime, TimeUnit.MILLISECONDS)) {
                this.log.info("Initialization took longer than 10000, setting new CountDownLatch and continuing in event handler");
                this.initializationLatch = new CountDownLatch(1);
                initializer.replaceLatch(this.initializationLatch);
            }
        }
        catch (InterruptedException e) {
            throw new ContainerInitializationException("Container initialization interrupted", e);
        }
    }

    public long getActualStartTimeMs() {
        return this.actualStartTime;
    }

    @Override
    public CountDownLatch getInitializationLatch() {
        return this.initializationLatch;
    }

    private static class AsyncInitializer
    implements Runnable {
        private LambdaContainerHandler handler;
        private CountDownLatch initLatch;
        private Logger log = LoggerFactory.getLogger(AsyncInitializationWrapper.class);

        AsyncInitializer(CountDownLatch latch, LambdaContainerHandler h) {
            this.initLatch = latch;
            this.handler = h;
        }

        synchronized void replaceLatch(CountDownLatch newLatch) {
            this.initLatch = newLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"DM_EXIT"})
        public void run() {
            this.log.info("Starting async initializer");
            try {
                this.handler.initialize();
            }
            catch (ContainerInitializationException e) {
                this.log.error("Failed to initialize container handler", (Throwable)e);
                System.exit(1);
            }
            AsyncInitializer asyncInitializer = this;
            synchronized (asyncInitializer) {
                this.initLatch.countDown();
            }
        }
    }
}

