/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsAsyncContext;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletInputStream;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.amazonaws.services.lambda.runtime.Context;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.Principal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsHttpApiV2ProxyHttpServletRequest
extends AwsHttpServletRequest {
    private static Logger log = LoggerFactory.getLogger(AwsHttpApiV2ProxyHttpServletRequest.class);
    private HttpApiV2ProxyRequest request;
    private MultiValuedTreeMap<String, String> queryString;
    private Headers headers;
    private ContainerConfig config;
    private SecurityContext securityContext;
    private AwsAsyncContext asyncContext;

    public AwsHttpApiV2ProxyHttpServletRequest(HttpApiV2ProxyRequest req, Context lambdaContext, SecurityContext sc, ContainerConfig cfg) {
        super(lambdaContext);
        this.request = req;
        this.config = cfg;
        this.securityContext = sc;
        this.queryString = this.parseRawQueryString(this.request.getRawQueryString());
        this.headers = this.headersMapToMultiValue(this.request.getHeaders());
    }

    public HttpApiV2ProxyRequest getRequest() {
        return this.request;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        if (this.headers == null || !this.headers.containsKey("Cookie")) {
            return new Cookie[0];
        }
        return this.parseCookieHeaderValue((String)this.headers.getFirst("Cookie"));
    }

    public long getDateHeader(String s) {
        if (this.headers == null) {
            return -1L;
        }
        String dateString = (String)this.headers.getFirst(s);
        if (dateString == null) {
            return -1L;
        }
        try {
            return Instant.from(ZonedDateTime.parse(dateString, dateFormatter)).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            log.warn("Invalid date header in request: " + SecurityUtils.crlf(dateString));
            return -1L;
        }
    }

    public String getHeader(String s) {
        if (this.headers == null) {
            return null;
        }
        return (String)this.headers.getFirst(s);
    }

    public Enumeration<String> getHeaders(String s) {
        if (this.headers == null || !this.headers.containsKey(s)) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.headers.get(s));
    }

    public Enumeration<String> getHeaderNames() {
        if (this.headers == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String s) {
        if (this.headers == null) {
            return -1;
        }
        String headerValue = (String)this.headers.getFirst(s);
        if (headerValue == null || "".equals(headerValue)) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public String getMethod() {
        return this.request.getRequestContext().getHttp().getMethod();
    }

    public String getPathInfo() {
        String pathInfo = AwsHttpApiV2ProxyHttpServletRequest.cleanUri(this.request.getRawPath());
        return AwsHttpApiV2ProxyHttpServletRequest.decodeRequestPath(pathInfo, LambdaContainerHandler.getContainerConfig());
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.generateContextPath(this.config, this.request.getRequestContext().getStage());
    }

    public String getQueryString() {
        return this.request.getRawQueryString();
    }

    public String getRemoteUser() {
        if (this.securityContext == null || this.securityContext.getUserPrincipal() == null) {
            return null;
        }
        return this.securityContext.getUserPrincipal().getName();
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        if (this.securityContext == null) {
            return null;
        }
        return this.securityContext.getUserPrincipal();
    }

    public String getRequestURI() {
        return AwsHttpApiV2ProxyHttpServletRequest.cleanUri(this.getContextPath()) + AwsHttpApiV2ProxyHttpServletRequest.cleanUri(this.request.getRawPath());
    }

    public StringBuffer getRequestURL() {
        return this.generateRequestURL(this.request.getRawPath());
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String s, String s1) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.getMultipartFormParametersMap().values();
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.getMultipartFormParametersMap().get(s);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        if (this.headers == null) {
            return this.config.getDefaultContentCharset();
        }
        return this.parseCharacterEncoding((String)this.headers.getFirst("Content-Type"));
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        if (this.headers == null || !this.headers.containsKey("Content-Type")) {
            log.debug("Called set character encoding to " + SecurityUtils.crlf(s) + " on a request without a content type. Character encoding will not be set");
            return;
        }
        String currentContentType = (String)this.headers.getFirst("Content-Type");
        this.headers.putSingle("Content-Type", this.appendCharacterEncoding(currentContentType, s));
    }

    public int getContentLength() {
        String headerValue = (String)this.headers.getFirst("Content-Length");
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public long getContentLengthLong() {
        String headerValue = (String)this.headers.getFirst("Content-Length");
        if (headerValue == null) {
            return -1L;
        }
        return Long.parseLong(headerValue);
    }

    public String getContentType() {
        if (this.headers == null) {
            return null;
        }
        return (String)this.headers.getFirst("Content-Type");
    }

    public String getParameter(String s) {
        String queryStringParameter = this.getFirstQueryParamValue(this.queryString, s, this.config.isQueryStringCaseSensitive());
        if (queryStringParameter != null) {
            return queryStringParameter;
        }
        String[] bodyParams = this.getFormBodyParameterCaseInsensitive(s);
        if (bodyParams.length == 0) {
            return null;
        }
        return bodyParams[0];
    }

    public Enumeration<String> getParameterNames() {
        if (this.queryString == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.queryString.keySet());
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public String[] getParameterValues(String s) {
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(this.getQueryParamValues(this.queryString, s, this.config.isQueryStringCaseSensitive())));
        values.addAll(Arrays.asList(this.getFormBodyParameterCaseInsensitive(s)));
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        return this.generateParameterMap(this.queryString, this.config);
    }

    public String getProtocol() {
        return this.request.getRequestContext().getHttp().getProtocol();
    }

    public String getScheme() {
        return this.getSchemeFromHeader(this.headers);
    }

    @Override
    public String getServerName() {
        String hostHeader;
        String region = System.getenv("AWS_REGION");
        if (region == null) {
            region = "us-east-1";
        }
        if (this.headers != null && this.headers.containsKey("Host") && SecurityUtils.isValidHost(hostHeader = (String)this.headers.getFirst("Host"), this.request.getRequestContext().getApiId(), region)) {
            return hostHeader;
        }
        return this.request.getRequestContext().getDomainName();
    }

    @Override
    public int getServerPort() {
        if (this.headers == null || !this.headers.containsKey("X-Forwarded-Port")) {
            return 443;
        }
        String port = (String)this.headers.getFirst("X-Forwarded-Port");
        if (SecurityUtils.isValidPort(port)) {
            return Integer.parseInt(port);
        }
        return 443;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.requestInputStream == null) {
            this.requestInputStream = new AwsServletInputStream((InputStream)this.bodyStringToInputStream(this.request.getBody(), this.request.isBase64Encoded()));
        }
        return this.requestInputStream;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new StringReader(this.request.getBody()));
    }

    public String getRemoteAddr() {
        if (this.request.getRequestContext() == null || this.request.getRequestContext().getHttp() == null || this.request.getRequestContext().getHttp().getSourceIp() == null) {
            return "127.0.0.1";
        }
        return this.request.getRequestContext().getHttp().getSourceIp();
    }

    public String getRemoteHost() {
        if (this.headers == null) {
            return null;
        }
        return (String)this.headers.getFirst("Host");
    }

    public Locale getLocale() {
        List<AwsHttpServletRequest.HeaderValue> values = this.parseHeaderValue((String)this.headers.getFirst("Accept-Language"), ",", ";");
        if (values.size() == 0) {
            return Locale.getDefault();
        }
        return new Locale(values.get(0).getValue());
    }

    public Enumeration<Locale> getLocales() {
        List<AwsHttpServletRequest.HeaderValue> values = this.parseHeaderValue((String)this.headers.getFirst("Accept-Language"), ",", ";");
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (values.size() == 0) {
            locales.add(Locale.getDefault());
        } else {
            for (AwsHttpServletRequest.HeaderValue locale : values) {
                locales.add(new Locale(locale.getValue()));
            }
        }
        return Collections.enumeration(locales);
    }

    public boolean isSecure() {
        return this.securityContext.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.getServletContext().getRequestDispatcher(s);
    }

    public String getRealPath(String s) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    @Override
    public boolean isAsyncSupported() {
        return true;
    }

    @Override
    public boolean isAsyncStarted() {
        if (this.asyncContext == null) {
            return false;
        }
        return !this.asyncContext.isCompleted() && !this.asyncContext.isDispatched();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        this.asyncContext = new AwsAsyncContext(this, this.response, this.containerHandler);
        this.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", DispatcherType.ASYNC);
        log.debug("Starting async context for request: " + SecurityUtils.crlf(this.request.getRequestContext().getRequestId()));
        return this.asyncContext;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        this.asyncContext = new AwsAsyncContext((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, this.containerHandler);
        this.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", DispatcherType.ASYNC);
        log.debug("Starting async context for request: " + SecurityUtils.crlf(this.request.getRequestContext().getRequestId()));
        return this.asyncContext;
    }

    public AsyncContext getAsyncContext() {
        if (this.asyncContext == null) {
            throw new IllegalStateException("Request " + SecurityUtils.crlf(this.request.getRequestContext().getRequestId()) + " is not in asynchronous mode. Call startAsync before attempting to get the async context.");
        }
        return this.asyncContext;
    }

    private MultiValuedTreeMap<String, String> parseRawQueryString(String qs) {
        if (qs == null || "".equals(qs.trim())) {
            return new MultiValuedTreeMap<String, String>();
        }
        MultiValuedTreeMap<String, String> qsMap = new MultiValuedTreeMap<String, String>();
        for (String value : qs.split("&")) {
            if (!value.contains("=")) {
                log.warn("Invalid query string parameter: " + SecurityUtils.crlf(value));
                continue;
            }
            String[] kv = value.split("=");
            try {
                qsMap.add(URLDecoder.decode(kv[0], LambdaContainerHandler.getContainerConfig().getUriEncoding()), kv[1]);
            }
            catch (UnsupportedEncodingException e) {
                log.error("Unsupported encoding in query string key: " + SecurityUtils.crlf(kv[0]), (Throwable)e);
            }
        }
        return qsMap;
    }

    private Headers headersMapToMultiValue(Map<String, String> headers) {
        if (headers == null || headers.size() == 0) {
            return new Headers();
        }
        Headers h = new Headers();
        for (Map.Entry<String, String> hkv : headers.entrySet()) {
            if (hkv.getKey().equalsIgnoreCase("Date") || hkv.getKey().equalsIgnoreCase("If-Modified-Since") || hkv.getKey().toLowerCase(Locale.getDefault()).startsWith("accept-")) {
                h.add(hkv.getKey(), hkv.getValue());
                continue;
            }
            for (String value : hkv.getValue().split(",")) {
                h.add(hkv.getKey(), value);
            }
        }
        return h;
    }
}

