/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpSession;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyRequestPart;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletInputStream;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.amazonaws.services.lambda.runtime.Context;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsHttpServletRequest
implements HttpServletRequest {
    static final String HEADER_KEY_VALUE_SEPARATOR = "=";
    static final String HEADER_VALUE_SEPARATOR = ";";
    static final String HEADER_QUALIFIER_SEPARATOR = ",";
    static final String FORM_DATA_SEPARATOR = "&";
    static final DateTimeFormatter dateFormatter = DateTimeFormatter.RFC_1123_DATE_TIME;
    static final String ENCODING_VALUE_KEY = "charset";
    static final String DISPATCHER_TYPE_ATTRIBUTE = "com.amazonaws.serverless.javacontainer.dispatchertype";
    static final String QUERY_STRING_SEPARATOR = "&";
    static final String QUERY_STRING_KEY_VALUE_SEPARATOR = "=";
    static final String CF_PROTOCOL_HEADER_NAME = "CloudFront-Forwarded-Proto";
    static final String PROTOCOL_HEADER_NAME = "X-Forwarded-Proto";
    static final String HOST_HEADER_NAME = "Host";
    static final String PORT_HEADER_NAME = "X-Forwarded-Port";
    static final String CLIENT_IP_HEADER = "X-Forwarded-For";
    private Context lambdaContext;
    private Map<String, Object> attributes;
    private ServletContext servletContext;
    private AwsHttpSession session;
    private String queryString;
    private Map<String, List<Part>> multipartFormParameters;
    private Map<String, List<String>> urlEncodedFormParameters;
    protected AwsHttpServletResponse response;
    protected AwsLambdaServletContainerHandler containerHandler;
    protected ServletInputStream requestInputStream;
    private static Logger log = LoggerFactory.getLogger(AwsHttpServletRequest.class);

    protected AwsHttpServletRequest(Context lambdaContext) {
        this.lambdaContext = lambdaContext;
        this.attributes = new HashMap<String, Object>();
        this.setAttribute(DISPATCHER_TYPE_ATTRIBUTE, DispatcherType.REQUEST);
    }

    public AwsHttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(AwsHttpServletResponse response) {
        this.response = response;
    }

    public void setContainerHandler(AwsLambdaServletContainerHandler containerHandler) {
        this.containerHandler = containerHandler;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public HttpSession getSession(boolean b) {
        log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        if (b && null == this.session) {
            AwsProxyRequestContext requestContext = (AwsProxyRequestContext)this.getAttribute("com.amazonaws.apigateway.request.context");
            this.session = new AwsHttpSession(requestContext.getRequestId());
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getServerName() {
        return "lambda.amazonaws.com";
    }

    public int getServerPort() {
        return 0;
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public String getLocalName() {
        return "lambda.amazonaws.com";
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public DispatcherType getDispatcherType() {
        if (this.getAttribute(DISPATCHER_TYPE_ATTRIBUTE) != null) {
            return (DispatcherType)this.getAttribute(DISPATCHER_TYPE_ATTRIBUTE);
        }
        return DispatcherType.REQUEST;
    }

    public String getServletPath() {
        return "";
    }

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    protected Cookie[] parseCookieHeaderValue(String headerValue) {
        List<HeaderValue> parsedHeaders = this.parseHeaderValue(headerValue, HEADER_VALUE_SEPARATOR, HEADER_QUALIFIER_SEPARATOR);
        return (Cookie[])parsedHeaders.stream().filter(e -> e.getKey() != null).map(e -> new Cookie(SecurityUtils.crlf(e.getKey()), SecurityUtils.crlf(e.getValue()))).toArray(Cookie[]::new);
    }

    protected String generateQueryString(MultiValuedTreeMap<String, String> parameters, boolean encode, String encodeCharset) throws ServletException {
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        if (this.queryString != null) {
            return this.queryString;
        }
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            for (String key : parameters.keySet()) {
                Iterator iterator = parameters.get(key).iterator();
                while (iterator.hasNext()) {
                    String val = (String)iterator.next();
                    queryStringBuilder.append("&");
                    if (encode) {
                        queryStringBuilder.append(URLEncoder.encode(key, encodeCharset));
                    } else {
                        queryStringBuilder.append(key);
                    }
                    queryStringBuilder.append("=");
                    if (val == null) continue;
                    if (encode) {
                        queryStringBuilder.append(URLEncoder.encode(val, encodeCharset));
                        continue;
                    }
                    queryStringBuilder.append(val);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException("Invalid charset passed for query string encoding", (Throwable)e);
        }
        this.queryString = queryStringBuilder.toString();
        this.queryString = this.queryString.substring(1);
        return this.queryString;
    }

    protected String generateContextPath(ContainerConfig config, String apiStage) {
        String contextPath = "";
        if (config.isUseStageAsServletContext() && apiStage != null) {
            log.debug("Using stage as context path");
            contextPath = AwsHttpServletRequest.cleanUri(apiStage);
        }
        if (config.getServiceBasePath() != null) {
            contextPath = contextPath + AwsHttpServletRequest.cleanUri(config.getServiceBasePath());
        }
        return contextPath;
    }

    protected StringBuffer generateRequestURL(String requestPath) {
        String url = "";
        url = url + this.getServerName();
        url = url + AwsHttpServletRequest.cleanUri(this.getContextPath());
        url = url + AwsHttpServletRequest.cleanUri(requestPath);
        return new StringBuffer(this.getScheme() + "://" + url);
    }

    protected String parseCharacterEncoding(String contentTypeHeader) {
        if (contentTypeHeader == null) {
            return null;
        }
        String[] contentTypeValues = contentTypeHeader.split(HEADER_VALUE_SEPARATOR);
        if (contentTypeValues.length <= 1) {
            return null;
        }
        for (String contentTypeValue : contentTypeValues) {
            if (!contentTypeValue.trim().startsWith(ENCODING_VALUE_KEY)) continue;
            String[] encodingValues = contentTypeValue.split("=");
            if (encodingValues.length <= 1) {
                return null;
            }
            return encodingValues[1];
        }
        return null;
    }

    protected String appendCharacterEncoding(String currentContentType, String newEncoding) {
        if (currentContentType == null || currentContentType.trim().isEmpty()) {
            return null;
        }
        if (currentContentType.contains(HEADER_VALUE_SEPARATOR)) {
            String[] contentTypeValues = currentContentType.split(HEADER_VALUE_SEPARATOR);
            StringBuilder contentType = new StringBuilder(contentTypeValues[0]);
            for (int i = 1; i < contentTypeValues.length; ++i) {
                String contentTypeValue = contentTypeValues[i];
                String contentTypeString = "; " + contentTypeValue;
                if (contentTypeValue.trim().startsWith(ENCODING_VALUE_KEY)) {
                    contentTypeString = "; charset=" + newEncoding;
                }
                contentType.append(contentTypeString);
            }
            return contentType.toString();
        }
        return currentContentType + HEADER_VALUE_SEPARATOR + " " + ENCODING_VALUE_KEY + "=" + newEncoding;
    }

    protected ServletInputStream bodyStringToInputStream(String body, boolean isBase64Encoded) throws IOException {
        byte[] bodyBytes;
        if (body == null) {
            return new AwsServletInputStream((InputStream)new NullInputStream(0L, false, false));
        }
        if (isBase64Encoded) {
            bodyBytes = Base64.getMimeDecoder().decode(body);
        } else {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = Charset.defaultCharset().name();
            }
            try {
                bodyBytes = body.getBytes(encoding);
            }
            catch (Exception e) {
                log.error("Could not read request with character encoding: " + SecurityUtils.crlf(encoding), (Throwable)e);
                bodyBytes = body.getBytes(Charset.defaultCharset());
            }
        }
        ByteArrayInputStream requestBodyStream = new ByteArrayInputStream(bodyBytes);
        return new AwsServletInputStream(requestBodyStream);
    }

    protected String getFirstQueryParamValue(MultiValuedTreeMap<String, String> queryString, String key, boolean isCaseSensitive) {
        if (queryString != null) {
            if (isCaseSensitive) {
                return queryString.getFirst(key);
            }
            for (String k : queryString.keySet()) {
                if (!k.toLowerCase(Locale.getDefault()).equals(key.toLowerCase(Locale.getDefault()))) continue;
                return queryString.getFirst(k);
            }
        }
        return null;
    }

    protected String[] getFormBodyParameterCaseInsensitive(String key) {
        List<String> values = this.getFormUrlEncodedParametersMap().get(key);
        if (values != null) {
            String[] valuesArray = new String[values.size()];
            valuesArray = values.toArray(valuesArray);
            return valuesArray;
        }
        return new String[0];
    }

    protected Map<String, List<String>> getFormUrlEncodedParametersMap() {
        if (this.urlEncodedFormParameters != null) {
            return this.urlEncodedFormParameters;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            this.urlEncodedFormParameters = new HashMap<String, List<String>>();
            return this.urlEncodedFormParameters;
        }
        if (!contentType.startsWith("application/x-www-form-urlencoded") || !this.getMethod().toLowerCase(Locale.ENGLISH).equals("post")) {
            this.urlEncodedFormParameters = new HashMap<String, List<String>>();
            return this.urlEncodedFormParameters;
        }
        Timer.start("SERVLET_REQUEST_GET_FORM_PARAMS");
        String rawBodyContent = null;
        try {
            rawBodyContent = IOUtils.toString((InputStream)this.getInputStream(), (String)this.getCharacterEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.urlEncodedFormParameters = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String parameter : rawBodyContent.split("&")) {
            String[] parameterKeyValue = parameter.split("=");
            if (parameterKeyValue.length < 1) continue;
            List<String> values = new ArrayList<String>();
            if (this.urlEncodedFormParameters.containsKey(parameterKeyValue[0])) {
                values = this.urlEncodedFormParameters.get(parameterKeyValue[0]);
            }
            if (parameterKeyValue.length > 1) {
                values.add(AwsHttpServletRequest.decodeValueIfEncoded(parameterKeyValue[1]));
            }
            this.urlEncodedFormParameters.put(AwsHttpServletRequest.decodeValueIfEncoded(parameterKeyValue[0]), values);
        }
        Timer.stop("SERVLET_REQUEST_GET_FORM_PARAMS");
        return this.urlEncodedFormParameters;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        List<Part> partList = this.getMultipartFormParametersMap().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return partList;
    }

    public Part getPart(String s) throws IOException, ServletException {
        List<Part> values = this.getMultipartFormParametersMap().get(s);
        if (Objects.isNull(values)) {
            return null;
        }
        return this.getMultipartFormParametersMap().get(s).get(0);
    }

    @SuppressFBWarnings(value={"FILE_UPLOAD_FILENAME", "WEAK_FILENAMEUTILS"})
    protected Map<String, List<Part>> getMultipartFormParametersMap() {
        if (this.multipartFormParameters != null) {
            return this.multipartFormParameters;
        }
        if (!JakartaServletFileUpload.isMultipartContent((HttpServletRequest)this)) {
            this.multipartFormParameters = new HashMap<String, List<Part>>();
            return this.multipartFormParameters;
        }
        Timer.start("SERVLET_REQUEST_GET_MULTIPART_PARAMS");
        this.multipartFormParameters = new TreeMap<String, List<Part>>(String.CASE_INSENSITIVE_ORDER);
        JakartaServletFileUpload upload = new JakartaServletFileUpload((FileItemFactory)DiskFileItemFactory.builder().get());
        try {
            List items = upload.parseRequest((HttpServletRequest)this);
            for (FileItem item : items) {
                String fileName = FilenameUtils.getName((String)item.getName());
                AwsProxyRequestPart newPart = new AwsProxyRequestPart(item.get());
                newPart.setName(item.getFieldName());
                newPart.setSubmittedFileName(fileName);
                newPart.setContentType(item.getContentType());
                newPart.setSize(item.getSize());
                item.getHeaders().getHeaderNames().forEachRemaining(h -> newPart.addHeader((String)h, item.getHeaders().getHeader(h)));
                this.addPart(this.multipartFormParameters, item.getFieldName(), newPart);
            }
        }
        catch (FileUploadException e) {
            Timer.stop("SERVLET_REQUEST_GET_MULTIPART_PARAMS");
            log.error("Could not read multipart upload file", (Throwable)e);
        }
        Timer.stop("SERVLET_REQUEST_GET_MULTIPART_PARAMS");
        return this.multipartFormParameters;
    }

    private void addPart(Map<String, List<Part>> params, String fieldName, Part newPart) {
        List<Part> partList = params.get(fieldName);
        if (Objects.isNull(partList)) {
            partList = new ArrayList<Part>();
            params.put(fieldName, partList);
        }
        partList.add(newPart);
    }

    protected String[] getQueryParamValues(MultiValuedTreeMap<String, String> qs, String key, boolean isCaseSensitive) {
        List<String> value = this.getQueryParamValuesAsList(qs, key, isCaseSensitive);
        if (value == null) {
            return null;
        }
        return value.toArray(new String[0]);
    }

    protected List<String> getQueryParamValuesAsList(MultiValuedTreeMap<String, String> qs, String key, boolean isCaseSensitive) {
        if (qs != null) {
            if (isCaseSensitive) {
                return qs.get(key);
            }
            for (String k : qs.keySet()) {
                if (!k.toLowerCase(Locale.getDefault()).equals(key.toLowerCase(Locale.getDefault()))) continue;
                return qs.get(k);
            }
        }
        return Collections.emptyList();
    }

    protected Map<String, String[]> generateParameterMap(MultiValuedTreeMap<String, String> qs, ContainerConfig config) {
        Map<String, String[]> output;
        Map<String, List<String>> formEncodedParams = this.getFormUrlEncodedParametersMap();
        if (qs == null) {
            output = formEncodedParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).toArray(new String[0])));
        } else {
            Object queryStringParams = config.isQueryStringCaseSensitive() ? qs : ((Stream)qs.entrySet().stream().parallel()).collect(Collectors.toMap(Map.Entry::getKey, e -> this.getQueryParamValuesAsList(qs, (String)e.getKey(), false)));
            output = Stream.of(formEncodedParams, queryStringParams).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).toArray(new String[0]), (formParam, queryParam) -> (String[])Stream.of(formParam, queryParam).flatMap(Stream::of).toArray(String[]::new)));
        }
        return output;
    }

    protected String getSchemeFromHeader(Headers headers) {
        if (headers == null) {
            return "https";
        }
        String cfScheme = (String)headers.getFirst(CF_PROTOCOL_HEADER_NAME);
        if (cfScheme != null && SecurityUtils.isValidScheme(cfScheme)) {
            return cfScheme;
        }
        String gwScheme = (String)headers.getFirst(PROTOCOL_HEADER_NAME);
        if (gwScheme != null && SecurityUtils.isValidScheme(gwScheme)) {
            return gwScheme;
        }
        return "https";
    }

    protected List<HeaderValue> parseHeaderValue(String headerValue) {
        return this.parseHeaderValue(headerValue, HEADER_VALUE_SEPARATOR, HEADER_QUALIFIER_SEPARATOR);
    }

    protected List<HeaderValue> parseHeaderValue(String headerValue, String valueSeparator, String qualifierSeparator) {
        ArrayList<HeaderValue> values = new ArrayList<HeaderValue>();
        if (headerValue == null) {
            return values;
        }
        for (String curValue : headerValue.split(valueSeparator)) {
            float curPreference = 1.0f;
            HeaderValue newValue = new HeaderValue();
            newValue.setRawValue(curValue);
            for (String q : curValue.split(qualifierSeparator)) {
                String[] kv = q.split("=", 2);
                String key = null;
                String val = null;
                if (kv.length == 1) {
                    val = q.trim();
                }
                if (kv.length == 2) {
                    if (kv[1].isEmpty()) {
                        val = q.trim();
                    }
                    if ("=".equals(kv[1].trim())) {
                        val = q.trim();
                    } else {
                        key = kv[0].trim();
                        String string = val = "".equals(kv[1].trim()) ? null : kv[1].trim();
                    }
                }
                if (newValue.getValue() == null) {
                    newValue.setKey(key);
                    newValue.setValue(val);
                    continue;
                }
                if ("q".equals(key)) {
                    curPreference = Float.parseFloat(val);
                    continue;
                }
                newValue.addAttribute(key, val);
            }
            newValue.setPriority(curPreference);
            values.add(newValue);
        }
        values.sort((first, second) -> {
            if (first.getPriority() - second.getPriority() < 0.001f) {
                return 0;
            }
            if (first.getPriority() < second.getPriority()) {
                return 1;
            }
            return -1;
        });
        return values;
    }

    protected List<Locale> parseAcceptLanguageHeader(String headerValue) {
        List<HeaderValue> values = this.parseHeaderValue(headerValue, HEADER_QUALIFIER_SEPARATOR, HEADER_VALUE_SEPARATOR);
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (values.isEmpty()) {
            locales.add(Locale.getDefault());
        } else {
            for (HeaderValue locale : values) {
                locales.add(this.parseLanguageTag(locale.getValue()));
            }
        }
        return locales;
    }

    protected Locale parseLanguageTag(String languageTag) {
        String language;
        languageTag = languageTag.trim();
        String country = "";
        int indexDash = languageTag.indexOf(45);
        if (indexDash > -1) {
            country = languageTag.substring(indexDash + 1).trim();
            language = languageTag.substring(0, indexDash).trim();
        } else {
            language = languageTag;
        }
        return new Locale(language, country);
    }

    static String decodeRequestPath(String requestPath, ContainerConfig config) {
        try {
            return URLDecoder.decode(requestPath, config.getUriEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            log.error("Could not URL decode the request path, configured encoding not supported: {}", (Object)SecurityUtils.encode(config.getUriEncoding()));
            return requestPath;
        }
    }

    static String cleanUri(String uri) {
        String finalUri;
        String string = finalUri = uri == null ? "/" : uri;
        if (finalUri.equals("/")) {
            return finalUri;
        }
        if (!finalUri.startsWith("/")) {
            finalUri = "/" + finalUri;
        }
        if (finalUri.endsWith("/")) {
            finalUri = finalUri.substring(0, finalUri.length() - 1);
        }
        finalUri = finalUri.replaceAll("/+", "/");
        return finalUri;
    }

    static String decodeValueIfEncoded(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, LambdaContainerHandler.getContainerConfig().getUriEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Could not decode body content - proceeding as if it was already decoded", (Throwable)e);
            return value;
        }
    }

    public static class HeaderValue {
        private String key;
        private String value;
        private String rawValue;
        private float priority;
        private Map<String, String> attributes = new HashMap<String, String>();

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getRawValue() {
            return this.rawValue;
        }

        public void setRawValue(String rawValue) {
            this.rawValue = rawValue;
        }

        public float getPriority() {
            return this.priority;
        }

        public void setPriority(float priority) {
            this.priority = priority;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        public String getAttribute(String key) {
            return this.attributes.get(key);
        }
    }
}

