/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.model;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.model.HttpApiV2IamAuthorizer;
import com.amazonaws.serverless.proxy.model.HttpApiV2JwtAuthorizer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=HttpApiV2AuthorizerSerializer.class)
@JsonDeserialize(using=HttpApiV2AuthorizerDeserializer.class)
public class HttpApiV2AuthorizerMap
extends HashMap<String, Object> {
    private static final String JWT_KEY = "jwt";
    private static final String LAMBDA_KEY = "lambda";
    private static final String IAM_KEY = "iam";
    private static final long serialVersionUID = 42L;

    public HttpApiV2JwtAuthorizer getJwtAuthorizer() {
        return (HttpApiV2JwtAuthorizer)this.get(JWT_KEY);
    }

    public Map<String, Object> getLambdaAuthorizerContext() {
        return (Map)this.get(LAMBDA_KEY);
    }

    public HttpApiV2IamAuthorizer getIamAuthorizer() {
        return (HttpApiV2IamAuthorizer)this.get(IAM_KEY);
    }

    public boolean isJwt() {
        return this.containsKey(JWT_KEY);
    }

    public boolean isLambda() {
        return this.containsKey(LAMBDA_KEY);
    }

    public boolean isIam() {
        return this.containsKey(IAM_KEY);
    }

    public void putJwtAuthorizer(HttpApiV2JwtAuthorizer jwt) {
        this.put(JWT_KEY, jwt);
    }

    public void putIamAuthorizer(HttpApiV2IamAuthorizer iam) {
        this.put(IAM_KEY, iam);
    }

    public static class HttpApiV2AuthorizerSerializer
    extends StdSerializer<HttpApiV2AuthorizerMap> {
        private static final long serialVersionUID = 42L;

        public HttpApiV2AuthorizerSerializer() {
            super(HttpApiV2AuthorizerMap.class);
        }

        public void serialize(HttpApiV2AuthorizerMap httpApiV2AuthorizerMap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeStartObject();
            if (httpApiV2AuthorizerMap.isJwt()) {
                jsonGenerator.writeObjectField(HttpApiV2AuthorizerMap.JWT_KEY, (Object)httpApiV2AuthorizerMap.getJwtAuthorizer());
            }
            if (httpApiV2AuthorizerMap.isLambda()) {
                jsonGenerator.writeObjectField(HttpApiV2AuthorizerMap.LAMBDA_KEY, httpApiV2AuthorizerMap.getLambdaAuthorizerContext());
            }
            if (httpApiV2AuthorizerMap.isIam()) {
                jsonGenerator.writeObjectField(HttpApiV2AuthorizerMap.IAM_KEY, httpApiV2AuthorizerMap.get(HttpApiV2AuthorizerMap.IAM_KEY));
            }
            jsonGenerator.writeEndObject();
        }
    }

    public static class HttpApiV2AuthorizerDeserializer
    extends StdDeserializer<HttpApiV2AuthorizerMap> {
        private static final long serialVersionUID = 42L;

        public HttpApiV2AuthorizerDeserializer() {
            super(HttpApiV2AuthorizerMap.class);
        }

        public HttpApiV2AuthorizerMap deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            HttpApiV2AuthorizerMap map = new HttpApiV2AuthorizerMap();
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            if (node.has(HttpApiV2AuthorizerMap.JWT_KEY)) {
                HttpApiV2JwtAuthorizer authorizer = (HttpApiV2JwtAuthorizer)LambdaContainerHandler.getObjectMapper().treeToValue((TreeNode)node.get(HttpApiV2AuthorizerMap.JWT_KEY), HttpApiV2JwtAuthorizer.class);
                map.putJwtAuthorizer(authorizer);
            }
            if (node.has(HttpApiV2AuthorizerMap.LAMBDA_KEY)) {
                Map context = (Map)LambdaContainerHandler.getObjectMapper().treeToValue((TreeNode)node.get(HttpApiV2AuthorizerMap.LAMBDA_KEY), (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, Object.class));
                map.put(HttpApiV2AuthorizerMap.LAMBDA_KEY, context);
            }
            if (node.has(HttpApiV2AuthorizerMap.IAM_KEY)) {
                HttpApiV2IamAuthorizer iam_authorizer = (HttpApiV2IamAuthorizer)LambdaContainerHandler.getObjectMapper().treeToValue((TreeNode)node.get(HttpApiV2AuthorizerMap.IAM_KEY), HttpApiV2IamAuthorizer.class);
                map.putIamAuthorizer(iam_authorizer);
            }
            return map;
        }
    }
}

