/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.model;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.model.HttpApiV2IamAuthorizer;
import com.amazonaws.serverless.proxy.model.HttpApiV2JwtAuthorizer;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TreeNode;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.annotation.JsonDeserialize;
import tools.jackson.databind.annotation.JsonSerialize;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.ser.std.StdSerializer;

@JsonSerialize(using=HttpApiV2AuthorizerSerializer.class)
@JsonDeserialize(using=HttpApiV2AuthorizerDeserializer.class)
public class HttpApiV2AuthorizerMap
extends HashMap<String, Object> {
    private static final String JWT_KEY = "jwt";
    private static final String LAMBDA_KEY = "lambda";
    private static final String IAM_KEY = "iam";
    private static final long serialVersionUID = 42L;

    public HttpApiV2JwtAuthorizer getJwtAuthorizer() {
        return (HttpApiV2JwtAuthorizer)this.get(JWT_KEY);
    }

    public Map<String, Object> getLambdaAuthorizerContext() {
        return (Map)this.get(LAMBDA_KEY);
    }

    public HttpApiV2IamAuthorizer getIamAuthorizer() {
        return (HttpApiV2IamAuthorizer)this.get(IAM_KEY);
    }

    public boolean isJwt() {
        return this.containsKey(JWT_KEY);
    }

    public boolean isLambda() {
        return this.containsKey(LAMBDA_KEY);
    }

    public boolean isIam() {
        return this.containsKey(IAM_KEY);
    }

    public void putJwtAuthorizer(HttpApiV2JwtAuthorizer jwt) {
        this.put(JWT_KEY, jwt);
    }

    public void putIamAuthorizer(HttpApiV2IamAuthorizer iam) {
        this.put(IAM_KEY, iam);
    }

    public static class HttpApiV2AuthorizerSerializer
    extends StdSerializer<HttpApiV2AuthorizerMap> {
        private static final long serialVersionUID = 42L;

        public HttpApiV2AuthorizerSerializer() {
            super(HttpApiV2AuthorizerMap.class);
        }

        public void serialize(HttpApiV2AuthorizerMap httpApiV2AuthorizerMap, JsonGenerator jsonGenerator, SerializationContext serializationContext) {
            jsonGenerator.writeStartObject();
            if (httpApiV2AuthorizerMap.isJwt()) {
                jsonGenerator.writeName(HttpApiV2AuthorizerMap.JWT_KEY);
                jsonGenerator.writePOJO((Object)httpApiV2AuthorizerMap.getJwtAuthorizer());
            }
            if (httpApiV2AuthorizerMap.isLambda()) {
                jsonGenerator.writeName(HttpApiV2AuthorizerMap.LAMBDA_KEY);
                jsonGenerator.writePOJO(httpApiV2AuthorizerMap.getLambdaAuthorizerContext());
            }
            if (httpApiV2AuthorizerMap.isIam()) {
                jsonGenerator.writeName(HttpApiV2AuthorizerMap.IAM_KEY);
                jsonGenerator.writePOJO(httpApiV2AuthorizerMap.get(HttpApiV2AuthorizerMap.IAM_KEY));
            }
            jsonGenerator.writeEndObject();
        }
    }

    public static class HttpApiV2AuthorizerDeserializer
    extends StdDeserializer<HttpApiV2AuthorizerMap> {
        private static final long serialVersionUID = 42L;

        public HttpApiV2AuthorizerDeserializer() {
            super(HttpApiV2AuthorizerMap.class);
        }

        public HttpApiV2AuthorizerMap deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
            HttpApiV2AuthorizerMap map = new HttpApiV2AuthorizerMap();
            JsonNode node = deserializationContext.readTree(jsonParser);
            if (node.has(HttpApiV2AuthorizerMap.JWT_KEY)) {
                HttpApiV2JwtAuthorizer authorizer = (HttpApiV2JwtAuthorizer)LambdaContainerHandler.getObjectMapper().treeToValue((TreeNode)node.get(HttpApiV2AuthorizerMap.JWT_KEY), HttpApiV2JwtAuthorizer.class);
                map.putJwtAuthorizer(authorizer);
            }
            if (node.has(HttpApiV2AuthorizerMap.LAMBDA_KEY)) {
                Map context = (Map)LambdaContainerHandler.getObjectMapper().treeToValue((TreeNode)node.get(HttpApiV2AuthorizerMap.LAMBDA_KEY), (JavaType)LambdaContainerHandler.getObjectMapper().getTypeFactory().constructMapType(HashMap.class, String.class, Object.class));
                map.put(HttpApiV2AuthorizerMap.LAMBDA_KEY, context);
            }
            if (node.has(HttpApiV2AuthorizerMap.IAM_KEY)) {
                HttpApiV2IamAuthorizer iam_authorizer = (HttpApiV2IamAuthorizer)LambdaContainerHandler.getObjectMapper().treeToValue((TreeNode)node.get(HttpApiV2AuthorizerMap.IAM_KEY), HttpApiV2IamAuthorizer.class);
                map.putIamAuthorizer(iam_authorizer);
            }
            return map;
        }
    }
}

