/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.struts2;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.AwsHttpApiV2SecurityContextWriter;
import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpApiV2HttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.EnumSet;
import java.util.concurrent.CountDownLatch;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.dispatcher.filter.StrutsPrepareAndExecuteFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Struts2LambdaContainerHandler<RequestType, ResponseType>
extends AwsLambdaServletContainerHandler<RequestType, ResponseType, HttpServletRequest, AwsHttpServletResponse> {
    private static final Logger log = LoggerFactory.getLogger(Struts2LambdaContainerHandler.class);
    public static final String HEADER_STRUTS_STATUS_CODE = "X-Struts-StatusCode";
    private static final String TIMER_STRUTS_2_CONTAINER_CONSTRUCTOR = "STRUTS2_CONTAINER_CONSTRUCTOR";
    private static final String TIMER_STRUTS_2_HANDLE_REQUEST = "STRUTS2_HANDLE_REQUEST";
    private static final String TIMER_STRUTS_2_COLD_START_INIT = "STRUTS2_COLD_START_INIT";
    private static final String STRUTS_FILTER_NAME = "Struts2Filter";
    private boolean initialized;

    public static Struts2LambdaContainerHandler<AwsProxyRequest, AwsProxyResponse> getAwsProxyHandler() {
        return new Struts2LambdaContainerHandler<AwsProxyRequest, AwsProxyResponse>(AwsProxyRequest.class, AwsProxyResponse.class, (RequestReader<AwsProxyRequest, HttpServletRequest>)new AwsProxyHttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler());
    }

    public static Struts2LambdaContainerHandler<HttpApiV2ProxyRequest, AwsProxyResponse> getHttpApiV2ProxyHandler() {
        return new Struts2LambdaContainerHandler<HttpApiV2ProxyRequest, AwsProxyResponse>(HttpApiV2ProxyRequest.class, AwsProxyResponse.class, (RequestReader<HttpApiV2ProxyRequest, HttpServletRequest>)new AwsHttpApiV2HttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(true), (SecurityContextWriter<HttpApiV2ProxyRequest>)new AwsHttpApiV2SecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler());
    }

    public Struts2LambdaContainerHandler(Class<RequestType> requestTypeClass, Class<ResponseType> responseTypeClass, RequestReader<RequestType, HttpServletRequest> requestReader, ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler) {
        super(requestTypeClass, responseTypeClass, requestReader, responseWriter, securityContextWriter, exceptionHandler);
        Timer.start((String)TIMER_STRUTS_2_CONTAINER_CONSTRUCTOR);
        this.initialized = false;
        Timer.stop((String)TIMER_STRUTS_2_CONTAINER_CONSTRUCTOR);
    }

    protected AwsHttpServletResponse getContainerResponse(HttpServletRequest request, CountDownLatch latch) {
        return new AwsHttpServletResponse(request, latch);
    }

    protected void handleRequest(HttpServletRequest httpServletRequest, AwsHttpServletResponse httpServletResponse, Context lambdaContext) throws Exception {
        Timer.start((String)TIMER_STRUTS_2_HANDLE_REQUEST);
        if (!this.initialized) {
            this.initialize();
        }
        if (AwsHttpServletRequest.class.isAssignableFrom(httpServletRequest.getClass())) {
            ((AwsHttpServletRequest)httpServletRequest).setServletContext(this.getServletContext());
        }
        this.doFilter(httpServletRequest, (HttpServletResponse)httpServletResponse, null);
        String responseStatusCode = httpServletResponse.getHeader(HEADER_STRUTS_STATUS_CODE);
        if (responseStatusCode != null) {
            httpServletResponse.setStatus(Integer.parseInt(responseStatusCode));
        }
        Timer.stop((String)TIMER_STRUTS_2_HANDLE_REQUEST);
    }

    public void initialize() throws ContainerInitializationException {
        log.info("Initialize Struts2 Lambda Application ...");
        Timer.start((String)TIMER_STRUTS_2_COLD_START_INIT);
        try {
            if (this.startupHandler != null) {
                this.startupHandler.onStartup(this.getServletContext());
            }
            StrutsPrepareAndExecuteFilter filter = new StrutsPrepareAndExecuteFilter();
            FilterRegistration.Dynamic filterRegistration = this.getServletContext().addFilter(STRUTS_FILTER_NAME, (Filter)filter);
            filterRegistration.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC, DispatcherType.INCLUDE, DispatcherType.FORWARD), true, new String[]{"/*"});
        }
        catch (Exception e) {
            throw new ContainerInitializationException("Could not initialize Struts2", e);
        }
        this.initialized = true;
        Timer.stop((String)TIMER_STRUTS_2_COLD_START_INIT);
        log.info("... initialize of Struts2 Lambda Application completed!");
    }

    public Servlet getServlet() {
        return null;
    }
}

