/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.functionaljava;

import com.aol.cyclops.functionaljava.FJ;
import com.aol.cyclops.monad.AnyM;
import fj.Monoid;
import fj.control.Trampoline;
import fj.data.Either;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.IterableW;
import fj.data.List;
import fj.data.Option;
import fj.data.Reader;
import fj.data.State;
import fj.data.Validation;
import fj.data.Writer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.SystemOutRule;

public class AnyFunctionalJavaMTest {
    @Rule
    public final SystemOutRule sout = new SystemOutRule().enableLog();
    private static final String SEP = System.getProperty("line.separator");

    private String success() {
        return "hello world";
    }

    private String exceptional() {
        throw new RuntimeException();
    }

    @Test
    public void flatMapCrossTypeNotCollectionUnwrap() {
        Assert.assertThat((Object)FJ.anyM((Option)Option.some((Object)1)).flatMap(i -> FJ.anyM((fj.data.Stream)fj.data.Stream.stream((Object[])new Integer[]{i + 2}))).unwrap(), (Matcher)Matchers.equalTo((Object)Option.some(Arrays.asList(3))));
    }

    @Test
    public void flatMapCrossTypeNotCollection() {
        Assert.assertThat((Object)FJ.anyM((Option)Option.some((Object)1)).flatMap(i -> FJ.anyM((fj.data.Stream)fj.data.Stream.stream((Object[])new Integer[]{i + 2}))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(3)));
    }

    @Test
    public void eitherTest() {
        Assert.assertThat((Object)FJ.anyM((Either)Either.right((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void eitherLeftTest() {
        Assert.assertThat((Object)FJ.anyM((Either)Either.left((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void eitherFlatMapTest() {
        Assert.assertThat((Object)FJ.anyM((Either)Either.right((Object)"hello world")).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void rightProjectionTest() {
        Assert.assertThat((Object)FJ.anyM((Either.RightProjection)Either.right((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void rightProjectionLeftTest() {
        Assert.assertThat((Object)FJ.anyM((Either.RightProjection)Either.left((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void rightProjectionFlatMapTest() {
        Assert.assertThat((Object)FJ.anyM((Either.RightProjection)Either.right((Object)"hello world").right()).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void leftProjectionTest() {
        Assert.assertThat((Object)FJ.anyM((Either.RightProjection)Either.left((Object)"hello world").right()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void leftProjectionLeftTest() {
        Assert.assertThat((Object)FJ.anyM((Either.LeftProjection)Either.left((Object)"hello world").left()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void leftProjectionLeftFlatMapTest() {
        Assert.assertThat((Object)FJ.anyM((Either.LeftProjection)Either.left((Object)"hello world").left()).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionTest() {
        Assert.assertThat((Object)FJ.anyM((Option)Option.some((Object)"hello world")).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionFlatMapTest() {
        Assert.assertThat((Object)FJ.anyM((Option)Option.some((Object)"hello world")).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void optionEmptyTest() {
        Assert.assertThat((Object)FJ.anyM((Option)Option.none()).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void streamTest() {
        Assert.assertThat((Object)FJ.anyM((fj.data.Stream)fj.data.Stream.stream((Object[])new String[]{"hello world"})).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void listTest() {
        Assert.assertThat((Object)FJ.anyM((List)List.list((Object[])new String[]{"hello world"})).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void iterableWTest() {
        Assert.assertThat((Object)FJ.anyM((IterableW)IterableW.wrap(Arrays.asList("hello world"))).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamFlatMapTest() {
        Assert.assertThat((Object)FJ.anyM((fj.data.Stream)fj.data.Stream.stream((Object[])new String[]{"hello world"})).map(String::toUpperCase).flatMap(i -> FJ.anyM((fj.data.Stream)fj.data.Stream.stream((Object[])new String[]{i}))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void streamFlatMapTestJDK() {
        Assert.assertThat((Object)FJ.anyM((fj.data.Stream)fj.data.Stream.stream((Object[])new String[]{"hello world"})).map(String::toUpperCase).flatMap(i -> AnyM.fromStream(Stream.of(i))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void JDKstreamFlatMapTest() {
        Assert.assertThat((Object)AnyM.fromStream(Stream.of("hello world")).map(String::toUpperCase).flatMap(i -> FJ.anyM((fj.data.Stream)fj.data.Stream.stream((Object[])new String[]{i}))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void JDKOptionFlatMapTest() {
        Assert.assertThat((Object)AnyM.fromStream(Stream.of("hello world")).map(String::toUpperCase).flatMap(i -> FJ.anyM((Option)Option.some((Object)i))).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void JDKOptionEmptyFlatMapTest() {
        Assert.assertThat((Object)AnyM.fromStream(Stream.of("hello world")).map(String::toUpperCase).flatMap(i -> FJ.anyM((Option)Option.none())).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    public String finalStage() {
        return "hello world";
    }

    @Test
    public void trampolineTest() {
        Assert.assertThat((Object)FJ.anyM((Trampoline)FJ.Trampoline.suspend(() -> Trampoline.pure((Object)this.finalStage()))).map(String::toUpperCase).asSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void readerTest() {
        FJ.anyM((Reader)Reader.unit(a -> "hello " + a)).map(String::toUpperCase);
        Assert.assertThat((Object)FJ.unwrapReader((AnyM)FJ.anyM((Reader)Reader.unit(a -> "hello " + a)).map(String::toUpperCase)).f((Object)10), (Matcher)Matchers.equalTo((Object)"HELLO 10"));
    }

    @Test
    public void validateTest() {
        Assert.assertThat((Object)FJ.anyM((Validation)Validation.success((Object)this.success())).map(String::toUpperCase).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    public void validationTestFailure() {
        FJ.anyM((Validation)Validation.fail((Object)new RuntimeException())).toSequence().forEach(System.out::println);
    }

    @Test
    public void validateTestFailureProcess() {
        RuntimeException e = new RuntimeException();
        Assert.assertThat((Object)FJ.anyM((Validation)Validation.fail((Object)e)).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList(new Object[0])));
    }

    @Test
    public void tryFlatMapTest() {
        Assert.assertThat((Object)FJ.anyM((Validation)Validation.success((Object)this.success())).map(String::toUpperCase).flatMapOptional(Optional::of).toSequence().toList(), (Matcher)Matchers.equalTo(Arrays.asList("HELLO WORLD")));
    }

    @Test
    @Ignore
    public void writerFailingTest() {
        Writer.unit((Object)"lower", (Object)"", (Monoid)Monoid.stringMonoid).map(a -> a.length());
        System.out.println((String)((Writer)FJ.anyM((Writer)Writer.unit((Object)"lower", (Object)"", (Monoid)Monoid.stringMonoid)).map(a -> a.length()).unwrap()).value());
    }

    @Test
    public void writerUnwrapTest() {
        Writer writer = Writer.unit((Object)"lower", (Object)"", (Monoid)Monoid.stringMonoid);
        Assert.assertThat((Object)FJ.unwrapWriter((AnyM)FJ.anyM((Writer)writer).map(String::toUpperCase), (Writer)writer).value(), (Matcher)Matchers.equalTo((Object)"LOWER"));
    }

    @Test
    public void writerUpperCaseTest() {
        Assert.assertThat((Object)((Writer)FJ.anyM((Writer)Writer.unit((Object)"lower", (Object)"", (Monoid)Monoid.stringMonoid)).map(String::toUpperCase).unwrap()).value(), (Matcher)Matchers.equalTo((Object)"LOWER"));
    }

    @Test
    public void writerFlatMapTest() {
        Assert.assertThat((Object)((Writer)FJ.anyM((Writer)Writer.unit((Object)"lower", (Object)"", (Monoid)Monoid.stringMonoid)).flatMap(a -> FJ.anyMValue((Writer)Writer.unit((Object)"hello", (Monoid)Monoid.stringMonoid))).map(String::toUpperCase).unwrap()).value(), (Matcher)Matchers.equalTo((Object)"HELLO"));
    }

    @Test
    public void stateTest() {
        Assert.assertThat((Object)FJ.unwrapState((AnyM)FJ.anyM((State)State.constant((Object)"hello")).map(String::toUpperCase)).run((Object)"")._2(), (Matcher)Matchers.equalTo((Object)"HELLO"));
    }

    @Test
    public void stateFlatMapTest() {
        Assert.assertThat((Object)FJ.unwrapState((AnyM)FJ.anyM((State)State.constant((Object)"hello")).flatMap(s -> FJ.anyM((State)State.constant((Object)s.toUpperCase())))).run((Object)"")._2(), (Matcher)Matchers.equalTo((Object)"HELLO"));
    }

    @Test
    public void ioTest() throws IOException {
        FJ.unwrapIO((AnyM)FJ.anyM((IO)IOFunctions.lazy(a -> {
            System.out.println("hello world");
            return a;
        })).map(a -> {
            System.out.println("hello world2");
            return a;
        })).run();
        Assert.assertThat((Object)("hello world" + SEP + "hello world2" + SEP), (Matcher)Matchers.equalTo((Object)this.sout.getLog()));
    }
}

