/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.functionaljava.hkt.typeclesses.instances;

import com.aol.cyclops.functionaljava.hkt.NonEmptyListType;
import com.aol.cyclops.functionaljava.hkt.typeclassess.instances.NonEmptyListInstances;
import com.aol.cyclops.hkt.alias.Higher;
import com.aol.cyclops.util.function.Lambda;
import fj.data.List;
import fj.data.NonEmptyList;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class NonEmptyListsTest {
    @Test
    public void unit() {
        NonEmptyListType list = (NonEmptyListType)NonEmptyListInstances.unit().unit((Object)"hello").convert(NonEmptyListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo(this.list("hello")));
    }

    @Test
    public void functor() {
        NonEmptyListType list = (NonEmptyListType)NonEmptyListInstances.unit().unit((Object)"hello").then(h -> NonEmptyListInstances.functor().map(v -> v.length(), h)).convert(NonEmptyListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo((Object)NonEmptyList.fromList((List)List.list((Object[])new Integer[]{"hello".length()})).some()));
    }

    @Test
    public void apSimple() {
        NonEmptyListInstances.zippingApplicative().ap((Higher)NonEmptyListType.of((Object)Lambda.l1(this::multiplyByTwo), (Object[])new Function[0]), (Higher)NonEmptyListType.of((Object)1, (Object[])new Integer[]{2, 3}));
    }

    private int multiplyByTwo(int x) {
        return x * 2;
    }

    @Test
    public void applicative() {
        NonEmptyListType listFn = (NonEmptyListType)NonEmptyListInstances.unit().unit((Object)Lambda.l1(i -> i * 2)).convert(NonEmptyListType::narrowK);
        NonEmptyListType list = (NonEmptyListType)NonEmptyListInstances.unit().unit((Object)"hello").then(h -> NonEmptyListInstances.functor().map(v -> v.length(), h)).then(h -> NonEmptyListInstances.zippingApplicative().ap((Higher)listFn, h)).convert(NonEmptyListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo(this.list("hello".length() * 2)));
    }

    private <T> NonEmptyList<T> list(T ... values) {
        return (NonEmptyList)NonEmptyList.fromList((List)List.list((Object[])values)).some();
    }

    private NonEmptyListType<Integer> range(int start, int end) {
        return NonEmptyListType.widen((NonEmptyList)((NonEmptyList)NonEmptyList.fromList((List)List.range((int)start, (int)end)).some()));
    }

    @Test
    public void monadSimple() {
        NonEmptyListType list = (NonEmptyListType)NonEmptyListInstances.monad().flatMap(i -> this.range(0, (int)i), (Higher)NonEmptyListType.of((Object)1, (Object[])new Integer[]{2, 3})).convert(NonEmptyListType::narrowK);
    }

    @Test
    public void monad() {
        NonEmptyListType list = (NonEmptyListType)NonEmptyListInstances.unit().unit((Object)"hello").then(h -> NonEmptyListInstances.monad().flatMap(v -> NonEmptyListInstances.unit().unit((Object)v.length()), h)).convert(NonEmptyListType::narrowK);
        Assert.assertThat((Object)list, (Matcher)Matchers.equalTo(this.list("hello".length())));
    }

    @Test
    public void foldLeft() {
        int sum = (Integer)NonEmptyListInstances.foldable().foldLeft((Object)0, (a, b) -> a + b, (Higher)NonEmptyListType.of((Object)1, (Object[])new Integer[]{2, 3, 4}));
        Assert.assertThat((Object)sum, (Matcher)Matchers.equalTo((Object)10));
    }

    @Test
    public void foldRight() {
        int sum = (Integer)NonEmptyListInstances.foldable().foldRight((Object)0, (a, b) -> a + b, (Higher)NonEmptyListType.of((Object)1, (Object[])new Integer[]{2, 3, 4}));
        Assert.assertThat((Object)sum, (Matcher)Matchers.equalTo((Object)10));
    }
}

